/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.impl;

import io.vertx.core.AsyncResult;
import io.vertx.core.CompositeFuture;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Promise;
import io.vertx.core.impl.NoStackTraceThrowable;
import java.util.function.Function;

public class CompositeFutureImpl
implements CompositeFuture,
Handler<AsyncResult<CompositeFuture>> {
    private static final Function<CompositeFuture, Object> ALL = cf -> {
        int size = cf.size();
        for (int i = 0; i < size; ++i) {
            if (cf.succeeded(i)) continue;
            return cf.cause(i);
        }
        return cf;
    };
    private final Future[] results;
    private int count;
    private Object result;
    private Promise<CompositeFuture> promise;

    public static CompositeFuture all(Future<?> ... results) {
        CompositeFutureImpl composite = new CompositeFutureImpl(results);
        int len = results.length;
        for (Future<?> result2 : results) {
            result2.onComplete((AsyncResult<T> ar) -> {
                if (ar.succeeded()) {
                    CompositeFutureImpl compositeFutureImpl = composite;
                    synchronized (compositeFutureImpl) {
                        if (composite.count == len || ++composite.count != len) {
                            return;
                        }
                    }
                    composite.tryComplete();
                } else {
                    CompositeFutureImpl compositeFutureImpl = composite;
                    synchronized (compositeFutureImpl) {
                        if (composite.count == len) {
                            return;
                        }
                        composite.count = len;
                    }
                    composite.tryFail(ar.cause());
                }
            });
        }
        if (len == 0) {
            composite.complete();
        }
        return composite;
    }

    public static CompositeFuture any(Future<?> ... results) {
        CompositeFutureImpl composite = new CompositeFutureImpl(results);
        int len = results.length;
        for (Future<?> result2 : results) {
            result2.onComplete((AsyncResult<T> ar) -> {
                if (ar.succeeded()) {
                    CompositeFutureImpl compositeFutureImpl = composite;
                    synchronized (compositeFutureImpl) {
                        if (composite.count == len) {
                            return;
                        }
                        composite.count = len;
                    }
                    composite.tryComplete();
                } else {
                    CompositeFutureImpl compositeFutureImpl = composite;
                    synchronized (compositeFutureImpl) {
                        if (composite.count == len || ++composite.count != len) {
                            return;
                        }
                    }
                    composite.tryFail(ar.cause());
                }
            });
        }
        if (results.length == 0) {
            composite.complete();
        }
        return composite;
    }

    public static CompositeFuture join(Future<?> ... results) {
        return CompositeFutureImpl.join(ALL, results);
    }

    private static CompositeFuture join(Function<CompositeFuture, Object> pred2, Future<?> ... results) {
        CompositeFutureImpl composite = new CompositeFutureImpl(results);
        int len = results.length;
        for (Future<?> result2 : results) {
            result2.onComplete((AsyncResult<T> ar) -> {
                CompositeFutureImpl compositeFutureImpl = composite;
                synchronized (compositeFutureImpl) {
                    if (++composite.count < len) {
                        return;
                    }
                }
                composite.doComplete(pred2.apply(composite));
            });
        }
        if (len == 0) {
            composite.doComplete(composite);
        }
        return composite;
    }

    private CompositeFutureImpl(Future<?> ... results) {
        this.results = results;
        this.promise = Promise.promise();
    }

    @Override
    public CompositeFuture onComplete(Handler<AsyncResult<CompositeFuture>> handler) {
        this.promise.future().onComplete(handler);
        return this;
    }

    @Override
    public Throwable cause(int index2) {
        return this.future(index2).cause();
    }

    @Override
    public boolean succeeded(int index2) {
        return this.future(index2).succeeded();
    }

    @Override
    public boolean failed(int index2) {
        return this.future(index2).failed();
    }

    @Override
    public boolean isComplete(int index2) {
        return this.future(index2).isComplete();
    }

    @Override
    public <T> T resultAt(int index2) {
        return this.future(index2).result();
    }

    private <T> Future<T> future(int index2) {
        if (index2 < 0 || index2 > this.results.length) {
            throw new IndexOutOfBoundsException();
        }
        return this.results[index2];
    }

    @Override
    public int size() {
        return this.results.length;
    }

    @Override
    public synchronized boolean isComplete() {
        return this.result != null;
    }

    @Override
    public synchronized boolean succeeded() {
        return this.result == this;
    }

    @Override
    public synchronized boolean failed() {
        return this.result instanceof Throwable;
    }

    @Override
    public synchronized Throwable cause() {
        return this.result instanceof Throwable ? (Throwable)this.result : null;
    }

    @Override
    public synchronized CompositeFuture result() {
        return this.result == this ? this : null;
    }

    @Override
    public void complete() {
        if (!this.tryComplete()) {
            throw new IllegalStateException("Result is already complete: " + (this.result == this ? "succeeded" : "failed"));
        }
    }

    @Override
    public void complete(CompositeFuture result2) {
        if (!this.tryComplete(result2)) {
            throw new IllegalStateException("Result is already complete: " + (result2 == this ? "succeeded" : "failed"));
        }
    }

    @Override
    public void fail(Throwable cause) {
        if (!this.tryFail(cause)) {
            throw new IllegalStateException("Result is already complete: " + (this.result == this ? "succeeded" : "failed"));
        }
    }

    @Override
    public void fail(String failureMessage) {
        if (!this.tryFail(failureMessage)) {
            throw new IllegalStateException("Result is already complete: " + (this.result == this ? "succeeded" : "failed"));
        }
    }

    @Override
    public boolean tryComplete(CompositeFuture result2) {
        return this.doComplete(result2);
    }

    @Override
    public boolean tryComplete() {
        return this.tryComplete(this);
    }

    @Override
    public boolean tryFail(Throwable cause) {
        return this.doComplete(cause);
    }

    @Override
    public boolean tryFail(String failureMessage) {
        return this.tryFail(new NoStackTraceThrowable(failureMessage));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean doComplete(Object result2) {
        CompositeFutureImpl compositeFutureImpl = this;
        synchronized (compositeFutureImpl) {
            if (this.result != null) {
                return false;
            }
            this.result = result2;
        }
        this.promise.handle(this);
        return true;
    }

    @Override
    public Handler<AsyncResult<CompositeFuture>> completer() {
        return this;
    }

    @Override
    public void handle(AsyncResult<CompositeFuture> asyncResult) {
        if (asyncResult.succeeded()) {
            this.complete(this);
        } else {
            this.fail(asyncResult.cause());
        }
    }
}

