/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.impl;

import io.vertx.core.AsyncResult;
import io.vertx.core.Closeable;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Promise;
import io.vertx.core.logging.Logger;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;

class CloseHooks {
    private final Logger log;
    private boolean closeHooksRun;
    private Set<Closeable> closeHooks;

    CloseHooks(Logger log2) {
        this.log = log2;
    }

    synchronized void add(Closeable hook) {
        if (this.closeHooks == null) {
            this.closeHooks = new HashSet<Closeable>();
        }
        this.closeHooks.add(hook);
    }

    synchronized boolean remove(Closeable hook) {
        if (this.closeHooks != null) {
            return this.closeHooks.remove(hook);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void run(Handler<AsyncResult<Void>> completionHandler) {
        HashSet<Closeable> copy2 = null;
        CloseHooks closeHooks = this;
        synchronized (closeHooks) {
            if (this.closeHooksRun) {
                throw new IllegalStateException("Close hooks already run");
            }
            this.closeHooksRun = true;
            if (this.closeHooks != null && !this.closeHooks.isEmpty()) {
                copy2 = new HashSet<Closeable>(this.closeHooks);
            }
        }
        if (copy2 != null && !copy2.isEmpty()) {
            int num2 = copy2.size();
            if (num2 != 0) {
                AtomicInteger count2 = new AtomicInteger();
                AtomicBoolean failed = new AtomicBoolean();
                for (Closeable hook : copy2) {
                    Promise<Void> promise2 = Promise.promise();
                    promise2.future().onComplete(ar -> {
                        if (ar.failed()) {
                            if (failed.compareAndSet(false, true)) {
                                completionHandler.handle(Future.failedFuture(ar.cause()));
                            }
                        } else if (count2.incrementAndGet() == num2) {
                            completionHandler.handle(Future.succeededFuture());
                        }
                    });
                    try {
                        hook.close(promise2);
                    }
                    catch (Throwable t3) {
                        this.log.warn((Object)"Failed to run close hooks", t3);
                        promise2.tryFail(t3);
                    }
                }
            } else {
                completionHandler.handle(Future.succeededFuture());
            }
        } else {
            completionHandler.handle(Future.succeededFuture());
        }
    }
}

