/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.http.impl.headers;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufUtil;
import io.netty.util.AsciiString;
import io.netty.util.CharsetUtil;
import io.netty.util.HashingStrategy;
import io.vertx.core.MultiMap;
import io.vertx.core.http.HttpHeaders;
import io.vertx.core.http.impl.HttpUtils;
import java.util.AbstractMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Set;
import java.util.TreeSet;
import java.util.function.Consumer;

public final class VertxHttpHeaders
extends io.netty.handler.codec.http.HttpHeaders
implements MultiMap {
    private final MapEntry[] entries = new MapEntry[16];
    private final MapEntry head;
    private static final int COLON_AND_SPACE_SHORT = 14880;
    static final int CRLF_SHORT = 3338;

    private static CharSequence toValidCharSequence(Object value) {
        if (value instanceof CharSequence) {
            return (CharSequence)value;
        }
        return value.toString();
    }

    @Override
    public MultiMap setAll(MultiMap headers) {
        return this.set0(headers);
    }

    @Override
    public MultiMap setAll(Map<String, String> headers) {
        return this.set0(headers.entrySet());
    }

    @Override
    public int size() {
        return this.names().size();
    }

    public VertxHttpHeaders() {
        this.head.before = this.head.after = (this.head = new MapEntry());
    }

    @Override
    public VertxHttpHeaders add(CharSequence name2, CharSequence value) {
        Objects.requireNonNull(value);
        int h2 = AsciiString.hashCode(name2);
        int i = h2 & 0xF;
        this.add0(h2, i, name2, value);
        return this;
    }

    @Override
    public VertxHttpHeaders add(CharSequence name2, Object value) {
        return this.add(name2, VertxHttpHeaders.toValidCharSequence(value));
    }

    @Override
    public io.netty.handler.codec.http.HttpHeaders add(String name2, Object value) {
        return this.add((CharSequence)name2, VertxHttpHeaders.toValidCharSequence(value));
    }

    @Override
    public VertxHttpHeaders add(String name2, String strVal) {
        return this.add((CharSequence)name2, (CharSequence)strVal);
    }

    public VertxHttpHeaders add(CharSequence name2, Iterable values2) {
        int h2 = AsciiString.hashCode(name2);
        int i = h2 & 0xF;
        for (Object vstr : values2) {
            this.add0(h2, i, name2, VertxHttpHeaders.toValidCharSequence(vstr));
        }
        return this;
    }

    public VertxHttpHeaders add(String name2, Iterable values2) {
        return this.add((CharSequence)name2, values2);
    }

    @Override
    public MultiMap addAll(MultiMap headers) {
        return this.addAll(headers.entries());
    }

    @Override
    public MultiMap addAll(Map<String, String> map2) {
        return this.addAll(map2.entrySet());
    }

    private MultiMap addAll(Iterable<Map.Entry<String, String>> headers) {
        for (Map.Entry<String, String> entry : headers) {
            this.add(entry.getKey(), entry.getValue());
        }
        return this;
    }

    @Override
    public VertxHttpHeaders remove(CharSequence name2) {
        Objects.requireNonNull(name2, "name");
        int h2 = AsciiString.hashCode(name2);
        int i = h2 & 0xF;
        this.remove0(h2, i, name2);
        return this;
    }

    @Override
    public VertxHttpHeaders remove(String name2) {
        return this.remove((CharSequence)name2);
    }

    @Override
    public VertxHttpHeaders set(CharSequence name2, CharSequence value) {
        return this.set0(name2, value);
    }

    @Override
    public VertxHttpHeaders set(String name2, String value) {
        return this.set((CharSequence)name2, (CharSequence)value);
    }

    @Override
    public VertxHttpHeaders set(String name2, Object value) {
        return this.set((CharSequence)name2, VertxHttpHeaders.toValidCharSequence(value));
    }

    @Override
    public VertxHttpHeaders set(CharSequence name2, Object value) {
        return this.set(name2, VertxHttpHeaders.toValidCharSequence(value));
    }

    public VertxHttpHeaders set(CharSequence name2, Iterable values2) {
        Objects.requireNonNull(values2, "values");
        int h2 = AsciiString.hashCode(name2);
        int i = h2 & 0xF;
        this.remove0(h2, i, name2);
        for (Object v : values2) {
            if (v == null) break;
            this.add0(h2, i, name2, VertxHttpHeaders.toValidCharSequence(v));
        }
        return this;
    }

    public VertxHttpHeaders set(String name2, Iterable values2) {
        return this.set((CharSequence)name2, values2);
    }

    @Override
    public boolean contains(CharSequence name2, CharSequence value, boolean ignoreCase) {
        HashingStrategy<CharSequence> strategy;
        int h2 = AsciiString.hashCode(name2);
        int i = h2 & 0xF;
        MapEntry e2 = this.entries[i];
        HashingStrategy<CharSequence> hashingStrategy = strategy = ignoreCase ? AsciiString.CASE_INSENSITIVE_HASHER : AsciiString.CASE_SENSITIVE_HASHER;
        while (e2 != null) {
            CharSequence key2 = e2.key;
            if (e2.hash == h2 && (name2 == key2 || AsciiString.contentEqualsIgnoreCase(name2, key2)) && strategy.equals(value, e2.getValue())) {
                return true;
            }
            e2 = e2.next;
        }
        return false;
    }

    @Override
    public boolean contains(String name2, String value, boolean ignoreCase) {
        return this.contains((CharSequence)name2, (CharSequence)value, ignoreCase);
    }

    @Override
    public boolean contains(CharSequence name2) {
        return this.get0(name2) != null;
    }

    @Override
    public boolean contains(String name2) {
        return this.contains((CharSequence)name2);
    }

    @Override
    public String get(CharSequence name2) {
        Objects.requireNonNull(name2, "name");
        CharSequence ret = this.get0(name2);
        return ret != null ? ret.toString() : null;
    }

    @Override
    public String get(String name2) {
        return this.get((CharSequence)name2);
    }

    @Override
    public List<String> getAll(CharSequence name2) {
        Objects.requireNonNull(name2, "name");
        LinkedList<String> values2 = new LinkedList<String>();
        int h2 = AsciiString.hashCode(name2);
        int i = h2 & 0xF;
        MapEntry e2 = this.entries[i];
        while (e2 != null) {
            CharSequence key2 = e2.key;
            if (e2.hash == h2 && (name2 == key2 || AsciiString.contentEqualsIgnoreCase(name2, key2))) {
                values2.addFirst(e2.getValue().toString());
            }
            e2 = e2.next;
        }
        return values2;
    }

    @Override
    public List<String> getAll(String name2) {
        return this.getAll((CharSequence)name2);
    }

    @Override
    public void forEach(Consumer<? super Map.Entry<String, String>> action) {
        MapEntry e2 = this.head.after;
        while (e2 != this.head) {
            action.accept(new AbstractMap.SimpleEntry<String, String>(e2.key.toString(), e2.value.toString()));
            e2 = e2.after;
        }
    }

    @Override
    public List<Map.Entry<String, String>> entries() {
        return MultiMap.super.entries();
    }

    @Override
    public Iterator<Map.Entry<String, String>> iterator() {
        return new Iterator<Map.Entry<String, String>>(){
            MapEntry curr;
            {
                this.curr = VertxHttpHeaders.this.head;
            }

            @Override
            public boolean hasNext() {
                return this.curr.after != VertxHttpHeaders.this.head;
            }

            @Override
            public Map.Entry<String, String> next() {
                final MapEntry next2 = this.curr.after;
                if (next2 == VertxHttpHeaders.this.head) {
                    throw new NoSuchElementException();
                }
                this.curr = next2;
                return new Map.Entry<String, String>(){

                    @Override
                    public String getKey() {
                        return next2.key.toString();
                    }

                    @Override
                    public String getValue() {
                        return next2.value.toString();
                    }

                    @Override
                    public String setValue(String value) {
                        return next2.setValue(value).toString();
                    }

                    public String toString() {
                        return this.getKey() + ": " + this.getValue();
                    }
                };
            }
        };
    }

    @Override
    public boolean isEmpty() {
        return this.head == this.head.after;
    }

    @Override
    public Set<String> names() {
        TreeSet<String> names = new TreeSet<String>(String.CASE_INSENSITIVE_ORDER);
        MapEntry e2 = this.head.after;
        while (e2 != this.head) {
            names.add(e2.getKey().toString());
            e2 = e2.after;
        }
        return names;
    }

    @Override
    public VertxHttpHeaders clear() {
        for (int i = 0; i < this.entries.length; ++i) {
            this.entries[i] = null;
        }
        this.head.before = this.head.after = this.head;
        return this;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (Map.Entry<String, String> entry : this) {
            sb.append(entry).append('\n');
        }
        return sb.toString();
    }

    @Override
    public Integer getInt(CharSequence name2) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int getInt(CharSequence name2, int defaultValue) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Short getShort(CharSequence name2) {
        throw new UnsupportedOperationException();
    }

    @Override
    public short getShort(CharSequence name2, short defaultValue) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Long getTimeMillis(CharSequence name2) {
        throw new UnsupportedOperationException();
    }

    @Override
    public long getTimeMillis(CharSequence name2, long defaultValue) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Iterator<Map.Entry<CharSequence, CharSequence>> iteratorCharSequence() {
        return new Iterator<Map.Entry<CharSequence, CharSequence>>(){
            MapEntry current;
            {
                this.current = ((VertxHttpHeaders)VertxHttpHeaders.this).head.after;
            }

            @Override
            public boolean hasNext() {
                return this.current != VertxHttpHeaders.this.head;
            }

            @Override
            public Map.Entry<CharSequence, CharSequence> next() {
                MapEntry next2 = this.current;
                this.current = this.current.after;
                return next2;
            }
        };
    }

    @Override
    public io.netty.handler.codec.http.HttpHeaders addInt(CharSequence name2, int value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public io.netty.handler.codec.http.HttpHeaders addShort(CharSequence name2, short value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public io.netty.handler.codec.http.HttpHeaders setInt(CharSequence name2, int value) {
        return this.set(name2, (CharSequence)Integer.toString(value));
    }

    @Override
    public io.netty.handler.codec.http.HttpHeaders setShort(CharSequence name2, short value) {
        throw new UnsupportedOperationException();
    }

    public void encode(ByteBuf buf) {
        MapEntry current = this.head.after;
        while (current != this.head) {
            VertxHttpHeaders.encoderHeader(current.key, current.value, buf);
            current = current.after;
        }
    }

    static void encoderHeader(CharSequence name2, CharSequence value, ByteBuf buf) {
        int nameLen = name2.length();
        int valueLen = value.length();
        int entryLen = nameLen + valueLen + 4;
        buf.ensureWritable(entryLen);
        int offset = buf.writerIndex();
        VertxHttpHeaders.writeAscii(buf, offset, name2);
        ByteBufUtil.setShortBE(buf, offset += nameLen, 14880);
        VertxHttpHeaders.writeAscii(buf, offset += 2, value);
        ByteBufUtil.setShortBE(buf, offset += valueLen, 3338);
        buf.writerIndex(offset += 2);
    }

    private static void writeAscii(ByteBuf buf, int offset, CharSequence value) {
        if (value instanceof AsciiString) {
            ByteBufUtil.copy((AsciiString)value, 0, buf, offset, value.length());
        } else {
            buf.setCharSequence(offset, value, CharsetUtil.US_ASCII);
        }
    }

    private void remove0(int h2, int i, CharSequence name2) {
        MapEntry next2;
        MapEntry e2;
        block4: {
            e2 = this.entries[i];
            if (e2 == null) {
                return;
            }
            while (true) {
                CharSequence key2 = e2.key;
                if (e2.hash != h2 || name2 != key2 && !AsciiString.contentEqualsIgnoreCase(name2, key2)) break block4;
                e2.remove();
                MapEntry next3 = e2.next;
                if (next3 == null) break;
                this.entries[i] = next3;
                e2 = next3;
            }
            this.entries[i] = null;
            return;
        }
        while ((next2 = e2.next) != null) {
            CharSequence key3 = next2.key;
            if (next2.hash == h2 && (name2 == key3 || AsciiString.contentEqualsIgnoreCase(name2, key3))) {
                e2.next = next2.next;
                next2.remove();
                continue;
            }
            e2 = next2;
        }
    }

    private void add0(int h2, int i, CharSequence name2, CharSequence value) {
        MapEntry newEntry;
        if (!HttpHeaders.DISABLE_HTTP_HEADERS_VALIDATION) {
            HttpUtils.validateHeader(name2, value);
        }
        MapEntry e2 = this.entries[i];
        this.entries[i] = newEntry = new MapEntry(h2, name2, value);
        newEntry.next = e2;
        newEntry.addBefore(this.head);
    }

    private VertxHttpHeaders set0(CharSequence name2, CharSequence strVal) {
        int h2 = AsciiString.hashCode(name2);
        int i = h2 & 0xF;
        this.remove0(h2, i, name2);
        if (strVal != null) {
            this.add0(h2, i, name2, strVal);
        }
        return this;
    }

    private CharSequence get0(CharSequence name2) {
        int h2 = AsciiString.hashCode(name2);
        int i = h2 & 0xF;
        MapEntry e2 = this.entries[i];
        CharSequence value = null;
        while (e2 != null) {
            CharSequence key2 = e2.key;
            if (e2.hash == h2 && (name2 == key2 || AsciiString.contentEqualsIgnoreCase(name2, key2))) {
                value = e2.getValue();
            }
            e2 = e2.next;
        }
        return value;
    }

    private MultiMap set0(Iterable<Map.Entry<String, String>> map2) {
        this.clear();
        for (Map.Entry<String, String> entry : map2) {
            this.add(entry.getKey(), entry.getValue());
        }
        return this;
    }

    private static final class MapEntry
    implements Map.Entry<CharSequence, CharSequence> {
        final int hash;
        final CharSequence key;
        CharSequence value;
        MapEntry next;
        MapEntry before;
        MapEntry after;

        MapEntry() {
            this.hash = -1;
            this.key = null;
            this.value = null;
        }

        MapEntry(int hash2, CharSequence key2, CharSequence value) {
            this.hash = hash2;
            this.key = key2;
            this.value = value;
        }

        void remove() {
            this.before.after = this.after;
            this.after.before = this.before;
        }

        void addBefore(MapEntry e2) {
            this.after = e2;
            this.before = e2.before;
            this.before.after = this;
            this.after.before = this;
        }

        @Override
        public CharSequence getKey() {
            return this.key;
        }

        @Override
        public CharSequence getValue() {
            return this.value;
        }

        @Override
        public CharSequence setValue(CharSequence value) {
            Objects.requireNonNull(value, "value");
            if (!HttpHeaders.DISABLE_HTTP_HEADERS_VALIDATION) {
                HttpUtils.validateHeaderValue(value);
            }
            CharSequence oldValue = this.value;
            this.value = value;
            return oldValue;
        }

        public String toString() {
            return this.getKey() + "=" + this.getValue();
        }
    }
}

