/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.http.impl;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.Channel;
import io.netty.handler.codec.compression.ZlibWrapper;
import io.netty.handler.codec.http.DefaultFullHttpResponse;
import io.netty.handler.codec.http.HttpContentCompressor;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpHeaderValues;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpUtil;
import io.netty.handler.codec.http.QueryStringDecoder;
import io.netty.handler.codec.http2.Http2Headers;
import io.netty.util.AsciiString;
import io.netty.util.CharsetUtil;
import io.vertx.core.MultiMap;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.http.Http2Settings;
import io.vertx.core.http.HttpHeaders;
import io.vertx.core.http.HttpMethod;
import io.vertx.core.http.HttpServerRequest;
import io.vertx.core.http.HttpVersion;
import io.vertx.core.http.StreamPriority;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.Charset;
import java.util.Base64;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;

public final class HttpUtils {
    static final int SC_SWITCHING_PROTOCOLS = 101;
    static final int SC_BAD_GATEWAY = 502;
    static final StreamPriority DEFAULT_STREAM_PRIORITY = new StreamPriority(){

        @Override
        public StreamPriority setWeight(short weight) {
            throw new UnsupportedOperationException("Unmodifiable stream priority");
        }

        @Override
        public StreamPriority setDependency(int dependency) {
            throw new UnsupportedOperationException("Unmodifiable stream priority");
        }

        @Override
        public StreamPriority setExclusive(boolean exclusive) {
            throw new UnsupportedOperationException("Unmodifiable stream priority");
        }
    };
    private static final CustomCompressor compressor = new CustomCompressor();
    private static final AsciiString TIMEOUT_EQ = AsciiString.of("timeout=");
    private static final Consumer<CharSequence> HEADER_VALUE_VALIDATOR = HttpUtils::validateHeaderValue;
    private static final int HIGHEST_INVALID_VALUE_CHAR_MASK = -16;

    private HttpUtils() {
    }

    private static int indexOfSlash(CharSequence str2, int start2) {
        for (int i = start2; i < str2.length(); ++i) {
            if (str2.charAt(i) != '/') continue;
            return i;
        }
        return -1;
    }

    private static boolean matches(CharSequence path2, int start2, String what) {
        return HttpUtils.matches(path2, start2, what, false);
    }

    private static boolean matches(CharSequence path2, int start2, String what, boolean exact) {
        if (exact && path2.length() - start2 != what.length()) {
            return false;
        }
        if (path2.length() - start2 >= what.length()) {
            for (int i = 0; i < what.length(); ++i) {
                if (path2.charAt(start2 + i) == what.charAt(i)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public static String normalizePath(String pathname) {
        if (pathname == null) {
            return null;
        }
        if (pathname.length() == 0) {
            return "/";
        }
        StringBuilder ibuf = new StringBuilder(pathname.length() + 1);
        if (pathname.charAt(0) != '/') {
            ibuf.append('/');
        }
        ibuf.append(pathname);
        for (int i = 0; i < ibuf.length(); ++i) {
            if (ibuf.charAt(i) != '%') continue;
            HttpUtils.decodeUnreserved(ibuf, i);
        }
        return HttpUtils.removeDots(ibuf);
    }

    private static void decodeUnreserved(StringBuilder path2, int start2) {
        if (start2 + 3 <= path2.length()) {
            int unescaped;
            String escapeSequence = path2.substring(start2 + 1, start2 + 3);
            try {
                unescaped = Integer.parseInt(escapeSequence, 16);
                if (unescaped < 0) {
                    throw new IllegalArgumentException("Invalid escape sequence: %" + escapeSequence);
                }
            }
            catch (NumberFormatException e2) {
                throw new IllegalArgumentException("Invalid escape sequence: %" + escapeSequence);
            }
            if (unescaped >= 65 && unescaped <= 90 || unescaped >= 97 && unescaped <= 122 || unescaped >= 48 && unescaped <= 57 || unescaped == 45 || unescaped == 46 || unescaped == 95 || unescaped == 126) {
                path2.setCharAt(start2, (char)unescaped);
                path2.delete(start2 + 1, start2 + 3);
            }
        } else {
            throw new IllegalArgumentException("Invalid position for escape character: " + start2);
        }
    }

    public static String removeDots(CharSequence path2) {
        if (path2 == null) {
            return null;
        }
        StringBuilder obuf = new StringBuilder(path2.length());
        int i = 0;
        while (i < path2.length()) {
            int pos;
            if (HttpUtils.matches(path2, i, "./")) {
                i += 2;
                continue;
            }
            if (HttpUtils.matches(path2, i, "../")) {
                i += 3;
                continue;
            }
            if (HttpUtils.matches(path2, i, "/./")) {
                i += 2;
                continue;
            }
            if (HttpUtils.matches(path2, i, "/.", true)) {
                path2 = "/";
                i = 0;
                continue;
            }
            if (HttpUtils.matches(path2, i, "/../")) {
                i += 3;
                pos = obuf.lastIndexOf("/");
                if (pos == -1) continue;
                obuf.delete(pos, obuf.length());
                continue;
            }
            if (HttpUtils.matches(path2, i, "/..", true)) {
                path2 = "/";
                i = 0;
                pos = obuf.lastIndexOf("/");
                if (pos == -1) continue;
                obuf.delete(pos, obuf.length());
                continue;
            }
            if (HttpUtils.matches(path2, i, ".", true) || HttpUtils.matches(path2, i, "..", true)) break;
            if (path2.charAt(i) == '/') {
                ++i;
                if (obuf.length() == 0 || obuf.charAt(obuf.length() - 1) != '/') {
                    obuf.append('/');
                }
            }
            if ((pos = HttpUtils.indexOfSlash(path2, i)) != -1) {
                obuf.append(path2, i, pos);
                i = pos;
                continue;
            }
            obuf.append(path2, i, path2.length());
            break;
        }
        return obuf.toString();
    }

    public static URI resolveURIReference(String base, String ref2) throws URISyntaxException {
        return HttpUtils.resolveURIReference(URI.create(base), ref2);
    }

    public static URI resolveURIReference(URI base, String ref2) throws URISyntaxException {
        String query;
        String path2;
        String authority;
        String scheme;
        URI _ref2 = URI.create(ref2);
        if (_ref2.getScheme() != null) {
            scheme = _ref2.getScheme();
            authority = _ref2.getAuthority();
            path2 = HttpUtils.removeDots(_ref2.getRawPath());
            query = _ref2.getRawQuery();
        } else {
            if (_ref2.getAuthority() != null) {
                authority = _ref2.getAuthority();
                path2 = _ref2.getRawPath();
                query = _ref2.getRawQuery();
            } else {
                if (_ref2.getRawPath().length() == 0) {
                    path2 = base.getRawPath();
                    query = _ref2.getRawQuery() != null ? _ref2.getRawQuery() : base.getRawQuery();
                } else {
                    if (_ref2.getRawPath().startsWith("/")) {
                        path2 = HttpUtils.removeDots(_ref2.getRawPath());
                    } else {
                        int index2;
                        String basePath = base.getRawPath();
                        String mergedPath = base.getAuthority() != null && basePath.length() == 0 ? "/" + _ref2.getRawPath() : ((index2 = basePath.lastIndexOf(47)) > -1 ? basePath.substring(0, index2 + 1) + _ref2.getRawPath() : _ref2.getRawPath());
                        path2 = HttpUtils.removeDots(mergedPath);
                    }
                    query = _ref2.getRawQuery();
                }
                authority = base.getAuthority();
            }
            scheme = base.getScheme();
        }
        return new URI(scheme, authority, path2, query, _ref2.getFragment());
    }

    static String parsePath(String uri) {
        int i;
        if (uri.charAt(0) == '/') {
            i = 0;
        } else {
            i = uri.indexOf("://");
            if (i == -1) {
                i = 0;
            } else if ((i = uri.indexOf(47, i + 3)) == -1) {
                return "/";
            }
        }
        int queryStart = uri.indexOf(63, i);
        if (queryStart == -1) {
            queryStart = uri.length();
        }
        return uri.substring(i, queryStart);
    }

    static String parseQuery(String uri) {
        int i = uri.indexOf(63);
        if (i == -1) {
            return null;
        }
        return uri.substring(i + 1, uri.length());
    }

    static String absoluteURI(String serverOrigin, HttpServerRequest req) throws URISyntaxException {
        String host;
        URI uri = new URI(req.uri());
        String scheme = uri.getScheme();
        String absoluteURI = scheme != null && (scheme.equals("http") || scheme.equals("https")) ? uri.toString() : ((host = req.host()) != null ? req.scheme() + "://" + host + uri : serverOrigin + uri);
        return absoluteURI;
    }

    static MultiMap params(String uri) {
        QueryStringDecoder queryStringDecoder = new QueryStringDecoder(uri);
        Map<String, List<String>> prms = queryStringDecoder.parameters();
        MultiMap params = MultiMap.caseInsensitiveMultiMap();
        if (!prms.isEmpty()) {
            for (Map.Entry<String, List<String>> entry : prms.entrySet()) {
                params.add(entry.getKey(), (Iterable<String>)entry.getValue());
            }
        }
        return params;
    }

    public static void fromVertxInitialSettings(boolean server2, Http2Settings vertxSettings, io.netty.handler.codec.http2.Http2Settings nettySettings) {
        if (vertxSettings != null) {
            Map<Integer, Long> extraSettings;
            if (!server2 && !vertxSettings.isPushEnabled()) {
                nettySettings.pushEnabled(vertxSettings.isPushEnabled());
            }
            if (vertxSettings.getHeaderTableSize() != 4096L) {
                nettySettings.put('\u0001', vertxSettings.getHeaderTableSize());
            }
            if (vertxSettings.getInitialWindowSize() != 65535) {
                nettySettings.initialWindowSize(vertxSettings.getInitialWindowSize());
            }
            if (vertxSettings.getMaxConcurrentStreams() != 0xFFFFFFFFL) {
                nettySettings.maxConcurrentStreams(vertxSettings.getMaxConcurrentStreams());
            }
            if (vertxSettings.getMaxFrameSize() != 16384) {
                nettySettings.maxFrameSize(vertxSettings.getMaxFrameSize());
            }
            if (vertxSettings.getMaxHeaderListSize() != Integer.MAX_VALUE) {
                nettySettings.maxHeaderListSize(vertxSettings.getMaxHeaderListSize());
            }
            if ((extraSettings = vertxSettings.getExtraSettings()) != null) {
                extraSettings.forEach((code, setting) -> nettySettings.put((char)code.intValue(), (Long)setting));
            }
        }
    }

    public static io.netty.handler.codec.http2.Http2Settings fromVertxSettings(Http2Settings settings) {
        io.netty.handler.codec.http2.Http2Settings converted = new io.netty.handler.codec.http2.Http2Settings();
        converted.pushEnabled(settings.isPushEnabled());
        converted.maxFrameSize(settings.getMaxFrameSize());
        converted.initialWindowSize(settings.getInitialWindowSize());
        converted.headerTableSize(settings.getHeaderTableSize());
        converted.maxConcurrentStreams(settings.getMaxConcurrentStreams());
        converted.maxHeaderListSize(settings.getMaxHeaderListSize());
        if (settings.getExtraSettings() != null) {
            settings.getExtraSettings().forEach((key2, value) -> converted.put((char)key2.intValue(), (Long)value));
        }
        return converted;
    }

    public static Http2Settings toVertxSettings(io.netty.handler.codec.http2.Http2Settings settings) {
        Long headerTableSize;
        Integer initialWindowSize;
        Integer maxFrameSize;
        Long maxHeaderListSize;
        Long maxConcurrentStreams;
        Http2Settings converted = new Http2Settings();
        Boolean pushEnabled = settings.pushEnabled();
        if (pushEnabled != null) {
            converted.setPushEnabled(pushEnabled);
        }
        if ((maxConcurrentStreams = settings.maxConcurrentStreams()) != null) {
            converted.setMaxConcurrentStreams(maxConcurrentStreams);
        }
        if ((maxHeaderListSize = settings.maxHeaderListSize()) != null) {
            converted.setMaxHeaderListSize(maxHeaderListSize);
        }
        if ((maxFrameSize = settings.maxFrameSize()) != null) {
            converted.setMaxFrameSize(maxFrameSize);
        }
        if ((initialWindowSize = settings.initialWindowSize()) != null) {
            converted.setInitialWindowSize(initialWindowSize);
        }
        if ((headerTableSize = settings.headerTableSize()) != null) {
            converted.setHeaderTableSize(headerTableSize);
        }
        settings.forEach((key2, value) -> {
            if (key2.charValue() > '\u0006') {
                converted.set(key2.charValue(), (long)value);
            }
        });
        return converted;
    }

    static io.netty.handler.codec.http2.Http2Settings decodeSettings(String base64Settings) {
        try {
            io.netty.handler.codec.http2.Http2Settings settings = new io.netty.handler.codec.http2.Http2Settings();
            Buffer buffer = Buffer.buffer(Base64.getUrlDecoder().decode(base64Settings));
            int len = buffer.length();
            for (int pos = 0; pos < len; pos += 4) {
                int i = buffer.getUnsignedShort(pos);
                long j = buffer.getUnsignedInt(pos += 2);
                settings.put((char)i, j);
            }
            return settings;
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static String encodeSettings(Http2Settings settings) {
        Buffer buffer = Buffer.buffer();
        HttpUtils.fromVertxSettings(settings).forEach((c, l) -> {
            buffer.appendUnsignedShort(c.charValue());
            buffer.appendUnsignedInt((long)l);
        });
        return Base64.getUrlEncoder().encodeToString(buffer.getBytes());
    }

    public static ByteBuf generateWSCloseFrameByteBuf(short statusCode, String reason) {
        if (reason != null) {
            return Unpooled.copiedBuffer(Unpooled.copyShort((int)statusCode), Unpooled.copiedBuffer(reason, Charset.forName("UTF-8")));
        }
        return Unpooled.copyShort((int)statusCode);
    }

    static void sendError(Channel ch, HttpResponseStatus status) {
        HttpUtils.sendError(ch, status, status.reasonPhrase());
    }

    static void sendError(Channel ch, HttpResponseStatus status, CharSequence err) {
        DefaultFullHttpResponse resp = new DefaultFullHttpResponse(io.netty.handler.codec.http.HttpVersion.HTTP_1_1, status);
        if (status.code() == HttpResponseStatus.METHOD_NOT_ALLOWED.code()) {
            resp.headers().set(HttpHeaders.ALLOW, (Object)HttpHeaders.GET);
        }
        if (err != null) {
            resp.content().writeBytes(err.toString().getBytes(CharsetUtil.UTF_8));
            HttpUtil.setContentLength(resp, err.length());
        } else {
            HttpUtil.setContentLength(resp, 0L);
        }
        ch.writeAndFlush(resp);
    }

    static String getWebSocketLocation(HttpServerRequest req, boolean ssl) throws Exception {
        String prefix = ssl ? "wss://" : "ws://";
        URI uri = new URI(req.uri());
        String path2 = uri.getRawPath();
        String loc = prefix + req.headers().get(HttpHeaderNames.HOST) + path2;
        String query = uri.getRawQuery();
        if (query != null) {
            loc = loc + "?" + query;
        }
        return loc;
    }

    static String determineContentEncoding(Http2Headers headers) {
        ZlibWrapper wrapper;
        String acceptEncoding;
        String string2 = acceptEncoding = headers.get(HttpHeaderNames.ACCEPT_ENCODING) != null ? ((CharSequence)headers.get(HttpHeaderNames.ACCEPT_ENCODING)).toString() : null;
        if (acceptEncoding != null && (wrapper = compressor.determineWrapper(acceptEncoding)) != null) {
            switch (wrapper) {
                case GZIP: {
                    return "gzip";
                }
                case ZLIB: {
                    return "deflate";
                }
            }
        }
        return null;
    }

    static io.netty.handler.codec.http.HttpMethod toNettyHttpMethod(HttpMethod method, String rawMethod) {
        switch (method) {
            case CONNECT: {
                return io.netty.handler.codec.http.HttpMethod.CONNECT;
            }
            case GET: {
                return io.netty.handler.codec.http.HttpMethod.GET;
            }
            case PUT: {
                return io.netty.handler.codec.http.HttpMethod.PUT;
            }
            case POST: {
                return io.netty.handler.codec.http.HttpMethod.POST;
            }
            case DELETE: {
                return io.netty.handler.codec.http.HttpMethod.DELETE;
            }
            case HEAD: {
                return io.netty.handler.codec.http.HttpMethod.HEAD;
            }
            case OPTIONS: {
                return io.netty.handler.codec.http.HttpMethod.OPTIONS;
            }
            case TRACE: {
                return io.netty.handler.codec.http.HttpMethod.TRACE;
            }
            case PATCH: {
                return io.netty.handler.codec.http.HttpMethod.PATCH;
            }
        }
        return io.netty.handler.codec.http.HttpMethod.valueOf(rawMethod);
    }

    static io.netty.handler.codec.http.HttpVersion toNettyHttpVersion(HttpVersion version) {
        switch (version) {
            case HTTP_1_0: {
                return io.netty.handler.codec.http.HttpVersion.HTTP_1_0;
            }
            case HTTP_1_1: {
                return io.netty.handler.codec.http.HttpVersion.HTTP_1_1;
            }
        }
        throw new IllegalArgumentException("Unsupported HTTP version: " + (Object)((Object)version));
    }

    static HttpMethod toVertxMethod(String method) {
        try {
            return HttpMethod.valueOf(method);
        }
        catch (IllegalArgumentException e2) {
            return HttpMethod.OTHER;
        }
    }

    public static int parseKeepAliveHeaderTimeout(CharSequence value) {
        int len = value.length();
        int pos = 0;
        while (pos < len) {
            int to;
            int next2;
            int idx = AsciiString.indexOf(value, ',', pos);
            if (idx == -1) {
                idx = next2 = len;
            } else {
                next2 = idx + 1;
            }
            while (pos < idx && value.charAt(pos) == ' ') {
                ++pos;
            }
            for (to = idx; to > pos && value.charAt(to - 1) == ' '; --to) {
            }
            if (AsciiString.regionMatches(value, true, pos, TIMEOUT_EQ, 0, TIMEOUT_EQ.length()) && (pos += TIMEOUT_EQ.length()) < to) {
                int ret = 0;
                while (pos < to) {
                    char ch;
                    if ((ch = value.charAt(pos++)) >= '0' && ch < '9') {
                        ret = ret * 10 + (ch - 48);
                        continue;
                    }
                    ret = -1;
                    break;
                }
                if (ret > -1) {
                    return ret;
                }
            }
            pos = next2;
        }
        return -1;
    }

    public static void validateHeader(CharSequence name2, CharSequence value) {
        HttpUtils.validateHeaderName(name2);
        if (value != null) {
            HttpUtils.validateHeaderValue(value);
        }
    }

    public static void validateHeader(CharSequence name2, Iterable<? extends CharSequence> values2) {
        HttpUtils.validateHeaderName(name2);
        values2.forEach(value -> {
            if (value != null) {
                HEADER_VALUE_VALIDATOR.accept((CharSequence)value);
            }
        });
    }

    public static void validateHeaderValue(CharSequence seq) {
        int state = 0;
        for (int index2 = 0; index2 < seq.length(); ++index2) {
            state = HttpUtils.validateValueChar(seq, state, seq.charAt(index2));
        }
        if (state != 0) {
            throw new IllegalArgumentException("a header value must not end with '\\r' or '\\n':" + seq);
        }
    }

    private static int validateValueChar(CharSequence seq, int state, char character) {
        if ((character & 0xFFFFFFF0) == 0) {
            switch (character) {
                case '\u0000': {
                    throw new IllegalArgumentException("a header value contains a prohibited character '\u0000': " + seq);
                }
                case '\u000b': {
                    throw new IllegalArgumentException("a header value contains a prohibited character '\\v': " + seq);
                }
                case '\f': {
                    throw new IllegalArgumentException("a header value contains a prohibited character '\\f': " + seq);
                }
            }
        }
        switch (state) {
            case 0: {
                switch (character) {
                    case '\r': {
                        return 1;
                    }
                    case '\n': {
                        return 2;
                    }
                }
                break;
            }
            case 1: {
                switch (character) {
                    case '\n': {
                        return 2;
                    }
                }
                throw new IllegalArgumentException("only '\\n' is allowed after '\\r': " + seq);
            }
            case 2: {
                switch (character) {
                    case '\t': 
                    case ' ': {
                        return 0;
                    }
                }
                throw new IllegalArgumentException("only ' ' and '\\t' are allowed after '\\n': " + seq);
            }
        }
        return state;
    }

    public static void validateHeaderName(CharSequence value) {
        for (int i = 0; i < value.length(); ++i) {
            char c = value.charAt(i);
            switch (c) {
                case '\u0000': 
                case '\t': 
                case '\n': 
                case '\u000b': 
                case '\f': 
                case '\r': 
                case ' ': 
                case ',': 
                case ':': 
                case ';': 
                case '=': {
                    throw new IllegalArgumentException("a header name cannot contain the following prohibited characters: =,;: \\t\\r\\n\\v\\f: " + value);
                }
            }
            if (c <= '\u007f') continue;
            throw new IllegalArgumentException("a header name cannot contain non-ASCII character: " + value);
        }
    }

    public static boolean isValidMultipartContentType(String contentType) {
        return HttpHeaderValues.MULTIPART_FORM_DATA.regionMatches(true, 0, contentType, 0, HttpHeaderValues.MULTIPART_FORM_DATA.length()) || HttpHeaderValues.APPLICATION_X_WWW_FORM_URLENCODED.regionMatches(true, 0, contentType, 0, HttpHeaderValues.APPLICATION_X_WWW_FORM_URLENCODED.length());
    }

    public static boolean isValidMultipartMethod(io.netty.handler.codec.http.HttpMethod method) {
        return method.equals(io.netty.handler.codec.http.HttpMethod.POST) || method.equals(io.netty.handler.codec.http.HttpMethod.PUT) || method.equals(io.netty.handler.codec.http.HttpMethod.PATCH) || method.equals(io.netty.handler.codec.http.HttpMethod.DELETE);
    }

    private static class CustomCompressor
    extends HttpContentCompressor {
        private CustomCompressor() {
        }

        @Override
        public ZlibWrapper determineWrapper(String acceptEncoding) {
            return super.determineWrapper(acceptEncoding);
        }
    }
}

