/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.http.impl;

import io.netty.channel.ChannelPipeline;
import io.netty.handler.codec.compression.ZlibCodecFactory;
import io.netty.handler.codec.http.websocketx.extensions.WebSocketServerExtensionHandler;
import io.netty.handler.codec.http.websocketx.extensions.WebSocketServerExtensionHandshaker;
import io.netty.handler.codec.http.websocketx.extensions.compression.DeflateFrameServerExtensionHandshaker;
import io.netty.handler.codec.http.websocketx.extensions.compression.PerMessageDeflateServerExtensionHandshaker;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.GenericFutureListener;
import io.vertx.core.Handler;
import io.vertx.core.http.HttpConnection;
import io.vertx.core.http.HttpServerRequest;
import io.vertx.core.http.ServerWebSocket;
import io.vertx.core.http.impl.Http1xServerConnection;
import io.vertx.core.http.impl.HttpServerConnection;
import io.vertx.core.http.impl.HttpServerImpl;
import io.vertx.core.http.impl.WebSocketRequestHandler;
import io.vertx.core.net.impl.ConnectionBase;
import java.util.ArrayList;
import java.util.Objects;

public class HttpHandlers
implements Handler<HttpServerConnection> {
    final HttpServerImpl server;
    final Handler<HttpServerRequest> requestHandler;
    final Handler<ServerWebSocket> wsHandler;
    final Handler<HttpConnection> connectionHandler;
    final Handler<Throwable> exceptionHandler;

    public HttpHandlers(HttpServerImpl server2, Handler<HttpServerRequest> requestHandler, Handler<ServerWebSocket> wsHandler, Handler<HttpConnection> connectionHandler, Handler<Throwable> exceptionHandler) {
        this.server = server2;
        this.requestHandler = requestHandler;
        this.wsHandler = wsHandler;
        this.connectionHandler = connectionHandler;
        this.exceptionHandler = exceptionHandler;
    }

    @Override
    public void handle(HttpServerConnection conn) {
        this.server.connectionMap.put(conn.channel(), (ConnectionBase)((Object)conn));
        conn.channel().closeFuture().addListener((GenericFutureListener<? extends Future<? super Void>>)((GenericFutureListener<Future>)fut -> this.server.connectionMap.remove(conn.channel())));
        WebSocketRequestHandler requestHandler = this.requestHandler;
        if (!HttpServerImpl.DISABLE_WEBSOCKETS && conn instanceof Http1xServerConnection) {
            requestHandler = new WebSocketRequestHandler(this.server.metrics, this);
            Http1xServerConnection c = (Http1xServerConnection)conn;
            this.initializeWebsocketExtensions(c.channelHandlerContext().pipeline());
        }
        conn.exceptionHandler(this.exceptionHandler);
        conn.handler(requestHandler);
        if (this.connectionHandler != null) {
            this.connectionHandler.handle(conn);
        }
    }

    private void initializeWebsocketExtensions(ChannelPipeline pipeline) {
        ArrayList<WebSocketServerExtensionHandshaker> extensionHandshakers = new ArrayList<WebSocketServerExtensionHandshaker>();
        if (this.server.options.getPerFrameWebsocketCompressionSupported()) {
            extensionHandshakers.add(new DeflateFrameServerExtensionHandshaker(this.server.options.getWebsocketCompressionLevel()));
        }
        if (this.server.options.getPerMessageWebsocketCompressionSupported()) {
            extensionHandshakers.add(new PerMessageDeflateServerExtensionHandshaker(this.server.options.getWebsocketCompressionLevel(), ZlibCodecFactory.isSupportingWindowSizeAndMemLevel(), 15, this.server.options.getWebsocketAllowServerNoContext(), this.server.options.getWebsocketPreferredClientNoContext()));
        }
        if (!extensionHandshakers.isEmpty()) {
            WebSocketServerExtensionHandler extensionHandler = new WebSocketServerExtensionHandler(extensionHandshakers.toArray(new WebSocketServerExtensionHandshaker[extensionHandshakers.size()]));
            pipeline.addBefore("handler", "websocketExtensionHandler", extensionHandler);
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        HttpHandlers that = (HttpHandlers)o;
        if (!Objects.equals(this.requestHandler, that.requestHandler)) {
            return false;
        }
        if (!Objects.equals(this.wsHandler, that.wsHandler)) {
            return false;
        }
        if (!Objects.equals(this.connectionHandler, that.connectionHandler)) {
            return false;
        }
        return Objects.equals(this.exceptionHandler, that.exceptionHandler);
    }

    public int hashCode() {
        int result2 = 0;
        if (this.requestHandler != null) {
            result2 = 31 * result2 + this.requestHandler.hashCode();
        }
        if (this.wsHandler != null) {
            result2 = 31 * result2 + this.wsHandler.hashCode();
        }
        if (this.connectionHandler != null) {
            result2 = 31 * result2 + this.connectionHandler.hashCode();
        }
        if (this.exceptionHandler != null) {
            result2 = 31 * result2 + this.exceptionHandler.hashCode();
        }
        return result2;
    }
}

