/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.http.impl;

import io.vertx.codegen.annotations.Nullable;
import io.vertx.core.AsyncResult;
import io.vertx.core.Closeable;
import io.vertx.core.Context;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.MultiMap;
import io.vertx.core.VertxException;
import io.vertx.core.http.HttpClient;
import io.vertx.core.http.HttpClientOptions;
import io.vertx.core.http.HttpClientRequest;
import io.vertx.core.http.HttpClientResponse;
import io.vertx.core.http.HttpConnection;
import io.vertx.core.http.HttpHeaders;
import io.vertx.core.http.HttpMethod;
import io.vertx.core.http.HttpVersion;
import io.vertx.core.http.RequestOptions;
import io.vertx.core.http.WebSocket;
import io.vertx.core.http.WebSocketConnectOptions;
import io.vertx.core.http.WebsocketVersion;
import io.vertx.core.http.impl.ConnectionManager;
import io.vertx.core.http.impl.Http1xClientConnection;
import io.vertx.core.http.impl.HttpClientConnection;
import io.vertx.core.http.impl.HttpClientRequestImpl;
import io.vertx.core.http.impl.HttpClientStream;
import io.vertx.core.http.impl.HttpUtils;
import io.vertx.core.impl.ContextInternal;
import io.vertx.core.impl.VertxInternal;
import io.vertx.core.logging.Logger;
import io.vertx.core.logging.LoggerFactory;
import io.vertx.core.net.ProxyOptions;
import io.vertx.core.net.ProxyType;
import io.vertx.core.net.SocketAddress;
import io.vertx.core.net.impl.SSLHelper;
import io.vertx.core.spi.metrics.HttpClientMetrics;
import io.vertx.core.spi.metrics.Metrics;
import io.vertx.core.spi.metrics.MetricsProvider;
import io.vertx.core.streams.ReadStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Arrays;
import java.util.Base64;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;

public class HttpClientImpl
implements HttpClient,
MetricsProvider {
    private final Function<HttpClientResponse, Future<HttpClientRequest>> DEFAULT_HANDLER = resp -> {
        try {
            int statusCode = resp.statusCode();
            String location = resp.getHeader(HttpHeaders.LOCATION);
            if (location != null && (statusCode == 301 || statusCode == 302 || statusCode == 303 || statusCode == 307 || statusCode == 308)) {
                boolean ssl;
                HttpMethod m3 = resp.request().method();
                if (statusCode == 303) {
                    m3 = HttpMethod.GET;
                } else if (m3 != HttpMethod.GET && m3 != HttpMethod.HEAD) {
                    return null;
                }
                URI uri = HttpUtils.resolveURIReference(resp.request().absoluteURI(), location);
                int port = uri.getPort();
                String protocol2 = uri.getScheme();
                char chend = protocol2.charAt(protocol2.length() - 1);
                if (chend == 'p') {
                    ssl = false;
                    if (port == -1) {
                        port = 80;
                    }
                } else if (chend == 's') {
                    ssl = true;
                    if (port == -1) {
                        port = 443;
                    }
                } else {
                    return null;
                }
                String requestURI = uri.getPath();
                String query = uri.getQuery();
                if (query != null) {
                    requestURI = requestURI + "?" + query;
                }
                return Future.succeededFuture(this.createRequest(m3, null, uri.getHost(), port, ssl, requestURI, null));
            }
            return null;
        }
        catch (Exception e2) {
            return Future.failedFuture(e2);
        }
    };
    private static final Logger log = LoggerFactory.getLogger(HttpClientImpl.class);
    private final VertxInternal vertx;
    private final HttpClientOptions options;
    private final ContextInternal creatingContext;
    private final ConnectionManager websocketCM;
    private final ConnectionManager httpCM;
    private final Closeable closeHook;
    private final ProxyType proxyType;
    private final SSLHelper sslHelper;
    private final SSLHelper webSocketSSLHelper;
    private final HttpClientMetrics metrics;
    private final boolean keepAlive;
    private final boolean pipelining;
    private volatile boolean closed;
    private volatile Handler<HttpConnection> connectionHandler;
    private volatile Function<HttpClientResponse, Future<HttpClientRequest>> redirectHandler = this.DEFAULT_HANDLER;

    public HttpClientImpl(VertxInternal vertx, HttpClientOptions options2) {
        this.vertx = vertx;
        this.metrics = vertx.metricsSPI() != null ? vertx.metricsSPI().createHttpClientMetrics(options2) : null;
        this.options = new HttpClientOptions(options2);
        List<HttpVersion> alpnVersions = options2.getAlpnVersions();
        if (alpnVersions == null || alpnVersions.isEmpty()) {
            switch (options2.getProtocolVersion()) {
                case HTTP_2: {
                    alpnVersions = Arrays.asList(HttpVersion.HTTP_2, HttpVersion.HTTP_1_1);
                    break;
                }
                default: {
                    alpnVersions = Collections.singletonList(options2.getProtocolVersion());
                }
            }
        }
        this.keepAlive = options2.isKeepAlive();
        this.pipelining = options2.isPipelining();
        this.sslHelper = new SSLHelper(options2, options2.getKeyCertOptions(), options2.getTrustOptions()).setApplicationProtocols(alpnVersions);
        this.sslHelper.validate(vertx);
        this.webSocketSSLHelper = new SSLHelper(this.sslHelper).setUseAlpn(false);
        this.creatingContext = vertx.getContext();
        this.closeHook = completionHandler -> {
            this.close();
            completionHandler.handle(Future.succeededFuture());
        };
        if (this.creatingContext != null) {
            if (this.creatingContext.isMultiThreadedWorkerContext()) {
                throw new IllegalStateException("Cannot use HttpClient in a multi-threaded worker verticle");
            }
            if (options2.getProtocolVersion() == HttpVersion.HTTP_2 && Context.isOnWorkerThread()) {
                throw new IllegalStateException("Cannot use HttpClient with HTTP_2 in a worker");
            }
            this.creatingContext.addCloseHook(this.closeHook);
        }
        if (!this.keepAlive && this.pipelining) {
            throw new IllegalStateException("Cannot have pipelining with no keep alive");
        }
        long maxWeight = options2.getMaxPoolSize() * options2.getHttp2MaxPoolSize();
        this.websocketCM = new ConnectionManager(this, this.metrics, HttpVersion.HTTP_1_1, maxWeight, options2.getMaxWaitQueueSize());
        this.httpCM = new ConnectionManager(this, this.metrics, options2.getProtocolVersion(), maxWeight, options2.getMaxWaitQueueSize());
        this.proxyType = options2.getProxyOptions() != null ? options2.getProxyOptions().getType() : null;
        this.httpCM.start();
        this.websocketCM.start();
    }

    HttpClientMetrics metrics() {
        return this.metrics;
    }

    @Override
    public HttpClient websocket(RequestOptions options2, Handler<WebSocket> wsConnect) {
        return this.websocket(options2, (MultiMap)null, wsConnect);
    }

    @Override
    public HttpClient websocket(int port, String host, String requestURI, Handler<WebSocket> wsConnect) {
        this.websocketStream(port, host, requestURI, null, null).handler(wsConnect);
        return this;
    }

    @Override
    public HttpClient websocket(RequestOptions options2, Handler<WebSocket> wsConnect, Handler<Throwable> failureHandler) {
        return this.websocket(options2, null, wsConnect, failureHandler);
    }

    @Override
    public HttpClient websocket(int port, String host, String requestURI, Handler<WebSocket> wsConnect, Handler<Throwable> failureHandler) {
        this.websocketStream(port, host, requestURI, null, null).subscribe(wsConnect, failureHandler);
        return this;
    }

    @Override
    public HttpClient websocket(String host, String requestURI, Handler<WebSocket> wsConnect) {
        return this.websocket(this.options.getDefaultPort(), host, requestURI, wsConnect);
    }

    @Override
    public HttpClient websocket(String host, String requestURI, Handler<WebSocket> wsConnect, Handler<Throwable> failureHandler) {
        return this.websocket(this.options.getDefaultPort(), host, requestURI, wsConnect, failureHandler);
    }

    @Override
    public HttpClient websocket(RequestOptions options2, MultiMap headers, Handler<WebSocket> wsConnect) {
        return this.websocket(options2, headers, (WebsocketVersion)null, wsConnect);
    }

    @Override
    public HttpClient websocket(int port, String host, String requestURI, MultiMap headers, Handler<WebSocket> wsConnect) {
        this.websocketStream(port, host, requestURI, headers, null).handler(wsConnect);
        return this;
    }

    @Override
    public HttpClient websocket(RequestOptions options2, MultiMap headers, Handler<WebSocket> wsConnect, Handler<Throwable> failureHandler) {
        return this.websocket(options2, headers, null, wsConnect, failureHandler);
    }

    @Override
    public HttpClient websocket(int port, String host, String requestURI, MultiMap headers, Handler<WebSocket> wsConnect, Handler<Throwable> failureHandler) {
        this.websocketStream(port, host, requestURI, headers, null).subscribe(wsConnect, failureHandler);
        return this;
    }

    @Override
    public HttpClient websocket(String host, String requestURI, MultiMap headers, Handler<WebSocket> wsConnect) {
        return this.websocket(this.options.getDefaultPort(), host, requestURI, headers, wsConnect);
    }

    @Override
    public HttpClient websocket(String host, String requestURI, MultiMap headers, Handler<WebSocket> wsConnect, Handler<Throwable> failureHandler) {
        return this.websocket(this.options.getDefaultPort(), host, requestURI, headers, wsConnect, failureHandler);
    }

    @Override
    public HttpClient websocket(RequestOptions options2, MultiMap headers, WebsocketVersion version, Handler<WebSocket> wsConnect) {
        return this.websocket(options2, headers, version, (String)null, wsConnect);
    }

    @Override
    public HttpClient websocket(int port, String host, String requestURI, MultiMap headers, WebsocketVersion version, Handler<WebSocket> wsConnect) {
        this.websocketStream(port, host, requestURI, headers, version, null).handler(wsConnect);
        return this;
    }

    @Override
    public HttpClient websocket(RequestOptions options2, MultiMap headers, WebsocketVersion version, Handler<WebSocket> wsConnect, Handler<Throwable> failureHandler) {
        return this.websocket(options2, headers, version, null, wsConnect, failureHandler);
    }

    @Override
    public HttpClient websocket(int port, String host, String requestURI, MultiMap headers, WebsocketVersion version, Handler<WebSocket> wsConnect, Handler<Throwable> failureHandler) {
        this.websocketStream(port, host, requestURI, headers, version, null).subscribe(wsConnect, failureHandler);
        return this;
    }

    @Override
    public HttpClient websocket(String host, String requestURI, MultiMap headers, WebsocketVersion version, Handler<WebSocket> wsConnect) {
        return this.websocket(this.options.getDefaultPort(), host, requestURI, headers, version, wsConnect);
    }

    @Override
    public HttpClient websocket(String host, String requestURI, MultiMap headers, WebsocketVersion version, Handler<WebSocket> wsConnect, Handler<Throwable> failureHandler) {
        return this.websocket(this.options.getDefaultPort(), host, requestURI, headers, version, wsConnect, failureHandler);
    }

    @Override
    public HttpClient websocket(RequestOptions options2, MultiMap headers, WebsocketVersion version, String subProtocols, Handler<WebSocket> wsConnect) {
        this.websocketStream(options2, headers, version, subProtocols).handler(wsConnect);
        return this;
    }

    @Override
    public HttpClient websocket(int port, String host, String requestURI, MultiMap headers, WebsocketVersion version, String subProtocols, Handler<WebSocket> wsConnect) {
        this.websocketStream(port, host, requestURI, headers, version, subProtocols).handler(wsConnect);
        return this;
    }

    @Override
    public HttpClient websocketAbs(String url, MultiMap headers, WebsocketVersion version, String subProtocols, Handler<WebSocket> wsConnect, Handler<Throwable> failureHandler) {
        this.websocketStreamAbs(url, headers, version, subProtocols).subscribe(wsConnect, failureHandler);
        return this;
    }

    @Override
    public HttpClient websocket(RequestOptions options2, MultiMap headers, WebsocketVersion version, String subProtocols, Handler<WebSocket> wsConnect, Handler<Throwable> failureHandler) {
        this.websocketStream(options2, headers, version, subProtocols).subscribe(wsConnect, failureHandler);
        return this;
    }

    @Override
    public HttpClient websocket(int port, String host, String requestURI, MultiMap headers, WebsocketVersion version, String subProtocols, Handler<WebSocket> wsConnect, Handler<Throwable> failureHandler) {
        this.websocketStream(port, host, requestURI, headers, version, subProtocols).subscribe(wsConnect, failureHandler);
        return this;
    }

    @Override
    public HttpClient websocket(String host, String requestURI, MultiMap headers, WebsocketVersion version, String subProtocols, Handler<WebSocket> wsConnect) {
        return this.websocket(this.options.getDefaultPort(), host, requestURI, headers, version, subProtocols, wsConnect);
    }

    @Override
    public HttpClient websocket(String host, String requestURI, MultiMap headers, WebsocketVersion version, String subProtocols, Handler<WebSocket> wsConnect, Handler<Throwable> failureHandler) {
        return this.websocket(this.options.getDefaultPort(), host, requestURI, headers, version, subProtocols, wsConnect, failureHandler);
    }

    @Override
    public HttpClient websocket(String requestURI, Handler<WebSocket> wsConnect) {
        return this.websocket(this.options.getDefaultPort(), this.options.getDefaultHost(), requestURI, wsConnect);
    }

    @Override
    public HttpClient websocket(String requestURI, Handler<WebSocket> wsConnect, Handler<Throwable> failureHandler) {
        return this.websocket(this.options.getDefaultPort(), this.options.getDefaultHost(), requestURI, wsConnect, failureHandler);
    }

    @Override
    public HttpClient websocket(String requestURI, MultiMap headers, Handler<WebSocket> wsConnect) {
        return this.websocket(this.options.getDefaultPort(), this.options.getDefaultHost(), requestURI, headers, wsConnect);
    }

    @Override
    public HttpClient websocket(String requestURI, MultiMap headers, Handler<WebSocket> wsConnect, Handler<Throwable> failureHandler) {
        return this.websocket(this.options.getDefaultPort(), this.options.getDefaultHost(), requestURI, headers, wsConnect, failureHandler);
    }

    @Override
    public HttpClient websocket(String requestURI, MultiMap headers, WebsocketVersion version, Handler<WebSocket> wsConnect) {
        return this.websocket(this.options.getDefaultPort(), this.options.getDefaultHost(), requestURI, headers, version, wsConnect);
    }

    @Override
    public HttpClient websocket(String requestURI, MultiMap headers, WebsocketVersion version, Handler<WebSocket> wsConnect, Handler<Throwable> failureHandler) {
        return this.websocket(this.options.getDefaultPort(), this.options.getDefaultHost(), requestURI, headers, version, wsConnect, failureHandler);
    }

    @Override
    public HttpClient websocket(String requestURI, MultiMap headers, WebsocketVersion version, String subProtocols, Handler<WebSocket> wsConnect) {
        return this.websocket(this.options.getDefaultPort(), this.options.getDefaultHost(), requestURI, headers, version, subProtocols, wsConnect);
    }

    @Override
    public HttpClient websocket(String requestURI, MultiMap headers, WebsocketVersion version, String subProtocols, Handler<WebSocket> wsConnect, Handler<Throwable> failureHandler) {
        return this.websocket(this.options.getDefaultPort(), this.options.getDefaultHost(), requestURI, headers, version, subProtocols, wsConnect, failureHandler);
    }

    @Override
    public void webSocket(WebSocketConnectOptions connectOptions, Handler<AsyncResult<WebSocket>> handler) {
        ContextInternal ctx = this.vertx.getOrCreateContext();
        SocketAddress addr = SocketAddress.inetSocketAddress(connectOptions.getPort(), connectOptions.getHost());
        boolean ssl = connectOptions.isSsl() != null ? connectOptions.isSsl().booleanValue() : this.options.isSsl();
        this.websocketCM.getConnection(ctx, addr, ssl ? this.webSocketSSLHelper : null, addr, ar -> {
            if (ar.succeeded()) {
                Http1xClientConnection conn = (Http1xClientConnection)ar.result();
                conn.toWebSocket(connectOptions.getURI(), connectOptions.getHeaders(), connectOptions.getVersion(), connectOptions.getSubProtocols(), this.options.getMaxWebsocketFrameSize(), handler);
            } else {
                ctx.executeFromIO(v -> handler.handle(Future.failedFuture(ar.cause())));
            }
        });
    }

    @Override
    public void webSocket(int port, String host, String requestURI, Handler<AsyncResult<WebSocket>> handler) {
        this.webSocket(new WebSocketConnectOptions().setURI(requestURI).setHost(host).setPort(port), handler);
    }

    @Override
    public void webSocket(String host, String requestURI, Handler<AsyncResult<WebSocket>> handler) {
        this.webSocket(this.options.getDefaultPort(), host, requestURI, handler);
    }

    @Override
    public void webSocket(String requestURI, Handler<AsyncResult<WebSocket>> handler) {
        this.webSocket(this.options.getDefaultPort(), this.options.getDefaultHost(), requestURI, handler);
    }

    @Override
    public void webSocketAbs(String url, MultiMap headers, WebsocketVersion version, List<String> subProtocols, Handler<AsyncResult<WebSocket>> handler) {
        WebSocketConnectOptions options2 = new WebSocketConnectOptions();
        this.parseWebSocketRequestOptions(options2, url);
        options2.setHeaders(headers);
        options2.setVersion(version);
        options2.setSubProtocols(subProtocols);
        this.webSocket(options2, handler);
    }

    public WebSocketStream websocketStream(RequestOptions options2) {
        return this.websocketStream(options2, null);
    }

    public WebSocketStream websocketStream(int port, String host, String requestURI) {
        return this.websocketStream(port, host, requestURI, null, null);
    }

    public WebSocketStream websocketStream(String host, String requestURI) {
        return this.websocketStream(this.options.getDefaultPort(), host, requestURI);
    }

    public WebSocketStream websocketStream(RequestOptions options2, MultiMap headers) {
        return this.websocketStream(options2, headers, null);
    }

    public WebSocketStream websocketStream(int port, String host, String requestURI, MultiMap headers) {
        return this.websocketStream(port, host, requestURI, headers, null);
    }

    public WebSocketStream websocketStream(String host, String requestURI, MultiMap headers) {
        return this.websocketStream(this.options.getDefaultPort(), host, requestURI, headers);
    }

    public WebSocketStream websocketStream(RequestOptions options2, MultiMap headers, WebsocketVersion version) {
        return this.websocketStream(options2, headers, version, null);
    }

    public WebSocketStream websocketStream(int port, String host, String requestURI, MultiMap headers, WebsocketVersion version) {
        return this.websocketStream(port, host, requestURI, headers, version, null);
    }

    public WebSocketStream websocketStream(String host, String requestURI, MultiMap headers, WebsocketVersion version) {
        return this.websocketStream(this.options.getDefaultPort(), host, requestURI, headers, version);
    }

    private void parseWebSocketRequestOptions(RequestOptions options2, String url) {
        URI uri;
        try {
            uri = new URI(url);
        }
        catch (URISyntaxException e2) {
            throw new IllegalArgumentException(e2);
        }
        String scheme = uri.getScheme();
        if (!"ws".equals(scheme) && !"wss".equals(scheme)) {
            throw new IllegalArgumentException("Scheme: " + scheme);
        }
        boolean ssl = scheme.length() == 3;
        int port = uri.getPort();
        if (port == -1) {
            port = ssl ? 443 : 80;
        }
        StringBuilder relativeUri = new StringBuilder();
        if (uri.getRawPath() != null) {
            relativeUri.append(uri.getRawPath());
        }
        if (uri.getRawQuery() != null) {
            relativeUri.append('?').append(uri.getRawQuery());
        }
        if (uri.getRawFragment() != null) {
            relativeUri.append('#').append(uri.getRawFragment());
        }
        options2.setHost(uri.getHost()).setPort(port).setSsl(ssl).setURI(relativeUri.toString());
    }

    public WebSocketStream websocketStreamAbs(String url, MultiMap headers, WebsocketVersion version, String subProtocols) {
        RequestOptions options2 = new RequestOptions();
        this.parseWebSocketRequestOptions(options2, url);
        return this.websocketStream(options2, headers, version, subProtocols);
    }

    public WebSocketStream websocketStream(RequestOptions options2, MultiMap headers, WebsocketVersion version, String subProtocols) {
        WebSocketConnectOptions connectOptions = new WebSocketConnectOptions(options2);
        connectOptions.setHeaders(headers);
        connectOptions.setVersion(version);
        if (subProtocols != null) {
            connectOptions.setSubProtocols(Arrays.asList(subProtocols.split(",")));
        }
        return new WebSocketStream(connectOptions);
    }

    public WebSocketStream websocketStream(int port, String host, String requestURI, MultiMap headers, WebsocketVersion version, String subProtocols) {
        return this.websocketStream(new RequestOptions().setPort(port).setHost(host).setURI(requestURI), headers, version, subProtocols);
    }

    public WebSocketStream websocketStream(String host, String requestURI, MultiMap headers, WebsocketVersion version, String subProtocols) {
        return this.websocketStream(this.options.getDefaultPort(), host, requestURI, headers, version, subProtocols);
    }

    public WebSocketStream websocketStream(String requestURI) {
        return this.websocketStream(this.options.getDefaultPort(), this.options.getDefaultHost(), requestURI);
    }

    public WebSocketStream websocketStream(String requestURI, MultiMap headers) {
        return this.websocketStream(this.options.getDefaultPort(), this.options.getDefaultHost(), requestURI, headers);
    }

    public WebSocketStream websocketStream(String requestURI, MultiMap headers, WebsocketVersion version) {
        return this.websocketStream(this.options.getDefaultPort(), this.options.getDefaultHost(), requestURI, headers, version);
    }

    public WebSocketStream websocketStream(String requestURI, MultiMap headers, WebsocketVersion version, String subProtocols) {
        return this.websocketStream(this.options.getDefaultPort(), this.options.getDefaultHost(), requestURI, headers, version, subProtocols);
    }

    @Override
    public HttpClientRequest requestAbs(HttpMethod method, String absoluteURI, Handler<HttpClientResponse> responseHandler) {
        return this.requestAbs(method, null, absoluteURI, responseHandler);
    }

    @Override
    public HttpClientRequest requestAbs(HttpMethod method, SocketAddress serverAddress, String absoluteURI, Handler<HttpClientResponse> responseHandler) {
        return this.requestAbs(method, serverAddress, absoluteURI).handler((Handler)responseHandler);
    }

    @Override
    public HttpClientRequest get(RequestOptions options2) {
        return this.request(HttpMethod.GET, options2);
    }

    @Override
    public HttpClientRequest request(HttpMethod method, int port, String host, String requestURI, Handler<HttpClientResponse> responseHandler) {
        Objects.requireNonNull(responseHandler, "no null responseHandler accepted");
        return this.request(method, port, host, requestURI).handler((Handler)responseHandler);
    }

    @Override
    public HttpClientRequest request(HttpMethod method, SocketAddress serverAddress, int port, String host, String requestURI, Handler<HttpClientResponse> responseHandler) {
        Objects.requireNonNull(responseHandler, "no null responseHandler accepted");
        return this.request(method, serverAddress, port, host, requestURI).handler((Handler)responseHandler);
    }

    @Override
    public HttpClientRequest request(HttpMethod method, String host, String requestURI, Handler<HttpClientResponse> responseHandler) {
        return this.request(method, this.options.getDefaultPort(), host, requestURI, responseHandler);
    }

    @Override
    public HttpClientRequest request(HttpMethod method, String requestURI) {
        return this.request(method, this.options.getDefaultPort(), this.options.getDefaultHost(), requestURI);
    }

    @Override
    public HttpClientRequest request(HttpMethod method, String requestURI, Handler<HttpClientResponse> responseHandler) {
        return this.request(method, this.options.getDefaultPort(), this.options.getDefaultHost(), requestURI, responseHandler);
    }

    @Override
    public HttpClientRequest requestAbs(HttpMethod method, String absoluteURI) {
        return this.requestAbs(method, null, absoluteURI);
    }

    @Override
    public HttpClientRequest requestAbs(HttpMethod method, SocketAddress serverAddress, String absoluteURI) {
        URL url = this.parseUrl(absoluteURI);
        Boolean ssl = false;
        int port = url.getPort();
        String relativeUri = url.getPath().isEmpty() ? "/" + url.getFile() : url.getFile();
        String protocol2 = url.getProtocol();
        if ("ftp".equals(protocol2)) {
            if (port == -1) {
                port = 21;
            }
        } else {
            char chend = protocol2.charAt(protocol2.length() - 1);
            if (chend == 'p') {
                if (port == -1) {
                    port = 80;
                }
            } else if (chend == 's') {
                ssl = true;
                if (port == -1) {
                    port = 443;
                }
            }
        }
        return this.createRequest(method, serverAddress, protocol2, url.getHost(), port, ssl, relativeUri, null);
    }

    @Override
    public HttpClientRequest request(HttpMethod method, int port, String host, String requestURI) {
        return this.createRequest(method, null, host, port, null, requestURI, null);
    }

    @Override
    public HttpClientRequest request(HttpMethod method, SocketAddress serverAddress, int port, String host, String requestURI) {
        return this.createRequest(method, serverAddress, host, port, null, requestURI, null);
    }

    @Override
    public HttpClientRequest request(HttpMethod method, RequestOptions options2, Handler<HttpClientResponse> responseHandler) {
        return this.request(method, options2).handler((Handler)responseHandler);
    }

    @Override
    public HttpClientRequest request(HttpMethod method, SocketAddress serverAddress, RequestOptions options2, Handler<HttpClientResponse> responseHandler) {
        return this.request(method, serverAddress, options2).handler((Handler)responseHandler);
    }

    @Override
    public HttpClientRequest request(HttpMethod method, SocketAddress serverAddress, RequestOptions options2) {
        return this.createRequest(method, serverAddress, options2.getHost(), options2.getPort(), options2.isSsl(), options2.getURI(), null);
    }

    @Override
    public HttpClientRequest request(HttpMethod method, RequestOptions options2) {
        return this.createRequest(method, null, options2.getHost(), options2.getPort(), options2.isSsl(), options2.getURI(), options2.getHeaders());
    }

    @Override
    public HttpClientRequest request(HttpMethod method, String host, String requestURI) {
        return this.request(method, this.options.getDefaultPort(), host, requestURI);
    }

    @Override
    public HttpClientRequest get(int port, String host, String requestURI) {
        return this.request(HttpMethod.GET, port, host, requestURI);
    }

    @Override
    public HttpClientRequest get(String host, String requestURI) {
        return this.get(this.options.getDefaultPort(), host, requestURI);
    }

    @Override
    public HttpClientRequest get(RequestOptions options2, Handler<HttpClientResponse> responseHandler) {
        return this.request(HttpMethod.GET, options2, responseHandler);
    }

    @Override
    public HttpClientRequest get(int port, String host, String requestURI, Handler<HttpClientResponse> responseHandler) {
        return this.request(HttpMethod.GET, port, host, requestURI, responseHandler);
    }

    @Override
    public HttpClientRequest get(String host, String requestURI, Handler<HttpClientResponse> responseHandler) {
        return this.get(this.options.getDefaultPort(), host, requestURI, responseHandler);
    }

    @Override
    public HttpClientRequest get(String requestURI) {
        return this.request(HttpMethod.GET, requestURI);
    }

    @Override
    public HttpClientRequest get(String requestURI, Handler<HttpClientResponse> responseHandler) {
        return this.request(HttpMethod.GET, requestURI, responseHandler);
    }

    @Override
    public HttpClientRequest getAbs(String absoluteURI) {
        return this.requestAbs(HttpMethod.GET, absoluteURI);
    }

    @Override
    public HttpClientRequest getAbs(String absoluteURI, Handler<HttpClientResponse> responseHandler) {
        return this.requestAbs(HttpMethod.GET, absoluteURI, responseHandler);
    }

    @Override
    public HttpClient getNow(RequestOptions options2, Handler<HttpClientResponse> responseHandler) {
        return this.requestNow(HttpMethod.GET, options2, responseHandler);
    }

    @Override
    public HttpClient getNow(int port, String host, String requestURI, Handler<HttpClientResponse> responseHandler) {
        this.get(port, host, requestURI, responseHandler).end();
        return this;
    }

    @Override
    public HttpClient getNow(String host, String requestURI, Handler<HttpClientResponse> responseHandler) {
        return this.getNow(this.options.getDefaultPort(), host, requestURI, responseHandler);
    }

    @Override
    public HttpClient getNow(String requestURI, Handler<HttpClientResponse> responseHandler) {
        this.get(requestURI, responseHandler).end();
        return this;
    }

    @Override
    public HttpClientRequest post(RequestOptions options2) {
        return this.request(HttpMethod.POST, options2);
    }

    @Override
    public HttpClientRequest post(int port, String host, String requestURI) {
        return this.request(HttpMethod.POST, port, host, requestURI);
    }

    @Override
    public HttpClientRequest post(String host, String requestURI) {
        return this.post(this.options.getDefaultPort(), host, requestURI);
    }

    @Override
    public HttpClientRequest post(RequestOptions options2, Handler<HttpClientResponse> responseHandler) {
        return this.request(HttpMethod.POST, options2, responseHandler);
    }

    @Override
    public HttpClientRequest post(int port, String host, String requestURI, Handler<HttpClientResponse> responseHandler) {
        return this.request(HttpMethod.POST, port, host, requestURI, responseHandler);
    }

    @Override
    public HttpClientRequest post(String host, String requestURI, Handler<HttpClientResponse> responseHandler) {
        return this.post(this.options.getDefaultPort(), host, requestURI, responseHandler);
    }

    @Override
    public HttpClientRequest post(String requestURI) {
        return this.request(HttpMethod.POST, requestURI);
    }

    @Override
    public HttpClientRequest post(String requestURI, Handler<HttpClientResponse> responseHandler) {
        return this.request(HttpMethod.POST, requestURI, responseHandler);
    }

    @Override
    public HttpClientRequest postAbs(String absoluteURI) {
        return this.requestAbs(HttpMethod.POST, absoluteURI);
    }

    @Override
    public HttpClientRequest postAbs(String absoluteURI, Handler<HttpClientResponse> responseHandler) {
        return this.requestAbs(HttpMethod.POST, absoluteURI, responseHandler);
    }

    @Override
    public HttpClientRequest head(RequestOptions options2) {
        return this.request(HttpMethod.HEAD, options2);
    }

    @Override
    public HttpClientRequest head(int port, String host, String requestURI) {
        return this.request(HttpMethod.HEAD, port, host, requestURI);
    }

    @Override
    public HttpClientRequest head(String host, String requestURI) {
        return this.head(this.options.getDefaultPort(), host, requestURI);
    }

    @Override
    public HttpClientRequest head(RequestOptions options2, Handler<HttpClientResponse> responseHandler) {
        return this.request(HttpMethod.HEAD, options2, responseHandler);
    }

    @Override
    public HttpClientRequest head(int port, String host, String requestURI, Handler<HttpClientResponse> responseHandler) {
        return this.request(HttpMethod.HEAD, port, host, requestURI, responseHandler);
    }

    @Override
    public HttpClientRequest head(String host, String requestURI, Handler<HttpClientResponse> responseHandler) {
        return this.head(this.options.getDefaultPort(), host, requestURI, responseHandler);
    }

    @Override
    public HttpClientRequest head(String requestURI) {
        return this.request(HttpMethod.HEAD, requestURI);
    }

    @Override
    public HttpClientRequest head(String requestURI, Handler<HttpClientResponse> responseHandler) {
        return this.request(HttpMethod.HEAD, requestURI, responseHandler);
    }

    @Override
    public HttpClientRequest headAbs(String absoluteURI) {
        return this.requestAbs(HttpMethod.HEAD, absoluteURI);
    }

    @Override
    public HttpClientRequest headAbs(String absoluteURI, Handler<HttpClientResponse> responseHandler) {
        return this.requestAbs(HttpMethod.HEAD, absoluteURI, responseHandler);
    }

    @Override
    public HttpClient headNow(RequestOptions options2, Handler<HttpClientResponse> responseHandler) {
        return this.requestNow(HttpMethod.HEAD, options2, responseHandler);
    }

    @Override
    public HttpClient headNow(int port, String host, String requestURI, Handler<HttpClientResponse> responseHandler) {
        this.head(port, host, requestURI, responseHandler).end();
        return this;
    }

    @Override
    public HttpClient headNow(String host, String requestURI, Handler<HttpClientResponse> responseHandler) {
        return this.headNow(this.options.getDefaultPort(), host, requestURI, responseHandler);
    }

    @Override
    public HttpClient headNow(String requestURI, Handler<HttpClientResponse> responseHandler) {
        this.head(requestURI, responseHandler).end();
        return this;
    }

    @Override
    public HttpClientRequest options(RequestOptions options2) {
        return this.request(HttpMethod.OPTIONS, options2);
    }

    @Override
    public HttpClientRequest options(int port, String host, String requestURI) {
        return this.request(HttpMethod.OPTIONS, port, host, requestURI);
    }

    @Override
    public HttpClientRequest options(String host, String requestURI) {
        return this.options(this.options.getDefaultPort(), host, requestURI);
    }

    @Override
    public HttpClientRequest options(RequestOptions options2, Handler<HttpClientResponse> responseHandler) {
        return this.request(HttpMethod.OPTIONS, options2, responseHandler);
    }

    @Override
    public HttpClientRequest options(int port, String host, String requestURI, Handler<HttpClientResponse> responseHandler) {
        return this.request(HttpMethod.OPTIONS, port, host, requestURI, responseHandler);
    }

    @Override
    public HttpClientRequest options(String host, String requestURI, Handler<HttpClientResponse> responseHandler) {
        return this.options(this.options.getDefaultPort(), host, requestURI, responseHandler);
    }

    @Override
    public HttpClientRequest options(String requestURI) {
        return this.request(HttpMethod.OPTIONS, requestURI);
    }

    @Override
    public HttpClientRequest options(String requestURI, Handler<HttpClientResponse> responseHandler) {
        return this.request(HttpMethod.OPTIONS, requestURI, responseHandler);
    }

    @Override
    public HttpClientRequest optionsAbs(String absoluteURI) {
        return this.requestAbs(HttpMethod.OPTIONS, absoluteURI);
    }

    @Override
    public HttpClientRequest optionsAbs(String absoluteURI, Handler<HttpClientResponse> responseHandler) {
        return this.requestAbs(HttpMethod.OPTIONS, absoluteURI, responseHandler);
    }

    @Override
    public HttpClient optionsNow(RequestOptions options2, Handler<HttpClientResponse> responseHandler) {
        return this.requestNow(HttpMethod.OPTIONS, options2, responseHandler);
    }

    @Override
    public HttpClient optionsNow(int port, String host, String requestURI, Handler<HttpClientResponse> responseHandler) {
        this.options(port, host, requestURI, responseHandler).end();
        return this;
    }

    @Override
    public HttpClient optionsNow(String host, String requestURI, Handler<HttpClientResponse> responseHandler) {
        return this.optionsNow(this.options.getDefaultPort(), host, requestURI, responseHandler);
    }

    @Override
    public HttpClient optionsNow(String requestURI, Handler<HttpClientResponse> responseHandler) {
        this.options(requestURI, responseHandler).end();
        return this;
    }

    @Override
    public HttpClientRequest put(RequestOptions options2) {
        return this.request(HttpMethod.PUT, options2);
    }

    @Override
    public HttpClientRequest put(int port, String host, String requestURI) {
        return this.request(HttpMethod.PUT, port, host, requestURI);
    }

    @Override
    public HttpClientRequest put(String host, String requestURI) {
        return this.put(this.options.getDefaultPort(), host, requestURI);
    }

    @Override
    public HttpClientRequest put(RequestOptions options2, Handler<HttpClientResponse> responseHandler) {
        return this.request(HttpMethod.PUT, options2, responseHandler);
    }

    @Override
    public HttpClientRequest put(int port, String host, String requestURI, Handler<HttpClientResponse> responseHandler) {
        return this.request(HttpMethod.PUT, port, host, requestURI, responseHandler);
    }

    @Override
    public HttpClientRequest put(String host, String requestURI, Handler<HttpClientResponse> responseHandler) {
        return this.put(this.options.getDefaultPort(), host, requestURI, responseHandler);
    }

    @Override
    public HttpClientRequest put(String requestURI) {
        return this.request(HttpMethod.PUT, requestURI);
    }

    @Override
    public HttpClientRequest put(String requestURI, Handler<HttpClientResponse> responseHandler) {
        return this.request(HttpMethod.PUT, requestURI, responseHandler);
    }

    @Override
    public HttpClientRequest putAbs(String absoluteURI) {
        return this.requestAbs(HttpMethod.PUT, absoluteURI);
    }

    @Override
    public HttpClientRequest putAbs(String absoluteURI, Handler<HttpClientResponse> responseHandler) {
        return this.requestAbs(HttpMethod.PUT, absoluteURI, responseHandler);
    }

    @Override
    public HttpClientRequest delete(RequestOptions options2) {
        return this.request(HttpMethod.DELETE, options2);
    }

    @Override
    public HttpClientRequest delete(int port, String host, String requestURI) {
        return this.request(HttpMethod.DELETE, port, host, requestURI);
    }

    @Override
    public HttpClientRequest delete(String host, String requestURI) {
        return this.delete(this.options.getDefaultPort(), host, requestURI);
    }

    @Override
    public HttpClientRequest delete(RequestOptions options2, Handler<HttpClientResponse> responseHandler) {
        return this.request(HttpMethod.DELETE, options2, responseHandler);
    }

    @Override
    public HttpClientRequest delete(int port, String host, String requestURI, Handler<HttpClientResponse> responseHandler) {
        return this.request(HttpMethod.DELETE, port, host, requestURI, responseHandler);
    }

    @Override
    public HttpClientRequest delete(String host, String requestURI, Handler<HttpClientResponse> responseHandler) {
        return this.delete(this.options.getDefaultPort(), host, requestURI, responseHandler);
    }

    @Override
    public HttpClientRequest delete(String requestURI) {
        return this.request(HttpMethod.DELETE, requestURI);
    }

    @Override
    public HttpClientRequest delete(String requestURI, Handler<HttpClientResponse> responseHandler) {
        return this.request(HttpMethod.DELETE, requestURI, responseHandler);
    }

    @Override
    public HttpClientRequest deleteAbs(String absoluteURI) {
        return this.requestAbs(HttpMethod.DELETE, absoluteURI);
    }

    @Override
    public HttpClientRequest deleteAbs(String absoluteURI, Handler<HttpClientResponse> responseHandler) {
        return this.requestAbs(HttpMethod.DELETE, absoluteURI, responseHandler);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        HttpClientImpl httpClientImpl = this;
        synchronized (httpClientImpl) {
            if (this.closed) {
                return;
            }
            this.closed = true;
        }
        if (this.creatingContext != null) {
            this.creatingContext.removeCloseHook(this.closeHook);
        }
        this.websocketCM.close();
        this.httpCM.close();
        if (this.metrics != null) {
            this.metrics.close();
        }
    }

    @Override
    public boolean isMetricsEnabled() {
        return this.getMetrics() != null;
    }

    @Override
    public Metrics getMetrics() {
        return this.metrics;
    }

    @Override
    public HttpClient connectionHandler(Handler<HttpConnection> handler) {
        this.connectionHandler = handler;
        return this;
    }

    Handler<HttpConnection> connectionHandler() {
        return this.connectionHandler;
    }

    @Override
    public HttpClient redirectHandler(Function<HttpClientResponse, Future<HttpClientRequest>> handler) {
        if (handler == null) {
            handler = this.DEFAULT_HANDLER;
        }
        this.redirectHandler = handler;
        return this;
    }

    @Override
    public Function<HttpClientResponse, Future<HttpClientRequest>> redirectHandler() {
        return this.redirectHandler;
    }

    public HttpClientOptions getOptions() {
        return this.options;
    }

    void getConnectionForRequest(ContextInternal ctx, SocketAddress peerAddress, boolean ssl, SocketAddress server2, Handler<AsyncResult<HttpClientStream>> handler) {
        this.httpCM.getConnection(ctx, peerAddress, ssl ? this.sslHelper : null, server2, ar -> {
            if (ar.succeeded()) {
                ((HttpClientConnection)ar.result()).createStream(handler);
            } else {
                handler.handle(Future.failedFuture(ar.cause()));
            }
        });
    }

    public VertxInternal getVertx() {
        return this.vertx;
    }

    SSLHelper getSslHelper() {
        return this.sslHelper;
    }

    private URL parseUrl(String surl) {
        try {
            return new URL(surl);
        }
        catch (MalformedURLException e2) {
            throw new VertxException("Invalid url: " + surl, e2);
        }
    }

    private HttpClient requestNow(HttpMethod method, RequestOptions options2, Handler<HttpClientResponse> responseHandler) {
        this.createRequest(method, null, options2.getHost(), options2.getPort(), options2.isSsl(), options2.getURI(), null).handler((Handler)responseHandler).end();
        return this;
    }

    private HttpClientRequest createRequest(HttpMethod method, SocketAddress serverAddress, String host, int port, Boolean ssl, String relativeURI, MultiMap headers) {
        return this.createRequest(method, serverAddress, ssl == null || ssl == false ? "http" : "https", host, port, ssl, relativeURI, headers);
    }

    private HttpClientRequest createRequest(HttpMethod method, SocketAddress server2, String protocol2, String host, int port, Boolean ssl, String relativeURI, MultiMap headers) {
        HttpClientRequestImpl req;
        boolean useProxy;
        boolean useSSL;
        Objects.requireNonNull(method, "no null method accepted");
        Objects.requireNonNull(protocol2, "no null protocol accepted");
        Objects.requireNonNull(host, "no null host accepted");
        Objects.requireNonNull(relativeURI, "no null relativeURI accepted");
        boolean useAlpn = this.options.isUseAlpn();
        boolean bl = useSSL = ssl != null ? ssl.booleanValue() : this.options.isSsl();
        if (!useAlpn && useSSL && this.options.getProtocolVersion() == HttpVersion.HTTP_2) {
            throw new IllegalArgumentException("Must enable ALPN when using H2");
        }
        this.checkClosed();
        boolean bl2 = useProxy = !useSSL && this.proxyType == ProxyType.HTTP;
        if (useProxy) {
            int defaultPort = protocol2.equals("ftp") ? 21 : 80;
            String addPort = port != -1 && port != defaultPort ? ":" + port : "";
            relativeURI = protocol2 + "://" + host + addPort + relativeURI;
            ProxyOptions proxyOptions = this.options.getProxyOptions();
            if (proxyOptions.getUsername() != null && proxyOptions.getPassword() != null) {
                if (headers == null) {
                    headers = MultiMap.caseInsensitiveMultiMap();
                }
                headers.add("Proxy-Authorization", "Basic " + Base64.getEncoder().encodeToString((proxyOptions.getUsername() + ":" + proxyOptions.getPassword()).getBytes()));
            }
            req = new HttpClientRequestImpl(this, useSSL, method, SocketAddress.inetSocketAddress(proxyOptions.getPort(), proxyOptions.getHost()), host, port, relativeURI, this.vertx);
        } else {
            if (server2 == null) {
                server2 = SocketAddress.inetSocketAddress(port, host);
            }
            req = new HttpClientRequestImpl(this, useSSL, method, server2, host, port, relativeURI, this.vertx);
        }
        if (headers != null) {
            req.headers().setAll(headers);
        }
        return req;
    }

    private synchronized void checkClosed() {
        if (this.closed) {
            throw new IllegalStateException("Client is closed");
        }
    }

    protected void finalize() throws Throwable {
        this.close();
        super.finalize();
    }

    private class WebSocketStream
    implements ReadStream<WebSocket> {
        private WebSocketConnectOptions options;
        private Handler<WebSocket> handler;
        private Handler<Throwable> exceptionHandler;
        private Handler<Void> endHandler;

        WebSocketStream(WebSocketConnectOptions options2) {
            this.options = options2;
        }

        void subscribe(Handler<WebSocket> completionHandler, Handler<Throwable> failureHandler) {
            Future<WebSocket> fut = Future.future();
            fut.onComplete(ar -> {
                if (ar.succeeded()) {
                    completionHandler.handle((WebSocket)ar.result());
                } else if (failureHandler == null) {
                    log.error(ar.cause());
                } else {
                    failureHandler.handle(ar.cause());
                }
            });
            HttpClientImpl.this.webSocket(this.options, fut);
        }

        @Override
        public synchronized ReadStream<WebSocket> endHandler(Handler<Void> endHandler) {
            this.endHandler = endHandler;
            return this;
        }

        @Override
        public ReadStream<WebSocket> pause() {
            return this;
        }

        @Override
        public ReadStream<WebSocket> resume() {
            return this;
        }

        @Override
        public synchronized ReadStream<WebSocket> exceptionHandler(Handler<Throwable> handler) {
            this.exceptionHandler = handler;
            return this;
        }

        @Override
        public ReadStream<WebSocket> handler(@Nullable Handler<WebSocket> handler) {
            if (this.handler == null && handler != null) {
                this.handler = handler;
                this.subscribe(ws -> {
                    handler.handle((WebSocket)ws);
                    if (this.endHandler != null) {
                        this.endHandler.handle(null);
                    }
                }, err -> {
                    if (this.exceptionHandler != null) {
                        this.exceptionHandler.handle((Throwable)err);
                    }
                    if (this.endHandler != null) {
                        this.endHandler.handle(null);
                    }
                });
            }
            return this;
        }

        @Override
        public ReadStream<WebSocket> fetch(long amount) {
            return this;
        }
    }
}

