/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.http.impl;

import io.netty.bootstrap.Bootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPipeline;
import io.netty.handler.codec.http.HttpClientCodec;
import io.netty.handler.codec.http.HttpContentDecompressor;
import io.netty.handler.logging.LoggingHandler;
import io.netty.handler.timeout.IdleStateHandler;
import io.vertx.core.AsyncResult;
import io.vertx.core.Handler;
import io.vertx.core.Promise;
import io.vertx.core.http.HttpClientOptions;
import io.vertx.core.http.HttpVersion;
import io.vertx.core.http.impl.Http1xClientConnection;
import io.vertx.core.http.impl.Http2ClientConnection;
import io.vertx.core.http.impl.Http2UpgradedClientConnection;
import io.vertx.core.http.impl.HttpClientConnection;
import io.vertx.core.http.impl.HttpClientImpl;
import io.vertx.core.http.impl.VertxHttp2ConnectionHandler;
import io.vertx.core.http.impl.pool.ConnectResult;
import io.vertx.core.http.impl.pool.ConnectionListener;
import io.vertx.core.http.impl.pool.ConnectionProvider;
import io.vertx.core.impl.ContextInternal;
import io.vertx.core.net.ProxyOptions;
import io.vertx.core.net.ProxyType;
import io.vertx.core.net.SocketAddress;
import io.vertx.core.net.impl.ChannelProvider;
import io.vertx.core.net.impl.SSLHelper;
import io.vertx.core.net.impl.VertxHandler;
import io.vertx.core.spi.metrics.HttpClientMetrics;

class HttpChannelConnector
implements ConnectionProvider<HttpClientConnection> {
    private final HttpClientImpl client;
    private final HttpClientOptions options;
    private final HttpClientMetrics metrics;
    private final SSLHelper sslHelper;
    private final HttpVersion version;
    private final long weight;
    private final long http1Weight;
    private final long http2Weight;
    private final long http1MaxConcurrency;
    private final SocketAddress peerAddress;
    private final SocketAddress server;
    private final Object endpointMetric;

    HttpChannelConnector(HttpClientImpl client, Object endpointMetric, HttpVersion version, SSLHelper sslHelper, SocketAddress peerAddress, SocketAddress server2) {
        this.client = client;
        this.endpointMetric = endpointMetric;
        this.options = client.getOptions();
        this.metrics = client.metrics();
        this.sslHelper = sslHelper;
        this.version = version;
        this.http1Weight = this.options.getHttp2MaxPoolSize();
        this.http2Weight = this.options.getMaxPoolSize();
        this.weight = version == HttpVersion.HTTP_2 ? this.http2Weight : this.http1Weight;
        this.http1MaxConcurrency = this.options.isPipelining() ? (long)this.options.getPipeliningLimit() : 1L;
        this.peerAddress = peerAddress;
        this.server = server2;
    }

    public long weight() {
        return this.weight;
    }

    @Override
    public void close(HttpClientConnection conn) {
        conn.close();
    }

    @Override
    public boolean isValid(HttpClientConnection conn) {
        return conn.isValid();
    }

    @Override
    public void connect(ConnectionListener<HttpClientConnection> listener, ContextInternal context, Handler<AsyncResult<ConnectResult<HttpClientConnection>>> handler) {
        Promise<ConnectResult<HttpClientConnection>> promise2 = Promise.promise();
        promise2.future().onComplete(handler);
        try {
            this.doConnect(listener, context, promise2);
        }
        catch (Exception e2) {
            promise2.tryFail(e2);
        }
    }

    private void doConnect(ConnectionListener<HttpClientConnection> listener, ContextInternal context, Promise<ConnectResult<HttpClientConnection>> future2) {
        boolean domainSocket = this.server.path() != null;
        boolean useAlpn = this.sslHelper != null && this.sslHelper.isUseAlpn();
        Bootstrap bootstrap = new Bootstrap();
        bootstrap.group(context.nettyEventLoop());
        this.applyConnectionOptions(domainSocket, bootstrap);
        ProxyOptions options2 = this.options.getProxyOptions();
        if (options2 != null && this.sslHelper == null && options2.getType() == ProxyType.HTTP) {
            options2 = null;
        }
        ChannelProvider channelProvider = new ChannelProvider(bootstrap, this.sslHelper, context, options2);
        Handler<AsyncResult<Channel>> channelHandler = res -> {
            if (res.succeeded()) {
                Channel ch = (Channel)res.result();
                if (this.sslHelper != null) {
                    String protocol2 = channelProvider.applicationProtocol();
                    if (useAlpn) {
                        if ("h2".equals(protocol2)) {
                            this.applyHttp2ConnectionOptions(ch.pipeline());
                            this.http2Connected(listener, context, ch, future2);
                        } else {
                            this.applyHttp1xConnectionOptions(ch.pipeline());
                            HttpVersion fallbackProtocol = "http/1.0".equals(protocol2) ? HttpVersion.HTTP_1_0 : HttpVersion.HTTP_1_1;
                            this.http1xConnected(listener, fallbackProtocol, this.server, true, context, ch, this.http1Weight, future2);
                        }
                    } else {
                        this.applyHttp1xConnectionOptions(ch.pipeline());
                        this.http1xConnected(listener, this.version, this.server, true, context, ch, this.http1Weight, future2);
                    }
                } else {
                    ChannelPipeline pipeline = ch.pipeline();
                    if (this.version == HttpVersion.HTTP_2) {
                        if (this.options.isHttp2ClearTextUpgrade()) {
                            this.applyHttp1xConnectionOptions(pipeline);
                            this.http1xConnected(listener, this.version, this.server, false, context, ch, this.http2Weight, future2);
                        } else {
                            this.applyHttp2ConnectionOptions(pipeline);
                            this.http2Connected(listener, context, ch, future2);
                        }
                    } else {
                        this.applyHttp1xConnectionOptions(pipeline);
                        this.http1xConnected(listener, this.version, this.server, false, context, ch, this.http1Weight, future2);
                    }
                }
            } else {
                this.connectFailed(channelProvider.channel(), listener, res.cause(), future2);
            }
        };
        channelProvider.connect(this.server, this.peerAddress, this.options.isForceSni() ? this.peerAddress.host() : null, this.sslHelper != null, channelHandler);
    }

    private void applyConnectionOptions(boolean domainSocket, Bootstrap bootstrap) {
        this.client.getVertx().transport().configure(this.options, domainSocket, bootstrap);
    }

    private void applyHttp2ConnectionOptions(ChannelPipeline pipeline) {
        if (this.options.getIdleTimeout() > 0) {
            pipeline.addLast("idle", (ChannelHandler)new IdleStateHandler(0L, 0L, this.options.getIdleTimeout(), this.options.getIdleTimeoutUnit()));
        }
    }

    private void applyHttp1xConnectionOptions(ChannelPipeline pipeline) {
        if (this.options.getIdleTimeout() > 0) {
            pipeline.addLast("idle", (ChannelHandler)new IdleStateHandler(0L, 0L, this.options.getIdleTimeout(), this.options.getIdleTimeoutUnit()));
        }
        if (this.options.getLogActivity()) {
            pipeline.addLast("logging", (ChannelHandler)new LoggingHandler());
        }
        pipeline.addLast("codec", (ChannelHandler)new HttpClientCodec(this.options.getMaxInitialLineLength(), this.options.getMaxHeaderSize(), this.options.getMaxChunkSize(), false, false, this.options.getDecoderInitialBufferSize()));
        if (this.options.isTryUseCompression()) {
            pipeline.addLast("inflater", (ChannelHandler)new HttpContentDecompressor(false));
        }
    }

    private void http1xConnected(ConnectionListener<HttpClientConnection> listener, HttpVersion version, SocketAddress server2, boolean ssl, ContextInternal context, Channel ch, long weight, Promise<ConnectResult<HttpClientConnection>> future2) {
        boolean upgrade = version == HttpVersion.HTTP_2 && this.options.isHttp2ClearTextUpgrade();
        VertxHandler<Http1xClientConnection> clientHandler = VertxHandler.create(context, chctx -> {
            Http1xClientConnection conn = new Http1xClientConnection(listener, upgrade ? HttpVersion.HTTP_1_1 : version, this.client, this.endpointMetric, (ChannelHandlerContext)chctx, ssl, server2, context, this.metrics);
            if (this.metrics != null) {
                context.executeFromIO(v -> {
                    Object socketMetric = this.metrics.connected(conn.remoteAddress(), conn.remoteName());
                    conn.metric(socketMetric);
                    this.metrics.endpointConnected(this.endpointMetric, socketMetric);
                });
            }
            return conn;
        });
        clientHandler.addHandler(conn -> {
            if (upgrade) {
                future2.complete(new ConnectResult<Http2UpgradedClientConnection>(new Http2UpgradedClientConnection(this.client, (Http1xClientConnection)conn), 1L, this.http2Weight));
            } else {
                future2.complete(new ConnectResult<Http1xClientConnection>((Http1xClientConnection)conn, this.http1MaxConcurrency, this.http1Weight));
            }
        });
        clientHandler.removeHandler(conn -> listener.onEvict());
        ch.pipeline().addLast("handler", clientHandler);
    }

    private void http2Connected(ConnectionListener<HttpClientConnection> listener, ContextInternal context, Channel ch, Promise<ConnectResult<HttpClientConnection>> future2) {
        try {
            VertxHttp2ConnectionHandler<Http2ClientConnection> clientHandler = Http2ClientConnection.createHttp2ConnectionHandler(this.client, this.endpointMetric, listener, context, null, (conn, concurrency) -> future2.complete(new ConnectResult<Http2ClientConnection>((Http2ClientConnection)conn, (long)concurrency, this.http2Weight)));
            ch.pipeline().addLast("handler", clientHandler);
            ch.flush();
        }
        catch (Exception e2) {
            this.connectFailed(ch, listener, e2, future2);
        }
    }

    private void connectFailed(Channel ch, ConnectionListener<HttpClientConnection> listener, Throwable t3, Promise<ConnectResult<HttpClientConnection>> future2) {
        if (ch != null) {
            try {
                ch.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        future2.tryFail(t3);
    }
}

