/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.http.impl;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.channel.ChannelPipeline;
import io.netty.handler.codec.http.DefaultFullHttpResponse;
import io.netty.handler.codec.http.HttpContent;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpHeaderValues;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.handler.codec.http.LastHttpContent;
import io.netty.handler.codec.http2.DefaultHttp2DataFrame;
import io.netty.handler.codec.http2.DefaultHttp2Headers;
import io.netty.handler.codec.http2.DefaultHttp2HeadersFrame;
import io.netty.handler.codec.http2.Http2CodecUtil;
import io.netty.handler.codec.http2.Http2ConnectionHandler;
import io.netty.handler.codec.http2.Http2Headers;
import io.netty.handler.codec.http2.Http2Settings;
import io.netty.handler.timeout.IdleState;
import io.netty.handler.timeout.IdleStateEvent;
import io.vertx.core.Handler;
import io.vertx.core.http.HttpHeaders;
import io.vertx.core.http.impl.Http2ServerConnection;
import io.vertx.core.http.impl.HttpServerChannelInitializer;
import io.vertx.core.http.impl.HttpServerConnection;
import io.vertx.core.http.impl.HttpServerImpl;
import io.vertx.core.http.impl.HttpUtils;
import io.vertx.core.http.impl.VertxHttp2ConnectionHandler;
import io.vertx.core.net.impl.HandlerHolder;
import io.vertx.core.net.impl.VertxHandler;
import java.util.Map;

public class Http1xUpgradeToH2CHandler
extends ChannelInboundHandlerAdapter {
    private final HttpServerChannelInitializer initializer;
    private final HandlerHolder<? extends Handler<HttpServerConnection>> holder;
    private VertxHttp2ConnectionHandler<Http2ServerConnection> handler;
    private final boolean isCompressionSupported;
    private final boolean isDecompressionSupported;

    Http1xUpgradeToH2CHandler(HttpServerChannelInitializer initializer, HandlerHolder<? extends Handler<HttpServerConnection>> holder, boolean isCompressionSupported, boolean isDecompressionSupported) {
        this.initializer = initializer;
        this.holder = holder;
        this.isCompressionSupported = isCompressionSupported;
        this.isDecompressionSupported = isDecompressionSupported;
    }

    @Override
    public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
        if (msg instanceof HttpRequest) {
            HttpRequest request = (HttpRequest)msg;
            if (request.headers().contains(HttpHeaders.UPGRADE, Http2CodecUtil.HTTP_UPGRADE_PROTOCOL_NAME, true)) {
                Http2Settings settings;
                String settingsHeader;
                String connection = request.headers().get(HttpHeaders.CONNECTION);
                int found = 0;
                if (connection != null && connection.length() > 0) {
                    StringBuilder buff = new StringBuilder();
                    int pos = 0;
                    int len = connection.length();
                    while (pos < len) {
                        char c;
                        if ((c = connection.charAt(pos++)) != ' ' && c != ',') {
                            buff.append(Character.toLowerCase(c));
                        }
                        if (c != ',' && pos != len) continue;
                        if (buff.indexOf("upgrade") == 0 && buff.length() == 7) {
                            found |= 1;
                        } else if (buff.indexOf("http2-settings") == 0 && buff.length() == 14) {
                            found |= 2;
                        }
                        buff.setLength(0);
                    }
                }
                if (found == 3 && (settingsHeader = request.headers().get(Http2CodecUtil.HTTP_UPGRADE_SETTINGS_HEADER)) != null && (settings = HttpUtils.decodeSettings(settingsHeader)) != null) {
                    if (this.holder != null && this.holder.context.isEventLoopContext()) {
                        ChannelPipeline pipeline = ctx.pipeline();
                        DefaultFullHttpResponse res = new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.SWITCHING_PROTOCOLS, Unpooled.EMPTY_BUFFER, false);
                        res.headers().add((CharSequence)HttpHeaderNames.CONNECTION, (Object)HttpHeaderValues.UPGRADE);
                        res.headers().add((CharSequence)HttpHeaderNames.UPGRADE, (Object)Http2CodecUtil.HTTP_UPGRADE_PROTOCOL_NAME);
                        ctx.writeAndFlush(res);
                        pipeline.remove("httpEncoder");
                        if (this.isCompressionSupported) {
                            pipeline.remove("deflater");
                        }
                        if (this.isDecompressionSupported) {
                            pipeline.remove("inflater");
                        }
                        this.handler = this.initializer.buildHttp2ConnectionHandler(this.holder.context, (Handler)this.holder.handler);
                        pipeline.addLast("handler", this.handler);
                        this.handler.serverUpgrade(ctx, settings, request);
                        DefaultHttp2Headers headers = new DefaultHttp2Headers();
                        headers.method(request.method().name());
                        headers.path(request.uri());
                        headers.authority(request.headers().get("host"));
                        headers.scheme("http");
                        request.headers().remove("http2-settings");
                        request.headers().remove("host");
                        request.headers().forEach(header -> {
                            Http2Headers cfr_ignored_0 = (Http2Headers)headers.set(((String)header.getKey()).toLowerCase(), header.getValue());
                        });
                        ctx.fireChannelRead(new DefaultHttp2HeadersFrame(headers, false));
                    } else {
                        HttpServerImpl.log.warn("Cannot perform HTTP/2 upgrade in a worker verticle");
                    }
                }
                if (this.handler == null) {
                    DefaultFullHttpResponse res = new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.BAD_REQUEST, Unpooled.EMPTY_BUFFER, false);
                    res.headers().set((CharSequence)HttpHeaderNames.CONNECTION, (Object)HttpHeaderValues.CLOSE);
                    ctx.writeAndFlush(res);
                }
            } else {
                this.initializer.configureHttp1(ctx.pipeline(), this.holder);
                ctx.fireChannelRead(msg);
                ctx.pipeline().remove(this);
            }
        } else if (this.handler != null) {
            if (msg instanceof HttpContent) {
                HttpContent content = (HttpContent)msg;
                ByteBuf buf = VertxHandler.safeBuffer(content.content(), ctx.alloc());
                boolean end2 = msg instanceof LastHttpContent;
                ctx.fireChannelRead(new DefaultHttp2DataFrame(buf, end2, 0));
                if (end2) {
                    ChannelPipeline pipeline = ctx.pipeline();
                    for (Map.Entry handler : pipeline) {
                        if (handler.getValue() instanceof Http2ConnectionHandler) continue;
                        pipeline.remove((String)handler.getKey());
                    }
                    this.initializer.configureHttp2(pipeline);
                }
            } else {
                super.channelRead(ctx, msg);
            }
        }
    }

    @Override
    public void userEventTriggered(ChannelHandlerContext ctx, Object evt) throws Exception {
        if (evt instanceof IdleStateEvent && ((IdleStateEvent)evt).state() == IdleState.ALL_IDLE) {
            ctx.close();
        } else {
            ctx.fireUserEventTriggered(evt);
        }
    }
}

