/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.http.impl;

import io.netty.channel.Channel;
import io.vertx.core.AsyncResult;
import io.vertx.core.Handler;
import io.vertx.core.http.HttpClientOptions;
import io.vertx.core.http.HttpVersion;
import io.vertx.core.http.impl.HttpChannelConnector;
import io.vertx.core.http.impl.HttpClientConnection;
import io.vertx.core.http.impl.HttpClientImpl;
import io.vertx.core.http.impl.pool.Pool;
import io.vertx.core.impl.ContextInternal;
import io.vertx.core.net.SocketAddress;
import io.vertx.core.net.impl.SSLHelper;
import io.vertx.core.spi.metrics.HttpClientMetrics;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

class ConnectionManager {
    private final int maxWaitQueueSize;
    private final HttpClientMetrics metrics;
    private final HttpClientImpl client;
    private final Map<Channel, HttpClientConnection> connectionMap = new ConcurrentHashMap<Channel, HttpClientConnection>();
    private final Map<EndpointKey, Endpoint> endpointMap = new ConcurrentHashMap<EndpointKey, Endpoint>();
    private final HttpVersion version;
    private final long maxSize;
    private long timerID;

    ConnectionManager(HttpClientImpl client, HttpClientMetrics metrics, HttpVersion version, long maxSize, int maxWaitQueueSize) {
        this.client = client;
        this.maxWaitQueueSize = maxWaitQueueSize;
        this.metrics = metrics;
        this.maxSize = maxSize;
        this.version = version;
    }

    synchronized void start() {
        HttpClientOptions options2 = this.client.getOptions();
        long period2 = options2.getPoolCleanerPeriod();
        this.timerID = period2 > 0L && ((long)options2.getKeepAliveTimeout() > 0L || (long)options2.getHttp2KeepAliveTimeout() > 0L) ? this.client.getVertx().setTimer(options2.getPoolCleanerPeriod(), id -> this.checkExpired(period2)) : -1L;
    }

    private synchronized void checkExpired(long period2) {
        this.endpointMap.values().forEach(e2 -> ((Endpoint)e2).pool.closeIdle());
        this.timerID = this.client.getVertx().setTimer(period2, id -> this.checkExpired(period2));
    }

    void getConnection(ContextInternal ctx, SocketAddress peerAddress, SSLHelper sslHelper, SocketAddress server2, Handler<AsyncResult<HttpClientConnection>> handler) {
        Object metric2;
        Endpoint endpoint;
        EndpointKey key2 = new EndpointKey(sslHelper != null, server2, peerAddress);
        do {
            endpoint = this.endpointMap.computeIfAbsent(key2, targetAddress -> {
                int port;
                String host;
                int maxPoolSize = Math.max(this.client.getOptions().getMaxPoolSize(), this.client.getOptions().getHttp2MaxPoolSize());
                if (server2.path() == null) {
                    host = server2.host();
                    port = server2.port();
                } else {
                    host = server2.path();
                    port = 0;
                }
                Object metric2 = this.metrics != null ? this.metrics.createEndpoint(host, port, maxPoolSize) : null;
                HttpChannelConnector connector = new HttpChannelConnector(this.client, metric2, this.version, sslHelper, peerAddress, server2);
                Pool<HttpClientConnection> pool = new Pool<HttpClientConnection>(ctx, connector, this.maxWaitQueueSize, connector.weight(), this.maxSize, v -> {
                    if (this.metrics != null) {
                        this.metrics.closeEndpoint(host, port, metric2);
                    }
                    this.endpointMap.remove(key2);
                }, conn -> this.connectionMap.put(conn.channel(), (HttpClientConnection)conn), conn -> this.connectionMap.remove(conn.channel(), conn), false);
                return new Endpoint(pool, metric2);
            });
            metric2 = this.metrics != null ? this.metrics.enqueueRequest(endpoint.metric) : null;
        } while (!endpoint.pool.getConnection(ar -> {
            if (this.metrics != null) {
                this.metrics.dequeueRequest(endpoint.metric, metric2);
            }
            handler.handle((AsyncResult<HttpClientConnection>)ar);
        }));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        ConnectionManager connectionManager = this;
        synchronized (connectionManager) {
            if (this.timerID >= 0L) {
                this.client.getVertx().cancelTimer(this.timerID);
                this.timerID = -1L;
            }
        }
        this.endpointMap.clear();
        for (HttpClientConnection conn : this.connectionMap.values()) {
            conn.close();
        }
    }

    class Endpoint {
        private final Pool<HttpClientConnection> pool;
        private final Object metric;

        public Endpoint(Pool<HttpClientConnection> pool, Object metric2) {
            this.pool = pool;
            this.metric = metric2;
        }
    }

    private static final class EndpointKey {
        private final boolean ssl;
        private final SocketAddress server;
        private final SocketAddress peerAddress;

        EndpointKey(boolean ssl, SocketAddress server2, SocketAddress peerAddress) {
            if (server2 == null) {
                throw new NullPointerException("No null host");
            }
            if (peerAddress == null) {
                throw new NullPointerException("No null peer address");
            }
            this.ssl = ssl;
            this.peerAddress = peerAddress;
            this.server = server2;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            EndpointKey that = (EndpointKey)o;
            return this.ssl == that.ssl && this.server.equals(that.server) && this.peerAddress.equals(that.peerAddress);
        }

        public int hashCode() {
            int result2 = this.ssl ? 1 : 0;
            result2 = 31 * result2 + this.peerAddress.hashCode();
            result2 = 31 * result2 + this.server.hashCode();
            return result2;
        }
    }
}

