/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.http;

import io.vertx.codegen.annotations.CacheReturn;
import io.vertx.codegen.annotations.GenIgnore;
import io.vertx.codegen.annotations.VertxGen;
import io.vertx.core.ServiceHelper;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.spi.WebSocketFrameFactory;

@VertxGen
public interface WebSocketFrame {
    @GenIgnore
    public static final WebSocketFrameFactory factory = ServiceHelper.loadFactory(WebSocketFrameFactory.class);

    public static WebSocketFrame binaryFrame(Buffer data2, boolean isFinal) {
        return factory.binaryFrame(data2, isFinal);
    }

    public static WebSocketFrame textFrame(String str2, boolean isFinal) {
        return factory.textFrame(str2, isFinal);
    }

    public static WebSocketFrame pingFrame(Buffer data2) {
        return factory.pingFrame(data2);
    }

    public static WebSocketFrame pongFrame(Buffer data2) {
        return factory.pongFrame(data2);
    }

    public static WebSocketFrame continuationFrame(Buffer data2, boolean isFinal) {
        return factory.continuationFrame(data2, isFinal);
    }

    public boolean isText();

    public boolean isBinary();

    public boolean isContinuation();

    public boolean isClose();

    @CacheReturn
    public String textData();

    @CacheReturn
    public Buffer binaryData();

    public boolean isFinal();

    public short closeStatusCode();

    public String closeReason();
}

