/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.http;

import io.vertx.codegen.annotations.DataObject;
import io.vertx.codegen.annotations.GenIgnore;
import io.vertx.core.MultiMap;
import io.vertx.core.http.RequestOptionsConverter;
import io.vertx.core.json.JsonObject;
import java.util.List;
import java.util.Map;
import java.util.Objects;

@DataObject(generateConverter=true)
public class RequestOptions {
    public static final String DEFAULT_HOST = "localhost";
    public static final int DEFAULT_PORT = 80;
    public static final Boolean DEFAULT_SSL = null;
    public static final String DEFAULT_URI = "";
    private String host;
    private int port;
    private Boolean ssl;
    private String uri;
    private MultiMap headers;

    public RequestOptions() {
        this.host = DEFAULT_HOST;
        this.port = 80;
        this.ssl = DEFAULT_SSL;
        this.uri = DEFAULT_URI;
    }

    public RequestOptions(RequestOptions other) {
        this.setHost(other.host);
        this.setPort(other.port);
        this.setSsl(other.ssl);
        this.setURI(other.uri);
    }

    public RequestOptions(JsonObject json) {
        this();
        RequestOptionsConverter.fromJson(json, this);
        JsonObject headers = json.getJsonObject("headers");
        if (headers != null) {
            for (Map.Entry<String, Object> entry : headers) {
                Object value = entry.getValue();
                if (value instanceof String) {
                    this.addHeader(entry.getKey(), (String)value);
                    continue;
                }
                if (!(value instanceof Iterable)) continue;
                for (Object subValue : (Iterable)value) {
                    if (!(subValue instanceof String)) continue;
                    this.addHeader(entry.getKey(), (String)subValue);
                }
            }
        }
    }

    public String getHost() {
        return this.host;
    }

    public RequestOptions setHost(String host) {
        this.host = host;
        return this;
    }

    public int getPort() {
        return this.port;
    }

    public RequestOptions setPort(int port) {
        this.port = port;
        return this;
    }

    public Boolean isSsl() {
        return this.ssl;
    }

    public RequestOptions setSsl(Boolean ssl) {
        this.ssl = ssl;
        return this;
    }

    public String getURI() {
        return this.uri;
    }

    public RequestOptions setURI(String uri) {
        this.uri = uri;
        return this;
    }

    @GenIgnore
    public RequestOptions addHeader(String key2, String value) {
        this.checkHeaders();
        Objects.requireNonNull(key2, "no null key accepted");
        Objects.requireNonNull(value, "no null value accepted");
        this.headers.add(key2, value);
        return this;
    }

    @GenIgnore
    public RequestOptions setHeaders(MultiMap headers) {
        this.headers = headers;
        return this;
    }

    @GenIgnore
    public MultiMap getHeaders() {
        return this.headers;
    }

    private void checkHeaders() {
        if (this.headers == null) {
            this.headers = MultiMap.caseInsensitiveMultiMap();
        }
    }

    public JsonObject toJson() {
        JsonObject json = new JsonObject();
        RequestOptionsConverter.toJson(this, json);
        if (this.headers != null) {
            JsonObject headers = new JsonObject();
            for (String name2 : this.headers.names()) {
                List<String> values2 = this.headers.getAll(name2);
                if (values2.size() == 1) {
                    headers.put(name2, values2.iterator().next());
                    continue;
                }
                headers.put(name2, values2);
            }
            json.put("headers", headers);
        }
        return json;
    }
}

