/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.file.impl;

import io.vertx.core.AsyncResult;
import io.vertx.core.Handler;
import io.vertx.core.Promise;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.file.AsyncFile;
import io.vertx.core.file.CopyOptions;
import io.vertx.core.file.FileProps;
import io.vertx.core.file.FileSystem;
import io.vertx.core.file.FileSystemException;
import io.vertx.core.file.FileSystemProps;
import io.vertx.core.file.OpenOptions;
import io.vertx.core.file.impl.AsyncFileImpl;
import io.vertx.core.file.impl.FilePropsImpl;
import io.vertx.core.file.impl.FileSystemPropsImpl;
import io.vertx.core.impl.ContextInternal;
import io.vertx.core.impl.VertxInternal;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.file.CopyOption;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.FileStore;
import java.nio.file.FileVisitOption;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.GroupPrincipal;
import java.nio.file.attribute.PosixFileAttributeView;
import java.nio.file.attribute.PosixFilePermission;
import java.nio.file.attribute.PosixFilePermissions;
import java.nio.file.attribute.UserPrincipal;
import java.nio.file.attribute.UserPrincipalLookupService;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.regex.Pattern;

public class FileSystemImpl
implements FileSystem {
    private static final CopyOptions DEFAULT_OPTIONS = new CopyOptions();
    protected final VertxInternal vertx;

    public FileSystemImpl(VertxInternal vertx) {
        this.vertx = vertx;
    }

    @Override
    public FileSystem copy(String from, String to, Handler<AsyncResult<Void>> handler) {
        return this.copy(from, to, DEFAULT_OPTIONS, handler);
    }

    @Override
    public FileSystem copy(String from, String to, CopyOptions options2, Handler<AsyncResult<Void>> handler) {
        this.copyInternal(from, to, options2, handler).run();
        return this;
    }

    @Override
    public FileSystem copyBlocking(String from, String to) {
        this.copyInternal(from, to, DEFAULT_OPTIONS, null).perform();
        return this;
    }

    @Override
    public FileSystem copyRecursive(String from, String to, boolean recursive2, Handler<AsyncResult<Void>> handler) {
        this.copyRecursiveInternal(from, to, recursive2, handler).run();
        return this;
    }

    @Override
    public FileSystem copyRecursiveBlocking(String from, String to, boolean recursive2) {
        this.copyRecursiveInternal(from, to, recursive2, null).perform();
        return this;
    }

    @Override
    public FileSystem move(String from, String to, Handler<AsyncResult<Void>> handler) {
        return this.move(from, to, DEFAULT_OPTIONS, handler);
    }

    @Override
    public FileSystem move(String from, String to, CopyOptions options2, Handler<AsyncResult<Void>> handler) {
        this.moveInternal(from, to, options2, handler).run();
        return this;
    }

    @Override
    public FileSystem moveBlocking(String from, String to) {
        this.moveInternal(from, to, DEFAULT_OPTIONS, null).perform();
        return this;
    }

    @Override
    public FileSystem truncate(String path2, long len, Handler<AsyncResult<Void>> handler) {
        this.truncateInternal(path2, len, handler).run();
        return this;
    }

    @Override
    public FileSystem truncateBlocking(String path2, long len) {
        this.truncateInternal(path2, len, null).perform();
        return this;
    }

    @Override
    public FileSystem chmod(String path2, String perms, Handler<AsyncResult<Void>> handler) {
        this.chmodInternal(path2, perms, handler).run();
        return this;
    }

    @Override
    public FileSystem chmodBlocking(String path2, String perms) {
        this.chmodInternal(path2, perms, null).perform();
        return this;
    }

    @Override
    public FileSystem chmodRecursive(String path2, String perms, String dirPerms, Handler<AsyncResult<Void>> handler) {
        this.chmodInternal(path2, perms, dirPerms, handler).run();
        return this;
    }

    @Override
    public FileSystem chmodRecursiveBlocking(String path2, String perms, String dirPerms) {
        this.chmodInternal(path2, perms, dirPerms, null).perform();
        return this;
    }

    @Override
    public FileSystem chown(String path2, String user, String group, Handler<AsyncResult<Void>> handler) {
        this.chownInternal(path2, user, group, handler).run();
        return this;
    }

    @Override
    public FileSystem chownBlocking(String path2, String user, String group) {
        this.chownInternal(path2, user, group, null).perform();
        return this;
    }

    @Override
    public FileSystem props(String path2, Handler<AsyncResult<FileProps>> handler) {
        this.propsInternal(path2, handler).run();
        return this;
    }

    @Override
    public FileProps propsBlocking(String path2) {
        return this.propsInternal(path2, null).perform();
    }

    @Override
    public FileSystem lprops(String path2, Handler<AsyncResult<FileProps>> handler) {
        this.lpropsInternal(path2, handler).run();
        return this;
    }

    @Override
    public FileProps lpropsBlocking(String path2) {
        return this.lpropsInternal(path2, null).perform();
    }

    @Override
    public FileSystem link(String link, String existing, Handler<AsyncResult<Void>> handler) {
        this.linkInternal(link, existing, handler).run();
        return this;
    }

    @Override
    public FileSystem linkBlocking(String link, String existing) {
        this.linkInternal(link, existing, null).perform();
        return this;
    }

    @Override
    public FileSystem symlink(String link, String existing, Handler<AsyncResult<Void>> handler) {
        this.symlinkInternal(link, existing, handler).run();
        return this;
    }

    @Override
    public FileSystem symlinkBlocking(String link, String existing) {
        this.symlinkInternal(link, existing, null).perform();
        return this;
    }

    @Override
    public FileSystem unlink(String link, Handler<AsyncResult<Void>> handler) {
        this.unlinkInternal(link, handler).run();
        return this;
    }

    @Override
    public FileSystem unlinkBlocking(String link) {
        this.unlinkInternal(link, null).perform();
        return this;
    }

    @Override
    public FileSystem readSymlink(String link, Handler<AsyncResult<String>> handler) {
        this.readSymlinkInternal(link, handler).run();
        return this;
    }

    @Override
    public String readSymlinkBlocking(String link) {
        return this.readSymlinkInternal(link, null).perform();
    }

    @Override
    public FileSystem delete(String path2, Handler<AsyncResult<Void>> handler) {
        this.deleteInternal(path2, handler).run();
        return this;
    }

    @Override
    public FileSystem deleteBlocking(String path2) {
        this.deleteInternal(path2, null).perform();
        return this;
    }

    @Override
    public FileSystem deleteRecursive(String path2, boolean recursive2, Handler<AsyncResult<Void>> handler) {
        this.deleteInternal(path2, recursive2, handler).run();
        return this;
    }

    @Override
    public FileSystem deleteRecursiveBlocking(String path2, boolean recursive2) {
        this.deleteInternal(path2, recursive2, null).perform();
        return this;
    }

    @Override
    public FileSystem mkdir(String path2, Handler<AsyncResult<Void>> handler) {
        this.mkdirInternal(path2, handler).run();
        return this;
    }

    @Override
    public FileSystem mkdirBlocking(String path2) {
        this.mkdirInternal(path2, null).perform();
        return this;
    }

    @Override
    public FileSystem mkdirs(String path2, Handler<AsyncResult<Void>> handler) {
        this.mkdirInternal(path2, true, handler).run();
        return this;
    }

    @Override
    public FileSystem mkdirsBlocking(String path2) {
        this.mkdirInternal(path2, true, null).perform();
        return this;
    }

    @Override
    public FileSystem mkdir(String path2, String perms, Handler<AsyncResult<Void>> handler) {
        this.mkdirInternal(path2, perms, handler).run();
        return this;
    }

    @Override
    public FileSystem mkdirBlocking(String path2, String perms) {
        this.mkdirInternal(path2, perms, null).perform();
        return this;
    }

    @Override
    public FileSystem mkdirs(String path2, String perms, Handler<AsyncResult<Void>> handler) {
        this.mkdirInternal(path2, perms, true, handler).run();
        return this;
    }

    @Override
    public FileSystem mkdirsBlocking(String path2, String perms) {
        this.mkdirInternal(path2, perms, true, null).perform();
        return this;
    }

    @Override
    public FileSystem readDir(String path2, Handler<AsyncResult<List<String>>> handler) {
        this.readDirInternal(path2, handler).run();
        return this;
    }

    @Override
    public List<String> readDirBlocking(String path2) {
        return this.readDirInternal(path2, null).perform();
    }

    @Override
    public FileSystem readDir(String path2, String filter2, Handler<AsyncResult<List<String>>> handler) {
        this.readDirInternal(path2, filter2, handler).run();
        return this;
    }

    @Override
    public List<String> readDirBlocking(String path2, String filter2) {
        return this.readDirInternal(path2, filter2, null).perform();
    }

    @Override
    public FileSystem readFile(String path2, Handler<AsyncResult<Buffer>> handler) {
        this.readFileInternal(path2, handler).run();
        return this;
    }

    @Override
    public Buffer readFileBlocking(String path2) {
        return this.readFileInternal(path2, null).perform();
    }

    @Override
    public FileSystem writeFile(String path2, Buffer data2, Handler<AsyncResult<Void>> handler) {
        this.writeFileInternal(path2, data2, handler).run();
        return this;
    }

    @Override
    public FileSystem writeFileBlocking(String path2, Buffer data2) {
        this.writeFileInternal(path2, data2, null).perform();
        return this;
    }

    @Override
    public FileSystem open(String path2, OpenOptions options2, Handler<AsyncResult<AsyncFile>> handler) {
        this.openInternal(path2, options2, handler).run();
        return this;
    }

    @Override
    public AsyncFile openBlocking(String path2, OpenOptions options2) {
        return this.openInternal(path2, options2, null).perform();
    }

    @Override
    public FileSystem createFile(String path2, Handler<AsyncResult<Void>> handler) {
        this.createFileInternal(path2, handler).run();
        return this;
    }

    @Override
    public FileSystem createFileBlocking(String path2) {
        this.createFileInternal(path2, null).perform();
        return this;
    }

    @Override
    public FileSystem createFile(String path2, String perms, Handler<AsyncResult<Void>> handler) {
        this.createFileInternal(path2, perms, handler).run();
        return this;
    }

    @Override
    public FileSystem createFileBlocking(String path2, String perms) {
        this.createFileInternal(path2, perms, null).perform();
        return this;
    }

    @Override
    public FileSystem exists(String path2, Handler<AsyncResult<Boolean>> handler) {
        this.existsInternal(path2, handler).run();
        return this;
    }

    @Override
    public boolean existsBlocking(String path2) {
        return this.existsInternal(path2, null).perform();
    }

    @Override
    public FileSystem fsProps(String path2, Handler<AsyncResult<FileSystemProps>> handler) {
        this.fsPropsInternal(path2, handler).run();
        return this;
    }

    @Override
    public FileSystemProps fsPropsBlocking(String path2) {
        return this.fsPropsInternal(path2, null).perform();
    }

    @Override
    public FileSystem createTempDirectory(String prefix, Handler<AsyncResult<String>> handler) {
        this.createTempDirectoryInternal(null, prefix, null, handler).run();
        return this;
    }

    @Override
    public String createTempDirectoryBlocking(String prefix) {
        return this.createTempDirectoryInternal(null, prefix, null, null).perform();
    }

    @Override
    public FileSystem createTempDirectory(String prefix, String perms, Handler<AsyncResult<String>> handler) {
        this.createTempDirectoryInternal(null, prefix, perms, handler).run();
        return this;
    }

    @Override
    public String createTempDirectoryBlocking(String prefix, String perms) {
        return this.createTempDirectoryInternal(null, prefix, perms, null).perform();
    }

    @Override
    public FileSystem createTempDirectory(String dir2, String prefix, String perms, Handler<AsyncResult<String>> handler) {
        this.createTempDirectoryInternal(dir2, prefix, perms, handler).run();
        return this;
    }

    @Override
    public String createTempDirectoryBlocking(String dir2, String prefix, String perms) {
        return this.createTempDirectoryInternal(dir2, prefix, perms, null).perform();
    }

    @Override
    public FileSystem createTempFile(String prefix, String suffix, Handler<AsyncResult<String>> handler) {
        this.createTempFileInternal(null, prefix, suffix, null, handler).run();
        return this;
    }

    @Override
    public String createTempFileBlocking(String prefix, String suffix) {
        return this.createTempFileInternal(null, prefix, suffix, null, null).perform();
    }

    @Override
    public FileSystem createTempFile(String prefix, String suffix, String perms, Handler<AsyncResult<String>> handler) {
        this.createTempFileInternal(null, prefix, suffix, perms, handler).run();
        return this;
    }

    @Override
    public String createTempFileBlocking(String prefix, String suffix, String perms) {
        return this.createTempFileInternal(null, prefix, suffix, perms, null).perform();
    }

    @Override
    public FileSystem createTempFile(String dir2, String prefix, String suffix, String perms, Handler<AsyncResult<String>> handler) {
        this.createTempFileInternal(dir2, prefix, suffix, perms, handler).run();
        return this;
    }

    @Override
    public String createTempFileBlocking(String dir2, String prefix, String suffix, String perms) {
        return this.createTempFileInternal(dir2, prefix, suffix, perms, null).perform();
    }

    private BlockingAction<Void> copyInternal(final String from, final String to, CopyOptions options2, Handler<AsyncResult<Void>> handler) {
        Objects.requireNonNull(from);
        Objects.requireNonNull(to);
        Objects.requireNonNull(options2);
        Set<CopyOption> copyOptionSet = FileSystemImpl.toCopyOptionSet(options2);
        final CopyOption[] copyOptions = copyOptionSet.toArray(new CopyOption[copyOptionSet.size()]);
        return new BlockingAction<Void>(handler){

            @Override
            public Void perform() {
                try {
                    Path source2 = FileSystemImpl.this.vertx.resolveFile(from).toPath();
                    Path target = FileSystemImpl.this.vertx.resolveFile(to).toPath();
                    Files.copy(source2, target, copyOptions);
                }
                catch (IOException e2) {
                    throw new FileSystemException(e2);
                }
                return null;
            }
        };
    }

    private BlockingAction<Void> copyRecursiveInternal(final String from, final String to, final boolean recursive2, Handler<AsyncResult<Void>> handler) {
        Objects.requireNonNull(from);
        Objects.requireNonNull(to);
        return new BlockingAction<Void>(handler){

            @Override
            public Void perform() {
                try {
                    final Path source2 = FileSystemImpl.this.vertx.resolveFile(from).toPath();
                    final Path target = FileSystemImpl.this.vertx.resolveFile(to).toPath();
                    if (recursive2) {
                        Files.walkFileTree(source2, EnumSet.of(FileVisitOption.FOLLOW_LINKS), Integer.MAX_VALUE, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                            @Override
                            public FileVisitResult preVisitDirectory(Path dir2, BasicFileAttributes attrs) throws IOException {
                                block2: {
                                    Path targetDir = target.resolve(source2.relativize(dir2));
                                    try {
                                        Files.copy(dir2, targetDir, new CopyOption[0]);
                                    }
                                    catch (FileAlreadyExistsException e2) {
                                        if (Files.isDirectory(targetDir, new LinkOption[0])) break block2;
                                        throw e2;
                                    }
                                }
                                return FileVisitResult.CONTINUE;
                            }

                            @Override
                            public FileVisitResult visitFile(Path file2, BasicFileAttributes attrs) throws IOException {
                                Files.copy(file2, target.resolve(source2.relativize(file2)), new CopyOption[0]);
                                return FileVisitResult.CONTINUE;
                            }
                        });
                    } else {
                        Files.copy(source2, target, new CopyOption[0]);
                    }
                }
                catch (IOException e2) {
                    throw new FileSystemException(e2);
                }
                return null;
            }
        };
    }

    private BlockingAction<Void> moveInternal(final String from, final String to, CopyOptions options2, Handler<AsyncResult<Void>> handler) {
        Objects.requireNonNull(from);
        Objects.requireNonNull(to);
        Objects.requireNonNull(options2);
        Set<CopyOption> copyOptionSet = FileSystemImpl.toCopyOptionSet(options2);
        final CopyOption[] copyOptions = copyOptionSet.toArray(new CopyOption[copyOptionSet.size()]);
        return new BlockingAction<Void>(handler){

            @Override
            public Void perform() {
                try {
                    Path source2 = FileSystemImpl.this.vertx.resolveFile(from).toPath();
                    Path target = FileSystemImpl.this.vertx.resolveFile(to).toPath();
                    Files.move(source2, target, copyOptions);
                }
                catch (IOException e2) {
                    throw new FileSystemException(e2);
                }
                return null;
            }
        };
    }

    private BlockingAction<Void> truncateInternal(final String p, final long len, Handler<AsyncResult<Void>> handler) {
        Objects.requireNonNull(p);
        return new BlockingAction<Void>(handler){

            @Override
            public Void perform() {
                try {
                    String path2 = FileSystemImpl.this.vertx.resolveFile(p).getAbsolutePath();
                    if (len < 0L) {
                        throw new FileSystemException("Cannot truncate file to size < 0");
                    }
                    if (!Files.exists(Paths.get(path2, new String[0]), new LinkOption[0])) {
                        throw new FileSystemException("Cannot truncate file " + path2 + ". Does not exist");
                    }
                    try (RandomAccessFile raf = new RandomAccessFile(path2, "rw");){
                        raf.setLength(len);
                    }
                }
                catch (IOException e2) {
                    throw new FileSystemException(e2);
                }
                return null;
            }
        };
    }

    private BlockingAction<Void> chmodInternal(String path2, String perms, Handler<AsyncResult<Void>> handler) {
        return this.chmodInternal(path2, perms, null, handler);
    }

    protected BlockingAction<Void> chmodInternal(final String path2, String perms, String dirPerms, Handler<AsyncResult<Void>> handler) {
        Objects.requireNonNull(path2);
        final Set<PosixFilePermission> permissions = PosixFilePermissions.fromString(perms);
        final Set<PosixFilePermission> dirPermissions = dirPerms == null ? null : PosixFilePermissions.fromString(dirPerms);
        return new BlockingAction<Void>(handler){

            @Override
            public Void perform() {
                try {
                    Path target = FileSystemImpl.this.vertx.resolveFile(path2).toPath();
                    if (dirPermissions != null) {
                        Files.walkFileTree(target, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                            @Override
                            public FileVisitResult preVisitDirectory(Path dir2, BasicFileAttributes attrs) throws IOException {
                                Files.setPosixFilePermissions(dir2, dirPermissions);
                                return FileVisitResult.CONTINUE;
                            }

                            @Override
                            public FileVisitResult visitFile(Path file2, BasicFileAttributes attrs) throws IOException {
                                Files.setPosixFilePermissions(file2, permissions);
                                return FileVisitResult.CONTINUE;
                            }
                        });
                    } else {
                        Files.setPosixFilePermissions(target, permissions);
                    }
                }
                catch (SecurityException e2) {
                    throw new FileSystemException("Accessed denied for chmod on " + path2);
                }
                catch (IOException e3) {
                    throw new FileSystemException(e3);
                }
                return null;
            }
        };
    }

    protected BlockingAction<Void> chownInternal(final String path2, final String user, final String group, Handler<AsyncResult<Void>> handler) {
        Objects.requireNonNull(path2);
        return new BlockingAction<Void>(handler){

            @Override
            public Void perform() {
                try {
                    GroupPrincipal groupPrincipal;
                    Path target = FileSystemImpl.this.vertx.resolveFile(path2).toPath();
                    UserPrincipalLookupService service = target.getFileSystem().getUserPrincipalLookupService();
                    UserPrincipal userPrincipal = user == null ? null : service.lookupPrincipalByName(user);
                    GroupPrincipal groupPrincipal2 = groupPrincipal = group == null ? null : service.lookupPrincipalByGroupName(group);
                    if (groupPrincipal != null) {
                        PosixFileAttributeView view = Files.getFileAttributeView(target, PosixFileAttributeView.class, LinkOption.NOFOLLOW_LINKS);
                        if (view == null) {
                            throw new FileSystemException("Change group of file not supported");
                        }
                        view.setGroup(groupPrincipal);
                    }
                    if (userPrincipal != null) {
                        Files.setOwner(target, userPrincipal);
                    }
                }
                catch (SecurityException e2) {
                    throw new FileSystemException("Accessed denied for chown on " + path2);
                }
                catch (IOException e3) {
                    throw new FileSystemException(e3);
                }
                return null;
            }
        };
    }

    private BlockingAction<FileProps> propsInternal(String path2, Handler<AsyncResult<FileProps>> handler) {
        return this.props(path2, true, handler);
    }

    private BlockingAction<FileProps> lpropsInternal(String path2, Handler<AsyncResult<FileProps>> handler) {
        return this.props(path2, false, handler);
    }

    private BlockingAction<FileProps> props(final String path2, final boolean followLinks, Handler<AsyncResult<FileProps>> handler) {
        Objects.requireNonNull(path2);
        return new BlockingAction<FileProps>(handler){

            @Override
            public FileProps perform() {
                try {
                    Path target = FileSystemImpl.this.vertx.resolveFile(path2).toPath();
                    BasicFileAttributes attrs = followLinks ? Files.readAttributes(target, BasicFileAttributes.class, new LinkOption[0]) : Files.readAttributes(target, BasicFileAttributes.class, LinkOption.NOFOLLOW_LINKS);
                    return new FilePropsImpl(attrs);
                }
                catch (IOException e2) {
                    throw new FileSystemException(e2);
                }
            }
        };
    }

    private BlockingAction<Void> linkInternal(String link, String existing, Handler<AsyncResult<Void>> handler) {
        return this.link(link, existing, false, handler);
    }

    private BlockingAction<Void> symlinkInternal(String link, String existing, Handler<AsyncResult<Void>> handler) {
        return this.link(link, existing, true, handler);
    }

    private BlockingAction<Void> link(final String link, final String existing, final boolean symbolic, Handler<AsyncResult<Void>> handler) {
        Objects.requireNonNull(link);
        Objects.requireNonNull(existing);
        return new BlockingAction<Void>(handler){

            @Override
            public Void perform() {
                try {
                    Path source2 = FileSystemImpl.this.vertx.resolveFile(link).toPath();
                    Path target = FileSystemImpl.this.vertx.resolveFile(existing).toPath();
                    if (symbolic) {
                        Files.createSymbolicLink(source2, target, new FileAttribute[0]);
                    } else {
                        Files.createLink(source2, target);
                    }
                }
                catch (IOException e2) {
                    throw new FileSystemException(e2);
                }
                return null;
            }
        };
    }

    private BlockingAction<Void> unlinkInternal(String link, Handler<AsyncResult<Void>> handler) {
        return this.deleteInternal(link, handler);
    }

    private BlockingAction<String> readSymlinkInternal(final String link, Handler<AsyncResult<String>> handler) {
        Objects.requireNonNull(link);
        return new BlockingAction<String>(handler){

            @Override
            public String perform() {
                try {
                    Path source2 = FileSystemImpl.this.vertx.resolveFile(link).toPath();
                    return Files.readSymbolicLink(source2).toString();
                }
                catch (IOException e2) {
                    throw new FileSystemException(e2);
                }
            }
        };
    }

    private BlockingAction<Void> deleteInternal(String path2, Handler<AsyncResult<Void>> handler) {
        return this.deleteInternal(path2, false, handler);
    }

    private BlockingAction<Void> deleteInternal(final String path2, final boolean recursive2, Handler<AsyncResult<Void>> handler) {
        Objects.requireNonNull(path2);
        return new BlockingAction<Void>(handler){

            @Override
            public Void perform() {
                try {
                    Path source2 = FileSystemImpl.this.vertx.resolveFile(path2).toPath();
                    FileSystemImpl.delete(source2, recursive2);
                }
                catch (IOException e2) {
                    throw new FileSystemException(e2);
                }
                return null;
            }
        };
    }

    public static void delete(Path path2, boolean recursive2) throws IOException {
        if (recursive2) {
            Files.walkFileTree(path2, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                @Override
                public FileVisitResult visitFile(Path file2, BasicFileAttributes attrs) throws IOException {
                    Files.delete(file2);
                    return FileVisitResult.CONTINUE;
                }

                @Override
                public FileVisitResult postVisitDirectory(Path dir2, IOException e2) throws IOException {
                    if (e2 == null) {
                        Files.delete(dir2);
                        return FileVisitResult.CONTINUE;
                    }
                    throw e2;
                }
            });
        } else {
            Files.delete(path2);
        }
    }

    private BlockingAction<Void> mkdirInternal(String path2, Handler<AsyncResult<Void>> handler) {
        return this.mkdirInternal(path2, null, false, handler);
    }

    private BlockingAction<Void> mkdirInternal(String path2, boolean createParents, Handler<AsyncResult<Void>> handler) {
        return this.mkdirInternal(path2, null, createParents, handler);
    }

    private BlockingAction<Void> mkdirInternal(String path2, String perms, Handler<AsyncResult<Void>> handler) {
        return this.mkdirInternal(path2, perms, false, handler);
    }

    protected BlockingAction<Void> mkdirInternal(final String path2, String perms, final boolean createParents, Handler<AsyncResult<Void>> handler) {
        Objects.requireNonNull(path2);
        final FileAttribute<Set<PosixFilePermission>> attrs = perms == null ? null : PosixFilePermissions.asFileAttribute(PosixFilePermissions.fromString(perms));
        return new BlockingAction<Void>(handler){

            @Override
            public Void perform() {
                try {
                    Path source2 = FileSystemImpl.this.vertx.resolveFile(path2).toPath();
                    if (createParents) {
                        if (attrs != null) {
                            Files.createDirectories(source2, attrs);
                        } else {
                            Files.createDirectories(source2, new FileAttribute[0]);
                        }
                    } else if (attrs != null) {
                        Files.createDirectory(source2, attrs);
                    } else {
                        Files.createDirectory(source2, new FileAttribute[0]);
                    }
                }
                catch (IOException e2) {
                    throw new FileSystemException(e2);
                }
                return null;
            }
        };
    }

    protected BlockingAction<String> createTempDirectoryInternal(final String parentDir, final String prefix, String perms, Handler<AsyncResult<String>> handler) {
        final FileAttribute<Set<PosixFilePermission>> attrs = perms == null ? null : PosixFilePermissions.asFileAttribute(PosixFilePermissions.fromString(perms));
        return new BlockingAction<String>(handler){

            @Override
            public String perform() {
                try {
                    Path tmpDir;
                    if (parentDir != null) {
                        Path dir2 = FileSystemImpl.this.vertx.resolveFile(parentDir).toPath();
                        tmpDir = attrs != null ? Files.createTempDirectory(dir2, prefix, attrs) : Files.createTempDirectory(dir2, prefix, new FileAttribute[0]);
                    } else {
                        tmpDir = attrs != null ? Files.createTempDirectory(prefix, attrs) : Files.createTempDirectory(prefix, new FileAttribute[0]);
                    }
                    return tmpDir.toFile().getAbsolutePath();
                }
                catch (IOException e2) {
                    throw new FileSystemException(e2);
                }
            }
        };
    }

    protected BlockingAction<String> createTempFileInternal(final String parentDir, final String prefix, final String suffix, String perms, Handler<AsyncResult<String>> handler) {
        final FileAttribute<Set<PosixFilePermission>> attrs = perms == null ? null : PosixFilePermissions.asFileAttribute(PosixFilePermissions.fromString(perms));
        return new BlockingAction<String>(handler){

            @Override
            public String perform() {
                try {
                    Path tmpFile;
                    if (parentDir != null) {
                        Path dir2 = FileSystemImpl.this.vertx.resolveFile(parentDir).toPath();
                        tmpFile = attrs != null ? Files.createTempFile(dir2, prefix, suffix, attrs) : Files.createTempFile(dir2, prefix, suffix, new FileAttribute[0]);
                    } else {
                        tmpFile = attrs != null ? Files.createTempFile(prefix, suffix, attrs) : Files.createTempFile(prefix, suffix, new FileAttribute[0]);
                    }
                    return tmpFile.toFile().getAbsolutePath();
                }
                catch (IOException e2) {
                    throw new FileSystemException(e2);
                }
            }
        };
    }

    private BlockingAction<List<String>> readDirInternal(String path2, Handler<AsyncResult<List<String>>> handler) {
        return this.readDirInternal(path2, null, handler);
    }

    private BlockingAction<List<String>> readDirInternal(final String p, final String filter2, Handler<AsyncResult<List<String>>> handler) {
        Objects.requireNonNull(p);
        return new BlockingAction<List<String>>(handler){

            @Override
            public List<String> perform() {
                try {
                    File file2 = FileSystemImpl.this.vertx.resolveFile(p);
                    if (!file2.exists()) {
                        throw new FileSystemException("Cannot read directory " + file2 + ". Does not exist");
                    }
                    if (!file2.isDirectory()) {
                        throw new FileSystemException("Cannot read directory " + file2 + ". It's not a directory");
                    }
                    FilenameFilter fnFilter = filter2 != null ? new FilenameFilter(){

                        @Override
                        public boolean accept(File dir2, String name2) {
                            return Pattern.matches(filter2, name2);
                        }
                    } : null;
                    File[] files = fnFilter == null ? file2.listFiles() : file2.listFiles(fnFilter);
                    ArrayList<String> ret = new ArrayList<String>(files.length);
                    for (File f : files) {
                        ret.add(f.getCanonicalPath());
                    }
                    return ret;
                }
                catch (IOException e2) {
                    throw new FileSystemException(e2);
                }
            }
        };
    }

    private BlockingAction<Buffer> readFileInternal(final String path2, Handler<AsyncResult<Buffer>> handler) {
        Objects.requireNonNull(path2);
        return new BlockingAction<Buffer>(handler){

            @Override
            public Buffer perform() {
                try {
                    Path target = FileSystemImpl.this.vertx.resolveFile(path2).toPath();
                    byte[] bytes2 = Files.readAllBytes(target);
                    Buffer buff = Buffer.buffer(bytes2);
                    return buff;
                }
                catch (IOException e2) {
                    throw new FileSystemException(e2);
                }
            }
        };
    }

    private BlockingAction<Void> writeFileInternal(final String path2, final Buffer data2, Handler<AsyncResult<Void>> handler) {
        Objects.requireNonNull(path2);
        Objects.requireNonNull(data2);
        return new BlockingAction<Void>(handler){

            @Override
            public Void perform() {
                try {
                    Path target = FileSystemImpl.this.vertx.resolveFile(path2).toPath();
                    Files.write(target, data2.getBytes(), new OpenOption[0]);
                    return null;
                }
                catch (IOException e2) {
                    throw new FileSystemException(e2);
                }
            }
        };
    }

    private BlockingAction<AsyncFile> openInternal(final String p, final OpenOptions options2, Handler<AsyncResult<AsyncFile>> handler) {
        Objects.requireNonNull(p);
        Objects.requireNonNull(options2);
        return new BlockingAction<AsyncFile>(handler){

            @Override
            public AsyncFile perform() {
                String path2 = FileSystemImpl.this.vertx.resolveFile(p).getAbsolutePath();
                return FileSystemImpl.this.doOpen(path2, options2, this.context);
            }
        };
    }

    protected AsyncFile doOpen(String path2, OpenOptions options2, ContextInternal context) {
        return new AsyncFileImpl(this.vertx, path2, options2, context);
    }

    private BlockingAction<Void> createFileInternal(String path2, Handler<AsyncResult<Void>> handler) {
        return this.createFileInternal(path2, null, handler);
    }

    protected BlockingAction<Void> createFileInternal(final String p, String perms, Handler<AsyncResult<Void>> handler) {
        Objects.requireNonNull(p);
        final FileAttribute<Set<PosixFilePermission>> attrs = perms == null ? null : PosixFilePermissions.asFileAttribute(PosixFilePermissions.fromString(perms));
        return new BlockingAction<Void>(handler){

            @Override
            public Void perform() {
                try {
                    Path target = FileSystemImpl.this.vertx.resolveFile(p).toPath();
                    if (attrs != null) {
                        Files.createFile(target, attrs);
                    } else {
                        Files.createFile(target, new FileAttribute[0]);
                    }
                }
                catch (IOException e2) {
                    throw new FileSystemException(e2);
                }
                return null;
            }
        };
    }

    private BlockingAction<Boolean> existsInternal(final String path2, Handler<AsyncResult<Boolean>> handler) {
        Objects.requireNonNull(path2);
        return new BlockingAction<Boolean>(handler){

            @Override
            public Boolean perform() {
                File file2 = FileSystemImpl.this.vertx.resolveFile(path2);
                return file2.exists();
            }
        };
    }

    private BlockingAction<FileSystemProps> fsPropsInternal(final String path2, Handler<AsyncResult<FileSystemProps>> handler) {
        Objects.requireNonNull(path2);
        return new BlockingAction<FileSystemProps>(handler){

            @Override
            public FileSystemProps perform() {
                try {
                    Path target = FileSystemImpl.this.vertx.resolveFile(path2).toPath();
                    FileStore fs = Files.getFileStore(target);
                    return new FileSystemPropsImpl(fs.getTotalSpace(), fs.getUnallocatedSpace(), fs.getUsableSpace());
                }
                catch (IOException e2) {
                    throw new FileSystemException(e2);
                }
            }
        };
    }

    static Set<CopyOption> toCopyOptionSet(CopyOptions copyOptions) {
        HashSet<CopyOption> copyOptionSet = new HashSet<CopyOption>();
        if (copyOptions.isReplaceExisting()) {
            copyOptionSet.add(StandardCopyOption.REPLACE_EXISTING);
        }
        if (copyOptions.isCopyAttributes()) {
            copyOptionSet.add(StandardCopyOption.COPY_ATTRIBUTES);
        }
        if (copyOptions.isAtomicMove()) {
            copyOptionSet.add(StandardCopyOption.ATOMIC_MOVE);
        }
        if (copyOptions.isNofollowLinks()) {
            copyOptionSet.add(LinkOption.NOFOLLOW_LINKS);
        }
        return copyOptionSet;
    }

    protected abstract class BlockingAction<T>
    implements Handler<Promise<T>> {
        private final Handler<AsyncResult<T>> handler;
        protected final ContextInternal context;

        public BlockingAction(Handler<AsyncResult<T>> handler) {
            this.handler = handler;
            this.context = FileSystemImpl.this.vertx.getOrCreateContext();
        }

        public void run() {
            this.context.executeBlockingInternal(this, this.handler);
        }

        @Override
        public void handle(Promise<T> fut) {
            try {
                T result2 = this.perform();
                fut.complete(result2);
            }
            catch (Exception e2) {
                fut.fail(e2);
            }
        }

        public abstract T perform();
    }
}

