/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.eventbus.impl.clustered;

import io.vertx.core.AsyncResult;
import io.vertx.core.Context;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.MultiMap;
import io.vertx.core.Vertx;
import io.vertx.core.VertxException;
import io.vertx.core.VertxOptions;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.eventbus.EventBusOptions;
import io.vertx.core.eventbus.MessageCodec;
import io.vertx.core.eventbus.impl.CodecManager;
import io.vertx.core.eventbus.impl.EventBusImpl;
import io.vertx.core.eventbus.impl.HandlerHolder;
import io.vertx.core.eventbus.impl.MessageImpl;
import io.vertx.core.eventbus.impl.clustered.ClusterNodeInfo;
import io.vertx.core.eventbus.impl.clustered.ClusteredMessage;
import io.vertx.core.eventbus.impl.clustered.ConnectionHolder;
import io.vertx.core.impl.ConcurrentHashSet;
import io.vertx.core.impl.HAManager;
import io.vertx.core.impl.VertxInternal;
import io.vertx.core.json.JsonObject;
import io.vertx.core.logging.Logger;
import io.vertx.core.logging.LoggerFactory;
import io.vertx.core.net.JksOptions;
import io.vertx.core.net.KeyCertOptions;
import io.vertx.core.net.NetServer;
import io.vertx.core.net.NetServerOptions;
import io.vertx.core.net.NetSocket;
import io.vertx.core.net.PemKeyCertOptions;
import io.vertx.core.net.PemTrustOptions;
import io.vertx.core.net.PfxOptions;
import io.vertx.core.net.TCPSSLOptions;
import io.vertx.core.net.TrustOptions;
import io.vertx.core.net.impl.ServerID;
import io.vertx.core.parsetools.RecordParser;
import io.vertx.core.spi.cluster.AsyncMultiMap;
import io.vertx.core.spi.cluster.ChoosableIterable;
import io.vertx.core.spi.cluster.ClusterManager;
import java.io.Serializable;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Predicate;

public class ClusteredEventBus
extends EventBusImpl {
    private static final Logger log = LoggerFactory.getLogger(ClusteredEventBus.class);
    public static final String CLUSTER_PUBLIC_HOST_PROP_NAME = "vertx.cluster.public.host";
    public static final String CLUSTER_PUBLIC_PORT_PROP_NAME = "vertx.cluster.public.port";
    private static final Buffer PONG = Buffer.buffer(new byte[]{1});
    private static final String SERVER_ID_HA_KEY = "server_id";
    private static final String SUBS_MAP_NAME = "__vertx.subs";
    private final ClusterManager clusterManager;
    private final ConcurrentMap<ServerID, ConnectionHolder> connections = new ConcurrentHashMap<ServerID, ConnectionHolder>();
    private final Context sendNoContext;
    private EventBusOptions options;
    private AsyncMultiMap<String, ClusterNodeInfo> subs;
    private Set<String> ownSubs = new ConcurrentHashSet<String>();
    private ServerID serverID;
    private ClusterNodeInfo nodeInfo;
    private NetServer server;

    public ClusteredEventBus(VertxInternal vertx, VertxOptions options2, ClusterManager clusterManager) {
        super(vertx);
        this.options = options2.getEventBusOptions();
        this.clusterManager = clusterManager;
        this.sendNoContext = vertx.getOrCreateContext();
    }

    private NetServerOptions getServerOptions() {
        NetServerOptions serverOptions = new NetServerOptions(this.options.toJson());
        ClusteredEventBus.setCertOptions(serverOptions, this.options.getKeyCertOptions());
        ClusteredEventBus.setTrustOptions(serverOptions, this.options.getTrustOptions());
        return serverOptions;
    }

    static void setCertOptions(TCPSSLOptions options2, KeyCertOptions keyCertOptions) {
        if (keyCertOptions == null) {
            return;
        }
        if (keyCertOptions instanceof JksOptions) {
            options2.setKeyStoreOptions((JksOptions)keyCertOptions);
        } else if (keyCertOptions instanceof PfxOptions) {
            options2.setPfxKeyCertOptions((PfxOptions)keyCertOptions);
        } else {
            options2.setPemKeyCertOptions((PemKeyCertOptions)keyCertOptions);
        }
    }

    static void setTrustOptions(TCPSSLOptions sslOptions, TrustOptions options2) {
        if (options2 == null) {
            return;
        }
        if (options2 instanceof JksOptions) {
            sslOptions.setTrustStoreOptions((JksOptions)options2);
        } else if (options2 instanceof PfxOptions) {
            sslOptions.setPfxTrustOptions((PfxOptions)options2);
        } else {
            sslOptions.setPemTrustOptions((PemTrustOptions)options2);
        }
    }

    @Override
    public void start(Handler<AsyncResult<Void>> resultHandler) {
        HAManager haManager = this.vertx.haManager();
        this.setClusterViewChangedHandler(haManager);
        this.clusterManager.getAsyncMultiMap(SUBS_MAP_NAME, ar1 -> {
            if (ar1.succeeded()) {
                this.subs = (AsyncMultiMap)ar1.result();
                this.server = this.vertx.createNetServer(this.getServerOptions());
                this.server.connectHandler(this.getServerHandler());
                this.server.listen(asyncResult -> {
                    if (asyncResult.succeeded()) {
                        int serverPort = this.getClusterPublicPort(this.options, this.server.actualPort());
                        String serverHost = this.getClusterPublicHost(this.options);
                        this.serverID = new ServerID(serverPort, serverHost);
                        this.nodeInfo = new ClusterNodeInfo(this.clusterManager.getNodeID(), this.serverID);
                        this.vertx.executeBlocking(fut -> {
                            haManager.addDataToAHAInfo(SERVER_ID_HA_KEY, new JsonObject().put("host", this.serverID.host).put("port", this.serverID.port));
                            fut.complete();
                        }, false, ar2 -> {
                            if (ar2.succeeded()) {
                                this.started = true;
                                resultHandler.handle(Future.succeededFuture());
                            } else {
                                resultHandler.handle(Future.failedFuture(ar2.cause()));
                            }
                        });
                    } else {
                        resultHandler.handle(Future.failedFuture(asyncResult.cause()));
                    }
                });
            } else {
                resultHandler.handle(Future.failedFuture(ar1.cause()));
            }
        });
    }

    @Override
    public void close(Handler<AsyncResult<Void>> completionHandler) {
        super.close(ar1 -> {
            if (this.server != null) {
                this.server.close(ar -> {
                    if (ar.failed()) {
                        log.error((Object)"Failed to close server", ar.cause());
                    }
                    for (ConnectionHolder holder : this.connections.values()) {
                        holder.close();
                    }
                    if (completionHandler != null) {
                        completionHandler.handle((AsyncResult<Void>)ar);
                    }
                });
            } else if (completionHandler != null) {
                completionHandler.handle((AsyncResult<Void>)ar1);
            }
        });
    }

    @Override
    public MessageImpl createMessage(boolean send2, String address, MultiMap headers, Object body, String codecName, Handler<AsyncResult<Void>> writeHandler) {
        Objects.requireNonNull(address, "no null address accepted");
        MessageCodec codec = this.codecManager.lookupCodec(body, codecName);
        ClusteredMessage msg = new ClusteredMessage(this.serverID, address, null, headers, body, codec, send2, this, writeHandler);
        return msg;
    }

    @Override
    protected <T> void addRegistration(boolean newAddress, String address, boolean replyHandler, boolean localOnly, Handler<AsyncResult<Void>> completionHandler) {
        if (newAddress && this.subs != null && !replyHandler && !localOnly) {
            this.subs.add(address, this.nodeInfo, completionHandler);
            this.ownSubs.add(address);
        } else {
            completionHandler.handle(Future.succeededFuture());
        }
    }

    @Override
    protected <T> void removeRegistration(HandlerHolder<T> lastHolder, String address, Handler<AsyncResult<Void>> completionHandler) {
        if (lastHolder != null && this.subs != null && !lastHolder.isLocalOnly()) {
            this.ownSubs.remove(address);
            this.removeSub(address, this.nodeInfo, completionHandler);
        } else {
            this.callCompletionHandlerAsync(completionHandler);
        }
    }

    @Override
    protected <T> void sendReply(EventBusImpl.OutboundDeliveryContext<T> sendContext, MessageImpl replierMessage) {
        this.clusteredSendReply(((ClusteredMessage)replierMessage).getSender(), sendContext);
    }

    @Override
    protected <T> void sendOrPub(EventBusImpl.OutboundDeliveryContext<T> sendContext) {
        if (sendContext.options.isLocalOnly()) {
            if (this.metrics != null) {
                this.metrics.messageSent(sendContext.message.address(), !sendContext.message.isSend(), true, false);
            }
            this.deliverMessageLocally(sendContext);
        } else if (Vertx.currentContext() == null) {
            this.sendNoContext.runOnContext(v -> this.subs.get(sendContext.message.address(), ar -> this.onSubsReceived((AsyncResult<ChoosableIterable<ClusterNodeInfo>>)ar, sendContext)));
        } else {
            this.subs.get(sendContext.message.address(), ar -> this.onSubsReceived((AsyncResult<ChoosableIterable<ClusterNodeInfo>>)ar, sendContext));
        }
    }

    private <T> void onSubsReceived(AsyncResult<ChoosableIterable<ClusterNodeInfo>> asyncResult, EventBusImpl.OutboundDeliveryContext<T> sendContext) {
        if (asyncResult.succeeded()) {
            ChoosableIterable<ClusterNodeInfo> serverIDs = asyncResult.result();
            if (serverIDs != null && !serverIDs.isEmpty()) {
                this.sendToSubs(serverIDs, sendContext);
            } else {
                if (this.metrics != null) {
                    this.metrics.messageSent(sendContext.message.address(), !sendContext.message.isSend(), true, false);
                }
                this.deliverMessageLocally(sendContext);
            }
        } else {
            log.error((Object)"Failed to send message", asyncResult.cause());
            Handler<AsyncResult<Void>> handler = sendContext.message.writeHandler();
            if (handler != null) {
                handler.handle(asyncResult.mapEmpty());
            }
        }
    }

    @Override
    protected String generateReplyAddress() {
        return "__vertx.reply." + UUID.randomUUID().toString();
    }

    @Override
    protected boolean isMessageLocal(MessageImpl msg) {
        ClusteredMessage clusteredMessage = (ClusteredMessage)msg;
        return !clusteredMessage.isFromWire();
    }

    private void setClusterViewChangedHandler(HAManager haManager) {
        haManager.setClusterViewChangedHandler((Set<String> members2) -> {
            this.ownSubs.forEach(address -> this.subs.add((String)address, this.nodeInfo, addResult -> {
                if (addResult.failed()) {
                    log.warn((Object)"Failed to update subs map with self", addResult.cause());
                }
            }));
            this.subs.removeAllMatching((Predicate<ClusterNodeInfo> & Serializable)ci -> !members2.contains(ci.nodeId), removeResult -> {
                if (removeResult.failed()) {
                    log.warn((Object)"Error removing subs", removeResult.cause());
                }
            });
        });
    }

    private int getClusterPublicPort(EventBusOptions options2, int actualPort) {
        int publicPort = Integer.getInteger(CLUSTER_PUBLIC_PORT_PROP_NAME, options2.getClusterPublicPort());
        if (publicPort == -1) {
            publicPort = actualPort;
        }
        return publicPort;
    }

    private String getClusterPublicHost(EventBusOptions options2) {
        String publicHost = System.getProperty(CLUSTER_PUBLIC_HOST_PROP_NAME, options2.getClusterPublicHost());
        if (publicHost == null) {
            publicHost = options2.getHost();
        }
        return publicHost;
    }

    private Handler<NetSocket> getServerHandler() {
        return socket -> {
            final RecordParser parser = RecordParser.newFixed(4);
            Handler<Buffer> handler = new Handler<Buffer>(){
                int size = -1;

                @Override
                public void handle(Buffer buff) {
                    if (this.size == -1) {
                        this.size = buff.getInt(0);
                        parser.fixedSizeMode(this.size);
                    } else {
                        ClusteredMessage received = new ClusteredMessage(ClusteredEventBus.this);
                        received.readFromWire(buff, ClusteredEventBus.this.codecManager);
                        if (ClusteredEventBus.this.metrics != null) {
                            ClusteredEventBus.this.metrics.messageRead(received.address(), buff.length());
                        }
                        parser.fixedSizeMode(4);
                        this.size = -1;
                        if (received.hasFailure()) {
                            received.internalError();
                        } else if (received.codec() == CodecManager.PING_MESSAGE_CODEC) {
                            socket.write(PONG);
                        } else {
                            ClusteredEventBus.this.deliverMessageLocally(received);
                        }
                    }
                }
            };
            parser.setOutput(handler);
            socket.handler((Handler)parser);
        };
    }

    private <T> void sendToSubs(ChoosableIterable<ClusterNodeInfo> subs2, EventBusImpl.OutboundDeliveryContext<T> sendContext) {
        String address = sendContext.message.address();
        if (sendContext.message.isSend()) {
            ServerID sid;
            ClusterNodeInfo ci = subs2.choose();
            ServerID serverID = sid = ci == null ? null : ci.serverID;
            if (sid != null && !sid.equals(this.serverID)) {
                if (this.metrics != null) {
                    this.metrics.messageSent(address, false, false, true);
                }
                this.sendRemote(sid, sendContext.message);
            } else {
                if (this.metrics != null) {
                    this.metrics.messageSent(address, false, true, false);
                }
                this.deliverMessageLocally(sendContext);
            }
        } else {
            boolean local2 = false;
            boolean remote = false;
            for (ClusterNodeInfo ci : subs2) {
                if (!ci.serverID.equals(this.serverID)) {
                    remote = true;
                    this.sendRemote(ci.serverID, sendContext.message);
                    continue;
                }
                local2 = true;
            }
            if (this.metrics != null) {
                this.metrics.messageSent(address, true, local2, remote);
            }
            if (local2) {
                this.deliverMessageLocally(sendContext);
            }
        }
    }

    private <T> void clusteredSendReply(ServerID replyDest, EventBusImpl.OutboundDeliveryContext<T> sendContext) {
        MessageImpl message = sendContext.message;
        String address = message.address();
        if (!replyDest.equals(this.serverID)) {
            if (this.metrics != null) {
                this.metrics.messageSent(address, false, false, true);
            }
            this.sendRemote(replyDest, message);
        } else {
            if (this.metrics != null) {
                this.metrics.messageSent(address, false, true, false);
            }
            this.deliverMessageLocally(sendContext);
        }
    }

    private void sendRemote(ServerID theServerID, MessageImpl message) {
        ConnectionHolder holder = (ConnectionHolder)this.connections.get(theServerID);
        if (holder == null) {
            holder = new ConnectionHolder(this, theServerID, this.options);
            ConnectionHolder prevHolder = this.connections.putIfAbsent(theServerID, holder);
            if (prevHolder != null) {
                holder = prevHolder;
            } else {
                holder.connect();
            }
        }
        holder.writeMessage((ClusteredMessage)message);
    }

    private void removeSub(String subName, ClusterNodeInfo node2, Handler<AsyncResult<Void>> completionHandler) {
        this.subs.remove(subName, node2, ar -> {
            if (completionHandler != null) {
                if (ar.succeeded()) {
                    completionHandler.handle(Future.succeededFuture());
                } else {
                    completionHandler.handle(Future.failedFuture(new VertxException("Failed to remove sub", ar.cause())));
                }
            }
        });
    }

    ConcurrentMap<ServerID, ConnectionHolder> connections() {
        return this.connections;
    }

    VertxInternal vertx() {
        return this.vertx;
    }

    EventBusOptions options() {
        return this.options;
    }
}

