/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.dns.impl.decoder;

import io.netty.buffer.ByteBuf;
import io.netty.handler.codec.DecoderException;
import io.netty.handler.codec.dns.DnsPtrRecord;
import io.netty.handler.codec.dns.DnsRawRecord;
import io.netty.handler.codec.dns.DnsRecord;
import io.netty.handler.codec.dns.DnsRecordType;
import io.netty.util.CharsetUtil;
import io.vertx.core.dns.impl.MxRecordImpl;
import io.vertx.core.dns.impl.SrvRecordImpl;
import io.vertx.core.dns.impl.decoder.StartOfAuthorityRecord;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;

public class RecordDecoder {
    public static final Function<DnsRecord, MxRecordImpl> MX = record2 -> {
        ByteBuf packet = ((DnsRawRecord)record2).content();
        short priority = packet.readShort();
        String name2 = RecordDecoder.readName(packet);
        return new MxRecordImpl(priority, name2);
    };
    public static final Function<DnsRecord, String> DOMAIN = record2 -> {
        if (record2 instanceof DnsPtrRecord) {
            String val2 = ((DnsPtrRecord)record2).hostname();
            if (val2.endsWith(".")) {
                val2 = val2.substring(0, val2.length() - 1);
            }
            return val2;
        }
        ByteBuf content = ((DnsRawRecord)record2).content();
        return RecordDecoder.getName(content, content.readerIndex());
    };
    public static final Function<DnsRecord, String> A = RecordDecoder.address(4);
    public static final Function<DnsRecord, String> AAAA = RecordDecoder.address(16);
    public static final Function<DnsRecord, SrvRecordImpl> SRV = record2 -> {
        ByteBuf packet = ((DnsRawRecord)record2).content();
        short priority = packet.readShort();
        short weight = packet.readShort();
        int port = packet.readUnsignedShort();
        String target = RecordDecoder.readName(packet);
        String[] parts = record2.name().split("\\.", 3);
        String service = parts[0];
        String protocol2 = parts[1];
        String name2 = parts[2];
        return new SrvRecordImpl(priority, weight, port, name2, protocol2, service, target);
    };
    public static final Function<DnsRecord, StartOfAuthorityRecord> SOA = record2 -> {
        ByteBuf packet = ((DnsRawRecord)record2).content();
        String mName = RecordDecoder.readName(packet);
        String rName = RecordDecoder.readName(packet);
        long serial = packet.readUnsignedInt();
        int refresh = packet.readInt();
        int retry2 = packet.readInt();
        int expire = packet.readInt();
        long minimum = packet.readUnsignedInt();
        return new StartOfAuthorityRecord(mName, rName, serial, refresh, retry2, expire, minimum);
    };
    public static final Function<DnsRecord, List<String>> TXT = record2 -> {
        short len;
        ArrayList<String> list = new ArrayList<String>();
        ByteBuf data2 = ((DnsRawRecord)record2).content();
        for (int index2 = data2.readerIndex(); index2 < data2.writerIndex(); index2 += len) {
            len = data2.getUnsignedByte(index2++);
            list.add(data2.toString(index2, len, CharsetUtil.UTF_8));
        }
        return list;
    };
    private static final Map<DnsRecordType, Function<DnsRecord, ?>> decoders = new HashMap();

    static Function<DnsRecord, String> address(int octets) {
        return record2 -> {
            ByteBuf data2 = ((DnsRawRecord)record2).content();
            int size = data2.readableBytes();
            if (size != octets) {
                throw new DecoderException("Invalid content length, or reader index when decoding address [index: " + data2.readerIndex() + ", expected length: " + octets + ", actual: " + size + "].");
            }
            byte[] address = new byte[octets];
            data2.getBytes(data2.readerIndex(), address);
            try {
                return InetAddress.getByAddress(address).getHostAddress();
            }
            catch (UnknownHostException e2) {
                throw new DecoderException("Could not convert address " + data2.toString(data2.readerIndex(), size, CharsetUtil.UTF_8) + " to InetAddress.");
            }
        };
    }

    static String readName(ByteBuf buf) {
        int position = -1;
        StringBuilder name2 = new StringBuilder();
        short len = buf.readUnsignedByte();
        while (buf.isReadable() && len != 0) {
            boolean pointer;
            boolean bl = pointer = (len & 0xC0) == 192;
            if (pointer) {
                if (position == -1) {
                    position = buf.readerIndex() + 1;
                }
                buf.readerIndex((len & 0x3F) << 8 | buf.readUnsignedByte());
            } else {
                name2.append(buf.toString(buf.readerIndex(), len, CharsetUtil.UTF_8)).append(".");
                buf.skipBytes(len);
            }
            len = buf.readUnsignedByte();
        }
        if (position != -1) {
            buf.readerIndex(position);
        }
        if (name2.length() == 0) {
            return null;
        }
        return name2.substring(0, name2.length() - 1);
    }

    static String getName(ByteBuf buf, int offset) {
        StringBuilder name2 = new StringBuilder();
        short len = buf.getUnsignedByte(offset++);
        while (buf.writerIndex() > offset && len != 0) {
            boolean pointer;
            boolean bl = pointer = (len & 0xC0) == 192;
            if (pointer) {
                offset = (len & 0x3F) << 8 | buf.getUnsignedByte(offset++);
            } else {
                name2.append(buf.toString(offset, len, CharsetUtil.UTF_8)).append(".");
                offset += len;
            }
            len = buf.getUnsignedByte(offset++);
        }
        if (name2.length() == 0) {
            return null;
        }
        return name2.substring(0, name2.length() - 1);
    }

    public static <T> T decode(DnsRecord record2) {
        DnsRecordType type2 = record2.type();
        Function<DnsRecord, ?> decoder = decoders.get(type2);
        if (decoder == null) {
            throw new IllegalStateException("Unsupported resource record type [id: " + type2 + "].");
        }
        T result2 = null;
        try {
            result2 = (T)decoder.apply(record2);
        }
        catch (Exception e2) {
            e2.printStackTrace();
        }
        return result2;
    }

    static {
        decoders.put(DnsRecordType.A, A);
        decoders.put(DnsRecordType.AAAA, AAAA);
        decoders.put(DnsRecordType.MX, MX);
        decoders.put(DnsRecordType.TXT, TXT);
        decoders.put(DnsRecordType.SRV, SRV);
        decoders.put(DnsRecordType.NS, DOMAIN);
        decoders.put(DnsRecordType.CNAME, DOMAIN);
        decoders.put(DnsRecordType.PTR, DOMAIN);
        decoders.put(DnsRecordType.SOA, SOA);
    }
}

