/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.datagram.impl;

import io.vertx.core.AsyncResult;
import io.vertx.core.Handler;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.datagram.DatagramSocket;
import io.vertx.core.datagram.impl.DatagramSocketImpl;
import io.vertx.core.streams.WriteStream;

class PacketWriteStreamImpl
implements WriteStream<Buffer>,
Handler<AsyncResult<DatagramSocket>> {
    private DatagramSocketImpl datagramSocket;
    private Handler<Throwable> exceptionHandler;
    private final int port;
    private final String host;

    PacketWriteStreamImpl(DatagramSocketImpl datagramSocket, int port, String host) {
        this.datagramSocket = datagramSocket;
        this.port = port;
        this.host = host;
    }

    @Override
    public void handle(AsyncResult<DatagramSocket> event) {
        if (event.failed() && this.exceptionHandler != null) {
            this.exceptionHandler.handle(event.cause());
        }
    }

    @Override
    public PacketWriteStreamImpl exceptionHandler(Handler<Throwable> handler) {
        this.exceptionHandler = handler;
        return this;
    }

    public PacketWriteStreamImpl write(Buffer data2) {
        this.datagramSocket.send(data2, this.port, this.host, (Handler<AsyncResult<DatagramSocket>>)this);
        return this;
    }

    @Override
    public WriteStream<Buffer> write(Buffer data2, Handler<AsyncResult<Void>> handler) {
        this.datagramSocket.send(data2, this.port, this.host, ar -> {
            this.handle((AsyncResult<DatagramSocket>)ar);
            if (handler != null) {
                handler.handle(ar.mapEmpty());
            }
        });
        return this;
    }

    public PacketWriteStreamImpl setWriteQueueMaxSize(int maxSize) {
        return this;
    }

    @Override
    public boolean writeQueueFull() {
        return false;
    }

    public PacketWriteStreamImpl drainHandler(Handler<Void> handler) {
        return this;
    }

    @Override
    public void end() {
        this.datagramSocket.close();
    }

    @Override
    public void end(Handler<AsyncResult<Void>> handler) {
        this.datagramSocket.close(handler);
    }
}

