/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core;

import io.vertx.core.VertxOptions;
import io.vertx.core.dns.AddressResolverOptions;
import io.vertx.core.eventbus.EventBusOptions;
import io.vertx.core.file.FileSystemOptions;
import io.vertx.core.json.JsonObject;
import io.vertx.core.metrics.MetricsOptions;
import java.util.Map;
import java.util.concurrent.TimeUnit;

class VertxOptionsConverter {
    VertxOptionsConverter() {
    }

    static void fromJson(Iterable<Map.Entry<String, Object>> json, VertxOptions obj2) {
        for (Map.Entry<String, Object> member : json) {
            switch (member.getKey()) {
                case "addressResolverOptions": {
                    if (!(member.getValue() instanceof JsonObject)) break;
                    obj2.setAddressResolverOptions(new AddressResolverOptions((JsonObject)member.getValue()));
                    break;
                }
                case "blockedThreadCheckInterval": {
                    if (!(member.getValue() instanceof Number)) break;
                    obj2.setBlockedThreadCheckInterval(((Number)member.getValue()).longValue());
                    break;
                }
                case "blockedThreadCheckIntervalUnit": {
                    if (!(member.getValue() instanceof String)) break;
                    obj2.setBlockedThreadCheckIntervalUnit(TimeUnit.valueOf((String)member.getValue()));
                    break;
                }
                case "clusterHost": {
                    if (!(member.getValue() instanceof String)) break;
                    obj2.setClusterHost((String)member.getValue());
                    break;
                }
                case "clusterPingInterval": {
                    if (!(member.getValue() instanceof Number)) break;
                    obj2.setClusterPingInterval(((Number)member.getValue()).longValue());
                    break;
                }
                case "clusterPingReplyInterval": {
                    if (!(member.getValue() instanceof Number)) break;
                    obj2.setClusterPingReplyInterval(((Number)member.getValue()).longValue());
                    break;
                }
                case "clusterPort": {
                    if (!(member.getValue() instanceof Number)) break;
                    obj2.setClusterPort(((Number)member.getValue()).intValue());
                    break;
                }
                case "clusterPublicHost": {
                    if (!(member.getValue() instanceof String)) break;
                    obj2.setClusterPublicHost((String)member.getValue());
                    break;
                }
                case "clusterPublicPort": {
                    if (!(member.getValue() instanceof Number)) break;
                    obj2.setClusterPublicPort(((Number)member.getValue()).intValue());
                    break;
                }
                case "clustered": {
                    if (!(member.getValue() instanceof Boolean)) break;
                    obj2.setClustered((Boolean)member.getValue());
                    break;
                }
                case "eventBusOptions": {
                    if (!(member.getValue() instanceof JsonObject)) break;
                    obj2.setEventBusOptions(new EventBusOptions((JsonObject)member.getValue()));
                    break;
                }
                case "eventLoopPoolSize": {
                    if (!(member.getValue() instanceof Number)) break;
                    obj2.setEventLoopPoolSize(((Number)member.getValue()).intValue());
                    break;
                }
                case "fileResolverCachingEnabled": {
                    if (!(member.getValue() instanceof Boolean)) break;
                    obj2.setFileResolverCachingEnabled((Boolean)member.getValue());
                    break;
                }
                case "fileSystemOptions": {
                    if (!(member.getValue() instanceof JsonObject)) break;
                    obj2.setFileSystemOptions(new FileSystemOptions((JsonObject)member.getValue()));
                    break;
                }
                case "haEnabled": {
                    if (!(member.getValue() instanceof Boolean)) break;
                    obj2.setHAEnabled((Boolean)member.getValue());
                    break;
                }
                case "haGroup": {
                    if (!(member.getValue() instanceof String)) break;
                    obj2.setHAGroup((String)member.getValue());
                    break;
                }
                case "internalBlockingPoolSize": {
                    if (!(member.getValue() instanceof Number)) break;
                    obj2.setInternalBlockingPoolSize(((Number)member.getValue()).intValue());
                    break;
                }
                case "maxEventLoopExecuteTime": {
                    if (!(member.getValue() instanceof Number)) break;
                    obj2.setMaxEventLoopExecuteTime(((Number)member.getValue()).longValue());
                    break;
                }
                case "maxEventLoopExecuteTimeUnit": {
                    if (!(member.getValue() instanceof String)) break;
                    obj2.setMaxEventLoopExecuteTimeUnit(TimeUnit.valueOf((String)member.getValue()));
                    break;
                }
                case "maxWorkerExecuteTime": {
                    if (!(member.getValue() instanceof Number)) break;
                    obj2.setMaxWorkerExecuteTime(((Number)member.getValue()).longValue());
                    break;
                }
                case "maxWorkerExecuteTimeUnit": {
                    if (!(member.getValue() instanceof String)) break;
                    obj2.setMaxWorkerExecuteTimeUnit(TimeUnit.valueOf((String)member.getValue()));
                    break;
                }
                case "metricsOptions": {
                    if (!(member.getValue() instanceof JsonObject)) break;
                    obj2.setMetricsOptions(new MetricsOptions((JsonObject)member.getValue()));
                    break;
                }
                case "preferNativeTransport": {
                    if (!(member.getValue() instanceof Boolean)) break;
                    obj2.setPreferNativeTransport((Boolean)member.getValue());
                    break;
                }
                case "quorumSize": {
                    if (!(member.getValue() instanceof Number)) break;
                    obj2.setQuorumSize(((Number)member.getValue()).intValue());
                    break;
                }
                case "warningExceptionTime": {
                    if (!(member.getValue() instanceof Number)) break;
                    obj2.setWarningExceptionTime(((Number)member.getValue()).longValue());
                    break;
                }
                case "warningExceptionTimeUnit": {
                    if (!(member.getValue() instanceof String)) break;
                    obj2.setWarningExceptionTimeUnit(TimeUnit.valueOf((String)member.getValue()));
                    break;
                }
                case "workerPoolSize": {
                    if (!(member.getValue() instanceof Number)) break;
                    obj2.setWorkerPoolSize(((Number)member.getValue()).intValue());
                }
            }
        }
    }

    static void toJson(VertxOptions obj2, JsonObject json) {
        VertxOptionsConverter.toJson(obj2, json.getMap());
    }

    static void toJson(VertxOptions obj2, Map<String, Object> json) {
        if (obj2.getAddressResolverOptions() != null) {
            json.put("addressResolverOptions", obj2.getAddressResolverOptions().toJson());
        }
        json.put("blockedThreadCheckInterval", obj2.getBlockedThreadCheckInterval());
        if (obj2.getBlockedThreadCheckIntervalUnit() != null) {
            json.put("blockedThreadCheckIntervalUnit", obj2.getBlockedThreadCheckIntervalUnit().name());
        }
        if (obj2.getClusterHost() != null) {
            json.put("clusterHost", obj2.getClusterHost());
        }
        json.put("clusterPingInterval", obj2.getClusterPingInterval());
        json.put("clusterPingReplyInterval", obj2.getClusterPingReplyInterval());
        json.put("clusterPort", obj2.getClusterPort());
        if (obj2.getClusterPublicHost() != null) {
            json.put("clusterPublicHost", obj2.getClusterPublicHost());
        }
        json.put("clusterPublicPort", obj2.getClusterPublicPort());
        json.put("clustered", obj2.isClustered());
        if (obj2.getEventBusOptions() != null) {
            json.put("eventBusOptions", obj2.getEventBusOptions().toJson());
        }
        json.put("eventLoopPoolSize", obj2.getEventLoopPoolSize());
        json.put("fileResolverCachingEnabled", obj2.isFileResolverCachingEnabled());
        if (obj2.getFileSystemOptions() != null) {
            json.put("fileSystemOptions", obj2.getFileSystemOptions().toJson());
        }
        json.put("haEnabled", obj2.isHAEnabled());
        if (obj2.getHAGroup() != null) {
            json.put("haGroup", obj2.getHAGroup());
        }
        json.put("internalBlockingPoolSize", obj2.getInternalBlockingPoolSize());
        json.put("maxEventLoopExecuteTime", obj2.getMaxEventLoopExecuteTime());
        if (obj2.getMaxEventLoopExecuteTimeUnit() != null) {
            json.put("maxEventLoopExecuteTimeUnit", obj2.getMaxEventLoopExecuteTimeUnit().name());
        }
        json.put("maxWorkerExecuteTime", obj2.getMaxWorkerExecuteTime());
        if (obj2.getMaxWorkerExecuteTimeUnit() != null) {
            json.put("maxWorkerExecuteTimeUnit", obj2.getMaxWorkerExecuteTimeUnit().name());
        }
        if (obj2.getMetricsOptions() != null) {
            json.put("metricsOptions", obj2.getMetricsOptions().toJson());
        }
        json.put("preferNativeTransport", obj2.getPreferNativeTransport());
        json.put("quorumSize", obj2.getQuorumSize());
        json.put("warningExceptionTime", obj2.getWarningExceptionTime());
        if (obj2.getWarningExceptionTimeUnit() != null) {
            json.put("warningExceptionTimeUnit", obj2.getWarningExceptionTimeUnit().name());
        }
        json.put("workerPoolSize", obj2.getWorkerPoolSize());
    }
}

