/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core;

import io.vertx.codegen.annotations.Fluent;
import io.vertx.codegen.annotations.GenIgnore;
import io.vertx.codegen.annotations.Nullable;
import io.vertx.codegen.annotations.VertxGen;
import io.vertx.core.http.CaseInsensitiveHeaders;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;

@VertxGen
public interface MultiMap
extends Iterable<Map.Entry<String, String>> {
    public static MultiMap caseInsensitiveMultiMap() {
        CaseInsensitiveHeaders map2 = new CaseInsensitiveHeaders();
        return map2;
    }

    @GenIgnore(value={"permitted-type"})
    public String get(CharSequence var1);

    public @Nullable String get(String var1);

    public List<String> getAll(String var1);

    @GenIgnore(value={"permitted-type"})
    public List<String> getAll(CharSequence var1);

    @GenIgnore(value={"permitted-type"})
    default public List<Map.Entry<String, String>> entries() {
        ArrayList<Map.Entry<String, String>> entries2 = new ArrayList<Map.Entry<String, String>>();
        this.forEach(entries2::add);
        return entries2;
    }

    public boolean contains(String var1);

    @GenIgnore(value={"permitted-type"})
    public boolean contains(CharSequence var1);

    default public boolean contains(String name2, String value, boolean caseInsensitive) {
        return this.getAll(name2).stream().anyMatch(val2 -> caseInsensitive ? val2.equalsIgnoreCase(value) : val2.equals(value));
    }

    @GenIgnore(value={"permitted-type"})
    default public boolean contains(CharSequence name2, CharSequence value, boolean caseInsensitive) {
        Predicate<String> predicate;
        if (caseInsensitive) {
            String valueAsString = value.toString();
            predicate = val2 -> val2.equalsIgnoreCase(valueAsString);
        } else {
            predicate = val2 -> val2.contentEquals(value);
        }
        return this.getAll(name2).stream().anyMatch(predicate);
    }

    public boolean isEmpty();

    public Set<String> names();

    @Fluent
    public MultiMap add(String var1, String var2);

    @GenIgnore(value={"permitted-type"})
    @Fluent
    public MultiMap add(CharSequence var1, CharSequence var2);

    @GenIgnore(value={"permitted-type"})
    @Fluent
    public MultiMap add(String var1, Iterable<String> var2);

    @GenIgnore(value={"permitted-type"})
    @Fluent
    public MultiMap add(CharSequence var1, Iterable<CharSequence> var2);

    @Fluent
    public MultiMap addAll(MultiMap var1);

    @GenIgnore(value={"permitted-type"})
    @Fluent
    public MultiMap addAll(Map<String, String> var1);

    @Fluent
    public MultiMap set(String var1, String var2);

    @GenIgnore(value={"permitted-type"})
    @Fluent
    public MultiMap set(CharSequence var1, CharSequence var2);

    @GenIgnore(value={"permitted-type"})
    @Fluent
    public MultiMap set(String var1, Iterable<String> var2);

    @GenIgnore(value={"permitted-type"})
    @Fluent
    public MultiMap set(CharSequence var1, Iterable<CharSequence> var2);

    @Fluent
    public MultiMap setAll(MultiMap var1);

    @GenIgnore(value={"permitted-type"})
    @Fluent
    public MultiMap setAll(Map<String, String> var1);

    @Fluent
    public MultiMap remove(String var1);

    @GenIgnore(value={"permitted-type"})
    @Fluent
    public MultiMap remove(CharSequence var1);

    @Fluent
    public MultiMap clear();

    public int size();
}

