/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core;

import io.vertx.codegen.annotations.CacheReturn;
import io.vertx.codegen.annotations.Fluent;
import io.vertx.codegen.annotations.GenIgnore;
import io.vertx.codegen.annotations.VertxGen;
import io.vertx.core.AsyncResult;
import io.vertx.core.Context;
import io.vertx.core.Handler;
import io.vertx.core.Promise;
import io.vertx.core.ServiceHelper;
import io.vertx.core.spi.FutureFactory;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.function.Function;

@VertxGen
public interface Future<T>
extends AsyncResult<T>,
Handler<AsyncResult<T>> {
    @GenIgnore
    public static final FutureFactory factory = ServiceHelper.loadFactory(FutureFactory.class);

    public static <T> Future<T> future(Handler<Promise<T>> handler) {
        Promise promise2 = Promise.promise();
        try {
            handler.handle(promise2);
        }
        catch (Throwable e2) {
            promise2.tryFail(e2);
        }
        return promise2.future();
    }

    @Deprecated
    public static <T> Future<T> future() {
        return factory.future();
    }

    public static <T> Future<T> succeededFuture() {
        return factory.succeededFuture();
    }

    public static <T> Future<T> succeededFuture(T result2) {
        if (result2 == null) {
            return factory.succeededFuture();
        }
        return factory.succeededFuture(result2);
    }

    public static <T> Future<T> failedFuture(Throwable t3) {
        return factory.failedFuture(t3);
    }

    public static <T> Future<T> failedFuture(String failureMessage) {
        return factory.failureFuture(failureMessage);
    }

    public boolean isComplete();

    @Deprecated
    @Fluent
    default public Future<T> setHandler(Handler<AsyncResult<T>> handler) {
        return this.onComplete(handler);
    }

    @Fluent
    public Future<T> onComplete(Handler<AsyncResult<T>> var1);

    @Fluent
    default public Future<T> onSuccess(Handler<T> handler) {
        return this.onComplete(ar -> {
            if (ar.succeeded()) {
                handler.handle(ar.result());
            }
        });
    }

    @Fluent
    default public Future<T> onFailure(Handler<Throwable> handler) {
        return this.onComplete(ar -> {
            if (ar.failed()) {
                handler.handle(ar.cause());
            }
        });
    }

    @Deprecated
    public void complete(T var1);

    @Deprecated
    public void complete();

    @Deprecated
    public void fail(Throwable var1);

    @Deprecated
    public void fail(String var1);

    @Deprecated
    public boolean tryComplete(T var1);

    @Deprecated
    public boolean tryComplete();

    @Deprecated
    public boolean tryFail(Throwable var1);

    @Deprecated
    public boolean tryFail(String var1);

    @Override
    public T result();

    @Override
    public Throwable cause();

    @Override
    public boolean succeeded();

    @Override
    public boolean failed();

    default public <U> Future<U> flatMap(Function<T, Future<U>> mapper2) {
        return this.compose(mapper2);
    }

    @GenIgnore
    @Deprecated
    default public <U> Future<U> compose(Handler<T> handler, Future<U> next2) {
        this.onComplete(ar -> {
            if (ar.succeeded()) {
                try {
                    handler.handle(ar.result());
                }
                catch (Throwable err) {
                    if (next2.isComplete()) {
                        throw err;
                    }
                    next2.fail(err);
                }
            } else {
                next2.fail(ar.cause());
            }
        });
        return next2;
    }

    default public <U> Future<U> compose(Function<T, Future<U>> mapper2) {
        return this.compose(mapper2, Future::failedFuture);
    }

    default public <U> Future<U> compose(Function<T, Future<U>> successMapper, Function<Throwable, Future<U>> failureMapper) {
        if (successMapper == null) {
            throw new NullPointerException();
        }
        if (failureMapper == null) {
            throw new NullPointerException();
        }
        Promise ret = Promise.promise();
        this.onComplete(ar -> {
            if (ar.succeeded()) {
                Future apply2;
                try {
                    apply2 = (Future)successMapper.apply(ar.result());
                }
                catch (Throwable e2) {
                    ret.fail(e2);
                    return;
                }
                apply2.onComplete(ret);
            } else {
                Future apply3;
                try {
                    apply3 = (Future)failureMapper.apply(ar.cause());
                }
                catch (Throwable e3) {
                    ret.fail(e3);
                    return;
                }
                apply3.onComplete(ret);
            }
        });
        return ret.future();
    }

    @Override
    default public <U> Future<U> map(Function<T, U> mapper2) {
        if (mapper2 == null) {
            throw new NullPointerException();
        }
        Promise ret = Promise.promise();
        this.onComplete(ar -> {
            if (ar.succeeded()) {
                Object mapped;
                try {
                    mapped = mapper2.apply(ar.result());
                }
                catch (Throwable e2) {
                    ret.fail(e2);
                    return;
                }
                ret.complete(mapped);
            } else {
                ret.fail(ar.cause());
            }
        });
        return ret.future();
    }

    @Override
    default public <V> Future<V> map(V value) {
        Promise ret = Promise.promise();
        this.onComplete(ar -> {
            if (ar.succeeded()) {
                ret.complete(value);
            } else {
                ret.fail(ar.cause());
            }
        });
        return ret.future();
    }

    @Override
    default public <V> Future<V> mapEmpty() {
        return (Future)AsyncResult.super.mapEmpty();
    }

    @Override
    @GenIgnore
    public void handle(AsyncResult<T> var1);

    @Deprecated
    @CacheReturn
    default public Handler<AsyncResult<T>> completer() {
        return this;
    }

    default public Future<T> recover(Function<Throwable, Future<T>> mapper2) {
        if (mapper2 == null) {
            throw new NullPointerException();
        }
        Promise ret = Promise.promise();
        this.onComplete(ar -> {
            if (ar.succeeded()) {
                ret.complete(this.result());
            } else {
                Future mapped;
                try {
                    mapped = (Future)mapper2.apply(ar.cause());
                }
                catch (Throwable e2) {
                    ret.fail(e2);
                    return;
                }
                mapped.onComplete(ret);
            }
        });
        return ret.future();
    }

    @Override
    default public Future<T> otherwise(Function<Throwable, T> mapper2) {
        if (mapper2 == null) {
            throw new NullPointerException();
        }
        Promise ret = Promise.promise();
        this.onComplete(ar -> {
            if (ar.succeeded()) {
                ret.complete(this.result());
            } else {
                Object value;
                try {
                    value = mapper2.apply(ar.cause());
                }
                catch (Throwable e2) {
                    ret.fail(e2);
                    return;
                }
                ret.complete(value);
            }
        });
        return ret.future();
    }

    @Override
    default public Future<T> otherwise(T value) {
        Promise ret = Promise.promise();
        this.onComplete(ar -> {
            if (ar.succeeded()) {
                ret.complete(this.result());
            } else {
                ret.complete(value);
            }
        });
        return ret.future();
    }

    @Override
    default public Future<T> otherwiseEmpty() {
        return (Future)AsyncResult.super.otherwiseEmpty();
    }

    @GenIgnore
    default public CompletionStage<T> toCompletionStage() {
        CompletableFuture completableFuture = new CompletableFuture();
        this.setHandler(ar -> {
            if (ar.succeeded()) {
                completableFuture.complete(ar.result());
            } else {
                completableFuture.completeExceptionally(ar.cause());
            }
        });
        return completableFuture;
    }

    @GenIgnore
    public static <T> Future<T> fromCompletionStage(CompletionStage<T> completionStage) {
        Promise promise2 = Promise.promise();
        completionStage.whenComplete((value, err) -> {
            if (err != null) {
                promise2.fail((Throwable)err);
            } else {
                promise2.complete(value);
            }
        });
        return promise2.future();
    }

    @GenIgnore
    public static <T> Future<T> fromCompletionStage(CompletionStage<T> completionStage, Context context) {
        Promise promise2 = Promise.promise();
        completionStage.whenComplete((value, err) -> context.runOnContext(v -> {
            if (err != null) {
                promise2.fail((Throwable)err);
            } else {
                promise2.complete(value);
            }
        }));
        return promise2.future();
    }
}

