/*
 * Decompiled with CFR 0.152.
 */
package io.netty.util.internal;

import io.netty.util.ReferenceCountUtil;
import io.netty.util.concurrent.Promise;
import io.netty.util.internal.ObjectPool;

public final class PendingWrite {
    private static final ObjectPool<PendingWrite> RECYCLER = ObjectPool.newPool(new ObjectPool.ObjectCreator<PendingWrite>(){

        @Override
        public PendingWrite newObject(ObjectPool.Handle<PendingWrite> handle2) {
            return new PendingWrite(handle2);
        }
    });
    private final ObjectPool.Handle<PendingWrite> handle;
    private Object msg;
    private Promise<Void> promise;

    public static PendingWrite newInstance(Object msg, Promise<Void> promise2) {
        PendingWrite pending = RECYCLER.get();
        pending.msg = msg;
        pending.promise = promise2;
        return pending;
    }

    private PendingWrite(ObjectPool.Handle<PendingWrite> handle2) {
        this.handle = handle2;
    }

    public boolean recycle() {
        this.msg = null;
        this.promise = null;
        this.handle.recycle(this);
        return true;
    }

    public boolean failAndRecycle(Throwable cause) {
        ReferenceCountUtil.release(this.msg);
        if (this.promise != null) {
            this.promise.setFailure(cause);
        }
        return this.recycle();
    }

    public boolean successAndRecycle() {
        if (this.promise != null) {
            this.promise.setSuccess(null);
        }
        return this.recycle();
    }

    public Object msg() {
        return this.msg;
    }

    public Promise<Void> promise() {
        return this.promise;
    }

    public Promise<Void> recycleAndGet() {
        Promise<Void> promise2 = this.promise;
        this.recycle();
        return promise2;
    }
}

