/*
 * Decompiled with CFR 0.152.
 */
package io.netty.util;

import io.netty.util.ByteProcessor;
import io.netty.util.CharsetUtil;
import io.netty.util.HashingStrategy;
import io.netty.util.internal.EmptyArrays;
import io.netty.util.internal.InternalThreadLocalMap;
import io.netty.util.internal.MathUtil;
import io.netty.util.internal.ObjectUtil;
import io.netty.util.internal.PlatformDependent;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.regex.Pattern;

public final class AsciiString
implements CharSequence,
Comparable<CharSequence> {
    public static final AsciiString EMPTY_STRING = AsciiString.cached("");
    private static final char MAX_CHAR_VALUE = '\u00ff';
    public static final int INDEX_NOT_FOUND = -1;
    private final byte[] value;
    private final int offset;
    private final int length;
    private int hash;
    private String string;
    public static final HashingStrategy<CharSequence> CASE_INSENSITIVE_HASHER = new HashingStrategy<CharSequence>(){

        @Override
        public int hashCode(CharSequence o) {
            return AsciiString.hashCode(o);
        }

        @Override
        public boolean equals(CharSequence a, CharSequence b) {
            return AsciiString.contentEqualsIgnoreCase(a, b);
        }
    };
    public static final HashingStrategy<CharSequence> CASE_SENSITIVE_HASHER = new HashingStrategy<CharSequence>(){

        @Override
        public int hashCode(CharSequence o) {
            return AsciiString.hashCode(o);
        }

        @Override
        public boolean equals(CharSequence a, CharSequence b) {
            return AsciiString.contentEquals(a, b);
        }
    };

    public AsciiString(byte[] value) {
        this(value, true);
    }

    public AsciiString(byte[] value, boolean copy2) {
        this(value, 0, value.length, copy2);
    }

    public AsciiString(byte[] value, int start2, int length, boolean copy2) {
        if (copy2) {
            this.value = Arrays.copyOfRange(value, start2, start2 + length);
            this.offset = 0;
        } else {
            if (MathUtil.isOutOfBounds(start2, length, value.length)) {
                throw new IndexOutOfBoundsException("expected: 0 <= start(" + start2 + ") <= start + length(" + length + ") <= value.length(" + value.length + ')');
            }
            this.value = value;
            this.offset = start2;
        }
        this.length = length;
    }

    public AsciiString(ByteBuffer value) {
        this(value, true);
    }

    public AsciiString(ByteBuffer value, boolean copy2) {
        this(value, value.position(), value.remaining(), copy2);
    }

    public AsciiString(ByteBuffer value, int start2, int length, boolean copy2) {
        if (MathUtil.isOutOfBounds(start2, length, value.capacity())) {
            throw new IndexOutOfBoundsException("expected: 0 <= start(" + start2 + ") <= start + length(" + length + ") <= value.capacity(" + value.capacity() + ')');
        }
        if (value.hasArray()) {
            if (copy2) {
                int bufferOffset = value.arrayOffset() + start2;
                this.value = Arrays.copyOfRange(value.array(), bufferOffset, bufferOffset + length);
                this.offset = 0;
            } else {
                this.value = value.array();
                this.offset = start2;
            }
        } else {
            this.value = PlatformDependent.allocateUninitializedArray(length);
            int oldPos = value.position();
            value.get(this.value, 0, length);
            value.position(oldPos);
            this.offset = 0;
        }
        this.length = length;
    }

    public AsciiString(char[] value) {
        this(value, 0, value.length);
    }

    public AsciiString(char[] value, int start2, int length) {
        if (MathUtil.isOutOfBounds(start2, length, value.length)) {
            throw new IndexOutOfBoundsException("expected: 0 <= start(" + start2 + ") <= start + length(" + length + ") <= value.length(" + value.length + ')');
        }
        this.value = PlatformDependent.allocateUninitializedArray(length);
        int i = 0;
        int j = start2;
        while (i < length) {
            this.value[i] = AsciiString.c2b(value[j]);
            ++i;
            ++j;
        }
        this.offset = 0;
        this.length = length;
    }

    public AsciiString(char[] value, Charset charset) {
        this(value, charset, 0, value.length);
    }

    public AsciiString(char[] value, Charset charset, int start2, int length) {
        CharBuffer cbuf = CharBuffer.wrap(value, start2, length);
        CharsetEncoder encoder = CharsetUtil.encoder(charset);
        ByteBuffer nativeBuffer = ByteBuffer.allocate((int)(encoder.maxBytesPerChar() * (float)length));
        encoder.encode(cbuf, nativeBuffer, true);
        int bufferOffset = nativeBuffer.arrayOffset();
        this.value = Arrays.copyOfRange(nativeBuffer.array(), bufferOffset, bufferOffset + nativeBuffer.position());
        this.offset = 0;
        this.length = this.value.length;
    }

    public AsciiString(CharSequence value) {
        this(value, 0, value.length());
    }

    public AsciiString(CharSequence value, int start2, int length) {
        if (MathUtil.isOutOfBounds(start2, length, value.length())) {
            throw new IndexOutOfBoundsException("expected: 0 <= start(" + start2 + ") <= start + length(" + length + ") <= value.length(" + value.length() + ')');
        }
        this.value = PlatformDependent.allocateUninitializedArray(length);
        int i = 0;
        int j = start2;
        while (i < length) {
            this.value[i] = AsciiString.c2b(value.charAt(j));
            ++i;
            ++j;
        }
        this.offset = 0;
        this.length = length;
    }

    public AsciiString(CharSequence value, Charset charset) {
        this(value, charset, 0, value.length());
    }

    public AsciiString(CharSequence value, Charset charset, int start2, int length) {
        CharBuffer cbuf = CharBuffer.wrap(value, start2, start2 + length);
        CharsetEncoder encoder = CharsetUtil.encoder(charset);
        ByteBuffer nativeBuffer = ByteBuffer.allocate((int)(encoder.maxBytesPerChar() * (float)length));
        encoder.encode(cbuf, nativeBuffer, true);
        int offset = nativeBuffer.arrayOffset();
        this.value = Arrays.copyOfRange(nativeBuffer.array(), offset, offset + nativeBuffer.position());
        this.offset = 0;
        this.length = this.value.length;
    }

    public int forEachByte(ByteProcessor visitor2) throws Exception {
        return this.forEachByte0(0, this.length(), visitor2);
    }

    public int forEachByte(int index2, int length, ByteProcessor visitor2) throws Exception {
        if (MathUtil.isOutOfBounds(index2, length, this.length())) {
            throw new IndexOutOfBoundsException("expected: 0 <= index(" + index2 + ") <= start + length(" + length + ") <= length(" + this.length() + ')');
        }
        return this.forEachByte0(index2, length, visitor2);
    }

    private int forEachByte0(int index2, int length, ByteProcessor visitor2) throws Exception {
        int len = this.offset + index2 + length;
        for (int i = this.offset + index2; i < len; ++i) {
            if (visitor2.process(this.value[i])) continue;
            return i - this.offset;
        }
        return -1;
    }

    public int forEachByteDesc(ByteProcessor visitor2) throws Exception {
        return this.forEachByteDesc0(0, this.length(), visitor2);
    }

    public int forEachByteDesc(int index2, int length, ByteProcessor visitor2) throws Exception {
        if (MathUtil.isOutOfBounds(index2, length, this.length())) {
            throw new IndexOutOfBoundsException("expected: 0 <= index(" + index2 + ") <= start + length(" + length + ") <= length(" + this.length() + ')');
        }
        return this.forEachByteDesc0(index2, length, visitor2);
    }

    private int forEachByteDesc0(int index2, int length, ByteProcessor visitor2) throws Exception {
        int end2 = this.offset + index2;
        for (int i = this.offset + index2 + length - 1; i >= end2; --i) {
            if (visitor2.process(this.value[i])) continue;
            return i - this.offset;
        }
        return -1;
    }

    public byte byteAt(int index2) {
        if (index2 < 0 || index2 >= this.length) {
            throw new IndexOutOfBoundsException("index: " + index2 + " must be in the range [0," + this.length + ")");
        }
        if (PlatformDependent.hasUnsafe()) {
            return PlatformDependent.getByte(this.value, index2 + this.offset);
        }
        return this.value[index2 + this.offset];
    }

    @Override
    public boolean isEmpty() {
        return this.length == 0;
    }

    @Override
    public int length() {
        return this.length;
    }

    public void arrayChanged() {
        this.string = null;
        this.hash = 0;
    }

    public byte[] array() {
        return this.value;
    }

    public int arrayOffset() {
        return this.offset;
    }

    public boolean isEntireArrayUsed() {
        return this.offset == 0 && this.length == this.value.length;
    }

    public byte[] toByteArray() {
        return this.toByteArray(0, this.length());
    }

    public byte[] toByteArray(int start2, int end2) {
        return Arrays.copyOfRange(this.value, start2 + this.offset, end2 + this.offset);
    }

    public void copy(int srcIdx, byte[] dst, int dstIdx, int length) {
        if (MathUtil.isOutOfBounds(srcIdx, length, this.length())) {
            throw new IndexOutOfBoundsException("expected: 0 <= srcIdx(" + srcIdx + ") <= srcIdx + length(" + length + ") <= srcLen(" + this.length() + ')');
        }
        System.arraycopy(this.value, srcIdx + this.offset, ObjectUtil.checkNotNull(dst, "dst"), dstIdx, length);
    }

    @Override
    public char charAt(int index2) {
        return AsciiString.b2c(this.byteAt(index2));
    }

    public boolean contains(CharSequence cs) {
        return this.indexOf(cs) >= 0;
    }

    @Override
    public int compareTo(CharSequence string2) {
        if (this == string2) {
            return 0;
        }
        int length1 = this.length();
        int length2 = string2.length();
        int minLength = Math.min(length1, length2);
        int i = 0;
        int j = this.arrayOffset();
        while (i < minLength) {
            int result2 = AsciiString.b2c(this.value[j]) - string2.charAt(i);
            if (result2 != 0) {
                return result2;
            }
            ++i;
            ++j;
        }
        return length1 - length2;
    }

    public AsciiString concat(CharSequence string2) {
        int thisLen = this.length();
        int thatLen = string2.length();
        if (thatLen == 0) {
            return this;
        }
        if (string2 instanceof AsciiString) {
            AsciiString that = (AsciiString)string2;
            if (this.isEmpty()) {
                return that;
            }
            byte[] newValue = PlatformDependent.allocateUninitializedArray(thisLen + thatLen);
            System.arraycopy(this.value, this.arrayOffset(), newValue, 0, thisLen);
            System.arraycopy(that.value, that.arrayOffset(), newValue, thisLen, thatLen);
            return new AsciiString(newValue, false);
        }
        if (this.isEmpty()) {
            return new AsciiString(string2);
        }
        byte[] newValue = PlatformDependent.allocateUninitializedArray(thisLen + thatLen);
        System.arraycopy(this.value, this.arrayOffset(), newValue, 0, thisLen);
        int i = thisLen;
        int j = 0;
        while (i < newValue.length) {
            newValue[i] = AsciiString.c2b(string2.charAt(j));
            ++i;
            ++j;
        }
        return new AsciiString(newValue, false);
    }

    public boolean endsWith(CharSequence suffix) {
        int suffixLen = suffix.length();
        return this.regionMatches(this.length() - suffixLen, suffix, 0, suffixLen);
    }

    public boolean contentEqualsIgnoreCase(CharSequence string2) {
        if (this == string2) {
            return true;
        }
        if (string2 == null || string2.length() != this.length()) {
            return false;
        }
        if (string2 instanceof AsciiString) {
            AsciiString rhs = (AsciiString)string2;
            int i = this.arrayOffset();
            int j = rhs.arrayOffset();
            int end2 = i + this.length();
            while (i < end2) {
                if (!AsciiString.equalsIgnoreCase(this.value[i], rhs.value[j])) {
                    return false;
                }
                ++i;
                ++j;
            }
            return true;
        }
        int i = this.arrayOffset();
        int end3 = this.length();
        for (int j = 0; j < end3; ++j) {
            if (!AsciiString.equalsIgnoreCase(AsciiString.b2c(this.value[i]), string2.charAt(j))) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public char[] toCharArray() {
        return this.toCharArray(0, this.length());
    }

    public char[] toCharArray(int start2, int end2) {
        int length = end2 - start2;
        if (length == 0) {
            return EmptyArrays.EMPTY_CHARS;
        }
        if (MathUtil.isOutOfBounds(start2, length, this.length())) {
            throw new IndexOutOfBoundsException("expected: 0 <= start(" + start2 + ") <= srcIdx + length(" + length + ") <= srcLen(" + this.length() + ')');
        }
        char[] buffer = new char[length];
        int i = 0;
        int j = start2 + this.arrayOffset();
        while (i < length) {
            buffer[i] = AsciiString.b2c(this.value[j]);
            ++i;
            ++j;
        }
        return buffer;
    }

    public void copy(int srcIdx, char[] dst, int dstIdx, int length) {
        ObjectUtil.checkNotNull(dst, "dst");
        if (MathUtil.isOutOfBounds(srcIdx, length, this.length())) {
            throw new IndexOutOfBoundsException("expected: 0 <= srcIdx(" + srcIdx + ") <= srcIdx + length(" + length + ") <= srcLen(" + this.length() + ')');
        }
        int dstEnd = dstIdx + length;
        int i = dstIdx;
        int j = srcIdx + this.arrayOffset();
        while (i < dstEnd) {
            dst[i] = AsciiString.b2c(this.value[j]);
            ++i;
            ++j;
        }
    }

    public AsciiString subSequence(int start2) {
        return this.subSequence(start2, this.length());
    }

    @Override
    public AsciiString subSequence(int start2, int end2) {
        return this.subSequence(start2, end2, true);
    }

    public AsciiString subSequence(int start2, int end2, boolean copy2) {
        if (MathUtil.isOutOfBounds(start2, end2 - start2, this.length())) {
            throw new IndexOutOfBoundsException("expected: 0 <= start(" + start2 + ") <= end (" + end2 + ") <= length(" + this.length() + ')');
        }
        if (start2 == 0 && end2 == this.length()) {
            return this;
        }
        if (end2 == start2) {
            return EMPTY_STRING;
        }
        return new AsciiString(this.value, start2 + this.offset, end2 - start2, copy2);
    }

    public int indexOf(CharSequence string2) {
        return this.indexOf(string2, 0);
    }

    public int indexOf(CharSequence subString, int start2) {
        int subCount = subString.length();
        if (start2 < 0) {
            start2 = 0;
        }
        if (subCount <= 0) {
            return start2 < this.length ? start2 : this.length;
        }
        if (subCount > this.length - start2) {
            return -1;
        }
        char firstChar = subString.charAt(0);
        if (firstChar > '\u00ff') {
            return -1;
        }
        byte firstCharAsByte = AsciiString.c2b0(firstChar);
        int len = this.offset + this.length - subCount;
        for (int i = start2 + this.offset; i <= len; ++i) {
            if (this.value[i] != firstCharAsByte) continue;
            int o1 = i;
            int o2 = 0;
            while (++o2 < subCount && AsciiString.b2c(this.value[++o1]) == subString.charAt(o2)) {
            }
            if (o2 != subCount) continue;
            return i - this.offset;
        }
        return -1;
    }

    public int indexOf(char ch, int start2) {
        if (ch > '\u00ff') {
            return -1;
        }
        if (start2 < 0) {
            start2 = 0;
        }
        byte chAsByte = AsciiString.c2b0(ch);
        int len = this.offset + this.length;
        for (int i = start2 + this.offset; i < len; ++i) {
            if (this.value[i] != chAsByte) continue;
            return i - this.offset;
        }
        return -1;
    }

    public int lastIndexOf(CharSequence string2) {
        return this.lastIndexOf(string2, this.length);
    }

    public int lastIndexOf(CharSequence subString, int start2) {
        int subCount = subString.length();
        if ((start2 = Math.min(start2, this.length - subCount)) < 0) {
            return -1;
        }
        if (subCount == 0) {
            return start2;
        }
        char firstChar = subString.charAt(0);
        if (firstChar > '\u00ff') {
            return -1;
        }
        byte firstCharAsByte = AsciiString.c2b0(firstChar);
        for (int i = this.offset + start2; i >= 0; --i) {
            if (this.value[i] != firstCharAsByte) continue;
            int o1 = i;
            int o2 = 0;
            while (++o2 < subCount && AsciiString.b2c(this.value[++o1]) == subString.charAt(o2)) {
            }
            if (o2 != subCount) continue;
            return i - this.offset;
        }
        return -1;
    }

    public boolean regionMatches(int thisStart, CharSequence string2, int start2, int length) {
        ObjectUtil.checkNotNull(string2, "string");
        if (start2 < 0 || string2.length() - start2 < length) {
            return false;
        }
        int thisLen = this.length();
        if (thisStart < 0 || thisLen - thisStart < length) {
            return false;
        }
        if (length <= 0) {
            return true;
        }
        int thatEnd = start2 + length;
        int i = start2;
        int j = thisStart + this.arrayOffset();
        while (i < thatEnd) {
            if (AsciiString.b2c(this.value[j]) != string2.charAt(i)) {
                return false;
            }
            ++i;
            ++j;
        }
        return true;
    }

    public boolean regionMatches(boolean ignoreCase, int thisStart, CharSequence string2, int start2, int length) {
        if (!ignoreCase) {
            return this.regionMatches(thisStart, string2, start2, length);
        }
        ObjectUtil.checkNotNull(string2, "string");
        int thisLen = this.length();
        if (thisStart < 0 || length > thisLen - thisStart) {
            return false;
        }
        if (start2 < 0 || length > string2.length() - start2) {
            return false;
        }
        int thisEnd = (thisStart += this.arrayOffset()) + length;
        while (thisStart < thisEnd) {
            if (AsciiString.equalsIgnoreCase(AsciiString.b2c(this.value[thisStart++]), string2.charAt(start2++))) continue;
            return false;
        }
        return true;
    }

    public AsciiString replace(char oldChar, char newChar) {
        if (oldChar > '\u00ff') {
            return this;
        }
        byte oldCharAsByte = AsciiString.c2b0(oldChar);
        byte newCharAsByte = AsciiString.c2b(newChar);
        int len = this.offset + this.length;
        for (int i = this.offset; i < len; ++i) {
            if (this.value[i] != oldCharAsByte) continue;
            byte[] buffer = PlatformDependent.allocateUninitializedArray(this.length());
            System.arraycopy(this.value, this.offset, buffer, 0, i - this.offset);
            buffer[i - this.offset] = newCharAsByte;
            ++i;
            while (i < len) {
                byte oldValue = this.value[i];
                buffer[i - this.offset] = oldValue != oldCharAsByte ? oldValue : newCharAsByte;
                ++i;
            }
            return new AsciiString(buffer, false);
        }
        return this;
    }

    public boolean startsWith(CharSequence prefix) {
        return this.startsWith(prefix, 0);
    }

    public boolean startsWith(CharSequence prefix, int start2) {
        return this.regionMatches(start2, prefix, 0, prefix.length());
    }

    public AsciiString toLowerCase() {
        int i;
        boolean lowercased = true;
        int len = this.length() + this.arrayOffset();
        for (i = this.arrayOffset(); i < len; ++i) {
            byte b = this.value[i];
            if (b < 65 || b > 90) continue;
            lowercased = false;
            break;
        }
        if (lowercased) {
            return this;
        }
        byte[] newValue = PlatformDependent.allocateUninitializedArray(this.length());
        i = 0;
        int j = this.arrayOffset();
        while (i < newValue.length) {
            newValue[i] = AsciiString.toLowerCase(this.value[j]);
            ++i;
            ++j;
        }
        return new AsciiString(newValue, false);
    }

    public AsciiString toUpperCase() {
        int i;
        boolean uppercased = true;
        int len = this.length() + this.arrayOffset();
        for (i = this.arrayOffset(); i < len; ++i) {
            byte b = this.value[i];
            if (b < 97 || b > 122) continue;
            uppercased = false;
            break;
        }
        if (uppercased) {
            return this;
        }
        byte[] newValue = PlatformDependent.allocateUninitializedArray(this.length());
        i = 0;
        int j = this.arrayOffset();
        while (i < newValue.length) {
            newValue[i] = AsciiString.toUpperCase(this.value[j]);
            ++i;
            ++j;
        }
        return new AsciiString(newValue, false);
    }

    public static CharSequence trim(CharSequence c) {
        int start2;
        int last2;
        if (c instanceof AsciiString) {
            return ((AsciiString)c).trim();
        }
        if (c instanceof String) {
            return ((String)c).trim();
        }
        int end2 = last2 = c.length() - 1;
        for (start2 = 0; start2 <= end2 && c.charAt(start2) <= ' '; ++start2) {
        }
        while (end2 >= start2 && c.charAt(end2) <= ' ') {
            --end2;
        }
        if (start2 == 0 && end2 == last2) {
            return c;
        }
        return c.subSequence(start2, end2);
    }

    public AsciiString trim() {
        int start2;
        int last2;
        int end2 = last2 = this.arrayOffset() + this.length() - 1;
        for (start2 = this.arrayOffset(); start2 <= end2 && this.value[start2] <= 32; ++start2) {
        }
        while (end2 >= start2 && this.value[end2] <= 32) {
            --end2;
        }
        if (start2 == 0 && end2 == last2) {
            return this;
        }
        return new AsciiString(this.value, start2, end2 - start2 + 1, false);
    }

    public boolean contentEquals(CharSequence a) {
        if (this == a) {
            return true;
        }
        if (a == null || a.length() != this.length()) {
            return false;
        }
        if (a instanceof AsciiString) {
            return this.equals(a);
        }
        int i = this.arrayOffset();
        for (int j = 0; j < a.length(); ++j) {
            if (AsciiString.b2c(this.value[i]) != a.charAt(j)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public boolean matches(String expr) {
        return Pattern.matches(expr, this);
    }

    public AsciiString[] split(String expr, int max2) {
        return AsciiString.toAsciiStringArray(Pattern.compile(expr).split(this, max2));
    }

    public AsciiString[] split(char delim) {
        int i;
        ArrayList<AsciiString> res = InternalThreadLocalMap.get().arrayList();
        int start2 = 0;
        int length = this.length();
        for (i = start2; i < length; ++i) {
            if (this.charAt(i) != delim) continue;
            if (start2 == i) {
                res.add(EMPTY_STRING);
            } else {
                res.add(new AsciiString(this.value, start2 + this.arrayOffset(), i - start2, false));
            }
            start2 = i + 1;
        }
        if (start2 == 0) {
            res.add(this);
        } else if (start2 != length) {
            res.add(new AsciiString(this.value, start2 + this.arrayOffset(), length - start2, false));
        } else {
            for (i = res.size() - 1; i >= 0 && ((AsciiString)res.get(i)).isEmpty(); --i) {
                res.remove(i);
            }
        }
        return res.toArray(new AsciiString[0]);
    }

    public int hashCode() {
        int h2 = this.hash;
        if (h2 == 0) {
            this.hash = h2 = PlatformDependent.hashCodeAscii(this.value, this.offset, this.length);
        }
        return h2;
    }

    public boolean equals(Object obj2) {
        if (obj2 == null || obj2.getClass() != AsciiString.class) {
            return false;
        }
        if (this == obj2) {
            return true;
        }
        AsciiString other = (AsciiString)obj2;
        return this.length() == other.length() && this.hashCode() == other.hashCode() && PlatformDependent.equals(this.array(), this.arrayOffset(), other.array(), other.arrayOffset(), this.length());
    }

    @Override
    public String toString() {
        String cache = this.string;
        if (cache == null) {
            this.string = cache = this.toString(0);
        }
        return cache;
    }

    public String toString(int start2) {
        return this.toString(start2, this.length());
    }

    public String toString(int start2, int end2) {
        int length = end2 - start2;
        if (length == 0) {
            return "";
        }
        if (MathUtil.isOutOfBounds(start2, length, this.length())) {
            throw new IndexOutOfBoundsException("expected: 0 <= start(" + start2 + ") <= srcIdx + length(" + length + ") <= srcLen(" + this.length() + ')');
        }
        String str2 = new String(this.value, 0, start2 + this.offset, length);
        return str2;
    }

    public boolean parseBoolean() {
        return this.length >= 1 && this.value[this.offset] != 0;
    }

    public char parseChar() {
        return this.parseChar(0);
    }

    public char parseChar(int start2) {
        if (start2 + 1 >= this.length()) {
            throw new IndexOutOfBoundsException("2 bytes required to convert to character. index " + start2 + " would go out of bounds.");
        }
        int startWithOffset = start2 + this.offset;
        return (char)(AsciiString.b2c(this.value[startWithOffset]) << 8 | AsciiString.b2c(this.value[startWithOffset + 1]));
    }

    public short parseShort() {
        return this.parseShort(0, this.length(), 10);
    }

    public short parseShort(int radix) {
        return this.parseShort(0, this.length(), radix);
    }

    public short parseShort(int start2, int end2) {
        return this.parseShort(start2, end2, 10);
    }

    public short parseShort(int start2, int end2, int radix) {
        int intValue = this.parseInt(start2, end2, radix);
        short result2 = (short)intValue;
        if (result2 != intValue) {
            throw new NumberFormatException(this.subSequence(start2, end2, false).toString());
        }
        return result2;
    }

    public int parseInt() {
        return this.parseInt(0, this.length(), 10);
    }

    public int parseInt(int radix) {
        return this.parseInt(0, this.length(), radix);
    }

    public int parseInt(int start2, int end2) {
        return this.parseInt(start2, end2, 10);
    }

    public int parseInt(int start2, int end2, int radix) {
        boolean negative;
        if (radix < 2 || radix > 36) {
            throw new NumberFormatException();
        }
        if (start2 == end2) {
            throw new NumberFormatException();
        }
        int i = start2;
        boolean bl = negative = this.byteAt(i) == 45;
        if (negative && ++i == end2) {
            throw new NumberFormatException(this.subSequence(start2, end2, false).toString());
        }
        return this.parseInt(i, end2, radix, negative);
    }

    private int parseInt(int start2, int end2, int radix, boolean negative) {
        int max2 = Integer.MIN_VALUE / radix;
        int result2 = 0;
        int currOffset = start2;
        while (currOffset < end2) {
            int digit;
            if ((digit = Character.digit((char)(this.value[currOffset++ + this.offset] & 0xFF), radix)) == -1) {
                throw new NumberFormatException(this.subSequence(start2, end2, false).toString());
            }
            if (max2 > result2) {
                throw new NumberFormatException(this.subSequence(start2, end2, false).toString());
            }
            int next2 = result2 * radix - digit;
            if (next2 > result2) {
                throw new NumberFormatException(this.subSequence(start2, end2, false).toString());
            }
            result2 = next2;
        }
        if (!negative && (result2 = -result2) < 0) {
            throw new NumberFormatException(this.subSequence(start2, end2, false).toString());
        }
        return result2;
    }

    public long parseLong() {
        return this.parseLong(0, this.length(), 10);
    }

    public long parseLong(int radix) {
        return this.parseLong(0, this.length(), radix);
    }

    public long parseLong(int start2, int end2) {
        return this.parseLong(start2, end2, 10);
    }

    public long parseLong(int start2, int end2, int radix) {
        boolean negative;
        if (radix < 2 || radix > 36) {
            throw new NumberFormatException();
        }
        if (start2 == end2) {
            throw new NumberFormatException();
        }
        int i = start2;
        boolean bl = negative = this.byteAt(i) == 45;
        if (negative && ++i == end2) {
            throw new NumberFormatException(this.subSequence(start2, end2, false).toString());
        }
        return this.parseLong(i, end2, radix, negative);
    }

    private long parseLong(int start2, int end2, int radix, boolean negative) {
        long max2 = Long.MIN_VALUE / (long)radix;
        long result2 = 0L;
        int currOffset = start2;
        while (currOffset < end2) {
            int digit;
            if ((digit = Character.digit((char)(this.value[currOffset++ + this.offset] & 0xFF), radix)) == -1) {
                throw new NumberFormatException(this.subSequence(start2, end2, false).toString());
            }
            if (max2 > result2) {
                throw new NumberFormatException(this.subSequence(start2, end2, false).toString());
            }
            long next2 = result2 * (long)radix - (long)digit;
            if (next2 > result2) {
                throw new NumberFormatException(this.subSequence(start2, end2, false).toString());
            }
            result2 = next2;
        }
        if (!negative && (result2 = -result2) < 0L) {
            throw new NumberFormatException(this.subSequence(start2, end2, false).toString());
        }
        return result2;
    }

    public float parseFloat() {
        return this.parseFloat(0, this.length());
    }

    public float parseFloat(int start2, int end2) {
        return Float.parseFloat(this.toString(start2, end2));
    }

    public double parseDouble() {
        return this.parseDouble(0, this.length());
    }

    public double parseDouble(int start2, int end2) {
        return Double.parseDouble(this.toString(start2, end2));
    }

    public static AsciiString of(CharSequence string2) {
        return string2 instanceof AsciiString ? (AsciiString)string2 : new AsciiString(string2);
    }

    public static AsciiString cached(String string2) {
        AsciiString asciiString = new AsciiString(string2);
        asciiString.string = string2;
        return asciiString;
    }

    public static int hashCode(CharSequence value) {
        if (value == null) {
            return 0;
        }
        if (value instanceof AsciiString) {
            return value.hashCode();
        }
        return PlatformDependent.hashCodeAscii(value);
    }

    public static boolean contains(CharSequence a, CharSequence b) {
        return AsciiString.contains(a, b, DefaultCharEqualityComparator.INSTANCE);
    }

    public static boolean containsIgnoreCase(CharSequence a, CharSequence b) {
        return AsciiString.contains(a, b, AsciiCaseInsensitiveCharEqualityComparator.INSTANCE);
    }

    public static boolean contentEqualsIgnoreCase(CharSequence a, CharSequence b) {
        if (a == null || b == null) {
            return a == b;
        }
        if (a instanceof AsciiString) {
            return ((AsciiString)a).contentEqualsIgnoreCase(b);
        }
        if (b instanceof AsciiString) {
            return ((AsciiString)b).contentEqualsIgnoreCase(a);
        }
        if (a.length() != b.length()) {
            return false;
        }
        for (int i = 0; i < a.length(); ++i) {
            if (AsciiString.equalsIgnoreCase(a.charAt(i), b.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public static boolean containsContentEqualsIgnoreCase(Collection<CharSequence> collection2, CharSequence value) {
        for (CharSequence v : collection2) {
            if (!AsciiString.contentEqualsIgnoreCase(value, v)) continue;
            return true;
        }
        return false;
    }

    public static boolean containsAllContentEqualsIgnoreCase(Collection<CharSequence> a, Collection<CharSequence> b) {
        for (CharSequence v : b) {
            if (AsciiString.containsContentEqualsIgnoreCase(a, v)) continue;
            return false;
        }
        return true;
    }

    public static boolean contentEquals(CharSequence a, CharSequence b) {
        if (a == null || b == null) {
            return a == b;
        }
        if (a instanceof AsciiString) {
            return ((AsciiString)a).contentEquals(b);
        }
        if (b instanceof AsciiString) {
            return ((AsciiString)b).contentEquals(a);
        }
        if (a.length() != b.length()) {
            return false;
        }
        for (int i = 0; i < a.length(); ++i) {
            if (a.charAt(i) == b.charAt(i)) continue;
            return false;
        }
        return true;
    }

    private static AsciiString[] toAsciiStringArray(String[] jdkResult) {
        AsciiString[] res = new AsciiString[jdkResult.length];
        for (int i = 0; i < jdkResult.length; ++i) {
            res[i] = new AsciiString(jdkResult[i]);
        }
        return res;
    }

    private static boolean contains(CharSequence a, CharSequence b, CharEqualityComparator cmp) {
        if (a == null || b == null || a.length() < b.length()) {
            return false;
        }
        if (b.length() == 0) {
            return true;
        }
        int bStart = 0;
        for (int i = 0; i < a.length(); ++i) {
            if (cmp.equals(b.charAt(bStart), a.charAt(i))) {
                if (++bStart != b.length()) continue;
                return true;
            }
            if (a.length() - i < b.length()) {
                return false;
            }
            bStart = 0;
        }
        return false;
    }

    private static boolean regionMatchesCharSequences(CharSequence cs, int csStart, CharSequence string2, int start2, int length, CharEqualityComparator charEqualityComparator) {
        if (csStart < 0 || length > cs.length() - csStart) {
            return false;
        }
        if (start2 < 0 || length > string2.length() - start2) {
            return false;
        }
        int csIndex = csStart;
        int csEnd = csIndex + length;
        int stringIndex = start2;
        while (csIndex < csEnd) {
            char c2;
            char c1;
            if (charEqualityComparator.equals(c1 = cs.charAt(csIndex++), c2 = string2.charAt(stringIndex++))) continue;
            return false;
        }
        return true;
    }

    public static boolean regionMatches(CharSequence cs, boolean ignoreCase, int csStart, CharSequence string2, int start2, int length) {
        if (cs == null || string2 == null) {
            return false;
        }
        if (cs instanceof String && string2 instanceof String) {
            return ((String)cs).regionMatches(ignoreCase, csStart, (String)string2, start2, length);
        }
        if (cs instanceof AsciiString) {
            return ((AsciiString)cs).regionMatches(ignoreCase, csStart, string2, start2, length);
        }
        return AsciiString.regionMatchesCharSequences(cs, csStart, string2, start2, length, ignoreCase ? GeneralCaseInsensitiveCharEqualityComparator.INSTANCE : DefaultCharEqualityComparator.INSTANCE);
    }

    public static boolean regionMatchesAscii(CharSequence cs, boolean ignoreCase, int csStart, CharSequence string2, int start2, int length) {
        if (cs == null || string2 == null) {
            return false;
        }
        if (!ignoreCase && cs instanceof String && string2 instanceof String) {
            return ((String)cs).regionMatches(false, csStart, (String)string2, start2, length);
        }
        if (cs instanceof AsciiString) {
            return ((AsciiString)cs).regionMatches(ignoreCase, csStart, string2, start2, length);
        }
        return AsciiString.regionMatchesCharSequences(cs, csStart, string2, start2, length, ignoreCase ? AsciiCaseInsensitiveCharEqualityComparator.INSTANCE : DefaultCharEqualityComparator.INSTANCE);
    }

    public static int indexOfIgnoreCase(CharSequence str2, CharSequence searchStr, int startPos) {
        if (str2 == null || searchStr == null) {
            return -1;
        }
        if (startPos < 0) {
            startPos = 0;
        }
        int searchStrLen = searchStr.length();
        int endLimit = str2.length() - searchStrLen + 1;
        if (startPos > endLimit) {
            return -1;
        }
        if (searchStrLen == 0) {
            return startPos;
        }
        for (int i = startPos; i < endLimit; ++i) {
            if (!AsciiString.regionMatches(str2, true, i, searchStr, 0, searchStrLen)) continue;
            return i;
        }
        return -1;
    }

    public static int indexOfIgnoreCaseAscii(CharSequence str2, CharSequence searchStr, int startPos) {
        if (str2 == null || searchStr == null) {
            return -1;
        }
        if (startPos < 0) {
            startPos = 0;
        }
        int searchStrLen = searchStr.length();
        int endLimit = str2.length() - searchStrLen + 1;
        if (startPos > endLimit) {
            return -1;
        }
        if (searchStrLen == 0) {
            return startPos;
        }
        for (int i = startPos; i < endLimit; ++i) {
            if (!AsciiString.regionMatchesAscii(str2, true, i, searchStr, 0, searchStrLen)) continue;
            return i;
        }
        return -1;
    }

    public static int indexOf(CharSequence cs, char searchChar, int start2) {
        int i;
        if (cs instanceof String) {
            return ((String)cs).indexOf(searchChar, start2);
        }
        if (cs instanceof AsciiString) {
            return ((AsciiString)cs).indexOf(searchChar, start2);
        }
        if (cs == null) {
            return -1;
        }
        int sz = cs.length();
        int n = i = start2 < 0 ? 0 : start2;
        while (i < sz) {
            if (cs.charAt(i) == searchChar) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    private static boolean equalsIgnoreCase(byte a, byte b) {
        return a == b || AsciiString.toLowerCase(a) == AsciiString.toLowerCase(b);
    }

    private static boolean equalsIgnoreCase(char a, char b) {
        return a == b || AsciiString.toLowerCase(a) == AsciiString.toLowerCase(b);
    }

    private static byte toLowerCase(byte b) {
        return AsciiString.isUpperCase(b) ? (byte)(b + 32) : b;
    }

    public static char toLowerCase(char c) {
        return AsciiString.isUpperCase(c) ? (char)(c + 32) : c;
    }

    private static byte toUpperCase(byte b) {
        return AsciiString.isLowerCase(b) ? (byte)(b - 32) : b;
    }

    private static boolean isLowerCase(byte value) {
        return value >= 97 && value <= 122;
    }

    public static boolean isUpperCase(byte value) {
        return value >= 65 && value <= 90;
    }

    public static boolean isUpperCase(char value) {
        return value >= 'A' && value <= 'Z';
    }

    public static byte c2b(char c) {
        return (byte)(c > '\u00ff' ? 63 : (int)c);
    }

    private static byte c2b0(char c) {
        return (byte)c;
    }

    public static char b2c(byte b) {
        return (char)(b & 0xFF);
    }

    private static final class GeneralCaseInsensitiveCharEqualityComparator
    implements CharEqualityComparator {
        static final GeneralCaseInsensitiveCharEqualityComparator INSTANCE = new GeneralCaseInsensitiveCharEqualityComparator();

        private GeneralCaseInsensitiveCharEqualityComparator() {
        }

        @Override
        public boolean equals(char a, char b) {
            return Character.toUpperCase(a) == Character.toUpperCase(b) || Character.toLowerCase(a) == Character.toLowerCase(b);
        }
    }

    private static final class AsciiCaseInsensitiveCharEqualityComparator
    implements CharEqualityComparator {
        static final AsciiCaseInsensitiveCharEqualityComparator INSTANCE = new AsciiCaseInsensitiveCharEqualityComparator();

        private AsciiCaseInsensitiveCharEqualityComparator() {
        }

        @Override
        public boolean equals(char a, char b) {
            return AsciiString.equalsIgnoreCase(a, b);
        }
    }

    private static final class DefaultCharEqualityComparator
    implements CharEqualityComparator {
        static final DefaultCharEqualityComparator INSTANCE = new DefaultCharEqualityComparator();

        private DefaultCharEqualityComparator() {
        }

        @Override
        public boolean equals(char a, char b) {
            return a == b;
        }
    }

    private static interface CharEqualityComparator {
        public boolean equals(char var1, char var2);
    }
}

