/*
 * Decompiled with CFR 0.152.
 */
package io.netty.resolver;

import io.netty.resolver.HostsFileEntries;
import io.netty.resolver.HostsFileEntriesProvider;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.net.InetAddress;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public final class HostsFileParser {
    public static HostsFileEntries parseSilently() {
        return HostsFileParser.hostsFileEntries(HostsFileEntriesProvider.parser().parseSilently());
    }

    public static HostsFileEntries parseSilently(Charset ... charsets) {
        return HostsFileParser.hostsFileEntries(HostsFileEntriesProvider.parser().parseSilently(charsets));
    }

    public static HostsFileEntries parse() throws IOException {
        return HostsFileParser.hostsFileEntries(HostsFileEntriesProvider.parser().parse());
    }

    public static HostsFileEntries parse(File file2) throws IOException {
        return HostsFileParser.hostsFileEntries(HostsFileEntriesProvider.parser().parse(file2, new Charset[0]));
    }

    public static HostsFileEntries parse(File file2, Charset ... charsets) throws IOException {
        return HostsFileParser.hostsFileEntries(HostsFileEntriesProvider.parser().parse(file2, charsets));
    }

    public static HostsFileEntries parse(Reader reader2) throws IOException {
        return HostsFileParser.hostsFileEntries(HostsFileEntriesProvider.parser().parse(reader2));
    }

    private HostsFileParser() {
    }

    private static HostsFileEntries hostsFileEntries(HostsFileEntriesProvider provider2) {
        return provider2 == HostsFileEntriesProvider.EMPTY ? HostsFileEntries.EMPTY : new HostsFileEntries(HostsFileParser.toMapWithSingleValue(provider2.ipv4Entries()), HostsFileParser.toMapWithSingleValue(provider2.ipv6Entries()));
    }

    private static Map<String, ?> toMapWithSingleValue(Map<String, List<InetAddress>> fromMapWithListValue) {
        HashMap<String, InetAddress> result2 = new HashMap<String, InetAddress>();
        for (Map.Entry<String, List<InetAddress>> entry : fromMapWithListValue.entrySet()) {
            List<InetAddress> value = entry.getValue();
            if (value.isEmpty()) continue;
            result2.put(entry.getKey(), value.get(0));
        }
        return result2;
    }
}

