/*
 * Decompiled with CFR 0.152.
 */
package io.netty.buffer;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.ReadOnlyByteBufferBuf;
import io.netty.buffer.UnsafeByteBufUtil;
import io.netty.util.internal.ObjectUtil;
import io.netty.util.internal.PlatformDependent;
import java.nio.ByteBuffer;

final class ReadOnlyUnsafeDirectByteBuf
extends ReadOnlyByteBufferBuf {
    private final long memoryAddress;

    ReadOnlyUnsafeDirectByteBuf(ByteBufAllocator allocator, ByteBuffer byteBuffer) {
        super(allocator, byteBuffer);
        this.memoryAddress = PlatformDependent.directBufferAddress(this.buffer);
    }

    @Override
    protected byte _getByte(int index2) {
        return UnsafeByteBufUtil.getByte(this.addr(index2));
    }

    @Override
    protected short _getShort(int index2) {
        return UnsafeByteBufUtil.getShort(this.addr(index2));
    }

    @Override
    protected int _getUnsignedMedium(int index2) {
        return UnsafeByteBufUtil.getUnsignedMedium(this.addr(index2));
    }

    @Override
    protected int _getInt(int index2) {
        return UnsafeByteBufUtil.getInt(this.addr(index2));
    }

    @Override
    protected long _getLong(int index2) {
        return UnsafeByteBufUtil.getLong(this.addr(index2));
    }

    @Override
    public ByteBuf getBytes(int index2, ByteBuf dst, int dstIndex, int length) {
        this.checkIndex(index2, length);
        ObjectUtil.checkNotNull(dst, "dst");
        if (dstIndex < 0 || dstIndex > dst.capacity() - length) {
            throw new IndexOutOfBoundsException("dstIndex: " + dstIndex);
        }
        if (dst.hasMemoryAddress()) {
            PlatformDependent.copyMemory(this.addr(index2), dst.memoryAddress() + (long)dstIndex, length);
        } else if (dst.hasArray()) {
            PlatformDependent.copyMemory(this.addr(index2), dst.array(), dst.arrayOffset() + dstIndex, (long)length);
        } else {
            dst.setBytes(dstIndex, this, index2, length);
        }
        return this;
    }

    @Override
    public ByteBuf getBytes(int index2, byte[] dst, int dstIndex, int length) {
        this.checkIndex(index2, length);
        ObjectUtil.checkNotNull(dst, "dst");
        if (dstIndex < 0 || dstIndex > dst.length - length) {
            throw new IndexOutOfBoundsException(String.format("dstIndex: %d, length: %d (expected: range(0, %d))", dstIndex, length, dst.length));
        }
        if (length != 0) {
            PlatformDependent.copyMemory(this.addr(index2), dst, dstIndex, (long)length);
        }
        return this;
    }

    @Override
    public ByteBuf copy(int index2, int length) {
        this.checkIndex(index2, length);
        ByteBuf copy2 = this.alloc().directBuffer(length, this.maxCapacity());
        if (length != 0) {
            if (copy2.hasMemoryAddress()) {
                PlatformDependent.copyMemory(this.addr(index2), copy2.memoryAddress(), length);
                copy2.setIndex(0, length);
            } else {
                copy2.writeBytes(this, index2, length);
            }
        }
        return copy2;
    }

    @Override
    public boolean hasMemoryAddress() {
        return true;
    }

    @Override
    public long memoryAddress() {
        return this.memoryAddress;
    }

    private long addr(int index2) {
        return this.memoryAddress + (long)index2;
    }
}

