/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect;

import com.google.common.annotations.GwtCompatible;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.collect.AbstractMultimap;
import com.google.common.collect.Collections2;
import com.google.common.collect.FilteredMultimap;
import com.google.common.collect.FilteredMultimapValues;
import com.google.common.collect.ForwardingCollection;
import com.google.common.collect.ForwardingList;
import com.google.common.collect.ForwardingSet;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multiset;
import com.google.common.collect.Multisets;
import com.google.common.collect.SetMultimap;
import com.google.common.collect.Sets;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.checkerframework.checker.nullness.qual.Nullable;

@GwtCompatible
class FilteredKeyMultimap<K, V>
extends AbstractMultimap<K, V>
implements FilteredMultimap<K, V> {
    final Multimap<K, V> unfiltered;
    final Predicate<? super K> keyPredicate;

    FilteredKeyMultimap(Multimap<K, V> unfiltered, Predicate<? super K> keyPredicate) {
        this.unfiltered = Preconditions.checkNotNull(unfiltered);
        this.keyPredicate = Preconditions.checkNotNull(keyPredicate);
    }

    @Override
    public Multimap<K, V> unfiltered() {
        return this.unfiltered;
    }

    @Override
    public Predicate<? super Map.Entry<K, V>> entryPredicate() {
        return Maps.keyPredicateOnEntries(this.keyPredicate);
    }

    @Override
    public int size() {
        int size = 0;
        for (Collection collection2 : this.asMap().values()) {
            size += collection2.size();
        }
        return size;
    }

    @Override
    public boolean containsKey(@Nullable Object key2) {
        if (this.unfiltered.containsKey(key2)) {
            Object k = key2;
            return this.keyPredicate.apply(k);
        }
        return false;
    }

    @Override
    public Collection<V> removeAll(Object key2) {
        return this.containsKey(key2) ? this.unfiltered.removeAll(key2) : this.unmodifiableEmptyCollection();
    }

    Collection<V> unmodifiableEmptyCollection() {
        if (this.unfiltered instanceof SetMultimap) {
            return ImmutableSet.of();
        }
        return ImmutableList.of();
    }

    @Override
    public void clear() {
        this.keySet().clear();
    }

    @Override
    Set<K> createKeySet() {
        return Sets.filter(this.unfiltered.keySet(), this.keyPredicate);
    }

    @Override
    public Collection<V> get(K key2) {
        if (this.keyPredicate.apply(key2)) {
            return this.unfiltered.get(key2);
        }
        if (this.unfiltered instanceof SetMultimap) {
            return new AddRejectingSet(key2);
        }
        return new AddRejectingList(key2);
    }

    @Override
    Iterator<Map.Entry<K, V>> entryIterator() {
        throw new AssertionError((Object)"should never be called");
    }

    @Override
    Collection<Map.Entry<K, V>> createEntries() {
        return new Entries();
    }

    @Override
    Collection<V> createValues() {
        return new FilteredMultimapValues(this);
    }

    @Override
    Map<K, Collection<V>> createAsMap() {
        return Maps.filterKeys(this.unfiltered.asMap(), this.keyPredicate);
    }

    @Override
    Multiset<K> createKeys() {
        return Multisets.filter(this.unfiltered.keys(), this.keyPredicate);
    }

    class Entries
    extends ForwardingCollection<Map.Entry<K, V>> {
        Entries() {
        }

        @Override
        protected Collection<Map.Entry<K, V>> delegate() {
            return Collections2.filter(FilteredKeyMultimap.this.unfiltered.entries(), FilteredKeyMultimap.this.entryPredicate());
        }

        @Override
        public boolean remove(@Nullable Object o) {
            Map.Entry entry;
            if (o instanceof Map.Entry && FilteredKeyMultimap.this.unfiltered.containsKey((entry = (Map.Entry)o).getKey()) && FilteredKeyMultimap.this.keyPredicate.apply(entry.getKey())) {
                return FilteredKeyMultimap.this.unfiltered.remove(entry.getKey(), entry.getValue());
            }
            return false;
        }
    }

    static class AddRejectingList<K, V>
    extends ForwardingList<V> {
        final K key;

        AddRejectingList(K key2) {
            this.key = key2;
        }

        @Override
        public boolean add(V v) {
            this.add(0, v);
            return true;
        }

        @Override
        public void add(int index2, V element) {
            Preconditions.checkPositionIndex(index2, 0);
            String string2 = String.valueOf(this.key);
            throw new IllegalArgumentException(new StringBuilder(32 + String.valueOf(string2).length()).append("Key does not satisfy predicate: ").append(string2).toString());
        }

        @Override
        public boolean addAll(Collection<? extends V> collection2) {
            this.addAll(0, collection2);
            return true;
        }

        @Override
        @CanIgnoreReturnValue
        public boolean addAll(int index2, Collection<? extends V> elements) {
            Preconditions.checkNotNull(elements);
            Preconditions.checkPositionIndex(index2, 0);
            String string2 = String.valueOf(this.key);
            throw new IllegalArgumentException(new StringBuilder(32 + String.valueOf(string2).length()).append("Key does not satisfy predicate: ").append(string2).toString());
        }

        @Override
        protected List<V> delegate() {
            return Collections.emptyList();
        }
    }

    static class AddRejectingSet<K, V>
    extends ForwardingSet<V> {
        final K key;

        AddRejectingSet(K key2) {
            this.key = key2;
        }

        @Override
        public boolean add(V element) {
            String string2 = String.valueOf(this.key);
            throw new IllegalArgumentException(new StringBuilder(32 + String.valueOf(string2).length()).append("Key does not satisfy predicate: ").append(string2).toString());
        }

        @Override
        public boolean addAll(Collection<? extends V> collection2) {
            Preconditions.checkNotNull(collection2);
            String string2 = String.valueOf(this.key);
            throw new IllegalArgumentException(new StringBuilder(32 + String.valueOf(string2).length()).append("Key does not satisfy predicate: ").append(string2).toString());
        }

        @Override
        protected Set<V> delegate() {
            return Collections.emptySet();
        }
    }
}

