/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect;

import com.google.common.annotations.GwtCompatible;
import com.google.common.collect.AbstractMapBasedMultimap;
import com.google.common.collect.AbstractSetMultimap;
import com.google.common.collect.Sets;
import com.google.common.collect.SortedSetMultimap;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.NavigableSet;
import java.util.SortedSet;
import org.checkerframework.checker.nullness.qual.Nullable;

@GwtCompatible
abstract class AbstractSortedSetMultimap<K, V>
extends AbstractSetMultimap<K, V>
implements SortedSetMultimap<K, V> {
    private static final long serialVersionUID = 430848587173315748L;

    protected AbstractSortedSetMultimap(Map<K, Collection<V>> map2) {
        super(map2);
    }

    @Override
    abstract SortedSet<V> createCollection();

    @Override
    SortedSet<V> createUnmodifiableEmptyCollection() {
        return this.unmodifiableCollectionSubclass((Collection)this.createCollection());
    }

    @Override
    <E> SortedSet<E> unmodifiableCollectionSubclass(Collection<E> collection2) {
        if (collection2 instanceof NavigableSet) {
            return Sets.unmodifiableNavigableSet((NavigableSet)collection2);
        }
        return Collections.unmodifiableSortedSet((SortedSet)collection2);
    }

    @Override
    Collection<V> wrapCollection(K key2, Collection<V> collection2) {
        if (collection2 instanceof NavigableSet) {
            return (AbstractMapBasedMultimap)this.new AbstractMapBasedMultimap.WrappedNavigableSet(key2, (NavigableSet)collection2, null);
        }
        return (AbstractMapBasedMultimap)this.new AbstractMapBasedMultimap.WrappedSortedSet(key2, (SortedSet)collection2, null);
    }

    @Override
    public SortedSet<V> get(@Nullable K key2) {
        return (SortedSet)super.get((Object)key2);
    }

    @Override
    @CanIgnoreReturnValue
    public SortedSet<V> removeAll(@Nullable Object key2) {
        return (SortedSet)super.removeAll(key2);
    }

    @Override
    @CanIgnoreReturnValue
    public SortedSet<V> replaceValues(@Nullable K key2, Iterable<? extends V> values2) {
        return (SortedSet)super.replaceValues((Object)key2, (Iterable)values2);
    }

    @Override
    public Map<K, Collection<V>> asMap() {
        return super.asMap();
    }

    @Override
    public Collection<V> values() {
        return super.values();
    }
}

