/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.base;

import com.google.common.annotations.GwtCompatible;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Platform;
import com.google.common.base.Preconditions;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.checkerframework.checker.nullness.qual.Nullable;

@GwtCompatible
public final class Strings {
    private Strings() {
    }

    public static String nullToEmpty(@Nullable String string2) {
        return Platform.nullToEmpty(string2);
    }

    public static @Nullable String emptyToNull(@Nullable String string2) {
        return Platform.emptyToNull(string2);
    }

    public static boolean isNullOrEmpty(@Nullable String string2) {
        return Platform.stringIsNullOrEmpty(string2);
    }

    public static String padStart(String string2, int minLength, char padChar) {
        Preconditions.checkNotNull(string2);
        if (string2.length() >= minLength) {
            return string2;
        }
        StringBuilder sb = new StringBuilder(minLength);
        for (int i = string2.length(); i < minLength; ++i) {
            sb.append(padChar);
        }
        sb.append(string2);
        return sb.toString();
    }

    public static String padEnd(String string2, int minLength, char padChar) {
        Preconditions.checkNotNull(string2);
        if (string2.length() >= minLength) {
            return string2;
        }
        StringBuilder sb = new StringBuilder(minLength);
        sb.append(string2);
        for (int i = string2.length(); i < minLength; ++i) {
            sb.append(padChar);
        }
        return sb.toString();
    }

    public static String repeat(String string2, int count2) {
        int n;
        Preconditions.checkNotNull(string2);
        if (count2 <= 1) {
            Preconditions.checkArgument(count2 >= 0, "invalid count: %s", count2);
            return count2 == 0 ? "" : string2;
        }
        int len = string2.length();
        long longSize = (long)len * (long)count2;
        int size = (int)longSize;
        if ((long)size != longSize) {
            throw new ArrayIndexOutOfBoundsException(new StringBuilder(51).append("Required array size too large: ").append(longSize).toString());
        }
        char[] array2 = new char[size];
        string2.getChars(0, len, array2, 0);
        for (n = len; n < size - n; n <<= 1) {
            System.arraycopy(array2, 0, array2, n, n);
        }
        System.arraycopy(array2, 0, array2, n, size - n);
        return new String(array2);
    }

    public static String commonPrefix(CharSequence a, CharSequence b) {
        int p;
        Preconditions.checkNotNull(a);
        Preconditions.checkNotNull(b);
        int maxPrefixLength = Math.min(a.length(), b.length());
        for (p = 0; p < maxPrefixLength && a.charAt(p) == b.charAt(p); ++p) {
        }
        if (Strings.validSurrogatePairAt(a, p - 1) || Strings.validSurrogatePairAt(b, p - 1)) {
            --p;
        }
        return a.subSequence(0, p).toString();
    }

    public static String commonSuffix(CharSequence a, CharSequence b) {
        int s2;
        Preconditions.checkNotNull(a);
        Preconditions.checkNotNull(b);
        int maxSuffixLength = Math.min(a.length(), b.length());
        for (s2 = 0; s2 < maxSuffixLength && a.charAt(a.length() - s2 - 1) == b.charAt(b.length() - s2 - 1); ++s2) {
        }
        if (Strings.validSurrogatePairAt(a, a.length() - s2 - 1) || Strings.validSurrogatePairAt(b, b.length() - s2 - 1)) {
            --s2;
        }
        return a.subSequence(a.length() - s2, a.length()).toString();
    }

    @VisibleForTesting
    static boolean validSurrogatePairAt(CharSequence string2, int index2) {
        return index2 >= 0 && index2 <= string2.length() - 2 && Character.isHighSurrogate(string2.charAt(index2)) && Character.isLowSurrogate(string2.charAt(index2 + 1));
    }

    public static String lenientFormat(@Nullable String template2, Object ... args2) {
        int placeholderStart;
        template2 = String.valueOf(template2);
        if (args2 == null) {
            args2 = new Object[]{"(Object[])null"};
        } else {
            for (int i = 0; i < args2.length; ++i) {
                args2[i] = Strings.lenientToString(args2[i]);
            }
        }
        StringBuilder builder = new StringBuilder(template2.length() + 16 * args2.length);
        int templateStart = 0;
        int i = 0;
        while (i < args2.length && (placeholderStart = template2.indexOf("%s", templateStart)) != -1) {
            builder.append(template2, templateStart, placeholderStart);
            builder.append(args2[i++]);
            templateStart = placeholderStart + 2;
        }
        builder.append(template2, templateStart, template2.length());
        if (i < args2.length) {
            builder.append(" [");
            builder.append(args2[i++]);
            while (i < args2.length) {
                builder.append(", ");
                builder.append(args2[i++]);
            }
            builder.append(']');
        }
        return builder.toString();
    }

    private static String lenientToString(@Nullable Object o) {
        if (o == null) {
            return "null";
        }
        try {
            return o.toString();
        }
        catch (Exception e2) {
            String string2 = o.getClass().getName();
            String string3 = Integer.toHexString(System.identityHashCode(o));
            String objectToString = new StringBuilder(1 + String.valueOf(string2).length() + String.valueOf(string3).length()).append(string2).append('@').append(string3).toString();
            String string4 = String.valueOf(objectToString);
            Logger.getLogger("com.google.common.base.Strings").log(Level.WARNING, string4.length() != 0 ? "Exception during lenientFormat for ".concat(string4) : new String("Exception during lenientFormat for "), e2);
            string2 = e2.getClass().getName();
            return new StringBuilder(9 + String.valueOf(objectToString).length() + String.valueOf(string2).length()).append("<").append(objectToString).append(" threw ").append(string2).append(">").toString();
        }
    }
}

