/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.datatype.jsr310.deser;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.datatype.jsr310.deser.JSR310DateTimeDeserializerBase;
import java.io.IOException;
import java.time.DateTimeException;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;

public class LocalDateTimeDeserializer
extends JSR310DateTimeDeserializerBase<LocalDateTime> {
    private static final long serialVersionUID = 1L;
    private static final DateTimeFormatter DEFAULT_FORMATTER = DateTimeFormatter.ISO_LOCAL_DATE_TIME;
    public static final LocalDateTimeDeserializer INSTANCE = new LocalDateTimeDeserializer();

    protected LocalDateTimeDeserializer() {
        this(DEFAULT_FORMATTER);
    }

    public LocalDateTimeDeserializer(DateTimeFormatter formatter2) {
        super(LocalDateTime.class, formatter2);
    }

    protected LocalDateTimeDeserializer(LocalDateTimeDeserializer base, Boolean leniency) {
        super(base, leniency);
    }

    protected LocalDateTimeDeserializer withDateFormat(DateTimeFormatter formatter2) {
        return new LocalDateTimeDeserializer(formatter2);
    }

    @Override
    protected LocalDateTimeDeserializer withLeniency(Boolean leniency) {
        return new LocalDateTimeDeserializer(this, leniency);
    }

    protected LocalDateTimeDeserializer withShape(JsonFormat.Shape shape) {
        return this;
    }

    @Override
    public LocalDateTime deserialize(JsonParser parser, DeserializationContext context) throws IOException {
        if (parser.hasTokenId(6)) {
            return this._fromString(parser, context, parser.getText());
        }
        if (parser.isExpectedStartObjectToken()) {
            return this._fromString(parser, context, context.extractScalarFromObject(parser, this, this.handledType()));
        }
        if (parser.isExpectedStartArrayToken()) {
            JsonToken t3 = parser.nextToken();
            if (t3 == JsonToken.END_ARRAY) {
                return null;
            }
            if ((t3 == JsonToken.VALUE_STRING || t3 == JsonToken.VALUE_EMBEDDED_OBJECT) && context.isEnabled(DeserializationFeature.UNWRAP_SINGLE_VALUE_ARRAYS)) {
                LocalDateTime parsed = this.deserialize(parser, context);
                if (parser.nextToken() != JsonToken.END_ARRAY) {
                    this.handleMissingEndArrayForSingle(parser, context);
                }
                return parsed;
            }
            if (t3 == JsonToken.VALUE_NUMBER_INT) {
                LocalDateTime result2;
                int year2 = parser.getIntValue();
                int month2 = parser.nextIntValue(-1);
                int day2 = parser.nextIntValue(-1);
                int hour2 = parser.nextIntValue(-1);
                int minute2 = parser.nextIntValue(-1);
                t3 = parser.nextToken();
                if (t3 == JsonToken.END_ARRAY) {
                    result2 = LocalDateTime.of(year2, month2, day2, hour2, minute2);
                } else {
                    int second2 = parser.getIntValue();
                    t3 = parser.nextToken();
                    if (t3 == JsonToken.END_ARRAY) {
                        result2 = LocalDateTime.of(year2, month2, day2, hour2, minute2, second2);
                    } else {
                        int partialSecond = parser.getIntValue();
                        if (partialSecond < 1000 && !context.isEnabled(DeserializationFeature.READ_DATE_TIMESTAMPS_AS_NANOSECONDS)) {
                            partialSecond *= 1000000;
                        }
                        if (parser.nextToken() != JsonToken.END_ARRAY) {
                            throw context.wrongTokenException(parser, this.handledType(), JsonToken.END_ARRAY, "Expected array to end");
                        }
                        result2 = LocalDateTime.of(year2, month2, day2, hour2, minute2, second2, partialSecond);
                    }
                }
                return result2;
            }
            context.reportInputMismatch(this.handledType(), "Unexpected token (%s) within Array, expected VALUE_NUMBER_INT", new Object[]{t3});
        }
        if (parser.hasToken(JsonToken.VALUE_EMBEDDED_OBJECT)) {
            return (LocalDateTime)parser.getEmbeddedObject();
        }
        if (parser.hasToken(JsonToken.VALUE_NUMBER_INT)) {
            this._throwNoNumericTimestampNeedTimeZone(parser, context);
        }
        return (LocalDateTime)this._handleUnexpectedToken(context, parser, "Expected array or string.", new Object[0]);
    }

    protected LocalDateTime _fromString(JsonParser p, DeserializationContext ctxt, String string0) throws IOException {
        String string2 = string0.trim();
        if (string2.length() == 0) {
            return (LocalDateTime)this._fromEmptyString(p, ctxt, string2);
        }
        try {
            if (this._formatter == DEFAULT_FORMATTER && string2.length() > 10 && string2.charAt(10) == 'T' && string2.endsWith("Z")) {
                if (this.isLenient()) {
                    return LocalDateTime.parse(string2.substring(0, string2.length() - 1), this._formatter);
                }
                JavaType t3 = this.getValueType(ctxt);
                return (LocalDateTime)ctxt.handleWeirdStringValue(t3.getRawClass(), string2, "Should not contain offset when 'strict' mode set for property or type (enable 'lenient' handling to allow)", new Object[0]);
            }
            return LocalDateTime.parse(string2, this._formatter);
        }
        catch (DateTimeException e2) {
            return (LocalDateTime)this._handleDateTimeException(ctxt, e2, string2);
        }
    }
}

