/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.databind.util;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.PropertyName;
import com.fasterxml.jackson.databind.annotation.JacksonStdImpl;
import com.fasterxml.jackson.databind.annotation.NoClass;
import com.fasterxml.jackson.databind.util.Named;
import java.io.Closeable;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public final class ClassUtil {
    private static final Class<?> CLS_OBJECT = Object.class;
    private static final Annotation[] NO_ANNOTATIONS = new Annotation[0];
    private static final Ctor[] NO_CTORS = new Ctor[0];
    private static final Iterator<?> EMPTY_ITERATOR = Collections.emptyIterator();

    public static <T> Iterator<T> emptyIterator() {
        return EMPTY_ITERATOR;
    }

    public static List<JavaType> findSuperTypes(JavaType type2, Class<?> endBefore, boolean addClassItself) {
        if (type2 == null || type2.hasRawClass(endBefore) || type2.hasRawClass(Object.class)) {
            return Collections.emptyList();
        }
        ArrayList<JavaType> result2 = new ArrayList<JavaType>(8);
        ClassUtil._addSuperTypes(type2, endBefore, result2, addClassItself);
        return result2;
    }

    public static List<Class<?>> findRawSuperTypes(Class<?> cls, Class<?> endBefore, boolean addClassItself) {
        if (cls == null || cls == endBefore || cls == Object.class) {
            return Collections.emptyList();
        }
        ArrayList result2 = new ArrayList(8);
        ClassUtil._addRawSuperTypes(cls, endBefore, result2, addClassItself);
        return result2;
    }

    public static List<Class<?>> findSuperClasses(Class<?> cls, Class<?> endBefore, boolean addClassItself) {
        ArrayList result2 = new ArrayList(8);
        if (cls != null && cls != endBefore) {
            if (addClassItself) {
                result2.add(cls);
            }
            while ((cls = cls.getSuperclass()) != null && cls != endBefore) {
                result2.add(cls);
            }
        }
        return result2;
    }

    @Deprecated
    public static List<Class<?>> findSuperTypes(Class<?> cls, Class<?> endBefore) {
        return ClassUtil.findSuperTypes(cls, endBefore, new ArrayList(8));
    }

    @Deprecated
    public static List<Class<?>> findSuperTypes(Class<?> cls, Class<?> endBefore, List<Class<?>> result2) {
        ClassUtil._addRawSuperTypes(cls, endBefore, result2, false);
        return result2;
    }

    private static void _addSuperTypes(JavaType type2, Class<?> endBefore, Collection<JavaType> result2, boolean addClassItself) {
        if (type2 == null) {
            return;
        }
        Class<?> cls = type2.getRawClass();
        if (cls == endBefore || cls == Object.class) {
            return;
        }
        if (addClassItself) {
            if (result2.contains(type2)) {
                return;
            }
            result2.add(type2);
        }
        for (JavaType intCls : type2.getInterfaces()) {
            ClassUtil._addSuperTypes(intCls, endBefore, result2, true);
        }
        ClassUtil._addSuperTypes(type2.getSuperClass(), endBefore, result2, true);
    }

    private static void _addRawSuperTypes(Class<?> cls, Class<?> endBefore, Collection<Class<?>> result2, boolean addClassItself) {
        if (cls == endBefore || cls == null || cls == Object.class) {
            return;
        }
        if (addClassItself) {
            if (result2.contains(cls)) {
                return;
            }
            result2.add(cls);
        }
        for (Class<?> intCls : ClassUtil._interfaces(cls)) {
            ClassUtil._addRawSuperTypes(intCls, endBefore, result2, true);
        }
        ClassUtil._addRawSuperTypes(cls.getSuperclass(), endBefore, result2, true);
    }

    public static String canBeABeanType(Class<?> type2) {
        if (type2.isAnnotation()) {
            return "annotation";
        }
        if (type2.isArray()) {
            return "array";
        }
        if (Enum.class.isAssignableFrom(type2)) {
            return "enum";
        }
        if (type2.isPrimitive()) {
            return "primitive";
        }
        return null;
    }

    public static String isLocalType(Class<?> type2, boolean allowNonStatic) {
        try {
            boolean isStatic = Modifier.isStatic(type2.getModifiers());
            if (!isStatic && ClassUtil.hasEnclosingMethod(type2)) {
                return "local/anonymous";
            }
            if (!allowNonStatic && !isStatic && ClassUtil.getEnclosingClass(type2) != null) {
                return "non-static member class";
            }
        }
        catch (SecurityException securityException) {
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        return null;
    }

    public static Class<?> getOuterClass(Class<?> type2) {
        if (!Modifier.isStatic(type2.getModifiers())) {
            try {
                if (ClassUtil.hasEnclosingMethod(type2)) {
                    return null;
                }
                return ClassUtil.getEnclosingClass(type2);
            }
            catch (SecurityException securityException) {
                // empty catch block
            }
        }
        return null;
    }

    public static boolean isProxyType(Class<?> type2) {
        String name2 = type2.getName();
        return name2.startsWith("net.sf.cglib.proxy.") || name2.startsWith("org.hibernate.proxy.");
    }

    public static boolean isConcrete(Class<?> type2) {
        int mod2 = type2.getModifiers();
        return (mod2 & 0x600) == 0;
    }

    public static boolean isConcrete(Member member) {
        int mod2 = member.getModifiers();
        return (mod2 & 0x600) == 0;
    }

    public static boolean isCollectionMapOrArray(Class<?> type2) {
        if (type2.isArray()) {
            return true;
        }
        if (Collection.class.isAssignableFrom(type2)) {
            return true;
        }
        return Map.class.isAssignableFrom(type2);
    }

    public static boolean isBogusClass(Class<?> cls) {
        return cls == Void.class || cls == Void.TYPE || cls == NoClass.class;
    }

    public static boolean isRecordType(Class<?> cls) {
        Class<?> parent = cls.getSuperclass();
        return parent != null && "java.lang.Record".equals(parent.getName());
    }

    public static boolean isObjectOrPrimitive(Class<?> cls) {
        return cls == CLS_OBJECT || cls.isPrimitive();
    }

    public static boolean hasClass(Object inst, Class<?> raw) {
        return inst != null && inst.getClass() == raw;
    }

    public static void verifyMustOverride(Class<?> expType, Object instance, String method) {
        if (instance.getClass() != expType) {
            throw new IllegalStateException(String.format("Sub-class %s (of class %s) must override method '%s'", instance.getClass().getName(), expType.getName(), method));
        }
    }

    @Deprecated
    public static boolean hasGetterSignature(Method m3) {
        if (Modifier.isStatic(m3.getModifiers())) {
            return false;
        }
        Class<?>[] pts = m3.getParameterTypes();
        if (pts != null && pts.length != 0) {
            return false;
        }
        return Void.TYPE != m3.getReturnType();
    }

    public static Throwable throwIfError(Throwable t3) {
        if (t3 instanceof Error) {
            throw (Error)t3;
        }
        return t3;
    }

    public static Throwable throwIfRTE(Throwable t3) {
        if (t3 instanceof RuntimeException) {
            throw (RuntimeException)t3;
        }
        return t3;
    }

    public static Throwable throwIfIOE(Throwable t3) throws IOException {
        if (t3 instanceof IOException) {
            throw (IOException)t3;
        }
        return t3;
    }

    public static Throwable getRootCause(Throwable t3) {
        while (t3.getCause() != null) {
            t3 = t3.getCause();
        }
        return t3;
    }

    public static Throwable throwRootCauseIfIOE(Throwable t3) throws IOException {
        return ClassUtil.throwIfIOE(ClassUtil.getRootCause(t3));
    }

    public static void throwAsIAE(Throwable t3) {
        ClassUtil.throwAsIAE(t3, t3.getMessage());
    }

    public static void throwAsIAE(Throwable t3, String msg) {
        ClassUtil.throwIfRTE(t3);
        ClassUtil.throwIfError(t3);
        throw new IllegalArgumentException(msg, t3);
    }

    public static <T> T throwAsMappingException(DeserializationContext ctxt, IOException e0) throws JsonMappingException {
        if (e0 instanceof JsonMappingException) {
            throw (JsonMappingException)e0;
        }
        JsonMappingException e2 = JsonMappingException.from(ctxt, e0.getMessage());
        e2.initCause(e0);
        throw e2;
    }

    public static void unwrapAndThrowAsIAE(Throwable t3) {
        ClassUtil.throwAsIAE(ClassUtil.getRootCause(t3));
    }

    public static void unwrapAndThrowAsIAE(Throwable t3, String msg) {
        ClassUtil.throwAsIAE(ClassUtil.getRootCause(t3), msg);
    }

    public static void closeOnFailAndThrowAsIOE(JsonGenerator g2, Exception fail2) throws IOException {
        g2.disable(JsonGenerator.Feature.AUTO_CLOSE_JSON_CONTENT);
        try {
            g2.close();
        }
        catch (Exception e2) {
            fail2.addSuppressed(e2);
        }
        ClassUtil.throwIfIOE(fail2);
        ClassUtil.throwIfRTE(fail2);
        throw new RuntimeException(fail2);
    }

    public static void closeOnFailAndThrowAsIOE(JsonGenerator g2, Closeable toClose, Exception fail2) throws IOException {
        if (g2 != null) {
            g2.disable(JsonGenerator.Feature.AUTO_CLOSE_JSON_CONTENT);
            try {
                g2.close();
            }
            catch (Exception e2) {
                fail2.addSuppressed(e2);
            }
        }
        if (toClose != null) {
            try {
                toClose.close();
            }
            catch (Exception e3) {
                fail2.addSuppressed(e3);
            }
        }
        ClassUtil.throwIfIOE(fail2);
        ClassUtil.throwIfRTE(fail2);
        throw new RuntimeException(fail2);
    }

    public static <T> T createInstance(Class<T> cls, boolean canFixAccess) throws IllegalArgumentException {
        Constructor<T> ctor = ClassUtil.findConstructor(cls, canFixAccess);
        if (ctor == null) {
            throw new IllegalArgumentException("Class " + cls.getName() + " has no default (no arg) constructor");
        }
        try {
            return ctor.newInstance(new Object[0]);
        }
        catch (Exception e2) {
            ClassUtil.unwrapAndThrowAsIAE(e2, "Failed to instantiate class " + cls.getName() + ", problem: " + e2.getMessage());
            return null;
        }
    }

    public static <T> Constructor<T> findConstructor(Class<T> cls, boolean forceAccess) throws IllegalArgumentException {
        try {
            Constructor<T> ctor = cls.getDeclaredConstructor(new Class[0]);
            if (forceAccess) {
                ClassUtil.checkAndFixAccess(ctor, forceAccess);
            } else if (!Modifier.isPublic(ctor.getModifiers())) {
                throw new IllegalArgumentException("Default constructor for " + cls.getName() + " is not accessible (non-public?): not allowed to try modify access via Reflection: cannot instantiate type");
            }
            return ctor;
        }
        catch (NoSuchMethodException ctor) {
        }
        catch (Exception e2) {
            ClassUtil.unwrapAndThrowAsIAE(e2, "Failed to find default constructor of class " + cls.getName() + ", problem: " + e2.getMessage());
        }
        return null;
    }

    public static Class<?> classOf(Object inst) {
        if (inst == null) {
            return null;
        }
        return inst.getClass();
    }

    public static Class<?> rawClass(JavaType t3) {
        if (t3 == null) {
            return null;
        }
        return t3.getRawClass();
    }

    public static <T> T nonNull(T valueOrNull, T defaultValue) {
        return valueOrNull == null ? defaultValue : valueOrNull;
    }

    public static String nullOrToString(Object value) {
        if (value == null) {
            return null;
        }
        return value.toString();
    }

    public static String nonNullString(String str2) {
        if (str2 == null) {
            return "";
        }
        return str2;
    }

    public static String quotedOr(Object str2, String forNull) {
        if (str2 == null) {
            return forNull;
        }
        return String.format("\"%s\"", str2);
    }

    public static String getClassDescription(Object classOrInstance) {
        if (classOrInstance == null) {
            return "unknown";
        }
        Class<?> cls = classOrInstance instanceof Class ? (Class<?>)classOrInstance : classOrInstance.getClass();
        return ClassUtil.nameOf(cls);
    }

    public static String getTypeDescription(JavaType fullType) {
        if (fullType == null) {
            return "[null]";
        }
        StringBuilder sb = new StringBuilder(80).append('`');
        sb.append(fullType.toCanonical());
        return sb.append('`').toString();
    }

    public static String classNameOf(Object inst) {
        if (inst == null) {
            return "[null]";
        }
        Class<?> raw = inst instanceof Class ? (Class<?>)inst : inst.getClass();
        return ClassUtil.nameOf(raw);
    }

    public static String nameOf(Class<?> cls) {
        String base;
        if (cls == null) {
            return "[null]";
        }
        int index2 = 0;
        while (cls.isArray()) {
            ++index2;
            cls = cls.getComponentType();
        }
        String string2 = base = cls.isPrimitive() ? cls.getSimpleName() : cls.getName();
        if (index2 > 0) {
            StringBuilder sb = new StringBuilder(base);
            do {
                sb.append("[]");
            } while (--index2 > 0);
            base = sb.toString();
        }
        return ClassUtil.backticked(base);
    }

    public static String nameOf(Named named2) {
        if (named2 == null) {
            return "[null]";
        }
        return ClassUtil.apostrophed(named2.getName());
    }

    public static String name(String name2) {
        if (name2 == null) {
            return "[null]";
        }
        return ClassUtil.apostrophed(name2);
    }

    public static String name(PropertyName name2) {
        if (name2 == null) {
            return "[null]";
        }
        return ClassUtil.apostrophed(name2.getSimpleName());
    }

    public static String backticked(String text) {
        if (text == null) {
            return "[null]";
        }
        return new StringBuilder(text.length() + 2).append('`').append(text).append('`').toString();
    }

    public static String apostrophed(String text) {
        if (text == null) {
            return "[null]";
        }
        return new StringBuilder(text.length() + 2).append('\'').append(text).append('\'').toString();
    }

    public static String exceptionMessage(Throwable t3) {
        if (t3 instanceof JsonProcessingException) {
            return ((JsonProcessingException)t3).getOriginalMessage();
        }
        return t3.getMessage();
    }

    public static Object defaultValue(Class<?> cls) {
        if (cls == Integer.TYPE) {
            return 0;
        }
        if (cls == Long.TYPE) {
            return 0L;
        }
        if (cls == Boolean.TYPE) {
            return Boolean.FALSE;
        }
        if (cls == Double.TYPE) {
            return 0.0;
        }
        if (cls == Float.TYPE) {
            return Float.valueOf(0.0f);
        }
        if (cls == Byte.TYPE) {
            return (byte)0;
        }
        if (cls == Short.TYPE) {
            return (short)0;
        }
        if (cls == Character.TYPE) {
            return Character.valueOf('\u0000');
        }
        throw new IllegalArgumentException("Class " + cls.getName() + " is not a primitive type");
    }

    public static Class<?> wrapperType(Class<?> primitiveType) {
        if (primitiveType == Integer.TYPE) {
            return Integer.class;
        }
        if (primitiveType == Long.TYPE) {
            return Long.class;
        }
        if (primitiveType == Boolean.TYPE) {
            return Boolean.class;
        }
        if (primitiveType == Double.TYPE) {
            return Double.class;
        }
        if (primitiveType == Float.TYPE) {
            return Float.class;
        }
        if (primitiveType == Byte.TYPE) {
            return Byte.class;
        }
        if (primitiveType == Short.TYPE) {
            return Short.class;
        }
        if (primitiveType == Character.TYPE) {
            return Character.class;
        }
        throw new IllegalArgumentException("Class " + primitiveType.getName() + " is not a primitive type");
    }

    public static Class<?> primitiveType(Class<?> type2) {
        if (type2.isPrimitive()) {
            return type2;
        }
        if (type2 == Integer.class) {
            return Integer.TYPE;
        }
        if (type2 == Long.class) {
            return Long.TYPE;
        }
        if (type2 == Boolean.class) {
            return Boolean.TYPE;
        }
        if (type2 == Double.class) {
            return Double.TYPE;
        }
        if (type2 == Float.class) {
            return Float.TYPE;
        }
        if (type2 == Byte.class) {
            return Byte.TYPE;
        }
        if (type2 == Short.class) {
            return Short.TYPE;
        }
        if (type2 == Character.class) {
            return Character.TYPE;
        }
        return null;
    }

    @Deprecated
    public static void checkAndFixAccess(Member member) {
        ClassUtil.checkAndFixAccess(member, false);
    }

    public static void checkAndFixAccess(Member member, boolean force2) {
        block3: {
            AccessibleObject ao = (AccessibleObject)((Object)member);
            try {
                if (force2 || !Modifier.isPublic(member.getModifiers()) || !Modifier.isPublic(member.getDeclaringClass().getModifiers())) {
                    ao.setAccessible(true);
                }
            }
            catch (SecurityException se) {
                if (ao.isAccessible()) break block3;
                Class<?> declClass = member.getDeclaringClass();
                throw new IllegalArgumentException("Cannot access " + member + " (from class " + declClass.getName() + "; failed to set access: " + se.getMessage());
            }
        }
    }

    public static boolean isEnumType(Class<?> rawType) {
        return Enum.class.isAssignableFrom(rawType);
    }

    public static Class<? extends Enum<?>> findEnumType(EnumSet<?> s2) {
        if (!s2.isEmpty()) {
            return ClassUtil.findEnumType((Enum)s2.iterator().next());
        }
        return EnumTypeLocator.instance.enumTypeFor(s2);
    }

    public static Class<? extends Enum<?>> findEnumType(EnumMap<?, ?> m3) {
        if (!m3.isEmpty()) {
            return ClassUtil.findEnumType((Enum)m3.keySet().iterator().next());
        }
        return EnumTypeLocator.instance.enumTypeFor(m3);
    }

    public static Class<? extends Enum<?>> findEnumType(Enum<?> en) {
        return en.getDeclaringClass();
    }

    public static Class<? extends Enum<?>> findEnumType(Class<?> cls) {
        if (cls.getSuperclass() != Enum.class) {
            cls = cls.getSuperclass();
        }
        return cls;
    }

    public static <T extends Annotation> Enum<?> findFirstAnnotatedEnumValue(Class<Enum<?>> enumClass, Class<T> annotationClass) {
        Field[] fields2;
        for (Field field : fields2 = enumClass.getDeclaredFields()) {
            T defaultValueAnnotation;
            if (!field.isEnumConstant() || (defaultValueAnnotation = field.getAnnotation(annotationClass)) == null) continue;
            String name2 = field.getName();
            for (Enum<?> enumValue : enumClass.getEnumConstants()) {
                if (!name2.equals(enumValue.name())) continue;
                return enumValue;
            }
        }
        return null;
    }

    public static boolean isJacksonStdImpl(Object impl2) {
        return impl2 == null || ClassUtil.isJacksonStdImpl(impl2.getClass());
    }

    public static boolean isJacksonStdImpl(Class<?> implClass) {
        return implClass.getAnnotation(JacksonStdImpl.class) != null;
    }

    public static boolean isJDKClass(Class<?> rawType) {
        String clsName = rawType.getName();
        return clsName.startsWith("java.") || clsName.startsWith("javax.");
    }

    public static boolean isNonStaticInnerClass(Class<?> cls) {
        return !Modifier.isStatic(cls.getModifiers()) && ClassUtil.getEnclosingClass(cls) != null;
    }

    @Deprecated
    public static String getPackageName(Class<?> cls) {
        Package pkg = cls.getPackage();
        return pkg == null ? null : pkg.getName();
    }

    public static boolean hasEnclosingMethod(Class<?> cls) {
        return !ClassUtil.isObjectOrPrimitive(cls) && cls.getEnclosingMethod() != null;
    }

    @Deprecated
    public static Field[] getDeclaredFields(Class<?> cls) {
        return cls.getDeclaredFields();
    }

    @Deprecated
    public static Method[] getDeclaredMethods(Class<?> cls) {
        return cls.getDeclaredMethods();
    }

    public static Annotation[] findClassAnnotations(Class<?> cls) {
        if (ClassUtil.isObjectOrPrimitive(cls)) {
            return NO_ANNOTATIONS;
        }
        return cls.getDeclaredAnnotations();
    }

    public static Method[] getClassMethods(Class<?> cls) {
        try {
            return cls.getDeclaredMethods();
        }
        catch (NoClassDefFoundError ex) {
            Class<?> contextClass;
            ClassLoader loader = Thread.currentThread().getContextClassLoader();
            if (loader == null) {
                return ClassUtil._failGetClassMethods(cls, ex);
            }
            try {
                contextClass = loader.loadClass(cls.getName());
            }
            catch (ClassNotFoundException e2) {
                ex.addSuppressed(e2);
                return ClassUtil._failGetClassMethods(cls, ex);
            }
            try {
                return contextClass.getDeclaredMethods();
            }
            catch (Throwable t3) {
                return ClassUtil._failGetClassMethods(cls, t3);
            }
        }
        catch (Throwable t4) {
            return ClassUtil._failGetClassMethods(cls, t4);
        }
    }

    private static Method[] _failGetClassMethods(Class<?> cls, Throwable rootCause) throws IllegalArgumentException {
        throw new IllegalArgumentException(String.format("Failed on call to `getDeclaredMethods()` on class `%s`, problem: (%s) %s", cls.getName(), rootCause.getClass().getName(), rootCause.getMessage()), rootCause);
    }

    public static Ctor[] getConstructors(Class<?> cls) {
        if (cls.isInterface() || ClassUtil.isObjectOrPrimitive(cls)) {
            return NO_CTORS;
        }
        Constructor<?>[] rawCtors = cls.getDeclaredConstructors();
        int len = rawCtors.length;
        Ctor[] result2 = new Ctor[len];
        for (int i = 0; i < len; ++i) {
            result2[i] = new Ctor(rawCtors[i]);
        }
        return result2;
    }

    public static Class<?> getDeclaringClass(Class<?> cls) {
        return ClassUtil.isObjectOrPrimitive(cls) ? null : cls.getDeclaringClass();
    }

    public static Type getGenericSuperclass(Class<?> cls) {
        return cls.getGenericSuperclass();
    }

    public static Type[] getGenericInterfaces(Class<?> cls) {
        return cls.getGenericInterfaces();
    }

    public static Class<?> getEnclosingClass(Class<?> cls) {
        return ClassUtil.isObjectOrPrimitive(cls) ? null : cls.getEnclosingClass();
    }

    private static Class<?>[] _interfaces(Class<?> cls) {
        return cls.getInterfaces();
    }

    public static final class Ctor {
        public final Constructor<?> _ctor;
        private transient Annotation[] _annotations;
        private transient Annotation[][] _paramAnnotations;
        private int _paramCount = -1;

        public Ctor(Constructor<?> ctor) {
            this._ctor = ctor;
        }

        public Constructor<?> getConstructor() {
            return this._ctor;
        }

        public int getParamCount() {
            int c = this._paramCount;
            if (c < 0) {
                this._paramCount = c = this._ctor.getParameterTypes().length;
            }
            return c;
        }

        public Class<?> getDeclaringClass() {
            return this._ctor.getDeclaringClass();
        }

        public Annotation[] getDeclaredAnnotations() {
            Annotation[] result2 = this._annotations;
            if (result2 == null) {
                result2 = this._ctor.getDeclaredAnnotations();
                this._annotations = result2;
            }
            return result2;
        }

        public Annotation[][] getParameterAnnotations() {
            Annotation[][] result2 = this._paramAnnotations;
            if (result2 == null) {
                result2 = this._ctor.getParameterAnnotations();
                this._paramAnnotations = result2;
            }
            return result2;
        }
    }

    private static class EnumTypeLocator {
        static final EnumTypeLocator instance = new EnumTypeLocator();
        private final Field enumSetTypeField = EnumTypeLocator.locateField(EnumSet.class, "elementType", Class.class);
        private final Field enumMapTypeField = EnumTypeLocator.locateField(EnumMap.class, "elementType", Class.class);

        private EnumTypeLocator() {
        }

        public Class<? extends Enum<?>> enumTypeFor(EnumSet<?> set2) {
            if (this.enumSetTypeField != null) {
                return (Class)this.get(set2, this.enumSetTypeField);
            }
            throw new IllegalStateException("Cannot figure out type for EnumSet (odd JDK platform?)");
        }

        public Class<? extends Enum<?>> enumTypeFor(EnumMap<?, ?> set2) {
            if (this.enumMapTypeField != null) {
                return (Class)this.get(set2, this.enumMapTypeField);
            }
            throw new IllegalStateException("Cannot figure out type for EnumMap (odd JDK platform?)");
        }

        private Object get(Object bean2, Field field) {
            try {
                return field.get(bean2);
            }
            catch (Exception e2) {
                throw new IllegalArgumentException(e2);
            }
        }

        private static Field locateField(Class<?> fromClass, String expectedName, Class<?> type2) {
            Field[] fields2;
            Field found = null;
            for (Field f : fields2 = fromClass.getDeclaredFields()) {
                if (!expectedName.equals(f.getName()) || f.getType() != type2) continue;
                found = f;
                break;
            }
            if (found == null) {
                for (Field f : fields2) {
                    if (f.getType() != type2) continue;
                    if (found != null) {
                        return null;
                    }
                    found = f;
                }
            }
            if (found != null) {
                try {
                    found.setAccessible(true);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            return found;
        }
    }
}

