/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.databind.node;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonPointer;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.core.type.WritableTypeId;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.jsontype.TypeSerializer;
import com.fasterxml.jackson.databind.node.BaseJsonNode;
import com.fasterxml.jackson.databind.node.ContainerNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.JsonNodeType;
import com.fasterxml.jackson.databind.node.MissingNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.util.RawValue;
import java.io.IOException;
import java.io.Serializable;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;

public class ArrayNode
extends ContainerNode<ArrayNode>
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final List<JsonNode> _children;

    public ArrayNode(JsonNodeFactory nf) {
        super(nf);
        this._children = new ArrayList<JsonNode>();
    }

    public ArrayNode(JsonNodeFactory nf, int capacity) {
        super(nf);
        this._children = new ArrayList<JsonNode>(capacity);
    }

    public ArrayNode(JsonNodeFactory nf, List<JsonNode> children2) {
        super(nf);
        this._children = children2;
    }

    @Override
    protected JsonNode _at(JsonPointer ptr) {
        return this.get(ptr.getMatchingIndex());
    }

    public ArrayNode deepCopy() {
        ArrayNode ret = new ArrayNode(this._nodeFactory);
        for (JsonNode element : this._children) {
            ret._children.add((JsonNode)element.deepCopy());
        }
        return ret;
    }

    @Override
    public boolean isEmpty(SerializerProvider serializers) {
        return this._children.isEmpty();
    }

    @Override
    public JsonNodeType getNodeType() {
        return JsonNodeType.ARRAY;
    }

    @Override
    public boolean isArray() {
        return true;
    }

    @Override
    public JsonToken asToken() {
        return JsonToken.START_ARRAY;
    }

    @Override
    public int size() {
        return this._children.size();
    }

    @Override
    public boolean isEmpty() {
        return this._children.isEmpty();
    }

    @Override
    public Iterator<JsonNode> elements() {
        return this._children.iterator();
    }

    @Override
    public JsonNode get(int index2) {
        if (index2 >= 0 && index2 < this._children.size()) {
            return this._children.get(index2);
        }
        return null;
    }

    @Override
    public JsonNode get(String fieldName) {
        return null;
    }

    @Override
    public JsonNode path(String fieldName) {
        return MissingNode.getInstance();
    }

    @Override
    public JsonNode path(int index2) {
        if (index2 >= 0 && index2 < this._children.size()) {
            return this._children.get(index2);
        }
        return MissingNode.getInstance();
    }

    @Override
    public JsonNode required(int index2) {
        if (index2 >= 0 && index2 < this._children.size()) {
            return this._children.get(index2);
        }
        return (JsonNode)this._reportRequiredViolation("No value at index #%d [0, %d) of `ArrayNode`", index2, this._children.size());
    }

    @Override
    public boolean equals(Comparator<JsonNode> comparator2, JsonNode o) {
        if (!(o instanceof ArrayNode)) {
            return false;
        }
        ArrayNode other = (ArrayNode)o;
        int len = this._children.size();
        if (other.size() != len) {
            return false;
        }
        List<JsonNode> l1 = this._children;
        List<JsonNode> l2 = other._children;
        for (int i = 0; i < len; ++i) {
            if (l1.get(i).equals(comparator2, l2.get(i))) continue;
            return false;
        }
        return true;
    }

    @Override
    public void serialize(JsonGenerator f, SerializerProvider provider2) throws IOException {
        List<JsonNode> c = this._children;
        int size = c.size();
        f.writeStartArray(this, size);
        for (int i = 0; i < size; ++i) {
            JsonNode n = c.get(i);
            ((BaseJsonNode)n).serialize(f, provider2);
        }
        f.writeEndArray();
    }

    @Override
    public void serializeWithType(JsonGenerator g2, SerializerProvider provider2, TypeSerializer typeSer) throws IOException {
        WritableTypeId typeIdDef = typeSer.writeTypePrefix(g2, typeSer.typeId(this, JsonToken.START_ARRAY));
        for (JsonNode n : this._children) {
            ((BaseJsonNode)n).serialize(g2, provider2);
        }
        typeSer.writeTypeSuffix(g2, typeIdDef);
    }

    @Override
    public JsonNode findValue(String fieldName) {
        for (JsonNode node2 : this._children) {
            JsonNode value = node2.findValue(fieldName);
            if (value == null) continue;
            return value;
        }
        return null;
    }

    @Override
    public List<JsonNode> findValues(String fieldName, List<JsonNode> foundSoFar) {
        for (JsonNode node2 : this._children) {
            foundSoFar = node2.findValues(fieldName, foundSoFar);
        }
        return foundSoFar;
    }

    @Override
    public List<String> findValuesAsText(String fieldName, List<String> foundSoFar) {
        for (JsonNode node2 : this._children) {
            foundSoFar = node2.findValuesAsText(fieldName, foundSoFar);
        }
        return foundSoFar;
    }

    @Override
    public ObjectNode findParent(String fieldName) {
        for (JsonNode node2 : this._children) {
            JsonNode parent = node2.findParent(fieldName);
            if (parent == null) continue;
            return (ObjectNode)parent;
        }
        return null;
    }

    @Override
    public List<JsonNode> findParents(String fieldName, List<JsonNode> foundSoFar) {
        for (JsonNode node2 : this._children) {
            foundSoFar = node2.findParents(fieldName, foundSoFar);
        }
        return foundSoFar;
    }

    public JsonNode set(int index2, JsonNode value) {
        if (value == null) {
            value = this.nullNode();
        }
        if (index2 < 0 || index2 >= this._children.size()) {
            throw new IndexOutOfBoundsException("Illegal index " + index2 + ", array size " + this.size());
        }
        return this._children.set(index2, value);
    }

    public ArrayNode add(JsonNode value) {
        if (value == null) {
            value = this.nullNode();
        }
        this._add(value);
        return this;
    }

    public ArrayNode addAll(ArrayNode other) {
        this._children.addAll(other._children);
        return this;
    }

    public ArrayNode addAll(Collection<? extends JsonNode> nodes) {
        for (JsonNode jsonNode : nodes) {
            this.add(jsonNode);
        }
        return this;
    }

    public ArrayNode insert(int index2, JsonNode value) {
        if (value == null) {
            value = this.nullNode();
        }
        this._insert(index2, value);
        return this;
    }

    public JsonNode remove(int index2) {
        if (index2 >= 0 && index2 < this._children.size()) {
            return this._children.remove(index2);
        }
        return null;
    }

    @Override
    public ArrayNode removeAll() {
        this._children.clear();
        return this;
    }

    public ArrayNode addArray() {
        ArrayNode n = this.arrayNode();
        this._add(n);
        return n;
    }

    public ObjectNode addObject() {
        ObjectNode n = this.objectNode();
        this._add(n);
        return n;
    }

    public ArrayNode addPOJO(Object value) {
        if (value == null) {
            this.addNull();
        } else {
            this._add(this.pojoNode(value));
        }
        return this;
    }

    public ArrayNode addRawValue(RawValue raw) {
        if (raw == null) {
            this.addNull();
        } else {
            this._add(this.rawValueNode(raw));
        }
        return this;
    }

    public ArrayNode addNull() {
        this._add(this.nullNode());
        return this;
    }

    public ArrayNode add(int v) {
        this._add(this.numberNode(v));
        return this;
    }

    public ArrayNode add(Integer value) {
        if (value == null) {
            return this.addNull();
        }
        return this._add(this.numberNode((int)value));
    }

    public ArrayNode add(long v) {
        return this._add(this.numberNode(v));
    }

    public ArrayNode add(Long value) {
        if (value == null) {
            return this.addNull();
        }
        return this._add(this.numberNode((long)value));
    }

    public ArrayNode add(float v) {
        return this._add(this.numberNode(v));
    }

    public ArrayNode add(Float value) {
        if (value == null) {
            return this.addNull();
        }
        return this._add(this.numberNode(value.floatValue()));
    }

    public ArrayNode add(double v) {
        return this._add(this.numberNode(v));
    }

    public ArrayNode add(Double value) {
        if (value == null) {
            return this.addNull();
        }
        return this._add(this.numberNode((double)value));
    }

    public ArrayNode add(BigDecimal v) {
        if (v == null) {
            return this.addNull();
        }
        return this._add(this.numberNode(v));
    }

    public ArrayNode add(BigInteger v) {
        if (v == null) {
            return this.addNull();
        }
        return this._add(this.numberNode(v));
    }

    public ArrayNode add(String v) {
        if (v == null) {
            return this.addNull();
        }
        return this._add(this.textNode(v));
    }

    public ArrayNode add(boolean v) {
        return this._add(this.booleanNode(v));
    }

    public ArrayNode add(Boolean value) {
        if (value == null) {
            return this.addNull();
        }
        return this._add(this.booleanNode(value));
    }

    public ArrayNode add(byte[] v) {
        if (v == null) {
            return this.addNull();
        }
        return this._add(this.binaryNode(v));
    }

    public ArrayNode insertArray(int index2) {
        ArrayNode n = this.arrayNode();
        this._insert(index2, n);
        return n;
    }

    public ObjectNode insertObject(int index2) {
        ObjectNode n = this.objectNode();
        this._insert(index2, n);
        return n;
    }

    public ArrayNode insertPOJO(int index2, Object value) {
        if (value == null) {
            return this.insertNull(index2);
        }
        return this._insert(index2, this.pojoNode(value));
    }

    public ArrayNode insertNull(int index2) {
        this._insert(index2, this.nullNode());
        return this;
    }

    public ArrayNode insert(int index2, int v) {
        this._insert(index2, this.numberNode(v));
        return this;
    }

    public ArrayNode insert(int index2, Integer value) {
        if (value == null) {
            this.insertNull(index2);
        } else {
            this._insert(index2, this.numberNode((int)value));
        }
        return this;
    }

    public ArrayNode insert(int index2, long v) {
        return this._insert(index2, this.numberNode(v));
    }

    public ArrayNode insert(int index2, Long value) {
        if (value == null) {
            return this.insertNull(index2);
        }
        return this._insert(index2, this.numberNode((long)value));
    }

    public ArrayNode insert(int index2, float v) {
        return this._insert(index2, this.numberNode(v));
    }

    public ArrayNode insert(int index2, Float value) {
        if (value == null) {
            return this.insertNull(index2);
        }
        return this._insert(index2, this.numberNode(value.floatValue()));
    }

    public ArrayNode insert(int index2, double v) {
        return this._insert(index2, this.numberNode(v));
    }

    public ArrayNode insert(int index2, Double value) {
        if (value == null) {
            return this.insertNull(index2);
        }
        return this._insert(index2, this.numberNode((double)value));
    }

    public ArrayNode insert(int index2, BigDecimal v) {
        if (v == null) {
            return this.insertNull(index2);
        }
        return this._insert(index2, this.numberNode(v));
    }

    public ArrayNode insert(int index2, BigInteger v) {
        if (v == null) {
            return this.insertNull(index2);
        }
        return this._insert(index2, this.numberNode(v));
    }

    public ArrayNode insert(int index2, String v) {
        if (v == null) {
            return this.insertNull(index2);
        }
        return this._insert(index2, this.textNode(v));
    }

    public ArrayNode insert(int index2, boolean v) {
        return this._insert(index2, this.booleanNode(v));
    }

    public ArrayNode insert(int index2, Boolean value) {
        if (value == null) {
            return this.insertNull(index2);
        }
        return this._insert(index2, this.booleanNode(value));
    }

    public ArrayNode insert(int index2, byte[] v) {
        if (v == null) {
            return this.insertNull(index2);
        }
        return this._insert(index2, this.binaryNode(v));
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o == null) {
            return false;
        }
        if (o instanceof ArrayNode) {
            return this._children.equals(((ArrayNode)o)._children);
        }
        return false;
    }

    protected boolean _childrenEqual(ArrayNode other) {
        return this._children.equals(other._children);
    }

    @Override
    public int hashCode() {
        return this._children.hashCode();
    }

    protected ArrayNode _add(JsonNode node2) {
        this._children.add(node2);
        return this;
    }

    protected ArrayNode _insert(int index2, JsonNode node2) {
        if (index2 < 0) {
            this._children.add(0, node2);
        } else if (index2 >= this._children.size()) {
            this._children.add(node2);
        } else {
            this._children.add(index2, node2);
        }
        return this;
    }
}

