/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.core.io;

import com.fasterxml.jackson.core.util.BufferRecycler;
import com.fasterxml.jackson.core.util.TextBuffer;
import java.io.Writer;

public final class SegmentedStringWriter
extends Writer {
    private final TextBuffer _buffer;

    public SegmentedStringWriter(BufferRecycler br) {
        this._buffer = new TextBuffer(br);
    }

    @Override
    public Writer append(char c) {
        this.write(c);
        return this;
    }

    @Override
    public Writer append(CharSequence csq) {
        String str2 = csq.toString();
        this._buffer.append(str2, 0, str2.length());
        return this;
    }

    @Override
    public Writer append(CharSequence csq, int start2, int end2) {
        String str2 = csq.subSequence(start2, end2).toString();
        this._buffer.append(str2, 0, str2.length());
        return this;
    }

    @Override
    public void close() {
    }

    @Override
    public void flush() {
    }

    @Override
    public void write(char[] cbuf) {
        this._buffer.append(cbuf, 0, cbuf.length);
    }

    @Override
    public void write(char[] cbuf, int off, int len) {
        this._buffer.append(cbuf, off, len);
    }

    @Override
    public void write(int c) {
        this._buffer.append((char)c);
    }

    @Override
    public void write(String str2) {
        this._buffer.append(str2, 0, str2.length());
    }

    @Override
    public void write(String str2, int off, int len) {
        this._buffer.append(str2, off, len);
    }

    public String getAndClear() {
        String result2 = this._buffer.contentsAsString();
        this._buffer.releaseBuffers();
        return result2;
    }
}

