/*
 * Decompiled with CFR 0.152.
 */
package clojure.lang;

import clojure.lang.APersistentSet;
import clojure.lang.ATransientSet;
import clojure.lang.IEditableCollection;
import clojure.lang.IObj;
import clojure.lang.IPersistentCollection;
import clojure.lang.IPersistentMap;
import clojure.lang.IPersistentSet;
import clojure.lang.ISeq;
import clojure.lang.ITransientCollection;
import clojure.lang.ITransientMap;
import clojure.lang.ITransientSet;
import clojure.lang.PersistentHashMap;
import java.util.List;

public class PersistentHashSet
extends APersistentSet
implements IObj,
IEditableCollection {
    public static final PersistentHashSet EMPTY = new PersistentHashSet(null, PersistentHashMap.EMPTY);
    final IPersistentMap _meta;

    public static PersistentHashSet create(Object ... init2) {
        ITransientSet ret = (ITransientSet)EMPTY.asTransient();
        for (int i = 0; i < init2.length; ++i) {
            ret = (ITransientSet)ret.conj(init2[i]);
        }
        return (PersistentHashSet)ret.persistent();
    }

    public static PersistentHashSet create(List init2) {
        ITransientSet ret = (ITransientSet)EMPTY.asTransient();
        for (Object key2 : init2) {
            ret = (ITransientSet)ret.conj(key2);
        }
        return (PersistentHashSet)ret.persistent();
    }

    public static PersistentHashSet create(ISeq items) {
        ITransientSet ret = (ITransientSet)EMPTY.asTransient();
        while (items != null) {
            ret = (ITransientSet)ret.conj(items.first());
            items = items.next();
        }
        return (PersistentHashSet)ret.persistent();
    }

    public static PersistentHashSet createWithCheck(Object ... init2) {
        ITransientSet ret = (ITransientSet)EMPTY.asTransient();
        for (int i = 0; i < init2.length; ++i) {
            if ((ret = (ITransientSet)ret.conj(init2[i])).count() == i + 1) continue;
            throw new IllegalArgumentException("Duplicate key: " + init2[i]);
        }
        return (PersistentHashSet)ret.persistent();
    }

    public static PersistentHashSet createWithCheck(List init2) {
        ITransientSet ret = (ITransientSet)EMPTY.asTransient();
        int i = 0;
        for (Object key2 : init2) {
            if ((ret = (ITransientSet)ret.conj(key2)).count() != i + 1) {
                throw new IllegalArgumentException("Duplicate key: " + key2);
            }
            ++i;
        }
        return (PersistentHashSet)ret.persistent();
    }

    public static PersistentHashSet createWithCheck(ISeq items) {
        ITransientSet ret = (ITransientSet)EMPTY.asTransient();
        int i = 0;
        while (items != null) {
            if ((ret = (ITransientSet)ret.conj(items.first())).count() != i + 1) {
                throw new IllegalArgumentException("Duplicate key: " + items.first());
            }
            items = items.next();
            ++i;
        }
        return (PersistentHashSet)ret.persistent();
    }

    PersistentHashSet(IPersistentMap meta, IPersistentMap impl2) {
        super(impl2);
        this._meta = meta;
    }

    @Override
    public IPersistentSet disjoin(Object key2) {
        if (this.contains(key2)) {
            return new PersistentHashSet(this.meta(), this.impl.without(key2));
        }
        return this;
    }

    @Override
    public IPersistentSet cons(Object o) {
        if (this.contains(o)) {
            return this;
        }
        return new PersistentHashSet(this.meta(), this.impl.assoc(o, o));
    }

    @Override
    public IPersistentCollection empty() {
        return EMPTY.withMeta(this.meta());
    }

    @Override
    public PersistentHashSet withMeta(IPersistentMap meta) {
        return new PersistentHashSet(meta, this.impl);
    }

    @Override
    public ITransientCollection asTransient() {
        return new TransientHashSet(((PersistentHashMap)this.impl).asTransient());
    }

    @Override
    public IPersistentMap meta() {
        return this._meta;
    }

    static final class TransientHashSet
    extends ATransientSet {
        TransientHashSet(ITransientMap impl2) {
            super(impl2);
        }

        @Override
        public IPersistentCollection persistent() {
            return new PersistentHashSet(null, this.impl.persistent());
        }
    }
}

