/*
 * Decompiled with CFR 0.152.
 */
package clojure.lang;

import clojure.lang.IChunk;
import clojure.lang.IFn;
import clojure.lang.RT;
import java.io.Serializable;

public final class ArrayChunk
implements IChunk,
Serializable {
    final Object[] array;
    final int off;
    final int end;

    public ArrayChunk(Object[] array2) {
        this(array2, 0, array2.length);
    }

    public ArrayChunk(Object[] array2, int off) {
        this(array2, off, array2.length);
    }

    public ArrayChunk(Object[] array2, int off, int end2) {
        this.array = array2;
        this.off = off;
        this.end = end2;
    }

    @Override
    public Object nth(int i) {
        return this.array[this.off + i];
    }

    @Override
    public Object nth(int i, Object notFound) {
        if (i >= 0 && i < this.count()) {
            return this.nth(i);
        }
        return notFound;
    }

    @Override
    public int count() {
        return this.end - this.off;
    }

    @Override
    public IChunk dropFirst() {
        if (this.off == this.end) {
            throw new IllegalStateException("dropFirst of empty chunk");
        }
        return new ArrayChunk(this.array, this.off + 1, this.end);
    }

    @Override
    public Object reduce(IFn f, Object start2) {
        Object ret = f.invoke(start2, this.array[this.off]);
        if (RT.isReduced(ret)) {
            return ret;
        }
        for (int x = this.off + 1; x < this.end; ++x) {
            if (!RT.isReduced(ret = f.invoke(ret, this.array[x]))) continue;
            return ret;
        }
        return ret;
    }
}

