/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.core.rolling.helper;

import ch.qos.logback.core.rolling.helper.PeriodicityType;
import ch.qos.logback.core.spi.ContextAwareBase;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Locale;
import java.util.TimeZone;

public class RollingCalendar
extends GregorianCalendar {
    private static final long serialVersionUID = -5937537740925066161L;
    static final TimeZone GMT_TIMEZONE = TimeZone.getTimeZone("GMT");
    PeriodicityType periodicityType = PeriodicityType.ERRONEOUS;
    String datePattern;

    public RollingCalendar(String datePattern) {
        this.datePattern = datePattern;
        this.periodicityType = this.computePeriodicityType();
    }

    public RollingCalendar(String datePattern, TimeZone tz, Locale locale) {
        super(tz, locale);
        this.datePattern = datePattern;
        this.periodicityType = this.computePeriodicityType();
    }

    public PeriodicityType getPeriodicityType() {
        return this.periodicityType;
    }

    public PeriodicityType computePeriodicityType() {
        GregorianCalendar calendar = new GregorianCalendar(GMT_TIMEZONE, Locale.getDefault());
        Date epoch2 = new Date(0L);
        if (this.datePattern != null) {
            for (PeriodicityType i : PeriodicityType.VALID_ORDERED_LIST) {
                SimpleDateFormat simpleDateFormat = new SimpleDateFormat(this.datePattern);
                simpleDateFormat.setTimeZone(GMT_TIMEZONE);
                String r0 = simpleDateFormat.format(epoch2);
                Date next2 = RollingCalendar.innerGetEndOfThisPeriod(calendar, i, epoch2);
                String r1 = simpleDateFormat.format(next2);
                if (r0 == null || r1 == null || r0.equals(r1)) continue;
                return i;
            }
        }
        return PeriodicityType.ERRONEOUS;
    }

    public boolean isCollisionFree() {
        switch (this.periodicityType) {
            case TOP_OF_HOUR: {
                return !this.collision(43200000L);
            }
            case TOP_OF_DAY: {
                if (this.collision(604800000L)) {
                    return false;
                }
                if (this.collision(2678400000L)) {
                    return false;
                }
                return !this.collision(31536000000L);
            }
            case TOP_OF_WEEK: {
                if (this.collision(2937600000L)) {
                    return false;
                }
                return !this.collision(31622400000L);
            }
        }
        return true;
    }

    private boolean collision(long delta) {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat(this.datePattern);
        simpleDateFormat.setTimeZone(GMT_TIMEZONE);
        Date epoch0 = new Date(0L);
        String r0 = simpleDateFormat.format(epoch0);
        Date epoch12 = new Date(delta);
        String r12 = simpleDateFormat.format(epoch12);
        return r0.equals(r12);
    }

    public void printPeriodicity(ContextAwareBase cab) {
        switch (this.periodicityType) {
            case TOP_OF_MILLISECOND: {
                cab.addInfo("Roll-over every millisecond.");
                break;
            }
            case TOP_OF_SECOND: {
                cab.addInfo("Roll-over every second.");
                break;
            }
            case TOP_OF_MINUTE: {
                cab.addInfo("Roll-over every minute.");
                break;
            }
            case TOP_OF_HOUR: {
                cab.addInfo("Roll-over at the top of every hour.");
                break;
            }
            case HALF_DAY: {
                cab.addInfo("Roll-over at midday and midnight.");
                break;
            }
            case TOP_OF_DAY: {
                cab.addInfo("Roll-over at midnight.");
                break;
            }
            case TOP_OF_WEEK: {
                cab.addInfo("Rollover at the start of week.");
                break;
            }
            case TOP_OF_MONTH: {
                cab.addInfo("Rollover at start of every month.");
                break;
            }
            default: {
                cab.addInfo("Unknown periodicity.");
            }
        }
    }

    public long periodBarriersCrossed(long start2, long end2) {
        if (start2 > end2) {
            throw new IllegalArgumentException("Start cannot come before end");
        }
        long startFloored = this.getStartOfCurrentPeriodWithGMTOffsetCorrection(start2, this.getTimeZone());
        long endFloored = this.getStartOfCurrentPeriodWithGMTOffsetCorrection(end2, this.getTimeZone());
        long diff2 = endFloored - startFloored;
        switch (this.periodicityType) {
            case TOP_OF_MILLISECOND: {
                return diff2;
            }
            case TOP_OF_SECOND: {
                return diff2 / 1000L;
            }
            case TOP_OF_MINUTE: {
                return diff2 / 60000L;
            }
            case TOP_OF_HOUR: {
                return (long)((int)diff2) / 3600000L;
            }
            case TOP_OF_DAY: {
                return diff2 / 86400000L;
            }
            case TOP_OF_WEEK: {
                return diff2 / 604800000L;
            }
            case TOP_OF_MONTH: {
                return RollingCalendar.diffInMonths(start2, end2);
            }
        }
        throw new IllegalStateException("Unknown periodicity type.");
    }

    public static int diffInMonths(long startTime, long endTime) {
        if (startTime > endTime) {
            throw new IllegalArgumentException("startTime cannot be larger than endTime");
        }
        Calendar startCal = Calendar.getInstance();
        startCal.setTimeInMillis(startTime);
        Calendar endCal = Calendar.getInstance();
        endCal.setTimeInMillis(endTime);
        int yearDiff = endCal.get(1) - startCal.get(1);
        int monthDiff = endCal.get(2) - startCal.get(2);
        return yearDiff * 12 + monthDiff;
    }

    private static Date innerGetEndOfThisPeriod(Calendar cal, PeriodicityType periodicityType, Date now2) {
        return RollingCalendar.innerGetEndOfNextNthPeriod(cal, periodicityType, now2, 1);
    }

    private static Date innerGetEndOfNextNthPeriod(Calendar cal, PeriodicityType periodicityType, Date now2, int numPeriods) {
        cal.setTime(now2);
        switch (periodicityType) {
            case TOP_OF_MILLISECOND: {
                cal.add(14, numPeriods);
                break;
            }
            case TOP_OF_SECOND: {
                cal.set(14, 0);
                cal.add(13, numPeriods);
                break;
            }
            case TOP_OF_MINUTE: {
                cal.set(13, 0);
                cal.set(14, 0);
                cal.add(12, numPeriods);
                break;
            }
            case TOP_OF_HOUR: {
                cal.set(12, 0);
                cal.set(13, 0);
                cal.set(14, 0);
                cal.add(11, numPeriods);
                break;
            }
            case TOP_OF_DAY: {
                cal.set(11, 0);
                cal.set(12, 0);
                cal.set(13, 0);
                cal.set(14, 0);
                cal.add(5, numPeriods);
                break;
            }
            case TOP_OF_WEEK: {
                cal.set(7, cal.getFirstDayOfWeek());
                cal.set(11, 0);
                cal.set(12, 0);
                cal.set(13, 0);
                cal.set(14, 0);
                cal.add(3, numPeriods);
                break;
            }
            case TOP_OF_MONTH: {
                cal.set(5, 1);
                cal.set(11, 0);
                cal.set(12, 0);
                cal.set(13, 0);
                cal.set(14, 0);
                cal.add(2, numPeriods);
                break;
            }
            default: {
                throw new IllegalStateException("Unknown periodicity type.");
            }
        }
        return cal.getTime();
    }

    public Date getEndOfNextNthPeriod(Date now2, int periods) {
        return RollingCalendar.innerGetEndOfNextNthPeriod(this, this.periodicityType, now2, periods);
    }

    public Date getNextTriggeringDate(Date now2) {
        return this.getEndOfNextNthPeriod(now2, 1);
    }

    public long getStartOfCurrentPeriodWithGMTOffsetCorrection(long now2, TimeZone timezone2) {
        Calendar aCal = Calendar.getInstance(timezone2);
        aCal.setTimeInMillis(now2);
        Date toppedDate = this.getEndOfNextNthPeriod(aCal.getTime(), 0);
        Calendar secondCalendar = Calendar.getInstance(timezone2);
        secondCalendar.setTimeInMillis(toppedDate.getTime());
        long gmtOffset = secondCalendar.get(15) + secondCalendar.get(16);
        return toppedDate.getTime() + gmtOffset;
    }
}

