/*
 * Decompiled with CFR 0.152.
 */
package ai.tock.shared.security;

import ai.tock.shared.LoggersKt;
import ai.tock.shared.PropertiesKt;
import ai.tock.shared.security.EncryptorsKt;
import ai.tock.shared.security.TockObfuscatorService;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import mu.KLogger;
import mu.KotlinLogging;
import org.jasypt.contrib.org.apache.commons.codec_1_3.binary.Base64;
import org.jasypt.util.text.BasicTextEncryptor;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=2, xi=48, d1={"\u0000(\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\u001a\u000e\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\r\u001a\u000e\u0010\u000f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\r\u001a\u0006\u0010\u0010\u001a\u00020\u0011\u001a\u000e\u0010\u0012\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\r\"\u0011\u0010\u0000\u001a\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0002\u0010\u0003\"\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u001b\u0010\u0006\u001a\u00020\u00078BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\n\u0010\u000b\u001a\u0004\b\b\u0010\t\u00a8\u0006\u0013"}, d2={"encryptionEnabled", "", "getEncryptionEnabled", "()Z", "logger", "Lmu/KLogger;", "textEncryptor", "Lorg/jasypt/util/text/BasicTextEncryptor;", "getTextEncryptor", "()Lorg/jasypt/util/text/BasicTextEncryptor;", "textEncryptor$delegate", "Lkotlin/Lazy;", "decrypt", "", "s", "encrypt", "initEncryptor", "", "shaS256", "tock-shared"})
public final class EncryptorsKt {
    @NotNull
    private static final KLogger logger = KotlinLogging.INSTANCE.logger(logger.1.INSTANCE);
    @NotNull
    private static final Lazy textEncryptor$delegate = LazyKt.lazy(textEncryptor.2.INSTANCE);
    private static final boolean encryptionEnabled = PropertiesKt.propertyExists("tock_encrypt_pass");

    private static final BasicTextEncryptor getTextEncryptor() {
        Lazy lazy2 = textEncryptor$delegate;
        Object var1_1 = null;
        boolean bl = false;
        return (BasicTextEncryptor)lazy2.getValue();
    }

    public static final boolean getEncryptionEnabled() {
        return encryptionEnabled;
    }

    @NotNull
    public static final String shaS256(@NotNull String s2) {
        Intrinsics.checkNotNullParameter(s2, "s");
        MessageDigest messageDigest = MessageDigest.getInstance("SHA-256");
        String string2 = s2;
        Charset charset = StandardCharsets.UTF_8;
        Intrinsics.checkNotNullExpressionValue(charset, "UTF_8");
        boolean bl = false;
        byte[] byArray = string2.getBytes(charset);
        Intrinsics.checkNotNullExpressionValue(byArray, "(this as java.lang.String).getBytes(charset)");
        byte[] byArray2 = Base64.encodeBase64Chunked((byte[])messageDigest.digest(byArray));
        Intrinsics.checkNotNullExpressionValue(byArray2, "encodeBase64Chunked(\n            MessageDigest.getInstance(\"SHA-256\").digest(s.toByteArray(StandardCharsets.UTF_8))\n        )");
        boolean bl2 = false;
        return new String(byArray2, Charsets.UTF_8);
    }

    @NotNull
    public static final String encrypt(@NotNull String s2) {
        Intrinsics.checkNotNullParameter(s2, "s");
        String string2 = EncryptorsKt.getTextEncryptor().encrypt(s2);
        Intrinsics.checkNotNullExpressionValue(string2, "textEncryptor.encrypt(s)");
        return string2;
    }

    @NotNull
    public static final String decrypt(@NotNull String s2) {
        String string2;
        Intrinsics.checkNotNullParameter(s2, "s");
        try {
            string2 = EncryptorsKt.getTextEncryptor().decrypt(s2);
            Intrinsics.checkNotNullExpressionValue(string2, "{\n        textEncryptor.decrypt(s)\n    }");
        }
        catch (Exception e2) {
            LoggersKt.error(logger, e2);
            string2 = s2;
        }
        return string2;
    }

    public static final void initEncryptor() {
        if (encryptionEnabled) {
            logger.info(initEncryptor.1.INSTANCE);
            EncryptorsKt.decrypt(EncryptorsKt.encrypt("test"));
            logger.info(initEncryptor.2.INSTANCE);
        }
        TockObfuscatorService.INSTANCE.loadObfuscators$tock_shared();
    }
}

