/*
 * Decompiled with CFR 0.152.
 */
package ai.tock.shared.cache.mongo;

import ai.tock.shared.LoggersKt;
import ai.tock.shared.cache.TockCache;
import ai.tock.shared.cache.mongo.MongoCache;
import ai.tock.shared.cache.mongo.MongoCacheData;
import ai.tock.shared.cache.mongo.MongoCacheData_;
import com.mongodb.client.FindIterable;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.MongoIterable;
import com.mongodb.client.model.ReplaceOptions;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.collections.KMongoIterableKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.KProperty;
import kotlin.sequences.Sequence;
import mu.KLogger;
import mu.KotlinLogging;
import org.bson.conversions.Bson;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.litote.kmongo.FiltersKt;
import org.litote.kmongo.Id;
import org.litote.kmongo.MongoCollectionsKt;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J+\u0010\u000e\u001a\u0004\u0018\u0001H\u000f\"\u0004\b\u0000\u0010\u000f2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u0002H\u000f0\u00112\u0006\u0010\u0012\u001a\u00020\u0004H\u0016\u00a2\u0006\u0002\u0010\u0013J(\u0010\u0014\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u000f0\u0011\u0012\u0004\u0012\u00020\u00160\u0015\"\u0004\b\u0000\u0010\u000f2\u0006\u0010\u0012\u001a\u00020\u0004H\u0016J5\u0010\u0017\u001a\u00020\u0018\"\b\b\u0000\u0010\u000f*\u00020\u00162\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u0002H\u000f0\u00112\u0006\u0010\u0012\u001a\u00020\u00042\u0006\u0010\u0019\u001a\u0002H\u000fH\u0016\u00a2\u0006\u0002\u0010\u001aJ$\u0010\u001b\u001a\u00020\u0018\"\u0004\b\u0000\u0010\u000f2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u0002H\u000f0\u00112\u0006\u0010\u0012\u001a\u00020\u0004H\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R!\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00068BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\n\u0010\u000b\u001a\u0004\b\b\u0010\tR\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lai/tock/shared/cache/mongo/MongoCache;", "Lai/tock/shared/cache/TockCache;", "()V", "MONGO_DATABASE", "", "col", "Lcom/mongodb/client/MongoCollection;", "Lai/tock/shared/cache/mongo/MongoCacheData;", "getCol", "()Lcom/mongodb/client/MongoCollection;", "col$delegate", "Lkotlin/Lazy;", "logger", "Lmu/KLogger;", "get", "T", "id", "Lorg/litote/kmongo/Id;", "type", "(Lorg/litote/kmongo/Id;Ljava/lang/String;)Ljava/lang/Object;", "getAll", "", "", "put", "", "data", "(Lorg/litote/kmongo/Id;Ljava/lang/String;Ljava/lang/Object;)V", "remove", "tock-shared"})
public final class MongoCache
implements TockCache {
    @NotNull
    public static final MongoCache INSTANCE = new MongoCache();
    @NotNull
    private static final String MONGO_DATABASE = "tock_cache_mongo_db";
    @NotNull
    private static final KLogger logger = KotlinLogging.INSTANCE.logger(logger.1.INSTANCE);
    @NotNull
    private static final Lazy col$delegate = LazyKt.lazy(col.2.INSTANCE);

    private MongoCache() {
    }

    private final MongoCollection<MongoCacheData> getCol() {
        Lazy lazy2 = col$delegate;
        boolean bl = false;
        return (MongoCollection)lazy2.getValue();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public <T> Map<Id<T>, Object> getAll(@NotNull String type2) {
        void $this$mapValuesTo$iv$iv;
        Id<Object> id;
        Map map2;
        Map $this$associateByTo$iv$iv;
        Intrinsics.checkNotNullParameter(type2, "type");
        FindIterable findIterable = this.getCol().find(FiltersKt.eq((KProperty)MongoCacheData_.Companion.getType(), (Object)type2));
        Intrinsics.checkNotNullExpressionValue(findIterable, "col\n            .find(Type eq type)");
        Sequence $this$associateBy$iv = KMongoIterableKt.asSequence((MongoIterable)((MongoIterable)findIterable));
        boolean $i$f$associateBy = false;
        Sequence sequence2 = $this$associateBy$iv;
        Map destination$iv$iv = new LinkedHashMap();
        boolean $i$f$associateByTo = false;
        Iterator iterator2 = $this$associateByTo$iv$iv.iterator();
        while (iterator2.hasNext()) {
            void it;
            Object element$iv$iv = iterator2.next();
            MongoCacheData mongoCacheData = (MongoCacheData)element$iv$iv;
            map2 = destination$iv$iv;
            boolean bl = false;
            id = it.getId();
            map2.put(id, element$iv$iv);
        }
        Map $this$mapValues$iv = destination$iv$iv;
        boolean $i$f$mapValues = false;
        $this$associateByTo$iv$iv = $this$mapValues$iv;
        destination$iv$iv = new LinkedHashMap(MapsKt.mapCapacity($this$mapValues$iv.size()));
        boolean $i$f$mapValuesTo = false;
        Iterable $this$associateByTo$iv$iv$iv = $this$mapValuesTo$iv$iv.entrySet();
        boolean $i$f$associateByTo2 = false;
        for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
            void it;
            void it$iv$iv;
            Map.Entry entry = (Map.Entry)element$iv$iv$iv;
            Map map3 = destination$iv$iv;
            boolean bl = false;
            Object k = it$iv$iv.getKey();
            Map.Entry entry2 = (Map.Entry)element$iv$iv$iv;
            id = k;
            map2 = map3;
            boolean bl2 = false;
            Object object = ((MongoCacheData)it.getValue()).toValue();
            map2.put(id, object);
        }
        return destination$iv$iv;
    }

    @Override
    @Nullable
    public <T> T get(@NotNull Id<T> id, @NotNull String type2) {
        Object object;
        Intrinsics.checkNotNullParameter(id, "id");
        Intrinsics.checkNotNullParameter(type2, "type");
        try {
            Bson[] bsonArray = new Bson[]{FiltersKt.eq((KProperty)MongoCacheData_.Companion.getId(), id), FiltersKt.eq((KProperty)MongoCacheData_.Companion.getType(), (Object)type2)};
            object = (MongoCacheData)MongoCollectionsKt.findOne(this.getCol(), (Bson[])bsonArray);
            object = object == null ? null : ((MongoCacheData)object).toValue();
        }
        catch (Exception e2) {
            LoggersKt.error(logger, e2);
            this.remove(id, type2);
            object = null;
        }
        return (T)object;
    }

    @Override
    public <T> void put(@NotNull Id<T> id, @NotNull String type2, @NotNull T data2) {
        Intrinsics.checkNotNullParameter(id, "id");
        Intrinsics.checkNotNullParameter(type2, "type");
        Intrinsics.checkNotNullParameter(data2, "data");
        Bson[] bsonArray = new Bson[]{FiltersKt.eq((KProperty)MongoCacheData_.Companion.getId(), id), FiltersKt.eq((KProperty)MongoCacheData_.Companion.getType(), (Object)type2)};
        this.getCol().replaceOne(FiltersKt.and((Bson[])bsonArray), (Object)MongoCacheData.Companion.fromValue(id, type2, data2), new ReplaceOptions().upsert(true));
    }

    @Override
    public <T> void remove(@NotNull Id<T> id, @NotNull String type2) {
        Intrinsics.checkNotNullParameter(id, "id");
        Intrinsics.checkNotNullParameter(type2, "type");
        Bson[] bsonArray = new Bson[]{FiltersKt.eq((KProperty)MongoCacheData_.Companion.getId(), id), FiltersKt.eq((KProperty)MongoCacheData_.Companion.getType(), (Object)type2)};
        MongoCollectionsKt.deleteOne(this.getCol(), (Bson[])bsonArray);
    }
}

