/*
 * Decompiled with CFR 0.152.
 */
package ai.tock.duckling.service;

import ai.tock.duckling.service.DucklingBridge;
import clojure.java.api.Clojure;
import clojure.lang.IFn;
import clojure.lang.IPersistentMap;
import clojure.lang.Keyword;
import clojure.lang.PersistentArrayMap;
import clojure.lang.PersistentVector;
import clojure.lang.RT;
import duckling.core$load_BANG_;
import duckling.core$parse;
import java.io.Serializable;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import mu.KLogger;
import mu.KotlinLogging;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0010\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\u0006\u0010\u0013\u001a\u00020\u0014J\u0010\u0010\u0015\u001a\u00020\u00042\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J4\u0010\u0016\u001a\u00020\u00012\u0006\u0010\u0017\u001a\u00020\u00122\u0006\u0010\u0018\u001a\u00020\u00122\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00120\u001a2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001eR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082.\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0005\u001a\u00020\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\nR\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0004X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0004X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0004X\u0082.\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lai/tock/duckling/service/DucklingBridge;", "", "()V", "grain", "Lclojure/lang/Keyword;", "initialized", "", "getInitialized", "()Z", "setInitialized", "(Z)V", "logger", "Lmu/KLogger;", "referenceTime", "second", "start", "find", "name", "", "initDuckling", "", "keyword", "parse", "language", "textToParse", "dimensions", "", "referenceDate", "Ljava/time/ZonedDateTime;", "referenceTimezone", "Ljava/time/ZoneId;", "tock-nlp-duckling-service"})
public final class DucklingBridge {
    @NotNull
    public static final DucklingBridge INSTANCE = new DucklingBridge();
    @NotNull
    private static final KLogger logger = KotlinLogging.INSTANCE.logger(logger.1.INSTANCE);
    private static Keyword referenceTime;
    private static Keyword start;
    private static Keyword grain;
    private static Keyword second;
    private static volatile boolean initialized;

    private DucklingBridge() {
    }

    public final boolean getInitialized() {
        return initialized;
    }

    public final void setInitialized(boolean bl) {
        initialized = bl;
    }

    private final Keyword keyword(String name2) {
        Keyword keyword2 = RT.keyword(null, name2);
        Intrinsics.checkNotNullExpressionValue(keyword2, "keyword(null as String?, name)");
        return keyword2;
    }

    private final Keyword find(String name2) {
        return Keyword.find(null, name2);
    }

    public final void initDuckling() {
        IFn require2 = Clojure.var("clojure.core", "require");
        require2.invoke(Clojure.read("duckling.core"));
        core$load_BANG_ l = new core$load_BANG_();
        l.invoke();
        referenceTime = this.keyword("reference-time");
        start = this.keyword("start");
        grain = this.keyword("grain");
        second = this.keyword("second");
        List<String> list = CollectionsKt.listOf("time");
        Serializable serializable = ZonedDateTime.now();
        Intrinsics.checkNotNullExpressionValue(serializable, "now()");
        ZonedDateTime zonedDateTime = serializable;
        serializable = ZoneId.systemDefault();
        Intrinsics.checkNotNullExpressionValue(serializable, "systemDefault()");
        this.parse("en", "tomorrow", list, zonedDateTime, (ZoneId)serializable);
        initialized = true;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Object parse(@NotNull String language, @NotNull String textToParse, @NotNull List<String> dimensions, @NotNull ZonedDateTime referenceDate, @NotNull ZoneId referenceTimezone) {
        void $this$mapTo$iv$iv;
        Serializable serializable;
        Intrinsics.checkNotNullParameter(language, "language");
        Intrinsics.checkNotNullParameter(textToParse, "textToParse");
        Intrinsics.checkNotNullParameter(dimensions, "dimensions");
        Intrinsics.checkNotNullParameter(referenceDate, "referenceDate");
        Intrinsics.checkNotNullParameter(referenceTimezone, "referenceTimezone");
        HashMap<DateTimeZone, Serializable> dateMap = new HashMap<DateTimeZone, Serializable>();
        try {
            serializable = Intrinsics.areEqual(referenceTimezone.getId(), "Z") ? DateTimeZone.UTC : DateTimeZone.forID(referenceTimezone.getId());
        }
        catch (Exception e2) {
            logger.warn((Function0<? extends Object>)new Function0<Object>(referenceTimezone){
                final /* synthetic */ ZoneId $referenceTimezone;
                {
                    this.$referenceTimezone = $referenceTimezone;
                    super(0);
                }

                @Nullable
                public final Object invoke() {
                    return "unrecognized timezone " + this.$referenceTimezone + " - use UTC";
                }
            });
            serializable = DateTimeZone.UTC;
        }
        DateTimeZone timezone2 = serializable;
        serializable = start;
        if (serializable == null) {
            Intrinsics.throwUninitializedPropertyAccessException("start");
            throw null;
        }
        dateMap.put((DateTimeZone)serializable, new DateTime(referenceDate.toInstant().toEpochMilli(), timezone2));
        serializable = grain;
        if (serializable == null) {
            Intrinsics.throwUninitializedPropertyAccessException("grain");
            throw null;
        }
        Serializable serializable2 = serializable;
        serializable = second;
        if (serializable == null) {
            Intrinsics.throwUninitializedPropertyAccessException("second");
            throw null;
        }
        dateMap.put((DateTimeZone)serializable2, serializable);
        IPersistentMap dateClosureMap = PersistentArrayMap.create(dateMap);
        Keyword keyword2 = referenceTime;
        if (keyword2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException("referenceTime");
            throw null;
        }
        IPersistentMap context = PersistentArrayMap.create(Collections.singletonMap(keyword2, dateClosureMap));
        Iterable $this$map$iv = dimensions;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            String string2 = (String)item$iv$iv;
            Collection collection2 = destination$iv$iv;
            boolean bl = false;
            Keyword keyword3 = INSTANCE.find((String)it);
            collection2.add(keyword3);
        }
        PersistentVector dims = PersistentVector.create((List)destination$iv$iv);
        core$parse c = new core$parse();
        Object object = c.invoke(Intrinsics.stringPlus(language, "$core"), textToParse, dims, context);
        Intrinsics.checkNotNullExpressionValue(object, "c.invoke(language + \"\\$core\", textToParse, dims, context)");
        return object;
    }
}

