/*
 * Decompiled with CFR 0.152.
 */
package ai.tock.duckling.client;

import ai.tock.duckling.client.JSONValue;
import ai.tock.shared.LoggersKt;
import ai.tock.shared.PropertiesKt;
import ai.tock.shared.RetrofitsKt;
import ai.tock.shared.jackson.JacksonKt;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.vertx.core.json.JsonArray;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import mu.KLogger;
import mu.KotlinLogging;
import okhttp3.RequestBody;
import okhttp3.ResponseBody;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import retrofit2.Call;
import retrofit2.Converter;
import retrofit2.Retrofit;
import retrofit2.converter.jackson.JacksonConverterFactory;
import retrofit2.http.Body;
import retrofit2.http.GET;
import retrofit2.http.POST;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\b\u00c0\u0002\u0018\u00002\u00020\u0001:\u0004\u0017\u0018\u0019\u001aB\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J6\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\f\u001a\u00020\r2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\r0\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\rJ\u0006\u0010\u0015\u001a\u00020\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lai/tock/duckling/client/DucklingClient;", "", "<init>", "()V", "logger", "Lmu/KLogger;", "service", "Lai/tock/duckling/client/DucklingClient$DucklingService;", "jacksonConverterFactory", "Lretrofit2/converter/jackson/JacksonConverterFactory;", "parse", "Lai/tock/duckling/client/JSONValue;", "language", "", "dimensions", "", "referenceDate", "Ljava/time/ZonedDateTime;", "referenceTimezone", "Ljava/time/ZoneId;", "textToParse", "healthcheck", "", "ParseRequest", "DucklingService", "JacksonJsonArrayConverter", "RawJsonBodyConverterFactory", "tock-nlp-duckling-client"})
@SourceDebugExtension(value={"SMAP\nDucklingClient.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DucklingClient.kt\nai/tock/duckling/client/DucklingClient\n+ 2 Retrofits.kt\nai/tock/shared/RetrofitsKt\n*L\n1#1,122:1\n71#2:123\n*S KotlinDebug\n*F\n+ 1 DucklingClient.kt\nai/tock/duckling/client/DucklingClient\n*L\n76#1:123\n*E\n"})
public final class DucklingClient {
    @NotNull
    public static final DucklingClient INSTANCE = new DucklingClient();
    @NotNull
    private static final KLogger logger = KotlinLogging.INSTANCE.logger(DucklingClient::logger$lambda$0);
    @NotNull
    private static final DucklingService service;
    @NotNull
    private static final JacksonConverterFactory jacksonConverterFactory;

    private DucklingClient() {
    }

    @Nullable
    public final JSONValue parse(@NotNull String language, @NotNull List<String> dimensions, @NotNull ZonedDateTime referenceDate, @NotNull ZoneId referenceTimezone, @NotNull String textToParse) {
        Intrinsics.checkNotNullParameter((Object)language, (String)"language");
        Intrinsics.checkNotNullParameter(dimensions, (String)"dimensions");
        Intrinsics.checkNotNullParameter((Object)referenceDate, (String)"referenceDate");
        Intrinsics.checkNotNullParameter((Object)referenceTimezone, (String)"referenceTimezone");
        Intrinsics.checkNotNullParameter((Object)textToParse, (String)"textToParse");
        String text = StringsKt.replace$default((String)StringsKt.replace$default((String)textToParse, (String)"\u2019", (String)"'", (boolean)false, (int)4, null), (String)"\u00a0", (String)" ", (boolean)false, (int)4, null);
        return (JSONValue)service.parse(new ParseRequest(language, dimensions, referenceDate, referenceTimezone, text)).execute().body();
    }

    public final boolean healthcheck() {
        boolean bl;
        try {
            bl = service.healthcheck().execute().isSuccessful();
        }
        catch (Throwable t) {
            LoggersKt.info((KLogger)logger, (Throwable)t);
            bl = false;
        }
        return bl;
    }

    private static final Unit logger$lambda$0() {
        return Unit.INSTANCE;
    }

    static {
        JacksonConverterFactory jacksonConverterFactory = JacksonConverterFactory.create((ObjectMapper)JacksonKt.getMapper());
        Intrinsics.checkNotNullExpressionValue((Object)jacksonConverterFactory, (String)"create(...)");
        DucklingClient.jacksonConverterFactory = jacksonConverterFactory;
        Retrofit retrofit = RetrofitsKt.retrofitBuilderWithTimeoutAndLogger$default((long)PropertiesKt.longProperty((String)"tock_duckling_request_timeout_ms", (long)4000L), (KLogger)logger, null, null, (boolean)false, (boolean)true, null, (int)92, null).baseUrl(PropertiesKt.property((String)"nlp_duckling_url", (String)"http://localhost:8889") + "/").addConverterFactory((Converter.Factory)RawJsonBodyConverterFactory.INSTANCE).build();
        Intrinsics.checkNotNull((Object)retrofit);
        Retrofit $this$create$iv = retrofit;
        boolean $i$f$create = false;
        Object object = $this$create$iv.create(DucklingService.class);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"create(...)");
        service = (DucklingService)object;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\bf\u0018\u00002\u00020\u0001J\u0018\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\b\b\u0001\u0010\u0005\u001a\u00020\u0006H'J\u000e\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\b0\u0003H'\u00a8\u0006\t\u00c0\u0006\u0003"}, d2={"Lai/tock/duckling/client/DucklingClient$DucklingService;", "", "parse", "Lretrofit2/Call;", "Lai/tock/duckling/client/JSONValue;", "request", "Lai/tock/duckling/client/DucklingClient$ParseRequest;", "healthcheck", "Ljava/lang/Void;", "tock-nlp-duckling-client"})
    public static interface DucklingService {
        @POST(value="parse")
        @NotNull
        public Call<JSONValue> parse(@Body @NotNull ParseRequest var1);

        @GET(value="healthcheck")
        @NotNull
        public Call<Void> healthcheck();
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u00c6\u0002\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00032\u0006\u0010\u0007\u001a\u00020\u0002H\u0016\u00a8\u0006\b"}, d2={"Lai/tock/duckling/client/DucklingClient$JacksonJsonArrayConverter;", "Lretrofit2/Converter;", "Lokhttp3/ResponseBody;", "Lai/tock/duckling/client/JSONValue;", "<init>", "()V", "convert", "value", "tock-nlp-duckling-client"})
    public static final class JacksonJsonArrayConverter
    implements Converter<ResponseBody, JSONValue> {
        @NotNull
        public static final JacksonJsonArrayConverter INSTANCE = new JacksonJsonArrayConverter();

        private JacksonJsonArrayConverter() {
        }

        @NotNull
        public JSONValue convert(@NotNull ResponseBody value) {
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            return new JSONValue(new JsonArray(value.string()));
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0013\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B5\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00030\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u0003\u00a2\u0006\u0004\b\u000b\u0010\fJ\t\u0010\u0016\u001a\u00020\u0003H\u00c6\u0003J\u000f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00030\u0005H\u00c6\u0003J\t\u0010\u0018\u001a\u00020\u0007H\u00c6\u0003J\t\u0010\u0019\u001a\u00020\tH\u00c6\u0003J\t\u0010\u001a\u001a\u00020\u0003H\u00c6\u0003JA\u0010\u001b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\u000e\b\u0002\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00030\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00072\b\b\u0002\u0010\b\u001a\u00020\t2\b\b\u0002\u0010\n\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\u001c\u001a\u00020\u001d2\b\u0010\u001e\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u001f\u001a\u00020 H\u00d6\u0001J\t\u0010!\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00030\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0011\u0010\n\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u000e\u00a8\u0006\""}, d2={"Lai/tock/duckling/client/DucklingClient$ParseRequest;", "", "language", "", "dimensions", "", "referenceDate", "Ljava/time/ZonedDateTime;", "referenceTimezone", "Ljava/time/ZoneId;", "textToParse", "<init>", "(Ljava/lang/String;Ljava/util/List;Ljava/time/ZonedDateTime;Ljava/time/ZoneId;Ljava/lang/String;)V", "getLanguage", "()Ljava/lang/String;", "getDimensions", "()Ljava/util/List;", "getReferenceDate", "()Ljava/time/ZonedDateTime;", "getReferenceTimezone", "()Ljava/time/ZoneId;", "getTextToParse", "component1", "component2", "component3", "component4", "component5", "copy", "equals", "", "other", "hashCode", "", "toString", "tock-nlp-duckling-client"})
    public static final class ParseRequest {
        @NotNull
        private final String language;
        @NotNull
        private final List<String> dimensions;
        @NotNull
        private final ZonedDateTime referenceDate;
        @NotNull
        private final ZoneId referenceTimezone;
        @NotNull
        private final String textToParse;

        public ParseRequest(@NotNull String language, @NotNull List<String> dimensions, @NotNull ZonedDateTime referenceDate, @NotNull ZoneId referenceTimezone, @NotNull String textToParse) {
            Intrinsics.checkNotNullParameter((Object)language, (String)"language");
            Intrinsics.checkNotNullParameter(dimensions, (String)"dimensions");
            Intrinsics.checkNotNullParameter((Object)referenceDate, (String)"referenceDate");
            Intrinsics.checkNotNullParameter((Object)referenceTimezone, (String)"referenceTimezone");
            Intrinsics.checkNotNullParameter((Object)textToParse, (String)"textToParse");
            this.language = language;
            this.dimensions = dimensions;
            this.referenceDate = referenceDate;
            this.referenceTimezone = referenceTimezone;
            this.textToParse = textToParse;
        }

        @NotNull
        public final String getLanguage() {
            return this.language;
        }

        @NotNull
        public final List<String> getDimensions() {
            return this.dimensions;
        }

        @NotNull
        public final ZonedDateTime getReferenceDate() {
            return this.referenceDate;
        }

        @NotNull
        public final ZoneId getReferenceTimezone() {
            return this.referenceTimezone;
        }

        @NotNull
        public final String getTextToParse() {
            return this.textToParse;
        }

        @NotNull
        public final String component1() {
            return this.language;
        }

        @NotNull
        public final List<String> component2() {
            return this.dimensions;
        }

        @NotNull
        public final ZonedDateTime component3() {
            return this.referenceDate;
        }

        @NotNull
        public final ZoneId component4() {
            return this.referenceTimezone;
        }

        @NotNull
        public final String component5() {
            return this.textToParse;
        }

        @NotNull
        public final ParseRequest copy(@NotNull String language, @NotNull List<String> dimensions, @NotNull ZonedDateTime referenceDate, @NotNull ZoneId referenceTimezone, @NotNull String textToParse) {
            Intrinsics.checkNotNullParameter((Object)language, (String)"language");
            Intrinsics.checkNotNullParameter(dimensions, (String)"dimensions");
            Intrinsics.checkNotNullParameter((Object)referenceDate, (String)"referenceDate");
            Intrinsics.checkNotNullParameter((Object)referenceTimezone, (String)"referenceTimezone");
            Intrinsics.checkNotNullParameter((Object)textToParse, (String)"textToParse");
            return new ParseRequest(language, dimensions, referenceDate, referenceTimezone, textToParse);
        }

        public static /* synthetic */ ParseRequest copy$default(ParseRequest parseRequest, String string, List list, ZonedDateTime zonedDateTime, ZoneId zoneId, String string2, int n, Object object) {
            if ((n & 1) != 0) {
                string = parseRequest.language;
            }
            if ((n & 2) != 0) {
                list = parseRequest.dimensions;
            }
            if ((n & 4) != 0) {
                zonedDateTime = parseRequest.referenceDate;
            }
            if ((n & 8) != 0) {
                zoneId = parseRequest.referenceTimezone;
            }
            if ((n & 0x10) != 0) {
                string2 = parseRequest.textToParse;
            }
            return parseRequest.copy(string, list, zonedDateTime, zoneId, string2);
        }

        @NotNull
        public String toString() {
            return "ParseRequest(language=" + this.language + ", dimensions=" + this.dimensions + ", referenceDate=" + this.referenceDate + ", referenceTimezone=" + this.referenceTimezone + ", textToParse=" + this.textToParse + ")";
        }

        public int hashCode() {
            int result = this.language.hashCode();
            result = result * 31 + ((Object)this.dimensions).hashCode();
            result = result * 31 + this.referenceDate.hashCode();
            result = result * 31 + this.referenceTimezone.hashCode();
            result = result * 31 + this.textToParse.hashCode();
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof ParseRequest)) {
                return false;
            }
            ParseRequest parseRequest = (ParseRequest)other;
            if (!Intrinsics.areEqual((Object)this.language, (Object)parseRequest.language)) {
                return false;
            }
            if (!Intrinsics.areEqual(this.dimensions, parseRequest.dimensions)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.referenceDate, (Object)parseRequest.referenceDate)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.referenceTimezone, (Object)parseRequest.referenceTimezone)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.textToParse, (Object)parseRequest.textToParse);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0010\u001b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J7\u0010\u0004\u001a\f\u0012\u0004\u0012\u00020\u0006\u0012\u0002\b\u00030\u00052\u0006\u0010\u0007\u001a\u00020\b2\u000e\u0010\t\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u000b0\n2\u0006\u0010\f\u001a\u00020\rH\u0016\u00a2\u0006\u0002\u0010\u000eJI\u0010\u000f\u001a\u000e\u0012\u0002\b\u0003\u0012\u0004\u0012\u00020\u0010\u0018\u00010\u00052\u0006\u0010\u0007\u001a\u00020\b2\u000e\u0010\u0011\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u000b0\n2\u000e\u0010\u0012\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u000b0\n2\u0006\u0010\f\u001a\u00020\rH\u0016\u00a2\u0006\u0002\u0010\u0013J9\u0010\u0014\u001a\u000e\u0012\u0002\b\u0003\u0012\u0004\u0012\u00020\u0015\u0018\u00010\u00052\u0006\u0010\u0007\u001a\u00020\b2\u000e\u0010\t\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u000b0\n2\u0006\u0010\f\u001a\u00020\rH\u0016\u00a2\u0006\u0002\u0010\u000e\u00a8\u0006\u0016"}, d2={"Lai/tock/duckling/client/DucklingClient$RawJsonBodyConverterFactory;", "Lretrofit2/Converter$Factory;", "<init>", "()V", "responseBodyConverter", "Lretrofit2/Converter;", "Lokhttp3/ResponseBody;", "type", "Ljava/lang/reflect/Type;", "annotations", "", "", "retrofit", "Lretrofit2/Retrofit;", "(Ljava/lang/reflect/Type;[Ljava/lang/annotation/Annotation;Lretrofit2/Retrofit;)Lretrofit2/Converter;", "requestBodyConverter", "Lokhttp3/RequestBody;", "parameterAnnotations", "methodAnnotations", "(Ljava/lang/reflect/Type;[Ljava/lang/annotation/Annotation;[Ljava/lang/annotation/Annotation;Lretrofit2/Retrofit;)Lretrofit2/Converter;", "stringConverter", "", "tock-nlp-duckling-client"})
    public static final class RawJsonBodyConverterFactory
    extends Converter.Factory {
        @NotNull
        public static final RawJsonBodyConverterFactory INSTANCE = new RawJsonBodyConverterFactory();

        private RawJsonBodyConverterFactory() {
        }

        @NotNull
        public Converter<ResponseBody, ?> responseBodyConverter(@NotNull Type type, @NotNull Annotation[] annotations, @NotNull Retrofit retrofit) {
            Intrinsics.checkNotNullParameter((Object)type, (String)"type");
            Intrinsics.checkNotNullParameter((Object)annotations, (String)"annotations");
            Intrinsics.checkNotNullParameter((Object)retrofit, (String)"retrofit");
            return JacksonJsonArrayConverter.INSTANCE;
        }

        @Nullable
        public Converter<?, RequestBody> requestBodyConverter(@NotNull Type type, @NotNull Annotation[] parameterAnnotations, @NotNull Annotation[] methodAnnotations, @NotNull Retrofit retrofit) {
            Intrinsics.checkNotNullParameter((Object)type, (String)"type");
            Intrinsics.checkNotNullParameter((Object)parameterAnnotations, (String)"parameterAnnotations");
            Intrinsics.checkNotNullParameter((Object)methodAnnotations, (String)"methodAnnotations");
            Intrinsics.checkNotNullParameter((Object)retrofit, (String)"retrofit");
            return jacksonConverterFactory.requestBodyConverter(type, parameterAnnotations, methodAnnotations, retrofit);
        }

        @Nullable
        public Converter<?, String> stringConverter(@NotNull Type type, @NotNull Annotation[] annotations, @NotNull Retrofit retrofit) {
            Intrinsics.checkNotNullParameter((Object)type, (String)"type");
            Intrinsics.checkNotNullParameter((Object)annotations, (String)"annotations");
            Intrinsics.checkNotNullParameter((Object)retrofit, (String)"retrofit");
            return jacksonConverterFactory.stringConverter(type, annotations, retrofit);
        }
    }
}

