/*
 * Decompiled with CFR 0.152.
 */
package ai.tock.duckling.client;

import ai.tock.duckling.client.DucklingDimensions;
import ai.tock.duckling.client.Parser;
import ai.tock.duckling.client.ValueWithRange;
import ai.tock.nlp.core.merge.ValueDescriptor;
import ai.tock.nlp.entity.date.DateEntityGrain;
import ai.tock.nlp.entity.date.DateEntityRange;
import ai.tock.nlp.entity.date.DateEntityValue;
import ai.tock.nlp.entity.date.DateIntervalEntityValue;
import ai.tock.nlp.model.EntityCallContextForEntity;
import ai.tock.shared.DatesKt;
import ai.tock.shared.IOCsKt;
import ai.tock.shared.LoggersKt;
import com.github.salomonbrys.kodein.InjectedProperty;
import com.github.salomonbrys.kodein.KodeinInjectedBase;
import com.github.salomonbrys.kodein.KodeinInjector;
import com.github.salomonbrys.kodein.TypeReference;
import com.github.salomonbrys.kodein.TypeToken;
import java.time.DayOfWeek;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.temporal.ChronoUnit;
import java.time.temporal.TemporalAdjusters;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.PropertyReference1;
import kotlin.jvm.internal.PropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KProperty;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import mu.KLogger;
import mu.KotlinLogging;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000j\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u00c0\u0002\u0018\u00002\u00020\u0001:\u00014B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\u0012\u001a\u00020\u0013*\u00020\u00142\b\b\u0002\u0010\u0015\u001a\u00020\u0016H\u0002J\u0016\u0010\u0017\u001a\u00020\u0013*\u00020\u00142\b\b\u0002\u0010\u0015\u001a\u00020\u0016H\u0002J\f\u0010\u0018\u001a\u00020\u0019*\u00020\u0014H\u0002J\f\u0010\u001a\u001a\u00020\u0019*\u00020\u0014H\u0002J\u001e\u0010\u001b\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u001c\u001a\u00020\u001d2\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u00140\u001fJ&\u0010 \u001a\u00020\u00142\u0006\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020\u00132\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u00140\u001fH\u0002J(\u0010$\u001a\u00020\u00142\u0006\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020\u00132\u0006\u0010%\u001a\u00020\u00142\u0006\u0010&\u001a\u00020\u0014H\u0002J\u0010\u0010'\u001a\u00020(2\u0006\u0010)\u001a\u00020(H\u0002J\u0010\u0010*\u001a\u00020+2\b\u0010,\u001a\u0004\u0018\u00010(J \u0010-\u001a\u0004\u0018\u00010.2\u0006\u0010!\u001a\u00020\"2\u0006\u0010%\u001a\u00020\u00142\u0006\u0010&\u001a\u00020\u0014J\u0018\u0010/\u001a\u00020+2\u0006\u0010!\u001a\u00020\"2\u0006\u0010&\u001a\u00020\u0014H\u0002J\u0018\u00100\u001a\u00020+2\u0006\u0010!\u001a\u00020\"2\u0006\u0010&\u001a\u00020\u0014H\u0002J\u001a\u00101\u001a\u0004\u0018\u00010.2\u0006\u0010!\u001a\u00020\"2\u0006\u0010&\u001a\u00020\u0014H\u0002J0\u00102\u001a\u00020\u00142\u0006\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020\u00132\u0006\u0010%\u001a\u00020\u00142\u0006\u0010&\u001a\u00020\u00142\u0006\u0010-\u001a\u00020.H\u0002J\"\u00102\u001a\u0004\u0018\u00010\u00142\u0006\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020\u00132\u0006\u00103\u001a\u00020(H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010\f\u001a\u00020\r8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0010\u0010\u0011\u001a\u0004\b\u000e\u0010\u000f\u00a8\u00065"}, d2={"Lai/tock/duckling/client/DatesMerge;", "", "<init>", "()V", "logger", "Lmu/KLogger;", "removeDuplicateSpaceRegexp", "Lkotlin/text/Regex;", "frenchAddRegex", "frenchChangeHourRegex", "frenchChangeDayInMonth", "frenchChangeDayInWeek", "parser", "Lai/tock/duckling/client/Parser;", "getParser", "()Lai/tock/duckling/client/Parser;", "parser$delegate", "Lcom/github/salomonbrys/kodein/InjectedProperty;", "start", "Ljava/time/ZonedDateTime;", "Lai/tock/nlp/core/merge/ValueDescriptor;", "zoneId", "Ljava/time/ZoneId;", "end", "grain", "Lai/tock/nlp/entity/date/DateEntityGrain;", "grainFromNow", "merge", "context", "Lai/tock/nlp/model/EntityCallContextForEntity;", "values", "", "concatEntityValues", "language", "Ljava/util/Locale;", "referenceDateTime", "mergeDateEntityValue", "oldValue", "newValue", "normalize", "", "s", "isChangeHourPattern", "", "content", "mergeGrain", "Lai/tock/duckling/client/DatesMerge$MergeGrain;", "hasToChangeDayInMonth", "hasToChangeDayInWeek", "hasToAdd", "parseDate", "text", "MergeGrain", "tock-nlp-duckling-client"})
@SourceDebugExtension(value={"SMAP\nDatesMerge.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DatesMerge.kt\nai/tock/duckling/client/DatesMerge\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 GInjected.kt\ncom/github/salomonbrys/kodein/GInjectedKt\n+ 5 types.kt\ncom/github/salomonbrys/kodein/TypesKt\n*L\n1#1,287:1\n295#2,2:288\n774#2:290\n865#2,2:291\n1563#2:293\n1634#2,3:294\n1056#2:297\n1563#2:298\n1634#2,3:299\n1999#2,14:302\n1999#2,14:316\n1#3:330\n80#4:331\n277#5:332\n*S KotlinDebug\n*F\n+ 1 DatesMerge.kt\nai/tock/duckling/client/DatesMerge\n*L\n89#1:288,2\n100#1:290\n100#1:291,2\n106#1:293\n106#1:294,3\n111#1:297\n111#1:298\n111#1:299,3\n113#1:302,14\n115#1:316,14\n-1#1:331\n-1#1:332\n*E\n"})
public final class DatesMerge {
    @NotNull
    public static final DatesMerge INSTANCE;
    static final /* synthetic */ KProperty<Object>[] $$delegatedProperties;
    @NotNull
    private static final KLogger logger;
    @NotNull
    private static final Regex removeDuplicateSpaceRegexp;
    @NotNull
    private static final Regex frenchAddRegex;
    @NotNull
    private static final Regex frenchChangeHourRegex;
    @NotNull
    private static final Regex frenchChangeDayInMonth;
    @NotNull
    private static final Regex frenchChangeDayInWeek;
    @NotNull
    private static final InjectedProperty parser$delegate;

    private DatesMerge() {
    }

    private final Parser getParser() {
        return (Parser)parser$delegate.getValue((Object)this, $$delegatedProperties[0]);
    }

    private final ZonedDateTime start(ValueDescriptor $this$start, ZoneId zoneId) {
        Object object = $this$start.getValue();
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type ai.tock.nlp.entity.date.DateEntityRange");
        ZonedDateTime zonedDateTime = ((DateEntityRange)object).start().withZoneSameInstant(zoneId);
        Intrinsics.checkNotNullExpressionValue((Object)zonedDateTime, (String)"withZoneSameInstant(...)");
        return zonedDateTime;
    }

    static /* synthetic */ ZonedDateTime start$default(DatesMerge datesMerge, ValueDescriptor valueDescriptor, ZoneId zoneId, int n, Object object) {
        if ((n & 1) != 0) {
            zoneId = DatesKt.getDefaultZoneId();
        }
        return datesMerge.start(valueDescriptor, zoneId);
    }

    private final ZonedDateTime end(ValueDescriptor $this$end, ZoneId zoneId) {
        Object object = $this$end.getValue();
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type ai.tock.nlp.entity.date.DateEntityRange");
        ZonedDateTime zonedDateTime = ((DateEntityRange)object).end().withZoneSameInstant(zoneId);
        Intrinsics.checkNotNullExpressionValue((Object)zonedDateTime, (String)"withZoneSameInstant(...)");
        return zonedDateTime;
    }

    static /* synthetic */ ZonedDateTime end$default(DatesMerge datesMerge, ValueDescriptor valueDescriptor, ZoneId zoneId, int n, Object object) {
        if ((n & 1) != 0) {
            zoneId = DatesKt.getDefaultZoneId();
        }
        return datesMerge.end(valueDescriptor, zoneId);
    }

    private final DateEntityGrain grain(ValueDescriptor $this$grain) {
        DateEntityGrain dateEntityGrain;
        Object $this$grain_u24lambda_u240 = $this$grain.getValue();
        boolean bl = false;
        Object object = $this$grain_u24lambda_u240;
        if (object instanceof DateEntityValue) {
            dateEntityGrain = ((DateEntityValue)$this$grain_u24lambda_u240).getGrain();
        } else if (object instanceof DateIntervalEntityValue) {
            dateEntityGrain = ((DateIntervalEntityValue)$this$grain_u24lambda_u240).getDate().getGrain();
        } else {
            throw new IllegalStateException(("unsupported value " + $this$grain_u24lambda_u240).toString());
        }
        return dateEntityGrain;
    }

    private final DateEntityGrain grainFromNow(ValueDescriptor $this$grainFromNow) {
        ZonedDateTime zonedDateTime = ZonedDateTime.now();
        Intrinsics.checkNotNullExpressionValue((Object)zonedDateTime, (String)"now(...)");
        return DateEntityGrain.Companion.maxGrain(zonedDateTime, DatesMerge.start$default(this, $this$grainFromNow, null, 1, null));
    }

    @Nullable
    public final ValueDescriptor merge(@NotNull EntityCallContextForEntity context, @NotNull List<ValueDescriptor> values) {
        ValueDescriptor valueDescriptor;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter(values, (String)"values");
        if (!Intrinsics.areEqual((Object)context.getEntityType().getName(), (Object)DucklingDimensions.INSTANCE.getDatetimeEntityType())) {
            logger.warn(() -> DatesMerge.merge$lambda$0(context));
            valueDescriptor = null;
        } else {
            Object v1;
            ValueDescriptor concatenated;
            block3: {
                concatenated = this.concatEntityValues(context.getLanguage(), context.getReferenceDate(), values);
                Iterable $this$firstOrNull$iv = values;
                boolean $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    ValueDescriptor it = (ValueDescriptor)element$iv;
                    boolean bl = false;
                    if (!it.getInitial()) continue;
                    v1 = element$iv;
                    break block3;
                }
                v1 = null;
            }
            ValueDescriptor initial = v1;
            valueDescriptor = initial == null ? concatenated : this.mergeDateEntityValue(context.getLanguage(), context.getReferenceDate(), initial, concatenated);
        }
        return valueDescriptor;
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final ValueDescriptor concatEntityValues(Locale language, ZonedDateTime referenceDateTime, List<ValueDescriptor> values) {
        ValueDescriptor valueDescriptor;
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv = values;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            ValueDescriptor it = (ValueDescriptor)element$iv$iv;
            boolean bl = false;
            if (!(!it.getInitial())) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List $this$concatEntityValues_u24lambda_u241 = (List)destination$iv$iv;
        boolean bl = false;
        switch ($this$concatEntityValues_u24lambda_u241.size()) {
            case 0: {
                throw new IllegalStateException("at least one non initial value should be present".toString());
            }
            case 1: {
                valueDescriptor = (ValueDescriptor)CollectionsKt.first((List)$this$concatEntityValues_u24lambda_u241);
                return valueDescriptor;
            }
            default: {
                Object v3;
                boolean differentGrain;
                Object object;
                void $this$mapTo$iv$iv;
                Iterable $this$map$iv = $this$concatEntityValues_u24lambda_u241;
                boolean $i$f$map = false;
                Iterable iterable2 = $this$map$iv;
                Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    ValueDescriptor valueDescriptor2 = (ValueDescriptor)item$iv$iv;
                    object = destination$iv$iv2;
                    boolean bl2 = false;
                    object.add(INSTANCE.grain((ValueDescriptor)it));
                }
                boolean bl3 = differentGrain = CollectionsKt.distinct((Iterable)((List)destination$iv$iv2)).size() == $this$concatEntityValues_u24lambda_u241.size();
                if (differentGrain) {
                    Object v2;
                    Collection<String> collection;
                    void $this$mapTo$iv$iv2;
                    void $this$map$iv2;
                    Iterable $this$sortedBy$iv = $this$concatEntityValues_u24lambda_u241;
                    boolean $i$f$sortedBy = false;
                    $this$sortedBy$iv = CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(){

                        public final int compare(T a, T b) {
                            ValueDescriptor it = (ValueDescriptor)a;
                            boolean bl = false;
                            Comparable comparable = it.getPosition();
                            it = (ValueDescriptor)b;
                            Comparable comparable2 = comparable;
                            bl = false;
                            return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)it.getPosition());
                        }
                    });
                    ZonedDateTime zonedDateTime = referenceDateTime;
                    Locale locale = language;
                    object = INSTANCE;
                    boolean $i$f$map2 = false;
                    destination$iv$iv2 = $this$map$iv2;
                    Collection destination$iv$iv3 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
                    boolean $i$f$mapTo2 = false;
                    for (Object item$iv$iv : $this$mapTo$iv$iv2) {
                        void it;
                        ValueDescriptor bl2 = (ValueDescriptor)item$iv$iv;
                        collection = destination$iv$iv3;
                        boolean bl4 = false;
                        collection.add(it.getContent());
                    }
                    collection = (List)destination$iv$iv3;
                    valueDescriptor = super.parseDate(locale, zonedDateTime, CollectionsKt.joinToString$default((Iterable)collection, (CharSequence)" ", null, null, (int)0, null, null, (int)62, null));
                    if (valueDescriptor != null) return valueDescriptor;
                    Iterable $this$maxByOrNull$iv = $this$concatEntityValues_u24lambda_u241;
                    boolean $i$f$maxByOrNull = false;
                    Iterator iterator$iv = $this$maxByOrNull$iv.iterator();
                    if (!iterator$iv.hasNext()) {
                        v2 = null;
                    } else {
                        Object maxElem$iv = iterator$iv.next();
                        if (!iterator$iv.hasNext()) {
                            v2 = maxElem$iv;
                        } else {
                            ValueDescriptor it = (ValueDescriptor)maxElem$iv;
                            boolean bl5 = false;
                            double maxValue$iv = it.getProbability();
                            do {
                                Object e$iv = iterator$iv.next();
                                ValueDescriptor it2 = (ValueDescriptor)e$iv;
                                $i$a$-maxByOrNull-DatesMerge$concatEntityValues$2$3 = false;
                                double v$iv = it2.getProbability();
                                if (Double.compare(maxValue$iv, v$iv) >= 0) continue;
                                maxElem$iv = e$iv;
                                maxValue$iv = v$iv;
                            } while (iterator$iv.hasNext());
                            v2 = maxElem$iv;
                        }
                    }
                    Intrinsics.checkNotNull(v2);
                    valueDescriptor = v2;
                    return valueDescriptor;
                }
                Iterable $this$maxByOrNull$iv = $this$concatEntityValues_u24lambda_u241;
                boolean $i$f$maxByOrNull = false;
                Iterator iterator$iv = $this$maxByOrNull$iv.iterator();
                if (!iterator$iv.hasNext()) {
                    v3 = null;
                } else {
                    Object maxElem$iv = iterator$iv.next();
                    if (!iterator$iv.hasNext()) {
                        v3 = maxElem$iv;
                    } else {
                        ValueDescriptor it = (ValueDescriptor)maxElem$iv;
                        boolean bl6 = false;
                        double maxValue$iv = it.getProbability();
                        do {
                            Object e$iv = iterator$iv.next();
                            ValueDescriptor it3 = (ValueDescriptor)e$iv;
                            $i$a$-maxByOrNull-DatesMerge$concatEntityValues$2$4 = false;
                            double v$iv = it3.getProbability();
                            if (Double.compare(maxValue$iv, v$iv) >= 0) continue;
                            maxElem$iv = e$iv;
                            maxValue$iv = v$iv;
                        } while (iterator$iv.hasNext());
                        v3 = maxElem$iv;
                    }
                }
                Intrinsics.checkNotNull(v3);
                valueDescriptor = v3;
            }
        }
        return valueDescriptor;
    }

    private final ValueDescriptor mergeDateEntityValue(Locale language, ZonedDateTime referenceDateTime, ValueDescriptor oldValue, ValueDescriptor newValue) {
        try {
            MergeGrain mergeGrain;
            MergeGrain mergeGrain2;
            ZonedDateTime zonedDateTime;
            String newValueContent;
            ZoneId zoneId = referenceDateTime.getZone();
            if (this.hasToChangeDayInMonth(language, newValue)) {
                String string = newValue.getContent();
                Intrinsics.checkNotNull((Object)string);
                newValueContent = this.normalize(string);
                Intrinsics.checkNotNull((Object)zoneId);
                ZonedDateTime $this$mergeDateEntityValue_u24lambda_u240 = zonedDateTime = this.start(oldValue, zoneId);
                boolean bl = false;
                int n = $this$mergeDateEntityValue_u24lambda_u240.getYear();
                int n2 = $this$mergeDateEntityValue_u24lambda_u240.getMonthValue();
                String string2 = newValueContent.substring(3);
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
                ZonedDateTime zonedDateTime2 = ZonedDateTime.of(n, n2, Integer.parseInt(string2), 0, 0, 0, 0, $this$mergeDateEntityValue_u24lambda_u240.getZone());
                Intrinsics.checkNotNullExpressionValue((Object)zonedDateTime2, (String)"of(...)");
                ValueDescriptor newResult = new ValueDescriptor((Object)new DateEntityValue(zonedDateTime2, DateEntityGrain.day), newValue.getContent(), false, null, 0.0, 28, null);
                if (INSTANCE.start(newResult, zoneId).truncatedTo(ChronoUnit.DAYS).compareTo(referenceDateTime.truncatedTo(ChronoUnit.DAYS)) >= 0) {
                    return newResult;
                }
            }
            if (this.hasToChangeDayInWeek(language, newValue)) {
                DateEntityValue dateEntityValue;
                String string = newValue.getContent();
                Intrinsics.checkNotNull((Object)string);
                newValueContent = this.normalize(string);
                Intrinsics.checkNotNull((Object)zoneId);
                ZonedDateTime $this$mergeDateEntityValue_u24lambda_u241 = zonedDateTime = this.start(oldValue, zoneId);
                boolean bl = false;
                int oldDayOfWeek = $this$mergeDateEntityValue_u24lambda_u241.getDayOfWeek().getValue();
                int newDayOfWeek = StringsKt.contains$default((CharSequence)newValueContent, (CharSequence)"lundi", (boolean)false, (int)2, null) ? 1 : (StringsKt.contains$default((CharSequence)newValueContent, (CharSequence)"mardi", (boolean)false, (int)2, null) ? 2 : (StringsKt.contains$default((CharSequence)newValueContent, (CharSequence)"mercredi", (boolean)false, (int)2, null) ? 3 : (StringsKt.contains$default((CharSequence)newValueContent, (CharSequence)"jeudi", (boolean)false, (int)2, null) ? 4 : (StringsKt.contains$default((CharSequence)newValueContent, (CharSequence)"vendredi", (boolean)false, (int)2, null) ? 5 : (StringsKt.contains$default((CharSequence)newValueContent, (CharSequence)"samedi", (boolean)false, (int)2, null) ? 6 : (StringsKt.contains$default((CharSequence)newValueContent, (CharSequence)"dimanche", (boolean)false, (int)2, null) ? 7 : oldDayOfWeek))))));
                ZonedDateTime zonedDateTime3 = INSTANCE.start(oldValue, zoneId).with(TemporalAdjusters.previous(DayOfWeek.of(newDayOfWeek))).truncatedTo(ChronoUnit.DAYS);
                Intrinsics.checkNotNullExpressionValue((Object)zonedDateTime3, (String)"truncatedTo(...)");
                DateEntityValue previous = new DateEntityValue(zonedDateTime3, DateEntityGrain.day);
                if (oldDayOfWeek == newDayOfWeek) {
                    ZonedDateTime zonedDateTime4 = INSTANCE.start(oldValue, zoneId).truncatedTo(ChronoUnit.DAYS);
                    Intrinsics.checkNotNullExpressionValue((Object)zonedDateTime4, (String)"truncatedTo(...)");
                    DateEntityValue dateEntityValue2 = new DateEntityValue(zonedDateTime4, DateEntityGrain.day);
                    dateEntityValue = dateEntityValue2;
                } else if (oldDayOfWeek < newDayOfWeek || newDayOfWeek == 7 || previous.start().withZoneSameInstant(zoneId).truncatedTo(ChronoUnit.DAYS).compareTo(referenceDateTime.truncatedTo(ChronoUnit.DAYS)) < 0) {
                    ZonedDateTime zonedDateTime5 = INSTANCE.start(oldValue, zoneId).with(TemporalAdjusters.next(DayOfWeek.of(newDayOfWeek))).truncatedTo(ChronoUnit.DAYS);
                    Intrinsics.checkNotNullExpressionValue((Object)zonedDateTime5, (String)"truncatedTo(...)");
                    DateEntityValue dateEntityValue3 = new DateEntityValue(zonedDateTime5, DateEntityGrain.day);
                    dateEntityValue = dateEntityValue3;
                } else {
                    dateEntityValue = previous;
                }
                ValueDescriptor newResult = new ValueDescriptor((Object)dateEntityValue, newValue.getContent(), false, null, 0.0, 28, null);
                if (INSTANCE.start(newResult, zoneId).truncatedTo(ChronoUnit.DAYS).compareTo(referenceDateTime.truncatedTo(ChronoUnit.DAYS)) >= 0) {
                    return newResult;
                }
            }
            if ((mergeGrain2 = this.hasToAdd(language, newValue)) == null) {
                mergeGrain2 = this.mergeGrain(language, oldValue, newValue);
            }
            if ((mergeGrain = mergeGrain2) != null) {
                return this.parseDate(language, referenceDateTime, oldValue, newValue, mergeGrain);
            }
        }
        catch (Exception e) {
            LoggersKt.error((KLogger)logger, (Throwable)e);
        }
        return newValue;
    }

    private final String normalize(String s) {
        CharSequence charSequence = ((Object)StringsKt.trim((CharSequence)s)).toString();
        Regex regex = removeDuplicateSpaceRegexp;
        String string = " ";
        String string2 = regex.replace(charSequence, string).toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toLowerCase(...)");
        return string2;
    }

    public final boolean isChangeHourPattern(@Nullable String content) {
        return content != null && frenchChangeHourRegex.matches((CharSequence)this.normalize(content));
    }

    @Nullable
    public final MergeGrain mergeGrain(@NotNull Locale language, @NotNull ValueDescriptor oldValue, @NotNull ValueDescriptor newValue) {
        Intrinsics.checkNotNullParameter((Object)language, (String)"language");
        Intrinsics.checkNotNullParameter((Object)oldValue, (String)"oldValue");
        Intrinsics.checkNotNullParameter((Object)newValue, (String)"newValue");
        return DatesMerge.end$default(this, oldValue, null, 1, null).compareTo(ZonedDateTime.now()) < 0 ? null : (Intrinsics.areEqual((Object)language.getLanguage(), (Object)"fr") && this.isChangeHourPattern(newValue.getContent()) ? new MergeGrain(false, DateEntityGrain.day) : (this.grain(oldValue).compareTo((Enum)this.grain(newValue)) > 0 && this.grain(oldValue).calculateEnd(DatesMerge.start$default(this, newValue, null, 1, null), DatesKt.getDefaultZoneId()).compareTo(DatesMerge.end$default(this, newValue, null, 1, null)) >= 0 ? null : null));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean hasToChangeDayInMonth(Locale language, ValueDescriptor newValue) {
        if (!Intrinsics.areEqual((Object)language.getLanguage(), (Object)"fr")) return false;
        if (newValue.getContent() == null) return false;
        String string = newValue.getContent();
        Intrinsics.checkNotNull((Object)string);
        if (!frenchChangeDayInMonth.matches((CharSequence)this.normalize(string))) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean hasToChangeDayInWeek(Locale language, ValueDescriptor newValue) {
        if (!Intrinsics.areEqual((Object)language.getLanguage(), (Object)"fr")) return false;
        if (newValue.getContent() == null) return false;
        String string = newValue.getContent();
        Intrinsics.checkNotNull((Object)string);
        if (!frenchChangeDayInWeek.matches((CharSequence)this.normalize(string))) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final MergeGrain hasToAdd(Locale language, ValueDescriptor newValue) {
        if (!Intrinsics.areEqual((Object)language.getLanguage(), (Object)"fr")) {
            logger.warn(DatesMerge::hasToAdd$lambda$0);
            return null;
        }
        boolean bl = true;
        boolean basicSupport = bl;
        if (!basicSupport) return null;
        if (newValue.getContent() == null) return null;
        String string = newValue.getContent();
        Intrinsics.checkNotNull((Object)string);
        if (!frenchAddRegex.matches((CharSequence)this.normalize(string))) return null;
        MergeGrain mergeGrain = new MergeGrain(true, this.grain(newValue));
        return mergeGrain;
    }

    private final ValueDescriptor parseDate(Locale language, ZonedDateTime referenceDateTime, ValueDescriptor oldValue, ValueDescriptor newValue, MergeGrain mergeGrain) {
        ValueDescriptor valueDescriptor;
        String dateText = newValue.getContent();
        ZonedDateTime start = DatesMerge.parseDate$startWithZone(oldValue, referenceDateTime);
        if (dateText != null) {
            ZonedDateTime referenceDate = mergeGrain.getAdditional() ? start : mergeGrain.getGrain().truncate(start);
            valueDescriptor = this.parseDate(language, referenceDate, dateText);
            if (valueDescriptor == null) {
                valueDescriptor = newValue;
            }
        } else {
            valueDescriptor = newValue;
        }
        return valueDescriptor;
    }

    private final ValueDescriptor parseDate(Locale language, ZonedDateTime referenceDateTime, String text) {
        ValueDescriptor valueDescriptor;
        Parser parser = this.getParser();
        String string = language.getLanguage();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getLanguage(...)");
        ValueWithRange valueWithRange = (ValueWithRange)CollectionsKt.firstOrNull(parser.parse(string, "time", referenceDateTime, text));
        if (valueWithRange != null) {
            ValueWithRange $this$parseDate_u24lambda_u240 = valueWithRange;
            boolean bl = false;
            valueDescriptor = new ValueDescriptor((Object)$this$parseDate_u24lambda_u240.getValue(), text, false, null, 0.0, 28, null);
        } else {
            valueDescriptor = null;
        }
        return valueDescriptor;
    }

    private static final Unit logger$lambda$0() {
        return Unit.INSTANCE;
    }

    private static final Object merge$lambda$0(EntityCallContextForEntity $context) {
        return "merge not supported for " + $context;
    }

    private static final Object hasToAdd$lambda$0() {
        return "only fr supported for add merge";
    }

    private static final ZonedDateTime parseDate$startWithZone(ValueDescriptor $this$parseDate_u24startWithZone, ZonedDateTime $referenceDateTime) {
        ZonedDateTime zonedDateTime = DatesMerge.start$default(INSTANCE, $this$parseDate_u24startWithZone, null, 1, null).withZoneSameInstant($referenceDateTime.getZone());
        Intrinsics.checkNotNullExpressionValue((Object)zonedDateTime, (String)"withZoneSameInstant(...)");
        return zonedDateTime;
    }

    static {
        KProperty[] kPropertyArray = new KProperty[]{Reflection.property1((PropertyReference1)((PropertyReference1)new PropertyReference1Impl(DatesMerge.class, "parser", "getParser()Lai/tock/duckling/client/Parser;", 0)))};
        $$delegatedProperties = kPropertyArray;
        INSTANCE = new DatesMerge();
        logger = KotlinLogging.INSTANCE.logger(DatesMerge::logger$lambda$0);
        removeDuplicateSpaceRegexp = new Regex("\\s+");
        frenchAddRegex = new Regex(".*prochaine?$|.*suivante?$|.*qui suit$|.*(d')? ?apr[e\u00e8\u00e9]s$|.*plus tard$|.*derni[\u00e8e]re?$|.*pass[\u00e9e]e?$|.*pr[e\u00e9]c[e\u00e9]dente?$|.*(d')? ?avant$|.*plus t[o\u00f4]t$|lendemain|le lendemain|la veille|ce jour|(le |la )?m[e\u00ea]me jour(n[e\u00e9]e)?");
        frenchChangeHourRegex = new Regex("(dans )?(le |la |en |(en )?fin de |(en )?d[\u00e9e]but de |(en )?milieu de )?soir[\u00e9e]?e?|(dans )?(le |la |en |(en )?fin de |(en )?d[\u00e9e]but de |(en )?milieu de )?mat(in[\u00e9e]?e?)?|(dans )?(l. ?|(en )?fin d. ?|(en )?d[\u00e9e]but d. ?|(en )?milieu d. ?)?apr[e\u00e9\u00e8](s?[ \\-]?midi|m)|([a\u00e0]|vers|apr(e|\u00e8)s|[a\u00e0] partir de|avant|jusqu'[a\u00e0])? ?((([01]?\\d)|(2[0-3]))([:h]|heures?)?([0-5]\\d)?)(du|dans l[ae']? ?|au|en|l[ae'] ?|d\u00e8s l?[ae']? ?|(en )?d[\u00e9e]but (de |d' ?)|(en )?fin (de |d' ?)|(en )?d[\u00e9e]but (d' ?|de ))?(mat(in[\u00e9e]?e?)|soir[\u00e9e]?e?|apr[e\u00e9\u00e8]s?[ \\-]?midi|journ[\u00e9e]e)?|entre ?((([01]?\\d)|(2[0-3]))([:h]|heures?)?([0-5]\\d)?)(du|dans l[ae']? ?|au|en|l[ae'] ?|d\u00e8s l?[ae']? ?|(en )?d[\u00e9e]but (de |d' ?)|(en )?fin (de |d' ?)|(en )?d[\u00e9e]but (d' ?|de ))?(mat(in[\u00e9e]?e?)|soir[\u00e9e]?e?|apr[e\u00e9\u00e8]s?[ \\-]?midi|journ[\u00e9e]e)? et .*");
        frenchChangeDayInMonth = new Regex("le \\d?\\d");
        frenchChangeDayInWeek = new Regex("(le )?(lundi|mardi|mercredi|jeudi|vendredi|samedi|dimanche)");
        KodeinInjectedBase $receiver$iv = (KodeinInjectedBase)IOCsKt.getInjector();
        Object tag$iv = null;
        KodeinInjector kodeinInjector = $receiver$iv.getInjector();
        parser$delegate = kodeinInjector.Instance((TypeToken)new TypeReference<Parser>(){}, tag$iv);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\t\u0010\f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\r\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\u000e\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u000f\u001a\u00020\u00032\b\u0010\u0010\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0011\u001a\u00020\u0012H\u00d6\u0001J\t\u0010\u0013\u001a\u00020\u0014H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0015"}, d2={"Lai/tock/duckling/client/DatesMerge$MergeGrain;", "", "additional", "", "grain", "Lai/tock/nlp/entity/date/DateEntityGrain;", "<init>", "(ZLai/tock/nlp/entity/date/DateEntityGrain;)V", "getAdditional", "()Z", "getGrain", "()Lai/tock/nlp/entity/date/DateEntityGrain;", "component1", "component2", "copy", "equals", "other", "hashCode", "", "toString", "", "tock-nlp-duckling-client"})
    public static final class MergeGrain {
        private final boolean additional;
        @NotNull
        private final DateEntityGrain grain;

        public MergeGrain(boolean additional, @NotNull DateEntityGrain grain) {
            Intrinsics.checkNotNullParameter((Object)grain, (String)"grain");
            this.additional = additional;
            this.grain = grain;
        }

        public final boolean getAdditional() {
            return this.additional;
        }

        @NotNull
        public final DateEntityGrain getGrain() {
            return this.grain;
        }

        public final boolean component1() {
            return this.additional;
        }

        @NotNull
        public final DateEntityGrain component2() {
            return this.grain;
        }

        @NotNull
        public final MergeGrain copy(boolean additional, @NotNull DateEntityGrain grain) {
            Intrinsics.checkNotNullParameter((Object)grain, (String)"grain");
            return new MergeGrain(additional, grain);
        }

        public static /* synthetic */ MergeGrain copy$default(MergeGrain mergeGrain, boolean bl, DateEntityGrain dateEntityGrain, int n, Object object) {
            if ((n & 1) != 0) {
                bl = mergeGrain.additional;
            }
            if ((n & 2) != 0) {
                dateEntityGrain = mergeGrain.grain;
            }
            return mergeGrain.copy(bl, dateEntityGrain);
        }

        @NotNull
        public String toString() {
            return "MergeGrain(additional=" + this.additional + ", grain=" + this.grain + ")";
        }

        public int hashCode() {
            int result = Boolean.hashCode(this.additional);
            result = result * 31 + this.grain.hashCode();
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof MergeGrain)) {
                return false;
            }
            MergeGrain mergeGrain = (MergeGrain)other;
            if (this.additional != mergeGrain.additional) {
                return false;
            }
            return this.grain == mergeGrain.grain;
        }
    }
}

