/*
 * Decompiled with CFR 0.152.
 */
package ai.tock.nlp.core.sample;

import ai.tock.nlp.core.Entity;
import ai.tock.nlp.core.EntityType;
import ai.tock.nlp.core.Intent;
import ai.tock.nlp.core.sample.SampleContext;
import ai.tock.nlp.core.sample.SampleEntity;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B1\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u000e\b\u0002\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u0012\b\b\u0002\u0010\t\u001a\u00020\n\u00a2\u0006\u0004\b\u000b\u0010\fJ\u0014\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00030\u00072\u0006\u0010\u0016\u001a\u00020\u0017J\u000e\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001bJ\t\u0010\u001c\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u001d\u001a\u00020\u0005H\u00c6\u0003J\u000f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\b0\u0007H\u00c6\u0003J\t\u0010\u001f\u001a\u00020\nH\u00c6\u0003J7\u0010 \u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\u000e\b\u0002\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\b\b\u0002\u0010\t\u001a\u00020\nH\u00c6\u0001J\u0013\u0010!\u001a\u00020\u00192\b\u0010\"\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010#\u001a\u00020$H\u00d6\u0001J\t\u0010%\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0017\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014\u00a8\u0006&"}, d2={"Lai/tock/nlp/core/sample/SampleExpression;", "", "text", "", "intent", "Lai/tock/nlp/core/Intent;", "entities", "", "Lai/tock/nlp/core/sample/SampleEntity;", "context", "Lai/tock/nlp/core/sample/SampleContext;", "<init>", "(Ljava/lang/String;Lai/tock/nlp/core/Intent;Ljava/util/List;Lai/tock/nlp/core/sample/SampleContext;)V", "getText", "()Ljava/lang/String;", "getIntent", "()Lai/tock/nlp/core/Intent;", "getEntities", "()Ljava/util/List;", "getContext", "()Lai/tock/nlp/core/sample/SampleContext;", "entityValues", "def", "Lai/tock/nlp/core/Entity;", "containsEntityType", "", "entityType", "Lai/tock/nlp/core/EntityType;", "component1", "component2", "component3", "component4", "copy", "equals", "other", "hashCode", "", "toString", "tock-nlp-core-shared"})
@SourceDebugExtension(value={"SMAP\nSampleExpression.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SampleExpression.kt\nai/tock/nlp/core/sample/SampleExpression\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,43:1\n774#2:44\n865#2,2:45\n1563#2:47\n1634#2,3:48\n1761#2,3:51\n*S KotlinDebug\n*F\n+ 1 SampleExpression.kt\nai/tock/nlp/core/sample/SampleExpression\n*L\n35#1:44\n35#1:45,2\n36#1:47\n36#1:48,3\n40#1:51,3\n*E\n"})
public final class SampleExpression {
    @NotNull
    private final String text;
    @NotNull
    private final Intent intent;
    @NotNull
    private final List<SampleEntity> entities;
    @NotNull
    private final SampleContext context;

    public SampleExpression(@NotNull String text, @NotNull Intent intent, @NotNull List<SampleEntity> entities, @NotNull SampleContext context) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        Intrinsics.checkNotNullParameter((Object)intent, (String)"intent");
        Intrinsics.checkNotNullParameter(entities, (String)"entities");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this.text = text;
        this.intent = intent;
        this.entities = entities;
        this.context = context;
    }

    public /* synthetic */ SampleExpression(String string, Intent intent, List list, SampleContext sampleContext, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            list = CollectionsKt.emptyList();
        }
        if ((n & 8) != 0) {
            sampleContext = new SampleContext(null, 1, null);
        }
        this(string, intent, list, sampleContext);
    }

    @NotNull
    public final String getText() {
        return this.text;
    }

    @NotNull
    public final Intent getIntent() {
        return this.intent;
    }

    @NotNull
    public final List<SampleEntity> getEntities() {
        return this.entities;
    }

    @NotNull
    public final SampleContext getContext() {
        return this.context;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<String> entityValues(@NotNull Entity def) {
        void $this$mapTo$iv$iv;
        SampleEntity it;
        Iterable $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)def, (String)"def");
        Iterable $this$filter$iv = this.entities;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (SampleEntity)element$iv$iv;
            boolean bl = false;
            if (!Intrinsics.areEqual((Object)it.getDefinition(), (Object)def)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$map$iv = (List)destination$iv$iv;
        boolean $i$f$map = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            it = (SampleEntity)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            String string = this.text.substring(it.getStart(), it.getEnd());
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
            collection.add(string);
        }
        return (List)destination$iv$iv;
    }

    public final boolean containsEntityType(@NotNull EntityType entityType) {
        boolean bl;
        block3: {
            Intrinsics.checkNotNullParameter((Object)entityType, (String)"entityType");
            Iterable $this$any$iv = this.entities;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    SampleEntity it = (SampleEntity)element$iv;
                    boolean bl2 = false;
                    if (!it.isType(entityType)) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }

    @NotNull
    public final String component1() {
        return this.text;
    }

    @NotNull
    public final Intent component2() {
        return this.intent;
    }

    @NotNull
    public final List<SampleEntity> component3() {
        return this.entities;
    }

    @NotNull
    public final SampleContext component4() {
        return this.context;
    }

    @NotNull
    public final SampleExpression copy(@NotNull String text, @NotNull Intent intent, @NotNull List<SampleEntity> entities, @NotNull SampleContext context) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        Intrinsics.checkNotNullParameter((Object)intent, (String)"intent");
        Intrinsics.checkNotNullParameter(entities, (String)"entities");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        return new SampleExpression(text, intent, entities, context);
    }

    public static /* synthetic */ SampleExpression copy$default(SampleExpression sampleExpression, String string, Intent intent, List list, SampleContext sampleContext, int n, Object object) {
        if ((n & 1) != 0) {
            string = sampleExpression.text;
        }
        if ((n & 2) != 0) {
            intent = sampleExpression.intent;
        }
        if ((n & 4) != 0) {
            list = sampleExpression.entities;
        }
        if ((n & 8) != 0) {
            sampleContext = sampleExpression.context;
        }
        return sampleExpression.copy(string, intent, list, sampleContext);
    }

    @NotNull
    public String toString() {
        return "SampleExpression(text=" + this.text + ", intent=" + this.intent + ", entities=" + this.entities + ", context=" + this.context + ")";
    }

    public int hashCode() {
        int result = this.text.hashCode();
        result = result * 31 + this.intent.hashCode();
        result = result * 31 + ((Object)this.entities).hashCode();
        result = result * 31 + this.context.hashCode();
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof SampleExpression)) {
            return false;
        }
        SampleExpression sampleExpression = (SampleExpression)other;
        if (!Intrinsics.areEqual((Object)this.text, (Object)sampleExpression.text)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.intent, (Object)sampleExpression.intent)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.entities, sampleExpression.entities)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.context, (Object)sampleExpression.context);
    }
}

