/*
 * Decompiled with CFR 0.152.
 */
package ai.tock.nlp.core.sample;

import ai.tock.nlp.core.Entity;
import ai.tock.nlp.core.EntityType;
import ai.tock.nlp.core.IntOpenRange;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0010\b\n\u0002\b\u000b\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B-\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00000\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\u0007\u00a2\u0006\u0004\b\t\u0010\nJ\u000e\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015J\t\u0010\u0016\u001a\u00020\u0003H\u00c6\u0003J\u000f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00000\u0005H\u00c6\u0003J\t\u0010\u0018\u001a\u00020\u0007H\u00c6\u0003J\t\u0010\u0019\u001a\u00020\u0007H\u00c6\u0003J7\u0010\u001a\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\u000e\b\u0002\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00000\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00072\b\b\u0002\u0010\b\u001a\u00020\u0007H\u00c6\u0001J\u0013\u0010\u001b\u001a\u00020\u00132\b\u0010\u001c\u001a\u0004\u0018\u00010\u001dH\u00d6\u0003J\t\u0010\u001e\u001a\u00020\u0007H\u00d6\u0001J\t\u0010\u001f\u001a\u00020 H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00000\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0014\u0010\u0006\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0014\u0010\b\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0010\u00a8\u0006!"}, d2={"Lai/tock/nlp/core/sample/SampleEntity;", "Lai/tock/nlp/core/IntOpenRange;", "definition", "Lai/tock/nlp/core/Entity;", "subEntities", "", "start", "", "end", "<init>", "(Lai/tock/nlp/core/Entity;Ljava/util/List;II)V", "getDefinition", "()Lai/tock/nlp/core/Entity;", "getSubEntities", "()Ljava/util/List;", "getStart", "()I", "getEnd", "isType", "", "entityType", "Lai/tock/nlp/core/EntityType;", "component1", "component2", "component3", "component4", "copy", "equals", "other", "", "hashCode", "toString", "", "tock-nlp-core-shared"})
public final class SampleEntity
implements IntOpenRange {
    @NotNull
    private final Entity definition;
    @NotNull
    private final List<SampleEntity> subEntities;
    private final int start;
    private final int end;

    public SampleEntity(@NotNull Entity definition, @NotNull List<SampleEntity> subEntities, int start, int end) {
        Intrinsics.checkNotNullParameter((Object)definition, (String)"definition");
        Intrinsics.checkNotNullParameter(subEntities, (String)"subEntities");
        this.definition = definition;
        this.subEntities = subEntities;
        this.start = start;
        this.end = end;
    }

    @NotNull
    public final Entity getDefinition() {
        return this.definition;
    }

    @NotNull
    public final List<SampleEntity> getSubEntities() {
        return this.subEntities;
    }

    @Override
    public int getStart() {
        return this.start;
    }

    @Override
    public int getEnd() {
        return this.end;
    }

    public final boolean isType(@NotNull EntityType entityType) {
        Intrinsics.checkNotNullParameter((Object)entityType, (String)"entityType");
        return Intrinsics.areEqual((Object)this.definition.getEntityType(), (Object)entityType);
    }

    @NotNull
    public final Entity component1() {
        return this.definition;
    }

    @NotNull
    public final List<SampleEntity> component2() {
        return this.subEntities;
    }

    public final int component3() {
        return this.start;
    }

    public final int component4() {
        return this.end;
    }

    @NotNull
    public final SampleEntity copy(@NotNull Entity definition, @NotNull List<SampleEntity> subEntities, int start, int end) {
        Intrinsics.checkNotNullParameter((Object)definition, (String)"definition");
        Intrinsics.checkNotNullParameter(subEntities, (String)"subEntities");
        return new SampleEntity(definition, subEntities, start, end);
    }

    public static /* synthetic */ SampleEntity copy$default(SampleEntity sampleEntity, Entity entity, List list, int n, int n2, int n3, Object object) {
        if ((n3 & 1) != 0) {
            entity = sampleEntity.definition;
        }
        if ((n3 & 2) != 0) {
            list = sampleEntity.subEntities;
        }
        if ((n3 & 4) != 0) {
            n = sampleEntity.start;
        }
        if ((n3 & 8) != 0) {
            n2 = sampleEntity.end;
        }
        return sampleEntity.copy(entity, list, n, n2);
    }

    @NotNull
    public String toString() {
        return "SampleEntity(definition=" + this.definition + ", subEntities=" + this.subEntities + ", start=" + this.start + ", end=" + this.end + ")";
    }

    public int hashCode() {
        int result = this.definition.hashCode();
        result = result * 31 + ((Object)this.subEntities).hashCode();
        result = result * 31 + Integer.hashCode(this.start);
        result = result * 31 + Integer.hashCode(this.end);
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof SampleEntity)) {
            return false;
        }
        SampleEntity sampleEntity = (SampleEntity)other;
        if (!Intrinsics.areEqual((Object)this.definition, (Object)sampleEntity.definition)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.subEntities, sampleEntity.subEntities)) {
            return false;
        }
        if (this.start != sampleEntity.start) {
            return false;
        }
        return this.end == sampleEntity.end;
    }
}

