/*
 * Decompiled with CFR 0.152.
 */
package ai.tock.bot.api.websocket;

import ai.tock.bot.api.client.ClientBotDefinition;
import ai.tock.bot.api.client.ConfigurationsKt;
import ai.tock.bot.api.client.TockClientBus;
import ai.tock.bot.api.model.BotResponse;
import ai.tock.bot.api.model.UserRequest;
import ai.tock.bot.api.model.websocket.RequestData;
import ai.tock.bot.api.model.websocket.ResponseData;
import ai.tock.bot.api.websocket.BotApiWebSocketClientKt;
import ai.tock.shared.Dice;
import ai.tock.shared.LoggersKt;
import ai.tock.shared.PropertiesKt;
import ai.tock.shared.jackson.JacksonKt;
import ai.tock.shared.vertx.VertXsKt;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.RuntimeJsonMappingException;
import io.vertx.core.AsyncResult;
import io.vertx.core.Promise;
import io.vertx.core.Vertx;
import io.vertx.core.http.HttpClient;
import io.vertx.core.http.WebSocket;
import io.vertx.core.http.WebSocketBase;
import io.vertx.core.http.WebSocketConnectOptions;
import java.net.URL;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import mu.KLogger;
import mu.KotlinLogging;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000(\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\u001a,\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00072\b\b\u0002\u0010\b\u001a\u00020\t2\b\b\u0002\u0010\n\u001a\u00020\u000b\u001a\u0016\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\f\u001a\u00020\t\u001a\u000e\u0010\r\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"logger", "Lmu/KLogger;", "start", "", "botDefinition", "Lai/tock/bot/api/client/ClientBotDefinition;", "serverPort", "", "serverHost", "", "ssl", "", "url", "startWithDemo", "tock-bot-api-websocket-base"})
@SourceDebugExtension(value={"SMAP\nBotApiWebSocketClient.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BotApiWebSocketClient.kt\nai/tock/bot/api/websocket/BotApiWebSocketClientKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,178:1\n1#2:179\n*E\n"})
public final class BotApiWebSocketClientKt {
    @NotNull
    private static final KLogger logger = KotlinLogging.INSTANCE.logger((Function0)logger.1.INSTANCE);

    public static final void startWithDemo(@NotNull ClientBotDefinition botDefinition) {
        Intrinsics.checkNotNullParameter((Object)botDefinition, (String)"botDefinition");
        BotApiWebSocketClientKt.start(botDefinition, "https://demo-bot.tock.ai");
    }

    /*
     * WARNING - void declaration
     */
    public static final void start(@NotNull ClientBotDefinition botDefinition, @NotNull String url) {
        void it;
        Intrinsics.checkNotNullParameter((Object)botDefinition, (String)"botDefinition");
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        URL u = new URL(url);
        Integer n = u.getPort();
        int n2 = ((Number)n).intValue();
        ClientBotDefinition clientBotDefinition = botDefinition;
        boolean bl = false;
        boolean bl2 = it == -1;
        Integer n3 = !bl2 ? n : null;
        int n4 = n3 != null ? n3.intValue() : u.getDefaultPort();
        String string = u.getHost();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getHost(...)");
        BotApiWebSocketClientKt.start(clientBotDefinition, n4, string, Intrinsics.areEqual((Object)u.getProtocol(), (Object)"https"));
    }

    public static final void start(@NotNull ClientBotDefinition botDefinition, int serverPort, @NotNull String serverHost, boolean ssl) {
        Intrinsics.checkNotNullParameter((Object)botDefinition, (String)"botDefinition");
        Intrinsics.checkNotNullParameter((Object)serverHost, (String)"serverHost");
        Ref.BooleanRef websocketIsRestarting = new Ref.BooleanRef();
        WebSocketConnectOptions options = new WebSocketConnectOptions().setSsl(Boolean.valueOf(ssl)).setHost(serverHost).setPort(Integer.valueOf(serverPort)).setURI(((Object)StringsKt.trim((CharSequence)("/" + botDefinition.getApiKey()))).toString());
        logger.info((Function0)new Function0<Object>(options){
            final /* synthetic */ WebSocketConnectOptions $options;
            {
                this.$options = $options;
                super(0);
            }

            public final Object invoke() {
                return "start web socket client: " + this.$options.toJson();
            }
        });
        HttpClient client = VertXsKt.getVertx().createHttpClient();
        client.webSocket(options, arg_0 -> BotApiWebSocketClientKt.start$lambda$6(botDefinition, client, websocketIsRestarting, serverPort, serverHost, ssl, arg_0));
    }

    public static /* synthetic */ void start$default(ClientBotDefinition clientBotDefinition, int n, String string, boolean bl, int n2, Object object) {
        if ((n2 & 2) != 0) {
            n = PropertiesKt.intProperty((String)"tock_websocket_port", (int)8080);
        }
        if ((n2 & 4) != 0) {
            string = PropertiesKt.property((String)"tock_websocket_host", (String)"localhost");
        }
        if ((n2 & 8) != 0) {
            bl = PropertiesKt.booleanProperty((String)"tock_websocket_ssl", (boolean)false);
        }
        BotApiWebSocketClientKt.start(clientBotDefinition, n, string, bl);
    }

    private static final void start$restart$lambda$1(ClientBotDefinition $botDefinition, int $serverPort, String $serverHost, boolean $ssl, HttpClient $client, long $delay, Ref.BooleanRef $websocketIsRestarting, Long it) {
        try {
            BotApiWebSocketClientKt.start($botDefinition, $serverPort, $serverHost, $ssl);
        }
        catch (Exception e) {
            LoggersKt.error((KLogger)logger, (Throwable)e);
            BotApiWebSocketClientKt.start$restart($websocketIsRestarting, $botDefinition, $serverPort, $serverHost, $ssl, $client, $delay);
        }
    }

    private static final void start$restart(Ref.BooleanRef websocketIsRestarting, ClientBotDefinition $botDefinition, int $serverPort, String $serverHost, boolean $ssl, HttpClient client, long delay) {
        if (websocketIsRestarting.element) {
            return;
        }
        websocketIsRestarting.element = true;
        logger.info((Function0)new Function0<Object>(delay){
            final /* synthetic */ long $delay;
            {
                this.$delay = $delay;
                super(0);
            }

            public final Object invoke() {
                return "restart in " + this.$delay + " seconds...";
            }
        });
        try {
            client.close();
        }
        catch (Exception e) {
            LoggersKt.error((KLogger)logger, (Throwable)e);
        }
        VertXsKt.getVertx().setTimer(TimeUnit.SECONDS.toMillis(delay), arg_0 -> BotApiWebSocketClientKt.start$restart$lambda$1($botDefinition, $serverPort, $serverHost, $ssl, client, delay, websocketIsRestarting, arg_0));
    }

    private static final void start$lambda$6$lambda$2(ClientBotDefinition $botDefinition, WebSocket $socket, String json) {
        VertXsKt.blocking((Vertx)VertXsKt.getVertx(), (Function1)((Function1)new Function1<Promise<String>, Unit>(json, $botDefinition, $socket){
            final /* synthetic */ String $json;
            final /* synthetic */ ClientBotDefinition $botDefinition;
            final /* synthetic */ WebSocket $socket;
            {
                this.$json = $json;
                this.$botDefinition = $botDefinition;
                this.$socket = $socket;
                super(1);
            }

            /*
             * WARNING - void declaration
             */
            public final void invoke(Promise<String> it) {
                void $this$checkTypeMismatch$iv$iv;
                void $this$readValue$iv;
                Intrinsics.checkNotNullParameter(it, (String)"it");
                BotApiWebSocketClientKt.access$getLogger$p().debug((Function0)new Function0<Object>(this.$json){
                    final /* synthetic */ String $json;
                    {
                        this.$json = $json;
                        super(0);
                    }

                    public final Object invoke() {
                        return "json: " + this.$json;
                    }
                });
                ObjectMapper objectMapper = JacksonKt.getMapper();
                String string = this.$json;
                Intrinsics.checkNotNull((Object)string);
                String content$iv = string;
                boolean $i$f$readValue = false;
                boolean $i$f$jacksonTypeRef22 = false;
                Object $i$f$jacksonTypeRef22 = $this$readValue$iv.readValue(content$iv, (TypeReference)new TypeReference<RequestData>(){});
                boolean $i$f$checkTypeMismatch = false;
                if (!($this$checkTypeMismatch$iv$iv instanceof RequestData)) {
                    String string2;
                    String nullability$iv$iv = "(non-null)";
                    StringBuilder stringBuilder = new StringBuilder().append("Deserialized value did not match the specified type; specified ").append(Reflection.getOrCreateKotlinClass(RequestData.class).getQualifiedName()).append(nullability$iv$iv).append(" but was ");
                    void v1 = $this$checkTypeMismatch$iv$iv;
                    if (v1 != null) {
                        void it$iv$iv;
                        void var9_9 = v1;
                        StringBuilder stringBuilder2 = stringBuilder;
                        boolean bl = false;
                        string2 = Reflection.getOrCreateKotlinClass(it$iv$iv.getClass()).getQualifiedName();
                        stringBuilder = stringBuilder2;
                    } else {
                        string2 = null;
                    }
                    String string3 = stringBuilder.append(string2).toString();
                    throw new RuntimeJsonMappingException(string3);
                }
                RequestData data = (RequestData)$this$checkTypeMismatch$iv$iv;
                UserRequest request = data.getBotRequest();
                if (request != null) {
                    BotApiWebSocketClientKt.access$getLogger$p().debug((Function0)start.3.2.2.INSTANCE);
                    TockClientBus bus2 = new TockClientBus(this.$botDefinition, data, (Function1)new Function1<BotResponse, Unit>(data, it, this.$socket){
                        final /* synthetic */ RequestData $data;
                        final /* synthetic */ Promise<String> $it;
                        final /* synthetic */ WebSocket $socket;
                        {
                            this.$data = $data;
                            this.$it = $it;
                            this.$socket = $socket;
                            super(1);
                        }

                        public final void invoke(BotResponse r) {
                            Intrinsics.checkNotNullParameter((Object)r, (String)"r");
                            BotApiWebSocketClientKt.access$getLogger$p().debug((Function0)start.3.2.bus.1.INSTANCE);
                            String response = JacksonKt.getMapper().writeValueAsString((Object)new ResponseData(this.$data.getRequestId(), r, null, 4, null));
                            BotApiWebSocketClientKt.access$getLogger$p().debug((Function0)new Function0<Object>(response){
                                final /* synthetic */ String $response;
                                {
                                    this.$response = $response;
                                    super(0);
                                }

                                public final Object invoke() {
                                    return this.$response;
                                }
                            });
                            if (r.getContext().getLastResponse()) {
                                this.$it.complete((Object)response);
                            } else {
                                this.$socket.writeTextMessage(response);
                            }
                        }
                    });
                    bus2.handle();
                } else if (Intrinsics.areEqual((Object)data.getConfiguration(), (Object)true)) {
                    BotApiWebSocketClientKt.access$getLogger$p().debug((Function0)start.3.2.3.INSTANCE);
                    it.complete((Object)JacksonKt.getMapper().writeValueAsString((Object)new ResponseData(data.getRequestId(), null, ConfigurationsKt.toConfiguration((ClientBotDefinition)this.$botDefinition), 2, null)));
                } else {
                    it.fail("invalid request: " + this.$json);
                }
            }
        }), (Function1)((Function1)new Function1<AsyncResult<String>, Unit>($socket, json){
            final /* synthetic */ WebSocket $socket;
            final /* synthetic */ String $json;
            {
                this.$socket = $socket;
                this.$json = $json;
                super(1);
            }

            public final void invoke(AsyncResult<String> it) {
                Intrinsics.checkNotNullParameter(it, (String)"it");
                if (it.succeeded()) {
                    if (it.result() != null) {
                        this.$socket.writeTextMessage((String)it.result());
                    } else {
                        BotApiWebSocketClientKt.access$getLogger$p().error((Function0)new Function0<Object>(this.$json){
                            final /* synthetic */ String $json;
                            {
                                this.$json = $json;
                                super(0);
                            }

                            public final Object invoke() {
                                return "empty response for " + this.$json;
                            }
                        });
                    }
                } else {
                    Throwable c = it.cause();
                    if (c == null) {
                        BotApiWebSocketClientKt.access$getLogger$p().error("unknown error for " + this.$json + " : " + it.result());
                    } else {
                        LoggersKt.error((KLogger)BotApiWebSocketClientKt.access$getLogger$p(), (Throwable)c);
                    }
                }
            }
        }));
    }

    private static final void start$lambda$6$lambda$3(HttpClient $client, Ref.BooleanRef $websocketIsRestarting, ClientBotDefinition $botDefinition, int $serverPort, String $serverHost, boolean $ssl, Throwable it) {
        logger.info("Exception");
        Intrinsics.checkNotNull((Object)$client);
        BotApiWebSocketClientKt.start$restart($websocketIsRestarting, $botDefinition, $serverPort, $serverHost, $ssl, $client, 1L);
    }

    private static final void start$lambda$6$lambda$4(HttpClient $client, Ref.BooleanRef $websocketIsRestarting, ClientBotDefinition $botDefinition, int $serverPort, String $serverHost, boolean $ssl, Void it) {
        logger.info("Closed");
        Intrinsics.checkNotNull((Object)$client);
        BotApiWebSocketClientKt.start$restart($websocketIsRestarting, $botDefinition, $serverPort, $serverHost, $ssl, $client, 1L);
    }

    private static final void start$lambda$6(ClientBotDefinition $botDefinition, HttpClient $client, Ref.BooleanRef $websocketIsRestarting, int $serverPort, String $serverHost, boolean $ssl, AsyncResult context) {
        try {
            WebSocketBase webSocketBase;
            WebSocketBase webSocketBase2;
            WebSocketBase webSocketBase3;
            WebSocket socket = (WebSocket)context.result();
            String conf = JacksonKt.getMapper().writeValueAsString((Object)new ResponseData(Dice.INSTANCE.newId(), null, ConfigurationsKt.toConfiguration((ClientBotDefinition)$botDefinition), 2, null));
            logger.debug((Function0)new Function0<Object>(conf){
                final /* synthetic */ String $conf;
                {
                    this.$conf = $conf;
                    super(0);
                }

                public final Object invoke() {
                    return "send bot conf: " + this.$conf;
                }
            });
            WebSocket webSocket = socket;
            if (webSocket != null) {
                webSocket.writeTextMessage(conf);
            }
            WebSocketBase webSocketBase4 = webSocketBase3 = socket != null && (webSocketBase2 = socket.textMessageHandler(arg_0 -> BotApiWebSocketClientKt.start$lambda$6$lambda$2($botDefinition, socket, arg_0))) != null && (webSocketBase = webSocketBase2.exceptionHandler(arg_0 -> BotApiWebSocketClientKt.start$lambda$6$lambda$3($client, $websocketIsRestarting, $botDefinition, $serverPort, $serverHost, $ssl, arg_0))) != null ? webSocketBase.closeHandler(arg_0 -> BotApiWebSocketClientKt.start$lambda$6$lambda$4($client, $websocketIsRestarting, $botDefinition, $serverPort, $serverHost, $ssl, arg_0)) : null;
            if (webSocketBase3 == null) {
                Intrinsics.checkNotNull((Object)$client);
                BotApiWebSocketClientKt.start$restart($websocketIsRestarting, $botDefinition, $serverPort, $serverHost, $ssl, $client, 10L);
                WebSocketBase $this$start_u24lambda_u246_u24lambda_u245 = webSocketBase2 = Unit.INSTANCE;
                boolean bl = false;
                logger.warn((Function0)start.3.5.1.INSTANCE);
            }
        }
        catch (Exception e) {
            LoggersKt.error((KLogger)logger, (Throwable)e);
        }
    }

    public static final /* synthetic */ KLogger access$getLogger$p() {
        return logger;
    }
}

