/*
 * Decompiled with CFR 0.152.
 */
package ai.tock.bot.api.websocket;

import ai.tock.bot.api.client.ClientBotDefinition;
import ai.tock.bot.api.client.ConfigurationsKt;
import ai.tock.bot.api.client.TockClientBus;
import ai.tock.bot.api.model.BotResponse;
import ai.tock.bot.api.model.UserRequest;
import ai.tock.bot.api.model.websocket.RequestData;
import ai.tock.bot.api.model.websocket.ResponseData;
import ai.tock.shared.Dice;
import ai.tock.shared.LoggersKt;
import ai.tock.shared.PropertiesKt;
import ai.tock.shared.jackson.JacksonKt;
import ai.tock.shared.vertx.VertXsKt;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.RuntimeJsonMappingException;
import io.vertx.core.AsyncResult;
import io.vertx.core.Promise;
import io.vertx.core.Vertx;
import io.vertx.core.http.WebSocket;
import io.vertx.core.http.WebSocketClient;
import io.vertx.core.http.WebSocketConnectOptions;
import java.net.URL;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import mu.KLogger;
import mu.KotlinLogging;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000*\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\u001a\u000e\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005\u001a\u0016\u0010\u0006\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0007\u001a\u00020\b\u001a,\u0010\u0006\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\t\u001a\u00020\n2\b\b\u0002\u0010\u000b\u001a\u00020\b2\b\b\u0002\u0010\f\u001a\u00020\r\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"logger", "Lmu/KLogger;", "startWithDemo", "", "botDefinition", "Lai/tock/bot/api/client/ClientBotDefinition;", "start", "url", "", "serverPort", "", "serverHost", "ssl", "", "tock-bot-api-websocket-base"})
@SourceDebugExtension(value={"SMAP\nBotApiWebSocketClient.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BotApiWebSocketClient.kt\nai/tock/bot/api/websocket/BotApiWebSocketClientKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 Extensions.kt\ncom/fasterxml/jackson/module/kotlin/ExtensionsKt\n*L\n1#1,178:1\n1#2:179\n1#2:191\n116#3:180\n54#3:181\n117#3:182\n61#3,8:183\n71#3:192\n*S KotlinDebug\n*F\n+ 1 BotApiWebSocketClient.kt\nai/tock/bot/api/websocket/BotApiWebSocketClientKt\n*L\n123#1:191\n123#1:180\n123#1:181\n123#1:182\n123#1:183,8\n123#1:192\n*E\n"})
public final class BotApiWebSocketClientKt {
    @NotNull
    private static final KLogger logger = KotlinLogging.INSTANCE.logger(BotApiWebSocketClientKt::logger$lambda$0);

    public static final void startWithDemo(@NotNull ClientBotDefinition botDefinition) {
        Intrinsics.checkNotNullParameter((Object)botDefinition, (String)"botDefinition");
        BotApiWebSocketClientKt.start(botDefinition, "https://demo-bot.tock.ai");
    }

    /*
     * WARNING - void declaration
     */
    public static final void start(@NotNull ClientBotDefinition botDefinition, @NotNull String url) {
        void it;
        Intrinsics.checkNotNullParameter((Object)botDefinition, (String)"botDefinition");
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        URL u = new URL(url);
        Integer n = u.getPort();
        int n2 = ((Number)n).intValue();
        ClientBotDefinition clientBotDefinition = botDefinition;
        boolean bl = false;
        boolean bl2 = it == -1;
        Integer n3 = !bl2 ? n : null;
        int n4 = n3 != null ? n3.intValue() : u.getDefaultPort();
        String string = u.getHost();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getHost(...)");
        BotApiWebSocketClientKt.start(clientBotDefinition, n4, string, Intrinsics.areEqual((Object)u.getProtocol(), (Object)"https"));
    }

    public static final void start(@NotNull ClientBotDefinition botDefinition, int serverPort, @NotNull String serverHost, boolean ssl) {
        Intrinsics.checkNotNullParameter((Object)botDefinition, (String)"botDefinition");
        Intrinsics.checkNotNullParameter((Object)serverHost, (String)"serverHost");
        Ref.BooleanRef websocketIsRestarting = new Ref.BooleanRef();
        WebSocketConnectOptions options = new WebSocketConnectOptions().setSsl(Boolean.valueOf(ssl)).setHost(serverHost).setPort(Integer.valueOf(serverPort)).setURI(((Object)StringsKt.trim((CharSequence)("/" + botDefinition.getApiKey()))).toString());
        logger.info(() -> BotApiWebSocketClientKt.start$lambda$3(options));
        WebSocketClient client = VertXsKt.getVertx().createWebSocketClient();
        client.connect(options).onSuccess(arg_0 -> BotApiWebSocketClientKt.start$lambda$5(arg_0 -> BotApiWebSocketClientKt.start$lambda$4(botDefinition, client, websocketIsRestarting, serverPort, serverHost, ssl, arg_0), arg_0));
    }

    public static /* synthetic */ void start$default(ClientBotDefinition clientBotDefinition, int n, String string, boolean bl, int n2, Object object) {
        if ((n2 & 2) != 0) {
            n = PropertiesKt.intProperty((String)"tock_websocket_port", (int)8080);
        }
        if ((n2 & 4) != 0) {
            string = PropertiesKt.property((String)"tock_websocket_host", (String)"localhost");
        }
        if ((n2 & 8) != 0) {
            bl = PropertiesKt.booleanProperty((String)"tock_websocket_ssl", (boolean)false);
        }
        BotApiWebSocketClientKt.start(clientBotDefinition, n, string, bl);
    }

    private static final Unit logger$lambda$0() {
        return Unit.INSTANCE;
    }

    private static final void start$restart(Ref.BooleanRef websocketIsRestarting, ClientBotDefinition $botDefinition, int $serverPort, String $serverHost, boolean $ssl, WebSocketClient client, long delay) {
        if (websocketIsRestarting.element) {
            return;
        }
        websocketIsRestarting.element = true;
        logger.info(() -> BotApiWebSocketClientKt.start$restart$lambda$1(delay));
        try {
            client.close();
        }
        catch (Exception e) {
            LoggersKt.error((KLogger)logger, (Throwable)e);
        }
        VertXsKt.getVertx().setTimer(TimeUnit.SECONDS.toMillis(delay), arg_0 -> BotApiWebSocketClientKt.start$restart$lambda$2($botDefinition, $serverPort, $serverHost, $ssl, client, delay, websocketIsRestarting, arg_0));
    }

    private static final Object start$restart$lambda$1(long $delay) {
        return "restart in " + $delay + " seconds...";
    }

    private static final void start$restart$lambda$2(ClientBotDefinition $botDefinition, int $serverPort, String $serverHost, boolean $ssl, WebSocketClient $client, long $delay, Ref.BooleanRef $websocketIsRestarting, Long it) {
        try {
            BotApiWebSocketClientKt.start($botDefinition, $serverPort, $serverHost, $ssl);
        }
        catch (Exception e) {
            LoggersKt.error((KLogger)logger, (Throwable)e);
            BotApiWebSocketClientKt.start$restart($websocketIsRestarting, $botDefinition, $serverPort, $serverHost, $ssl, $client, $delay);
        }
    }

    private static final Object start$lambda$3(WebSocketConnectOptions $options) {
        return "start web socket client: " + $options.toJson();
    }

    private static final Unit start$lambda$4(ClientBotDefinition $botDefinition, WebSocketClient $client, Ref.BooleanRef $websocketIsRestarting, int $serverPort, String $serverHost, boolean $ssl, WebSocket socket) {
        try {
            WebSocket webSocket;
            WebSocket webSocket2;
            WebSocket webSocket3;
            String conf = JacksonKt.getMapper().writeValueAsString((Object)new ResponseData(Dice.INSTANCE.newId(), null, ConfigurationsKt.toConfiguration((ClientBotDefinition)$botDefinition), 2, null));
            logger.debug(() -> BotApiWebSocketClientKt.start$lambda$4$0(conf));
            WebSocket webSocket4 = socket;
            if (webSocket4 != null) {
                webSocket4.writeTextMessage(conf);
            }
            if (socket == null || (webSocket3 = socket.textMessageHandler(arg_0 -> BotApiWebSocketClientKt.start$lambda$4$1($botDefinition, socket, arg_0))) == null || (webSocket2 = webSocket3.exceptionHandler(arg_0 -> BotApiWebSocketClientKt.start$lambda$4$2($client, $websocketIsRestarting, $botDefinition, $serverPort, $serverHost, $ssl, arg_0))) == null || (webSocket = webSocket2.closeHandler(arg_0 -> BotApiWebSocketClientKt.start$lambda$4$3($client, $websocketIsRestarting, $botDefinition, $serverPort, $serverHost, $ssl, arg_0))) == null) {
                Unit unit;
                Intrinsics.checkNotNull((Object)$client);
                BotApiWebSocketClientKt.start$restart($websocketIsRestarting, $botDefinition, $serverPort, $serverHost, $ssl, $client, 10L);
                Unit $this$start_u24lambda_u244_u244 = unit = Unit.INSTANCE;
                boolean bl = false;
                logger.warn(BotApiWebSocketClientKt::start$lambda$4$4$0);
            }
        }
        catch (Exception e) {
            LoggersKt.error((KLogger)logger, (Throwable)e);
        }
        return Unit.INSTANCE;
    }

    private static final Object start$lambda$4$0(String $conf) {
        return "send bot conf: " + $conf;
    }

    private static final void start$lambda$4$1(ClientBotDefinition $botDefinition, WebSocket $socket, String json) {
        VertXsKt.blocking((Vertx)VertXsKt.getVertx(), arg_0 -> BotApiWebSocketClientKt.start$lambda$4$1$0(json, $botDefinition, $socket, arg_0), arg_0 -> BotApiWebSocketClientKt.start$lambda$4$1$1($socket, json, arg_0));
    }

    /*
     * WARNING - void declaration
     */
    private static final Unit start$lambda$4$1$0(String $json, ClientBotDefinition $botDefinition, WebSocket $socket, Promise it) {
        void $this$checkTypeMismatch$iv$iv;
        void $this$readValue$iv;
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        logger.debug(() -> BotApiWebSocketClientKt.start$lambda$4$1$0$0($json));
        ObjectMapper objectMapper = JacksonKt.getMapper();
        Intrinsics.checkNotNull((Object)$json);
        String content$iv = $json;
        boolean $i$f$readValue = false;
        boolean $i$f$jacksonTypeRef22 = false;
        Object $i$f$jacksonTypeRef22 = $this$readValue$iv.readValue(content$iv, (TypeReference)new TypeReference<RequestData>(){});
        boolean $i$f$checkTypeMismatch = false;
        if (!($this$checkTypeMismatch$iv$iv instanceof RequestData)) {
            String string;
            String nullability$iv$iv = "(non-null)";
            StringBuilder stringBuilder = new StringBuilder().append("Deserialized value did not match the specified type; specified ").append(Reflection.getOrCreateKotlinClass(RequestData.class).getQualifiedName()).append(nullability$iv$iv).append(" but was ");
            void v1 = $this$checkTypeMismatch$iv$iv;
            if (v1 != null) {
                void it$iv$iv;
                void var11_11 = v1;
                StringBuilder stringBuilder2 = stringBuilder;
                boolean bl = false;
                string = Reflection.getOrCreateKotlinClass(it$iv$iv.getClass()).getQualifiedName();
                stringBuilder = stringBuilder2;
            } else {
                string = null;
            }
            String string2 = stringBuilder.append(string).toString();
            throw new RuntimeJsonMappingException(string2);
        }
        RequestData data = (RequestData)$this$checkTypeMismatch$iv$iv;
        UserRequest request = data.getBotRequest();
        if (request != null) {
            logger.debug(BotApiWebSocketClientKt::start$lambda$4$1$0$1);
            TockClientBus bus = new TockClientBus($botDefinition, data, arg_0 -> BotApiWebSocketClientKt.start$lambda$4$1$0$2(data, it, $socket, arg_0));
            bus.handle();
        } else if (Intrinsics.areEqual((Object)data.getConfiguration(), (Object)true)) {
            logger.debug(BotApiWebSocketClientKt::start$lambda$4$1$0$3);
            it.complete((Object)JacksonKt.getMapper().writeValueAsString((Object)new ResponseData(data.getRequestId(), null, ConfigurationsKt.toConfiguration((ClientBotDefinition)$botDefinition), 2, null)));
        } else {
            it.fail("invalid request: " + $json);
        }
        return Unit.INSTANCE;
    }

    private static final Object start$lambda$4$1$0$0(String $json) {
        return "json: " + $json;
    }

    private static final Object start$lambda$4$1$0$1() {
        return "handle request by bus";
    }

    private static final Unit start$lambda$4$1$0$2(RequestData $data, Promise $it, WebSocket $socket, BotResponse r) {
        Intrinsics.checkNotNullParameter((Object)r, (String)"r");
        logger.debug(BotApiWebSocketClientKt::start$lambda$4$1$0$2$0);
        String response = JacksonKt.getMapper().writeValueAsString((Object)new ResponseData($data.getRequestId(), r, null, 4, null));
        logger.debug(() -> BotApiWebSocketClientKt.start$lambda$4$1$0$2$1(response));
        if (r.getContext().getLastResponse()) {
            $it.complete((Object)response);
        } else {
            $socket.writeTextMessage(response);
        }
        return Unit.INSTANCE;
    }

    private static final Object start$lambda$4$1$0$2$0() {
        return "send bus response";
    }

    private static final Object start$lambda$4$1$0$2$1(String $response) {
        return $response;
    }

    private static final Object start$lambda$4$1$0$3() {
        return "send configuration";
    }

    private static final Unit start$lambda$4$1$1(WebSocket $socket, String $json, AsyncResult it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        if (it.succeeded()) {
            if (it.result() != null) {
                $socket.writeTextMessage((String)it.result());
            } else {
                logger.error(() -> BotApiWebSocketClientKt.start$lambda$4$1$1$0($json));
            }
        } else {
            Throwable c = it.cause();
            if (c == null) {
                logger.error("unknown error for " + $json + " : " + it.result());
            } else {
                LoggersKt.error((KLogger)logger, (Throwable)c);
            }
        }
        return Unit.INSTANCE;
    }

    private static final Object start$lambda$4$1$1$0(String $json) {
        return "empty response for " + $json;
    }

    private static final void start$lambda$4$2(WebSocketClient $client, Ref.BooleanRef $websocketIsRestarting, ClientBotDefinition $botDefinition, int $serverPort, String $serverHost, boolean $ssl, Throwable it) {
        logger.info("Exception");
        Intrinsics.checkNotNull((Object)$client);
        BotApiWebSocketClientKt.start$restart($websocketIsRestarting, $botDefinition, $serverPort, $serverHost, $ssl, $client, 1L);
    }

    private static final void start$lambda$4$3(WebSocketClient $client, Ref.BooleanRef $websocketIsRestarting, ClientBotDefinition $botDefinition, int $serverPort, String $serverHost, boolean $ssl, Void it) {
        logger.info("Closed");
        Intrinsics.checkNotNull((Object)$client);
        BotApiWebSocketClientKt.start$restart($websocketIsRestarting, $botDefinition, $serverPort, $serverHost, $ssl, $client, 1L);
    }

    private static final Object start$lambda$4$4$0() {
        return "websocket server not found or unknown key - retry in 10s";
    }

    private static final void start$lambda$5(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }
}

