/*
 * Decompiled with CFR 0.152.
 */
package ai.tock.bot.api.service;

import ai.tock.bot.api.model.BotResponse;
import ai.tock.bot.api.model.configuration.ResponseContextVersion;
import ai.tock.bot.api.model.websocket.RequestData;
import ai.tock.bot.api.model.websocket.ResponseData;
import ai.tock.bot.api.service.BotApiClient;
import ai.tock.bot.api.service.BotApiService;
import ai.tock.bot.api.service.CloseListener;
import ai.tock.shared.LoggersKt;
import ai.tock.shared.PropertiesKt;
import ai.tock.shared.RetrofitsKt;
import ai.tock.shared.jackson.JacksonKt;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.RuntimeJsonMappingException;
import com.launchdarkly.eventsource.ConnectStrategy;
import com.launchdarkly.eventsource.EventSource;
import com.launchdarkly.eventsource.HttpConnectStrategy;
import com.launchdarkly.eventsource.MessageEvent;
import com.launchdarkly.eventsource.background.BackgroundEventHandler;
import com.launchdarkly.eventsource.background.BackgroundEventSource;
import java.net.URI;
import java.net.URL;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import mu.KLogger;
import mu.KotlinLogging;
import okhttp3.RequestBody;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import retrofit2.Response;
import retrofit2.Retrofit;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0006\u0010\u0014\u001a\u00020\u000bJ\b\u0010\u0015\u001a\u00020\u0016H\u0002J\u0010\u0010\u0017\u001a\u0004\u0018\u00010\u00182\u0006\u0010\u0019\u001a\u00020\u001aJ.\u0010\u001b\u001a\u00020\u00162\u0006\u0010\u0019\u001a\u00020\u001a2\b\u0010\u001c\u001a\u0004\u0018\u00010\u001d2\u0014\u0010\u001e\u001a\u0010\u0012\u0006\u0012\u0004\u0018\u00010\u0018\u0012\u0004\u0012\u00020\u00160\u001fR\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0012\u001a\u0004\u0018\u00010\u0007X\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u0013\u00a8\u0006 "}, d2={"Lai/tock/bot/api/service/BotApiClient;", "", "baseUrl", "", "<init>", "(Ljava/lang/String;)V", "connectionTimeoutInMs", "", "timeoutInMs", "reachabilityInMs", "checkReachability", "", "logger", "Lmu/KLogger;", "formattedBaseUrl", "service", "Lai/tock/bot/api/service/BotApiService;", "webhookReachable", "lastReachabilityCheck", "Ljava/lang/Long;", "isReachable", "testReachability", "", "send", "Lai/tock/bot/api/model/websocket/ResponseData;", "request", "Lai/tock/bot/api/model/websocket/RequestData;", "sendWithSse", "version", "Lai/tock/bot/api/model/configuration/ResponseContextVersion;", "sendResponse", "Lkotlin/Function1;", "tock-bot-api-service"})
@SourceDebugExtension(value={"SMAP\nBotApiClient.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BotApiClient.kt\nai/tock/bot/api/service/BotApiClient\n+ 2 Retrofits.kt\nai/tock/shared/RetrofitsKt\n*L\n1#1,185:1\n71#2:186\n*S KotlinDebug\n*F\n+ 1 BotApiClient.kt\nai/tock/bot/api/service/BotApiClient\n*L\n66#1:186\n*E\n"})
public final class BotApiClient {
    private final long connectionTimeoutInMs;
    private final long timeoutInMs;
    private final long reachabilityInMs;
    private final boolean checkReachability;
    @NotNull
    private final KLogger logger;
    @NotNull
    private final String formattedBaseUrl;
    @NotNull
    private final BotApiService service;
    private volatile boolean webhookReachable;
    @Nullable
    private volatile Long lastReachabilityCheck;

    public BotApiClient(@NotNull String baseUrl) {
        Intrinsics.checkNotNullParameter((Object)baseUrl, (String)"baseUrl");
        this.connectionTimeoutInMs = PropertiesKt.longProperty((String)"tock_bot_api_connection_timeout_in_ms", (long)3000L);
        this.timeoutInMs = PropertiesKt.longProperty((String)"tock_bot_api_timeout_in_ms", (long)60000L);
        this.reachabilityInMs = PropertiesKt.longProperty((String)"tock_bot_api_webhook_reachability_in_ms", (long)10000L);
        this.checkReachability = PropertiesKt.booleanProperty((String)"tock_bot_api_webhook_check_reachability", (boolean)false);
        this.logger = KotlinLogging.INSTANCE.logger(BotApiClient::logger$lambda$0);
        this.formattedBaseUrl = StringsKt.endsWith$default((String)baseUrl, (String)"/", (boolean)false, (int)2, null) ? baseUrl : baseUrl + "/";
        this.webhookReachable = !this.checkReachability;
        Retrofit retrofit = RetrofitsKt.addJacksonConverter$default((Retrofit.Builder)RetrofitsKt.retrofitBuilderWithTimeoutAndLogger$default((long)this.timeoutInMs, (KLogger)this.logger, null, null, (boolean)false, (boolean)false, null, (int)124, null), null, (int)1, null).baseUrl(this.formattedBaseUrl).build();
        Intrinsics.checkNotNullExpressionValue((Object)retrofit, (String)"build(...)");
        Retrofit $this$create$iv = retrofit;
        boolean $i$f$create = false;
        Object object = $this$create$iv.create(BotApiService.class);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"create(...)");
        this.service = (BotApiService)object;
        this.testReachability();
    }

    public final boolean isReachable() {
        this.testReachability();
        return this.webhookReachable;
    }

    /*
     * WARNING - void declaration
     */
    private final void testReachability() {
        boolean bl;
        BotApiClient botApiClient = this;
        if (this.checkReachability && !this.webhookReachable) {
            Long lastCheck = this.lastReachabilityCheck;
            long time = System.currentTimeMillis();
            if (lastCheck == null || time - lastCheck > this.reachabilityInMs) {
                boolean bl2;
                BotApiClient botApiClient2 = botApiClient;
                try {
                    void $this$testReachability_u24lambda_u241;
                    this.lastReachabilityCheck = time;
                    this.logger.info(BotApiClient::testReachability$lambda$0);
                    Response response = this.service.healthcheck().execute();
                    BotApiClient botApiClient3 = botApiClient2;
                    boolean bl3 = false;
                    this.logger.info(() -> BotApiClient.testReachability$lambda$1$0((Response)$this$testReachability_u24lambda_u241));
                    boolean bl4 = $this$testReachability_u24lambda_u241.isSuccessful();
                    botApiClient = botApiClient3;
                    bl2 = bl4;
                }
                catch (Exception $this$testReachability_u24lambda_u241) {
                    void e;
                    botApiClient = botApiClient2;
                    LoggersKt.error((KLogger)this.logger, (Throwable)((Throwable)e));
                    bl2 = false;
                }
                bl = bl2;
            } else {
                bl = false;
            }
        } else {
            bl = true;
        }
        botApiClient.webhookReachable = bl;
    }

    @Nullable
    public final ResponseData send(@NotNull RequestData request) {
        ResponseData responseData;
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        try {
            responseData = (ResponseData)this.service.send(request).execute().body();
        }
        catch (Exception e) {
            LoggersKt.error((KLogger)this.logger, (Throwable)e);
            if (!Intrinsics.areEqual((Object)request.getConfiguration(), (Object)true)) {
                throw e;
            }
            responseData = null;
        }
        return responseData;
    }

    public final void sendWithSse(@NotNull RequestData request, @Nullable ResponseContextVersion version, @NotNull Function1<? super ResponseData, Unit> sendResponse) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Intrinsics.checkNotNullParameter(sendResponse, (String)"sendResponse");
        try {
            BackgroundEventSource backgroundEventSource;
            HttpConnectStrategy httpConnectStrategy;
            CloseListener closeListener = new CloseListener(null, 1, null);
            HttpConnectStrategy httpConnectStrategy2 = ConnectStrategy.http((URL)URI.create(this.formattedBaseUrl + "webhook/sse").toURL());
            BackgroundEventHandler backgroundEventHandler = new BackgroundEventHandler(this, sendResponse, closeListener){
                final /* synthetic */ BotApiClient this$0;
                final /* synthetic */ Function1<ResponseData, Unit> $sendResponse;
                final /* synthetic */ CloseListener $closeListener;
                {
                    this.this$0 = $receiver;
                    this.$sendResponse = $sendResponse;
                    this.$closeListener = $closeListener;
                }

                public void onOpen() {
                    BotApiClient.access$getLogger$p(this.this$0).debug("open sse connection");
                }

                public void onClosed() {
                    BotApiClient.access$getLogger$p(this.this$0).debug("close sse connection");
                }

                /*
                 * WARNING - void declaration
                 */
                public void onMessage(String event, MessageEvent messageEvent) {
                    Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                    Intrinsics.checkNotNullParameter((Object)messageEvent, (String)"messageEvent");
                    BotApiClient.access$getLogger$p(this.this$0).debug(() -> sendWithSse.1.onMessage$lambda$0(event));
                    BotApiClient.access$getLogger$p(this.this$0).debug(() -> sendWithSse.1.onMessage$lambda$1(messageEvent));
                    if (Intrinsics.areEqual((Object)event, (Object)"message")) {
                        void $this$checkTypeMismatch$iv$iv;
                        void $this$readValue$iv;
                        ObjectMapper objectMapper = JacksonKt.getMapper();
                        String string = messageEvent.getData();
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getData(...)");
                        String content$iv = string;
                        boolean $i$f$readValue = false;
                        boolean $i$f$jacksonTypeRef22 = false;
                        Object $i$f$jacksonTypeRef22 = $this$readValue$iv.readValue(content$iv, (TypeReference)new TypeReference<ResponseData>(){});
                        boolean $i$f$checkTypeMismatch = false;
                        if (!($this$checkTypeMismatch$iv$iv instanceof ResponseData)) {
                            String string2;
                            String nullability$iv$iv = "(non-null)";
                            StringBuilder stringBuilder = new StringBuilder().append("Deserialized value did not match the specified type; specified ").append(Reflection.getOrCreateKotlinClass(ResponseData.class).getQualifiedName()).append(nullability$iv$iv).append(" but was ");
                            void v2 = $this$checkTypeMismatch$iv$iv;
                            if (v2 != null) {
                                void it$iv$iv;
                                void var10_10 = v2;
                                StringBuilder stringBuilder2 = stringBuilder;
                                boolean bl = false;
                                string2 = Reflection.getOrCreateKotlinClass(it$iv$iv.getClass()).getQualifiedName();
                                stringBuilder = stringBuilder2;
                            } else {
                                string2 = null;
                            }
                            String string3 = stringBuilder.append(string2).toString();
                            throw new RuntimeJsonMappingException(string3);
                        }
                        ResponseData message = (ResponseData)$this$checkTypeMismatch$iv$iv;
                        this.$sendResponse.invoke((Object)message);
                        BotResponse botResponse = message.getBotResponse();
                        boolean bl = botResponse != null && (botResponse = botResponse.getContext()) != null ? botResponse.getLastResponse() : false;
                        if (bl) {
                            BotApiClient.access$getLogger$p(this.this$0).debug(sendWithSse.1::onMessage$lambda$2);
                            this.$closeListener.close();
                        }
                    }
                }

                public void onComment(String comment) {
                    Intrinsics.checkNotNullParameter((Object)comment, (String)"comment");
                    BotApiClient.access$getLogger$p(this.this$0).debug(() -> sendWithSse.1.onComment$lambda$3(comment));
                }

                public void onError(Throwable t) {
                    Intrinsics.checkNotNullParameter((Object)t, (String)"t");
                    LoggersKt.error((KLogger)BotApiClient.access$getLogger$p(this.this$0), (Throwable)t);
                }

                private static final Object onMessage$lambda$0(String $event) {
                    return "Event: " + $event;
                }

                private static final Object onMessage$lambda$1(MessageEvent $messageEvent) {
                    return "Message: " + $messageEvent.getData();
                }

                private static final Object onMessage$lambda$2() {
                    return "Last sse answer";
                }

                private static final Object onComment$lambda$3(String $comment) {
                    return "sse comment: " + $comment;
                }
            };
            boolean bl = false;
            if (version == ResponseContextVersion.V2) {
                httpConnectStrategy = $this$sendWithSse_u24lambda_u240.header("message", JacksonKt.getMapper().writeValueAsString((Object)request));
            } else {
                String string = JacksonKt.getMapper().writeValueAsString((Object)request);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"writeValueAsString(...)");
                httpConnectStrategy = $this$sendWithSse_u24lambda_u240.methodAndBody("POST", RequestBody.Companion.create$default((RequestBody.Companion)RequestBody.Companion, (String)string, null, (int)1, null));
            }
            ConnectStrategy connectStrategy = (ConnectStrategy)httpConnectStrategy.connectTimeout(this.connectionTimeoutInMs, TimeUnit.MILLISECONDS).readTimeout(this.timeoutInMs, TimeUnit.MILLISECONDS);
            EventSource.Builder builder = new EventSource.Builder(connectStrategy);
            BackgroundEventHandler backgroundEventHandler2 = backgroundEventHandler;
            BackgroundEventSource $this$sendWithSse_u24lambda_u241 = backgroundEventSource = new BackgroundEventSource.Builder(backgroundEventHandler2, builder).threadPriority(Integer.valueOf(10)).build();
            boolean bl2 = false;
            closeListener.setSource($this$sendWithSse_u24lambda_u241);
            $this$sendWithSse_u24lambda_u241.start();
        }
        catch (Exception e) {
            LoggersKt.error((KLogger)this.logger, (Throwable)e);
        }
    }

    private static final Unit logger$lambda$0() {
        return Unit.INSTANCE;
    }

    private static final Object testReachability$lambda$0() {
        return "test webhook reachability";
    }

    private static final Object testReachability$lambda$1$0(Response $this_run) {
        return "webhook healthcheck : " + $this_run;
    }

    public static final /* synthetic */ KLogger access$getLogger$p(BotApiClient $this) {
        return $this.logger;
    }
}

