/*
 * Decompiled with CFR 0.152.
 */
package ai.tock.bot.admin.kotlin.compiler;

import ai.tock.bot.admin.kotlin.compiler.DummyCodeStyleManager;
import ai.tock.bot.admin.kotlin.compiler.EnvironmentManager;
import com.google.common.collect.Lists;
import com.intellij.codeInsight.ContainerProvider;
import com.intellij.codeInsight.runner.JavaMainMethodProvider;
import com.intellij.core.CoreApplicationEnvironment;
import com.intellij.mock.MockProject;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.extensions.ExtensionsArea;
import com.intellij.openapi.fileTypes.FileTypeRegistry;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Getter;
import com.intellij.psi.FileContextProvider;
import com.intellij.psi.augment.PsiAugmentProvider;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.impl.compiled.ClsCustomNavigationPolicy;
import com.intellij.psi.meta.MetaDataContributor;
import java.io.File;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import mu.KLogger;
import mu.KotlinLogging;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.cli.common.CLIConfigurationKeys;
import org.jetbrains.kotlin.cli.common.arguments.K2JVMCompilerArguments;
import org.jetbrains.kotlin.cli.common.messages.CompilerMessageSeverity;
import org.jetbrains.kotlin.cli.common.messages.CompilerMessageSourceLocation;
import org.jetbrains.kotlin.cli.common.messages.MessageCollector;
import org.jetbrains.kotlin.cli.jvm.compiler.EnvironmentConfigFiles;
import org.jetbrains.kotlin.cli.jvm.compiler.KotlinCoreEnvironment;
import org.jetbrains.kotlin.cli.jvm.config.JvmContentRootsKt;
import org.jetbrains.kotlin.config.CommonConfigurationKeys;
import org.jetbrains.kotlin.config.CompilerConfiguration;
import org.jetbrains.kotlin.config.JVMConfigurationKeys;
import org.jetbrains.kotlin.js.config.JSConfigurationKeys;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c0\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0014\u0010\u0011\u001a\u00020\u00122\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00150\u0014J\u0016\u0010\u0016\u001a\u00020\n2\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00150\u0014H\u0002J\u0010\u0010\u0017\u001a\u00020\u00122\u0006\u0010\u0018\u001a\u00020\u0019H\u0002J$\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u001b0\u00142\u0006\u0010\u001c\u001a\u00020\u001d2\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00150\u0014H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0006\u001a\n\u0012\u0004\u0012\u00020\b\u0018\u00010\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001c\u0010\t\u001a\u0004\u0018\u00010\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000eR\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lai/tock/bot/admin/kotlin/compiler/EnvironmentManager;", "", "<init>", "()V", "logger", "Lmu/KLogger;", "registry", "Lcom/intellij/openapi/util/Getter;", "Lcom/intellij/openapi/fileTypes/FileTypeRegistry;", "environment", "Lorg/jetbrains/kotlin/cli/jvm/compiler/KotlinCoreEnvironment;", "getEnvironment", "()Lorg/jetbrains/kotlin/cli/jvm/compiler/KotlinCoreEnvironment;", "setEnvironment", "(Lorg/jetbrains/kotlin/cli/jvm/compiler/KotlinCoreEnvironment;)V", "disposable", "Lcom/intellij/openapi/Disposable;", "init", "", "libraries", "", "Ljava/nio/file/Path;", "createEnvironment", "registerExtensionPoints", "area", "Lcom/intellij/openapi/extensions/ExtensionsArea;", "getClasspath", "Ljava/io/File;", "arguments", "Lorg/jetbrains/kotlin/cli/common/arguments/K2JVMCompilerArguments;", "tock-bot-admin-kotlin-compiler-core"})
public final class EnvironmentManager {
    @NotNull
    public static final EnvironmentManager INSTANCE = new EnvironmentManager();
    @NotNull
    private static final KLogger logger = KotlinLogging.INSTANCE.logger(EnvironmentManager::logger$lambda$0);
    @Nullable
    private static Getter<FileTypeRegistry> registry;
    @Nullable
    private static KotlinCoreEnvironment environment;
    @NotNull
    private static final Disposable disposable;

    private EnvironmentManager() {
    }

    @Nullable
    public final KotlinCoreEnvironment getEnvironment() {
        return environment;
    }

    public final void setEnvironment(@Nullable KotlinCoreEnvironment kotlinCoreEnvironment) {
        environment = kotlinCoreEnvironment;
    }

    public final void init(@NotNull List<? extends Path> libraries) {
        Intrinsics.checkNotNullParameter(libraries, (String)"libraries");
        environment = this.createEnvironment(libraries);
    }

    private final KotlinCoreEnvironment createEnvironment(List<? extends Path> libraries) {
        K2JVMCompilerArguments arguments = new K2JVMCompilerArguments();
        CompilerConfiguration configuration = new CompilerConfiguration();
        JvmContentRootsKt.addJvmClasspathRoots((CompilerConfiguration)configuration, this.getClasspath(arguments, libraries));
        configuration.put(JVMConfigurationKeys.DISABLE_PARAM_ASSERTIONS, (Object)arguments.getNoParamAssertions());
        configuration.put(JVMConfigurationKeys.DISABLE_CALL_ASSERTIONS, (Object)arguments.getNoCallAssertions());
        configuration.put(CLIConfigurationKeys.MESSAGE_COLLECTOR_KEY, (Object)new MessageCollector(){
            private boolean error;

            public void clear() {
                this.error = false;
            }

            public boolean hasErrors() {
                return this.error;
            }

            public void report(CompilerMessageSeverity severity, String message, CompilerMessageSourceLocation location) {
                Intrinsics.checkNotNullParameter((Object)severity, (String)"severity");
                Intrinsics.checkNotNullParameter((Object)message, (String)"message");
                EnvironmentManager.access$getLogger$p().error(() -> createEnvironment.1.report$lambda$0(severity, message, location));
                this.error = true;
            }

            private static final Object report$lambda$0(CompilerMessageSeverity $severity, String $message, CompilerMessageSourceLocation $location) {
                Intrinsics.checkNotNullParameter((Object)$severity, (String)"$severity");
                Intrinsics.checkNotNullParameter((Object)$message, (String)"$message");
                return $severity + " " + $message + " " + $location;
            }
        });
        configuration.put(CommonConfigurationKeys.MODULE_NAME, (Object)"tockScript");
        configuration.put(JSConfigurationKeys.TYPED_ARRAYS_ENABLED, (Object)true);
        KotlinCoreEnvironment environment = KotlinCoreEnvironment.Companion.createForProduction(disposable, configuration, EnvironmentConfigFiles.JVM_CONFIG_FILES);
        Project project = environment.getProject();
        Intrinsics.checkNotNull((Object)project, (String)"null cannot be cast to non-null type com.intellij.mock.MockProject");
        MockProject project2 = (MockProject)project;
        project2.registerService(CodeStyleManager.class, (Object)new DummyCodeStyleManager());
        ExtensionsArea extensionsArea = Extensions.getRootArea();
        Intrinsics.checkNotNullExpressionValue((Object)extensionsArea, (String)"getRootArea(...)");
        this.registerExtensionPoints(extensionsArea);
        registry = FileTypeRegistry.ourInstanceGetter;
        return environment;
    }

    private final void registerExtensionPoints(ExtensionsArea area) {
        CoreApplicationEnvironment.registerExtensionPoint((ExtensionsArea)area, (ExtensionPointName)FileContextProvider.EP_NAME, FileContextProvider.class);
        CoreApplicationEnvironment.registerExtensionPoint((ExtensionsArea)area, (ExtensionPointName)MetaDataContributor.EP_NAME, MetaDataContributor.class);
        CoreApplicationEnvironment.registerExtensionPoint((ExtensionsArea)area, (ExtensionPointName)PsiAugmentProvider.EP_NAME, PsiAugmentProvider.class);
        CoreApplicationEnvironment.registerExtensionPoint((ExtensionsArea)area, (ExtensionPointName)JavaMainMethodProvider.EP_NAME, JavaMainMethodProvider.class);
        CoreApplicationEnvironment.registerExtensionPoint((ExtensionsArea)area, (ExtensionPointName)ContainerProvider.EP_NAME, ContainerProvider.class);
        CoreApplicationEnvironment.registerExtensionPoint((ExtensionsArea)area, (ExtensionPointName)ClsCustomNavigationPolicy.EP_NAME, ClsCustomNavigationPolicy.class);
    }

    private final List<File> getClasspath(K2JVMCompilerArguments arguments, List<? extends Path> libraries) {
        ArrayList classpath = Lists.newArrayList();
        for (Path object : libraries) {
            classpath.add(object.toFile());
        }
        if (arguments.getClasspath() != null) {
            String string = arguments.getClasspath();
            Intrinsics.checkNotNull((Object)string);
            char[] cArray = new char[]{File.pathSeparatorChar};
            List elements = StringsKt.split$default((CharSequence)string, (char[])cArray, (boolean)false, (int)0, (int)6, null);
            for (String element : elements) {
                classpath.add(new File(element));
            }
        }
        Intrinsics.checkNotNull((Object)classpath);
        return classpath;
    }

    private static final Unit logger$lambda$0() {
        return Unit.INSTANCE;
    }

    private static final void disposable$lambda$1() {
    }

    public static final /* synthetic */ KLogger access$getLogger$p() {
        return logger;
    }

    static {
        disposable = EnvironmentManager::disposable$lambda$1;
    }
}

