/*
 * Decompiled with CFR 0.152.
 */
package ai.tock.bot.admin.kotlin.compiler.client;

import ai.tock.bot.admin.kotlin.compiler.KotlinFile;
import ai.tock.bot.admin.kotlin.compiler.KotlinFileCompilation;
import ai.tock.bot.admin.kotlin.compiler.client.KotlinCompilerService;
import ai.tock.shared.LoggersKt;
import ai.tock.shared.PropertiesKt;
import ai.tock.shared.RetrofitsKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import mu.KLogger;
import mu.KotlinLogging;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import retrofit2.Response;
import retrofit2.Retrofit;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0010\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u0012\u001a\u00020\u0013R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0010\u0010\u000e\u001a\u0004\u0018\u00010\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lai/tock/bot/admin/kotlin/compiler/client/KotlinCompilerClient;", "", "<init>", "()V", "compilerTimeoutInSeconds", "", "compilerUrl", "", "logger", "Lmu/KLogger;", "compilerDisabled", "", "getCompilerDisabled", "()Z", "service", "Lai/tock/bot/admin/kotlin/compiler/client/KotlinCompilerService;", "compile", "Lai/tock/bot/admin/kotlin/compiler/KotlinFileCompilation;", "file", "Lai/tock/bot/admin/kotlin/compiler/KotlinFile;", "tock-bot-admin-kotlin-compiler-client"})
@SourceDebugExtension(value={"SMAP\nKotlinCompilerClient.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KotlinCompilerClient.kt\nai/tock/bot/admin/kotlin/compiler/client/KotlinCompilerClient\n+ 2 Retrofits.kt\nai/tock/shared/RetrofitsKt\n*L\n1#1,59:1\n71#2:60\n*S KotlinDebug\n*F\n+ 1 KotlinCompilerClient.kt\nai/tock/bot/admin/kotlin/compiler/client/KotlinCompilerClient\n*L\n45#1:60\n*E\n"})
public final class KotlinCompilerClient {
    @NotNull
    public static final KotlinCompilerClient INSTANCE;
    private static final long compilerTimeoutInSeconds;
    @NotNull
    private static final String compilerUrl;
    @NotNull
    private static final KLogger logger;
    private static final boolean compilerDisabled;
    @Nullable
    private static final KotlinCompilerService service;

    private KotlinCompilerClient() {
    }

    public final boolean getCompilerDisabled() {
        return compilerDisabled;
    }

    @Nullable
    public final KotlinFileCompilation compile(@NotNull KotlinFile file) {
        KotlinFileCompilation kotlinFileCompilation;
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        if (compilerDisabled) {
            logger.warn(KotlinCompilerClient::compile$lambda$0);
            kotlinFileCompilation = null;
        } else {
            Response response = service;
            kotlinFileCompilation = response != null && (response = response.compile(file)) != null && (response = response.execute()) != null ? (KotlinFileCompilation)response.body() : null;
        }
        return kotlinFileCompilation;
    }

    private static final Unit logger$lambda$0() {
        return Unit.INSTANCE;
    }

    private static final Object compile$lambda$0() {
        return "kotlin compiler is disabled";
    }

    static {
        KotlinCompilerService kotlinCompilerService;
        INSTANCE = new KotlinCompilerClient();
        compilerTimeoutInSeconds = PropertiesKt.longProperty((String)"tock_bot_compiler_timeout_in_ms", (long)60000L);
        compilerUrl = PropertiesKt.property((String)"tock_bot_compiler_service_url", (String)"http://localhost:8887");
        logger = KotlinLogging.INSTANCE.logger(KotlinCompilerClient::logger$lambda$0);
        compilerDisabled = PropertiesKt.booleanProperty((String)"tock_bot_compiler_disabled", (boolean)false);
        try {
            Retrofit retrofit = RetrofitsKt.addJacksonConverter$default((Retrofit.Builder)RetrofitsKt.retrofitBuilderWithTimeoutAndLogger$default((long)compilerTimeoutInSeconds, null, null, null, (boolean)false, (boolean)false, null, (int)126, null), null, (int)1, null).baseUrl(compilerUrl).build();
            Intrinsics.checkNotNullExpressionValue((Object)retrofit, (String)"build(...)");
            Retrofit $this$create$iv = retrofit;
            boolean $i$f$create = false;
            Object object = $this$create$iv.create(KotlinCompilerService.class);
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"create(...)");
            kotlinCompilerService = (KotlinCompilerService)object;
        }
        catch (Throwable t) {
            LoggersKt.error((KLogger)logger, (Throwable)t);
            kotlinCompilerService = null;
        }
        service = kotlinCompilerService;
    }
}

