/*
 * Decompiled with CFR 0.152.
 */
package ai.tecton.client.model;

import ai.tecton.client.exceptions.TectonClientException;
import ai.tecton.client.model.ValueType;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

class ListDataType {
    List<String> stringList;
    List<Float> float32List;
    List<Double> float64List;
    List<Long> int64List;
    ValueType listElementType;

    ListDataType(ValueType listElementType, Object featureObject) {
        ArrayList featureObjectList = (ArrayList)featureObject;
        this.listElementType = listElementType;
        switch (listElementType) {
            case INT64: {
                if (featureObjectList != null) {
                    this.int64List = featureObjectList.stream().map(obj -> {
                        String stringValue = (String)obj;
                        return stringValue != null ? Long.valueOf(Long.parseLong(stringValue)) : null;
                    }).collect(Collectors.toList());
                    break;
                }
                this.int64List = null;
                break;
            }
            case FLOAT32: {
                if (featureObjectList != null) {
                    this.float32List = new ArrayList<Float>(featureObjectList.size());
                    featureObjectList.forEach(obj -> this.float32List.add((Float)obj));
                    break;
                }
                this.float32List = null;
                break;
            }
            case FLOAT64: {
                if (featureObjectList != null) {
                    this.float64List = new ArrayList<Double>(featureObjectList.size());
                    featureObjectList.forEach(obj -> this.float64List.add((Double)obj));
                    break;
                }
                this.float64List = null;
                break;
            }
            case STRING: {
                if (featureObjectList != null) {
                    this.stringList = new ArrayList<String>(featureObjectList.size());
                    featureObjectList.forEach(obj -> this.stringList.add((String)obj));
                    break;
                }
                this.stringList = null;
                break;
            }
            default: {
                throw new TectonClientException("Unsupported data type detected for array feature values");
            }
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ListDataType that = (ListDataType)o;
        return Objects.equals(this.stringList, that.stringList) && Objects.equals(this.float32List, that.float32List) && Objects.equals(this.float64List, that.float64List) && Objects.equals(this.int64List, that.int64List) && Objects.equals((Object)this.listElementType, (Object)that.listElementType);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.stringList, this.float32List, this.float64List, this.int64List, this.listElementType});
    }
}

