/*
 * Decompiled with CFR 0.152.
 */
package ai.tecton.client;

import java.time.Duration;

public class TectonClientOptions {
    private static final Duration DEFAULT_READ_TIMEOUT = Duration.ofSeconds(2L);
    private static final Duration DEFAULT_CONNECT_TIMEOUT = Duration.ofSeconds(2L);
    private static final int DEFAULT_MAX_IDLE_CONNECTIONS = 5;
    private static final Duration DEFAULT_KEEPALIVE_DURATION = Duration.ofMinutes(5L);
    private static final int DEFAULT_MAX_PARALLEL_REQUESTS = 5;
    private final Duration readTimeout;
    private final Duration connectTimeout;
    private final int maxIdleConnections;
    private final Duration keepAliveDuration;
    private final int maxParallelRequests;

    public TectonClientOptions() {
        this.readTimeout = DEFAULT_READ_TIMEOUT;
        this.connectTimeout = DEFAULT_CONNECT_TIMEOUT;
        this.maxIdleConnections = 5;
        this.keepAliveDuration = DEFAULT_KEEPALIVE_DURATION;
        this.maxParallelRequests = 5;
    }

    public TectonClientOptions(Duration readTimeout, Duration connectTimeout, int maxIdleConnections, Duration keepAliveDuration, int maxParallelRequests) {
        this.readTimeout = readTimeout;
        this.connectTimeout = connectTimeout;
        this.maxIdleConnections = maxIdleConnections;
        this.keepAliveDuration = keepAliveDuration;
        this.maxParallelRequests = maxParallelRequests;
    }

    public Duration getConnectTimeout() {
        return this.connectTimeout;
    }

    public Duration getKeepAliveDuration() {
        return this.keepAliveDuration;
    }

    public Duration getReadTimeout() {
        return this.readTimeout;
    }

    public int getMaxIdleConnections() {
        return this.maxIdleConnections;
    }

    public int getMaxParallelRequests() {
        return this.maxParallelRequests;
    }

    static /* synthetic */ Duration access$000() {
        return DEFAULT_READ_TIMEOUT;
    }

    static /* synthetic */ Duration access$100() {
        return DEFAULT_CONNECT_TIMEOUT;
    }

    static /* synthetic */ Duration access$200() {
        return DEFAULT_KEEPALIVE_DURATION;
    }

    public static class Builder {
        private Duration readTimeout = TectonClientOptions.access$000();
        private Duration connectTimeout = TectonClientOptions.access$100();
        private int maxIdleConnections = 5;
        private Duration keepAliveDuration = TectonClientOptions.access$200();
        private int maxParallelRequests = 5;

        public Builder readTimeout(Duration readTimeout) {
            this.readTimeout = readTimeout;
            return this;
        }

        public Builder connectTimeout(Duration connectTimeout) {
            this.connectTimeout = connectTimeout;
            return this;
        }

        public Builder maxIdleConnections(int maxIdleConnections) {
            this.maxIdleConnections = maxIdleConnections;
            return this;
        }

        public Builder keepAliveDuration(Duration keepAliveDuration) {
            this.keepAliveDuration = keepAliveDuration;
            return this;
        }

        public Builder maxParallelRequests(int maxParallelRequests) {
            this.maxParallelRequests = maxParallelRequests;
            return this;
        }

        public TectonClientOptions build() {
            return new TectonClientOptions(this.readTimeout, this.connectTimeout, this.maxIdleConnections, this.keepAliveDuration, this.maxParallelRequests);
        }
    }
}

