package ai.systema.model.request

import ai.systema.constants.LanguagesISO6392
import ai.systema.enums.ScoreType
import ai.systema.serialize.Keys
import kotlinx.serialization.SerialName
import kotlinx.serialization.Serializable
import kotlinx.serialization.json.JsonElement

@Serializable
public data class SmartSearchRequest(
    @SerialName(Keys.Environment) var environment: String? = null,
    @SerialName(Keys.UserId) var user: RequestUser? = null,
    @SerialName(Keys.Query) val query: List<QueryItem>? = null,
    @SerialName(Keys.Filter) val filter: Filter? = null,
    @SerialName(Keys.Exclusion) val exclusion: Filter? = null,
    @SerialName(Keys.Size) val size: Int? = 10,
    @SerialName(Keys.Language) val language: String? = LanguagesISO6392.English,
    @SerialName(Keys.Start) val start: Int? = 0,
    @SerialName(Keys.FacetsSize) val facetSize: Int? = 10,
    @SerialName(Keys.Facets) val facets: List<String>? = null,
    @SerialName(Keys.Score) val score: String? = ScoreType.Relevance.value,
    @SerialName(Keys.Meta) val meta: Map<String, JsonElement>? = null, // this is for future customized extension
)
