package ai.systema.model.config

import ai.systema.constants.LanguagesISO6392
import ai.systema.model.request.Filter
import ai.systema.serialize.Keys
import kotlinx.serialization.SerialName
import kotlinx.serialization.Serializable
import kotlinx.serialization.json.JsonElement

@Serializable
public data class PayloadTemplate(
    @SerialName(Keys.Query) val query: List<String>? = null,
    @SerialName(Keys.Filter) val filter: Filter? = null,
    @SerialName(Keys.Exclusion) val exclusion: Filter? = null,
    @SerialName(Keys.Size) val size: Int? = 10,
    @SerialName(Keys.Language) val language: String? = LanguagesISO6392.English,
    @SerialName(Keys.Start) val start: Int? = 0,
    @SerialName(Keys.FacetsSize) val facetSize: Int? = 10,
    @SerialName(Keys.Facets) val facets: List<String>? = null,
    @SerialName(Keys.Score) val score: String? = null,
    @SerialName(Keys.Display) val display: List<String>? = null,
    @SerialName(Keys.DisplayVariants) val displayVariants: List<String>? = null,
    @SerialName(Keys.Meta) val meta: Map<String, JsonElement>? = null, // this is for future customized extension
)
