package ai.systema.helper.logging

import io.ktor.client.features.logging.*

/**
 * Systema Log Level
 * enum order represents amount of logs visible in the System.out
 */
public enum class SystemaLogLevel {
    NONE,
    ERROR,
    WARN,
    INFO,
    DEBUG,
}

internal val logLevelMapping: Map<SystemaLogLevel, LogLevel> = mapOf(
    SystemaLogLevel.ERROR to LogLevel.NONE,
    SystemaLogLevel.WARN to LogLevel.NONE,
    SystemaLogLevel.INFO to LogLevel.INFO,
    SystemaLogLevel.DEBUG to LogLevel.ALL,
    SystemaLogLevel.NONE to LogLevel.NONE,
)

internal fun toKtorLogLevel(level: SystemaLogLevel): LogLevel {
    if (logLevelMapping.containsKey(level)) return logLevelMapping[level] as LogLevel
    return LogLevel.NONE
}

