package ai.systema.endpoint.internal

import ai.systema.connection.RequestOptions
import ai.systema.connection.internal.Connector
import ai.systema.endpoint.EndpointSmartSearch
import ai.systema.endpoint.RouteSmartSearch
import ai.systema.enums.CallType
import ai.systema.enums.EndpointType
import ai.systema.model.request.SmartSearchRequest
import ai.systema.model.response.SmartSearchResponse
import ai.systema.serialize.internal.JsonNoDefaults
import io.ktor.http.*

internal class EndpointSmartSearchImpl(
    private val connector: Connector,
) : EndpointSmartSearch {

    override suspend fun smartSearch(
        payload: SmartSearchRequest,
        requestOptions: RequestOptions?
    ): SmartSearchResponse {
        if (payload.query == null || payload.query.isEmpty()) {
            throw IllegalArgumentException("'query' field cannot be empty")
        }

        return this.sendRequest(payload, RouteSmartSearch, requestOptions)
    }

    private suspend fun sendRequest(
        payload: SmartSearchRequest,
        path: String,
        requestOptions: RequestOptions?
    ): SmartSearchResponse {
        val body = JsonNoDefaults.encodeToString(SmartSearchRequest.serializer(), payload)
        return connector.request(
            HttpMethod.Post,
            EndpointType.Search,
            CallType.Read,
            path,
            requestOptions,
            body
        )
    }
}